/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.transformation.world;

import com.mojang.logging.LogUtils;
import io.leangen.geantyref.TypeToken;
import io.papermc.paper.configuration.Configurations;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;

public final class FeatureSeedsGeneration
implements TransformAction {
    public static final String FEATURE_SEEDS_KEY = "feature-seeds";
    public static final String GENERATE_KEY = "generate-random-seeds-for-all";
    public static final String FEATURES_KEY = "features";
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private final MinecraftKey worldKey;

    private FeatureSeedsGeneration(MinecraftKey worldKey) {
        this.worldKey = worldKey;
    }

    public Object @Nullable [] visitPath(NodePath path, ConfigurationNode value) throws ConfigurateException {
        ConfigurationNode featureNode = value.node(new Object[]{FEATURE_SEEDS_KEY, FEATURES_KEY});
        Reference2LongMap features = Objects.requireNonNullElseGet((Reference2LongMap)featureNode.get(new TypeToken<Reference2LongMap<Holder<WorldGenFeatureConfigured<?, ?>>>>(){}), Reference2LongOpenHashMap::new);
        SecureRandom random = new SecureRandom();
        AtomicInteger counter = new AtomicInteger(0);
        MinecraftServer.getServer().aU().d(Registries.as).h().forEach(holder -> {
            if (features.containsKey(holder)) {
                return;
            }
            long seed = random.nextLong();
            features.put(holder, seed);
            counter.incrementAndGet();
        });
        if (counter.get() > 0) {
            LOGGER.info("Generated {} random feature seeds for {}", (Object)counter.get(), (Object)this.worldKey);
            featureNode.raw(null);
            featureNode.set(new TypeToken<Reference2LongMap<Holder<WorldGenFeatureConfigured<?, ?>>>>(){}, (Object)features);
        }
        return null;
    }

    public static void apply(ConfigurationTransformation.Builder builder, Configurations.ContextMap contextMap, ConfigurationNode defaultsNode) {
        if (!contextMap.isDefaultWorldContext() && defaultsNode.node(new Object[]{FEATURE_SEEDS_KEY, GENERATE_KEY}).getBoolean(false)) {
            builder.addAction(NodePath.path(), (TransformAction)new FeatureSeedsGeneration(contextMap.require(Configurations.WORLD_KEY)));
        }
    }
}

