/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.strategy;

import com.google.common.graph.Graph;
import io.papermc.paper.plugin.entrypoint.strategy.PluginGraphCycleException;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public final class TopographicGraphSorter {
    public static <N> List<N> sortGraph(Graph<N> graph) throws PluginGraphCycleException {
        Object next;
        ArrayList sorted = new ArrayList();
        ArrayDeque roots = new ArrayDeque();
        Object2IntOpenHashMap nonRoots = new Object2IntOpenHashMap();
        for (Object node : graph.nodes()) {
            int degree = graph.inDegree(node);
            if (degree == 0) {
                roots.add(node);
                continue;
            }
            nonRoots.put(node, degree);
        }
        while ((next = roots.poll()) != null) {
            for (Object successor : graph.successors(next)) {
                int newInDegree = nonRoots.removeInt(successor) - 1;
                if (newInDegree == 0) {
                    roots.add(successor);
                    continue;
                }
                nonRoots.put(successor, newInDegree);
            }
            sorted.add(next);
        }
        if (!nonRoots.isEmpty()) {
            throw new GraphCycleException();
        }
        return sorted;
    }

    public static final class GraphCycleException
    extends RuntimeException {
    }
}

