/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.type.paper;

import com.destroystokyo.paper.utils.PaperPluginLogger;
import io.papermc.paper.plugin.bootstrap.PluginProviderContextImpl;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.entrypoint.classloader.PaperPluginClassLoader;
import io.papermc.paper.plugin.entrypoint.classloader.PaperSimplePluginClassLoader;
import io.papermc.paper.plugin.loader.PaperClasspathBuilder;
import io.papermc.paper.plugin.loader.PluginClasspathBuilder;
import io.papermc.paper.plugin.loader.PluginLoader;
import io.papermc.paper.plugin.provider.configuration.PaperPluginMeta;
import io.papermc.paper.plugin.provider.type.PluginTypeFactory;
import io.papermc.paper.plugin.provider.type.paper.PaperPluginParent;
import io.papermc.paper.plugin.provider.util.ProviderUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;

class PaperPluginProviderFactory
implements PluginTypeFactory<PaperPluginParent, PaperPluginMeta> {
    PaperPluginProviderFactory() {
    }

    @Override
    public PaperPluginParent build(JarFile file, PaperPluginMeta configuration, Path source) throws Exception {
        Logger jul = PaperPluginLogger.getLogger((PluginMeta)configuration);
        ComponentLogger logger = ComponentLogger.logger((String)jul.getName());
        PluginProviderContextImpl context = PluginProviderContextImpl.create(configuration, logger, source);
        PaperClasspathBuilder builder = new PaperClasspathBuilder(context);
        if (configuration.getLoader() != null) {
            try (PaperSimplePluginClassLoader simplePluginClassLoader = new PaperSimplePluginClassLoader(source, file, configuration, this.getClass().getClassLoader());){
                PluginLoader loader = (PluginLoader)ProviderUtil.loadClass((String)configuration.getLoader(), PluginLoader.class, (ClassLoader)simplePluginClassLoader);
                loader.classloader((PluginClasspathBuilder)builder);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        PaperPluginClassLoader classLoader = builder.buildClassLoader(jul, source, file, configuration);
        return new PaperPluginParent(source, file, configuration, classLoader, context);
    }

    @Override
    public PaperPluginMeta create(JarFile file, JarEntry config) throws Exception {
        PaperPluginMeta configuration;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(file.getInputStream(config)));){
            configuration = PaperPluginMeta.create(bufferedReader);
        }
        return configuration;
    }
}

