/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import io.papermc.paper.util.collisions.CachedShapeData;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IEntityAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.DoubleListOffset;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeArray;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapeCollisionEntity;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapes;

public final class CollisionUtil {
    public static final double COLLISION_EPSILON = 1.0E-7;
    public static final DoubleArrayList ZERO_ONE = DoubleArrayList.wrap((double[])new double[]{0.0, 1.0});
    public static final int COLLISION_FLAG_LOAD_CHUNKS = 1;
    public static final int COLLISION_FLAG_COLLIDE_WITH_UNLOADED_CHUNKS = 2;
    public static final int COLLISION_FLAG_CHECK_BORDER = 4;
    public static final int COLLISION_FLAG_CHECK_ONLY = 8;

    public static boolean isSpecialCollidingBlock(BlockBase.BlockData block) {
        return block.f() || block.b() == Blocks.bQ;
    }

    public static boolean isEmpty(AxisAlignedBB aabb) {
        return aabb.d - aabb.a < 1.0E-7 || aabb.e - aabb.b < 1.0E-7 || aabb.f - aabb.c < 1.0E-7;
    }

    public static boolean isEmpty(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return maxX - minX < 1.0E-7 || maxY - minY < 1.0E-7 || maxZ - minZ < 1.0E-7;
    }

    public static AxisAlignedBB getBoxForChunk(int chunkX, int chunkZ) {
        double x2 = chunkX << 4;
        double z2 = chunkZ << 4;
        return new AxisAlignedBB(x2 - 3.0E-7, Double.NEGATIVE_INFINITY, z2 - 3.0E-7, x2 + 16.0000003, Double.POSITIVE_INFINITY, z2 + 16.0000003, false);
    }

    public static boolean voxelShapeIntersect(double minX1, double minY1, double minZ1, double maxX1, double maxY1, double maxZ1, double minX2, double minY2, double minZ2, double maxX2, double maxY2, double maxZ2) {
        return minX1 - maxX2 < -1.0E-7 && maxX1 - minX2 > 1.0E-7 && minY1 - maxY2 < -1.0E-7 && maxY1 - minY2 > 1.0E-7 && minZ1 - maxZ2 < -1.0E-7 && maxZ1 - minZ2 > 1.0E-7;
    }

    public static boolean voxelShapeIntersect(AxisAlignedBB box, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return box.a - maxX < -1.0E-7 && box.d - minX > 1.0E-7 && box.b - maxY < -1.0E-7 && box.e - minY > 1.0E-7 && box.c - maxZ < -1.0E-7 && box.f - minZ > 1.0E-7;
    }

    public static boolean voxelShapeIntersect(AxisAlignedBB box1, AxisAlignedBB box2) {
        return box1.a - box2.d < -1.0E-7 && box1.d - box2.a > 1.0E-7 && box1.b - box2.e < -1.0E-7 && box1.e - box2.b > 1.0E-7 && box1.c - box2.f < -1.0E-7 && box1.f - box2.c > 1.0E-7;
    }

    public static double collideX(AxisAlignedBB target, AxisAlignedBB source, double source_move) {
        if (source.b - target.e < -1.0E-7 && source.e - target.b > 1.0E-7 && source.c - target.f < -1.0E-7 && source.f - target.c > 1.0E-7) {
            if (source_move >= 0.0) {
                double max_move = target.a - source.d;
                if (max_move < -1.0E-7) {
                    return source_move;
                }
                return Math.min(max_move, source_move);
            }
            double max_move = target.d - source.a;
            if (max_move > 1.0E-7) {
                return source_move;
            }
            return Math.max(max_move, source_move);
        }
        return source_move;
    }

    public static double collideY(AxisAlignedBB target, AxisAlignedBB source, double source_move) {
        if (source.a - target.d < -1.0E-7 && source.d - target.a > 1.0E-7 && source.c - target.f < -1.0E-7 && source.f - target.c > 1.0E-7) {
            if (source_move >= 0.0) {
                double max_move = target.b - source.e;
                if (max_move < -1.0E-7) {
                    return source_move;
                }
                return Math.min(max_move, source_move);
            }
            double max_move = target.e - source.b;
            if (max_move > 1.0E-7) {
                return source_move;
            }
            return Math.max(max_move, source_move);
        }
        return source_move;
    }

    public static double collideZ(AxisAlignedBB target, AxisAlignedBB source, double source_move) {
        if (source.a - target.d < -1.0E-7 && source.d - target.a > 1.0E-7 && source.b - target.e < -1.0E-7 && source.e - target.b > 1.0E-7) {
            if (source_move >= 0.0) {
                double max_move = target.c - source.f;
                if (max_move < -1.0E-7) {
                    return source_move;
                }
                return Math.min(max_move, source_move);
            }
            double max_move = target.f - source.c;
            if (max_move > 1.0E-7) {
                return source_move;
            }
            return Math.max(max_move, source_move);
        }
        return source_move;
    }

    private static int findFloor(double[] values, double value, int startIndex, int endIndex) {
        do {
            int middle;
            double middleVal;
            if (value < (middleVal = values[middle = startIndex + endIndex >>> 1])) {
                endIndex = middle - 1;
                continue;
            }
            startIndex = middle + 1;
        } while (startIndex <= endIndex);
        return startIndex - 1;
    }

    public static boolean voxelShapeIntersectNoEmpty(VoxelShape voxel, AxisAlignedBB aabb) {
        if (voxel.c()) {
            return false;
        }
        double off_x = voxel.offsetX();
        double off_y = voxel.offsetY();
        double off_z = voxel.offsetZ();
        double[] coords_x = voxel.rootCoordinatesX();
        double[] coords_y = voxel.rootCoordinatesY();
        double[] coords_z = voxel.rootCoordinatesZ();
        CachedShapeData cached_shape_data = voxel.getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int floor_min_x = Math.max(0, CollisionUtil.findFloor(coords_x, aabb.a - off_x + 1.0E-7, 0, size_x));
        if (floor_min_x >= size_x) {
            return false;
        }
        int ceil_max_x = Math.min(size_x, CollisionUtil.findFloor(coords_x, aabb.d - off_x - 1.0E-7, floor_min_x, size_x) + 1);
        if (floor_min_x >= ceil_max_x) {
            return false;
        }
        int floor_min_y = Math.max(0, CollisionUtil.findFloor(coords_y, aabb.b - off_y + 1.0E-7, 0, size_y));
        if (floor_min_y >= size_y) {
            return false;
        }
        int ceil_max_y = Math.min(size_y, CollisionUtil.findFloor(coords_y, aabb.e - off_y - 1.0E-7, floor_min_y, size_y) + 1);
        if (floor_min_y >= ceil_max_y) {
            return false;
        }
        int floor_min_z = Math.max(0, CollisionUtil.findFloor(coords_z, aabb.c - off_z + 1.0E-7, 0, size_z));
        if (floor_min_z >= size_z) {
            return false;
        }
        int ceil_max_z = Math.min(size_z, CollisionUtil.findFloor(coords_z, aabb.f - off_z - 1.0E-7, floor_min_z, size_z) + 1);
        if (floor_min_z >= ceil_max_z) {
            return false;
        }
        long[] bitset = cached_shape_data.voxelSet();
        int mul_x = size_y * size_z;
        for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
            for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                    int index = curr_z + curr_y * size_z + curr_x * mul_x;
                    if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static double collideX(VoxelShape target, AxisAlignedBB source, double source_move) {
        AxisAlignedBB single_aabb = target.getSingleAABBRepresentation();
        if (single_aabb != null) {
            return CollisionUtil.collideX(single_aabb, source, source_move);
        }
        double off_x = target.offsetX();
        double off_y = target.offsetY();
        double off_z = target.offsetZ();
        double[] coords_x = target.rootCoordinatesX();
        double[] coords_y = target.rootCoordinatesY();
        double[] coords_z = target.rootCoordinatesZ();
        CachedShapeData cached_shape_data = target.getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int floor_min_y = Math.max(0, CollisionUtil.findFloor(coords_y, source.b - off_y + 1.0E-7, 0, size_y));
        if (floor_min_y >= size_y) {
            return source_move;
        }
        int ceil_max_y = Math.min(size_y, CollisionUtil.findFloor(coords_y, source.e - off_y - 1.0E-7, floor_min_y, size_y) + 1);
        if (floor_min_y >= ceil_max_y) {
            return source_move;
        }
        int floor_min_z = Math.max(0, CollisionUtil.findFloor(coords_z, source.c - off_z + 1.0E-7, 0, size_z));
        if (floor_min_z >= size_z) {
            return source_move;
        }
        int ceil_max_z = Math.min(size_z, CollisionUtil.findFloor(coords_z, source.f - off_z - 1.0E-7, floor_min_z, size_z) + 1);
        if (floor_min_z >= ceil_max_z) {
            return source_move;
        }
        long[] bitset = cached_shape_data.voxelSet();
        if (source_move > 0.0) {
            double source_max = source.d - off_x;
            int ceil_max_x = CollisionUtil.findFloor(coords_x, source_max - 1.0E-7, 0, size_x) + 1;
            int mul_x = size_y * size_z;
            for (int curr_x = ceil_max_x; curr_x < size_x; ++curr_x) {
                double max_dist = coords_x[curr_x] - source_max;
                if (max_dist >= source_move) {
                    return source_move;
                }
                if (max_dist >= -1.0E-7) {
                    max_dist = Math.min(max_dist, source_move);
                }
                for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                    for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                        int index = curr_z + curr_y * size_z + curr_x * mul_x;
                        if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                        return max_dist;
                    }
                }
            }
            return source_move;
        }
        double source_min = source.a - off_x;
        int floor_min_x = CollisionUtil.findFloor(coords_x, source_min + 1.0E-7, 0, size_x);
        int mul_x = size_y * size_z;
        for (int curr_x = floor_min_x - 1; curr_x >= 0; --curr_x) {
            double max_dist = coords_x[curr_x + 1] - source_min;
            if (max_dist <= source_move) {
                return source_move;
            }
            if (max_dist <= 1.0E-7) {
                max_dist = Math.max(max_dist, source_move);
            }
            for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                    int index = curr_z + curr_y * size_z + curr_x * mul_x;
                    if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                    return max_dist;
                }
            }
        }
        return source_move;
    }

    public static double collideY(VoxelShape target, AxisAlignedBB source, double source_move) {
        AxisAlignedBB single_aabb = target.getSingleAABBRepresentation();
        if (single_aabb != null) {
            return CollisionUtil.collideY(single_aabb, source, source_move);
        }
        double off_x = target.offsetX();
        double off_y = target.offsetY();
        double off_z = target.offsetZ();
        double[] coords_x = target.rootCoordinatesX();
        double[] coords_y = target.rootCoordinatesY();
        double[] coords_z = target.rootCoordinatesZ();
        CachedShapeData cached_shape_data = target.getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int floor_min_x = Math.max(0, CollisionUtil.findFloor(coords_x, source.a - off_x + 1.0E-7, 0, size_x));
        if (floor_min_x >= size_x) {
            return source_move;
        }
        int ceil_max_x = Math.min(size_x, CollisionUtil.findFloor(coords_x, source.d - off_x - 1.0E-7, floor_min_x, size_x) + 1);
        if (floor_min_x >= ceil_max_x) {
            return source_move;
        }
        int floor_min_z = Math.max(0, CollisionUtil.findFloor(coords_z, source.c - off_z + 1.0E-7, 0, size_z));
        if (floor_min_z >= size_z) {
            return source_move;
        }
        int ceil_max_z = Math.min(size_z, CollisionUtil.findFloor(coords_z, source.f - off_z - 1.0E-7, floor_min_z, size_z) + 1);
        if (floor_min_z >= ceil_max_z) {
            return source_move;
        }
        long[] bitset = cached_shape_data.voxelSet();
        if (source_move > 0.0) {
            double source_max = source.e - off_y;
            int ceil_max_y = CollisionUtil.findFloor(coords_y, source_max - 1.0E-7, 0, size_y) + 1;
            int mul_x = size_y * size_z;
            for (int curr_y = ceil_max_y; curr_y < size_y; ++curr_y) {
                double max_dist = coords_y[curr_y] - source_max;
                if (max_dist >= source_move) {
                    return source_move;
                }
                if (max_dist >= -1.0E-7) {
                    max_dist = Math.min(max_dist, source_move);
                }
                for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
                    for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                        int index = curr_z + curr_y * size_z + curr_x * mul_x;
                        if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                        return max_dist;
                    }
                }
            }
            return source_move;
        }
        double source_min = source.b - off_y;
        int floor_min_y = CollisionUtil.findFloor(coords_y, source_min + 1.0E-7, 0, size_y);
        int mul_x = size_y * size_z;
        for (int curr_y = floor_min_y - 1; curr_y >= 0; --curr_y) {
            double max_dist = coords_y[curr_y + 1] - source_min;
            if (max_dist <= source_move) {
                return source_move;
            }
            if (max_dist <= 1.0E-7) {
                max_dist = Math.max(max_dist, source_move);
            }
            for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
                for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                    int index = curr_z + curr_y * size_z + curr_x * mul_x;
                    if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                    return max_dist;
                }
            }
        }
        return source_move;
    }

    public static double collideZ(VoxelShape target, AxisAlignedBB source, double source_move) {
        AxisAlignedBB single_aabb = target.getSingleAABBRepresentation();
        if (single_aabb != null) {
            return CollisionUtil.collideZ(single_aabb, source, source_move);
        }
        double off_x = target.offsetX();
        double off_y = target.offsetY();
        double off_z = target.offsetZ();
        double[] coords_x = target.rootCoordinatesX();
        double[] coords_y = target.rootCoordinatesY();
        double[] coords_z = target.rootCoordinatesZ();
        CachedShapeData cached_shape_data = target.getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int floor_min_x = Math.max(0, CollisionUtil.findFloor(coords_x, source.a - off_x + 1.0E-7, 0, size_x));
        if (floor_min_x >= size_x) {
            return source_move;
        }
        int ceil_max_x = Math.min(size_x, CollisionUtil.findFloor(coords_x, source.d - off_x - 1.0E-7, floor_min_x, size_x) + 1);
        if (floor_min_x >= ceil_max_x) {
            return source_move;
        }
        int floor_min_y = Math.max(0, CollisionUtil.findFloor(coords_y, source.b - off_y + 1.0E-7, 0, size_y));
        if (floor_min_y >= size_y) {
            return source_move;
        }
        int ceil_max_y = Math.min(size_y, CollisionUtil.findFloor(coords_y, source.e - off_y - 1.0E-7, floor_min_y, size_y) + 1);
        if (floor_min_y >= ceil_max_y) {
            return source_move;
        }
        long[] bitset = cached_shape_data.voxelSet();
        if (source_move > 0.0) {
            double source_max = source.f - off_z;
            int ceil_max_z = CollisionUtil.findFloor(coords_z, source_max - 1.0E-7, 0, size_z) + 1;
            int mul_x = size_y * size_z;
            for (int curr_z = ceil_max_z; curr_z < size_z; ++curr_z) {
                double max_dist = coords_z[curr_z] - source_max;
                if (max_dist >= source_move) {
                    return source_move;
                }
                if (max_dist >= -1.0E-7) {
                    max_dist = Math.min(max_dist, source_move);
                }
                for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
                    for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                        int index = curr_z + curr_y * size_z + curr_x * mul_x;
                        if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                        return max_dist;
                    }
                }
            }
            return source_move;
        }
        double source_min = source.c - off_z;
        int floor_min_z = CollisionUtil.findFloor(coords_z, source_min + 1.0E-7, 0, size_z);
        int mul_x = size_y * size_z;
        for (int curr_z = floor_min_z - 1; curr_z >= 0; --curr_z) {
            double max_dist = coords_z[curr_z + 1] - source_min;
            if (max_dist <= source_move) {
                return source_move;
            }
            if (max_dist <= 1.0E-7) {
                max_dist = Math.max(max_dist, source_move);
            }
            for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
                for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                    int index = curr_z + curr_y * size_z + curr_x * mul_x;
                    if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                    return max_dist;
                }
            }
        }
        return source_move;
    }

    public static boolean strictlyContains(VoxelShape voxel, Vec3D point) {
        return CollisionUtil.strictlyContains(voxel, point.c, point.d, point.e);
    }

    public static boolean strictlyContains(VoxelShape voxel, double x2, double y2, double z2) {
        AxisAlignedBB single_aabb = voxel.getSingleAABBRepresentation();
        if (single_aabb != null) {
            return single_aabb.e(x2, y2, z2);
        }
        if (voxel.c()) {
            return false;
        }
        x2 -= voxel.offsetX();
        y2 -= voxel.offsetY();
        z2 -= voxel.offsetZ();
        double[] coords_x = voxel.rootCoordinatesX();
        double[] coords_y = voxel.rootCoordinatesY();
        double[] coords_z = voxel.rootCoordinatesZ();
        CachedShapeData cached_shape_data = voxel.getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int index_x = CollisionUtil.findFloor(coords_x, x2, 0, size_x);
        if (index_x < 0 || index_x >= size_x) {
            return false;
        }
        int index_y = CollisionUtil.findFloor(coords_y, y2, 0, size_y);
        if (index_y < 0 || index_y >= size_y) {
            return false;
        }
        int index_z = CollisionUtil.findFloor(coords_z, z2, 0, size_z);
        if (index_z < 0 || index_z >= size_z) {
            return false;
        }
        int index = index_z + index_y * size_z + index_x * (size_z * size_y);
        long[] bitset = cached_shape_data.voxelSet();
        return (bitset[index >>> 6] & 1L << index) != 0L;
    }

    private static int makeBitset(boolean ft, boolean tf, boolean tt) {
        return (ft ? 1 : 0) << 1 | (tf ? 1 : 0) << 2 | (tt ? 1 : 0) << 3;
    }

    private static VoxelShapeBitSet merge(CachedShapeData shapeDataFirst, CachedShapeData shapeDataSecond, MergedVoxelCoordinateList mergedX, MergedVoxelCoordinateList mergedY, MergedVoxelCoordinateList mergedZ, int booleanOp) {
        int sizeX = mergedX.voxels;
        int sizeY = mergedY.voxels;
        int sizeZ = mergedZ.voxels;
        long[] s1Voxels = shapeDataFirst.voxelSet();
        long[] s2Voxels = shapeDataSecond.voxelSet();
        int s1Mul1 = shapeDataFirst.sizeZ();
        int s1Mul2 = s1Mul1 * shapeDataFirst.sizeY();
        int s2Mul1 = shapeDataSecond.sizeZ();
        int s2Mul2 = s2Mul1 * shapeDataSecond.sizeY();
        VoxelShapeBitSet ret = new VoxelShapeBitSet(sizeX, sizeY, sizeZ);
        boolean empty = true;
        int mergedIdx = 0;
        for (int idxX = 0; idxX < sizeX; ++idxX) {
            int s1x = mergedX.firstIndices[idxX];
            int s2x = mergedX.secondIndices[idxX];
            boolean setX = false;
            for (int idxY = 0; idxY < sizeY; ++idxY) {
                int s1y = mergedY.firstIndices[idxY];
                int s2y = mergedY.secondIndices[idxY];
                boolean setY = false;
                for (int idxZ = 0; idxZ < sizeZ; ++idxZ) {
                    int n2;
                    int isS1Full;
                    int idx;
                    int s1z = mergedZ.firstIndices[idxZ];
                    int s2z = mergedZ.secondIndices[idxZ];
                    if ((s1x | s1y | s1z) < 0) {
                        v0 = 0;
                    } else {
                        idx = s1z + s1y * s1Mul1 + s1x * s1Mul2;
                        v0 = isS1Full = (int)(s1Voxels[idx >>> 6] >>> idx & 1L);
                    }
                    if ((s2x | s2y | s2z) < 0) {
                        n2 = 0;
                    } else {
                        idx = s2z + s2y * s2Mul1 + s2x * s2Mul2;
                        n2 = (int)(s2Voxels[idx >>> 6] >>> idx & 1L);
                    }
                    int isS2Full = n2;
                    boolean res = (booleanOp & 1 << (isS2Full | isS1Full << 1)) != 0;
                    setY |= res;
                    setX |= res;
                    if (res) {
                        empty = false;
                        ret.g = Math.min(ret.g, idxZ);
                        ret.j = Math.max(ret.j, idxZ + 1);
                        ret.d.set(mergedIdx);
                    }
                    ++mergedIdx;
                }
                if (!setY) continue;
                ret.f = Math.min(ret.f, idxY);
                ret.i = Math.max(ret.i, idxY + 1);
            }
            if (!setX) continue;
            ret.e = Math.min(ret.e, idxX);
            ret.h = Math.max(ret.h, idxX + 1);
        }
        return empty ? null : ret;
    }

    private static boolean isMergeEmpty(CachedShapeData shapeDataFirst, CachedShapeData shapeDataSecond, MergedVoxelCoordinateList mergedX, MergedVoxelCoordinateList mergedY, MergedVoxelCoordinateList mergedZ, int booleanOp) {
        int sizeX = mergedX.voxels;
        int sizeY = mergedY.voxels;
        int sizeZ = mergedZ.voxels;
        long[] s1Voxels = shapeDataFirst.voxelSet();
        long[] s2Voxels = shapeDataSecond.voxelSet();
        int s1Mul1 = shapeDataFirst.sizeZ();
        int s1Mul2 = s1Mul1 * shapeDataFirst.sizeY();
        int s2Mul1 = shapeDataSecond.sizeZ();
        int s2Mul2 = s2Mul1 * shapeDataSecond.sizeY();
        for (int idxX = 0; idxX < sizeX; ++idxX) {
            int s1x = mergedX.firstIndices[idxX];
            int s2x = mergedX.secondIndices[idxX];
            for (int idxY = 0; idxY < sizeY; ++idxY) {
                int s1y = mergedY.firstIndices[idxY];
                int s2y = mergedY.secondIndices[idxY];
                for (int idxZ = 0; idxZ < sizeZ; ++idxZ) {
                    boolean res;
                    int n2;
                    int isS1Full;
                    int idx;
                    int s1z = mergedZ.firstIndices[idxZ];
                    int s2z = mergedZ.secondIndices[idxZ];
                    if ((s1x | s1y | s1z) < 0) {
                        v0 = 0;
                    } else {
                        idx = s1z + s1y * s1Mul1 + s1x * s1Mul2;
                        v0 = isS1Full = (int)(s1Voxels[idx >>> 6] >>> idx & 1L);
                    }
                    if ((s2x | s2y | s2z) < 0) {
                        n2 = 0;
                    } else {
                        idx = s2z + s2y * s2Mul1 + s2x * s2Mul2;
                        n2 = (int)(s2Voxels[idx >>> 6] >>> idx & 1L);
                    }
                    int isS2Full = n2;
                    boolean bl = res = (booleanOp & 1 << (isS2Full | isS1Full << 1)) != 0;
                    if (!res) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static VoxelShape joinOptimized(VoxelShape first, VoxelShape second, OperatorBoolean operator) {
        return CollisionUtil.joinUnoptimized(first, second, operator).d();
    }

    public static VoxelShape joinUnoptimized(VoxelShape first, VoxelShape second, OperatorBoolean operator) {
        CachedShapeData shapeDataSecond;
        MergedVoxelCoordinateList mergedX;
        boolean ff = operator.apply(false, false);
        if (ff) {
            throw new UnsupportedOperationException("Ambiguous operator: (false, false) -> true");
        }
        boolean tt = operator.apply(true, true);
        if (first == second) {
            return tt ? first : VoxelShapes.a();
        }
        boolean ft = operator.apply(false, true);
        boolean tf = operator.apply(true, false);
        if (first.c()) {
            return ft ? second : VoxelShapes.a();
        }
        if (second.c()) {
            return tf ? first : VoxelShapes.a();
        }
        if (!tt) {
            boolean hasAABBS;
            AxisAlignedBB aabbF = first.getSingleAABBRepresentation();
            AxisAlignedBB aabbS = second.getSingleAABBRepresentation();
            boolean hasAABBF = aabbF != null;
            boolean bl = hasAABBS = aabbS != null;
            boolean intersect = hasAABBF | hasAABBS ? (hasAABBF & hasAABBS ? CollisionUtil.voxelShapeIntersect(aabbF, aabbS) : (hasAABBF ? CollisionUtil.voxelShapeIntersectNoEmpty(second, aabbF) : CollisionUtil.voxelShapeIntersectNoEmpty(first, aabbS))) : CollisionUtil.voxelShapeIntersect(first.a(), second.a());
            if (!intersect) {
                if (!tf & !ft) {
                    return VoxelShapes.a();
                }
                if (!tf | !ft) {
                    return tf ? first : second;
                }
            }
        }
        if ((mergedX = MergedVoxelCoordinateList.merge(first.rootCoordinatesX(), first.offsetX(), second.rootCoordinatesX(), second.offsetX(), ft, tf)) == MergedVoxelCoordinateList.EMPTY) {
            return VoxelShapes.a();
        }
        MergedVoxelCoordinateList mergedY = MergedVoxelCoordinateList.merge(first.rootCoordinatesY(), first.offsetY(), second.rootCoordinatesY(), second.offsetY(), ft, tf);
        if (mergedY == MergedVoxelCoordinateList.EMPTY) {
            return VoxelShapes.a();
        }
        MergedVoxelCoordinateList mergedZ = MergedVoxelCoordinateList.merge(first.rootCoordinatesZ(), first.offsetZ(), second.rootCoordinatesZ(), second.offsetZ(), ft, tf);
        if (mergedZ == MergedVoxelCoordinateList.EMPTY) {
            return VoxelShapes.a();
        }
        CachedShapeData shapeDataFirst = first.getCachedVoxelData();
        VoxelShapeBitSet mergedShape = CollisionUtil.merge(shapeDataFirst, shapeDataSecond = second.getCachedVoxelData(), mergedX, mergedY, mergedZ, CollisionUtil.makeBitset(ft, tf, tt));
        if (mergedShape == null) {
            return VoxelShapes.a();
        }
        return new VoxelShapeArray((VoxelShapeDiscrete)mergedShape, mergedX.wrapCoords(), mergedY.wrapCoords(), mergedZ.wrapCoords());
    }

    public static boolean isJoinNonEmpty(VoxelShape first, VoxelShape second, OperatorBoolean operator) {
        CachedShapeData shapeDataSecond;
        MergedVoxelCoordinateList mergedX;
        boolean hasAABBS;
        boolean secondEmpty;
        boolean ff = operator.apply(false, false);
        if (ff) {
            throw new UnsupportedOperationException("Ambiguous operator: (false, false) -> true");
        }
        boolean firstEmpty = first.c();
        if (firstEmpty | (secondEmpty = second.c())) {
            return operator.apply(!firstEmpty, !secondEmpty);
        }
        boolean tt = operator.apply(true, true);
        if (first == second) {
            return tt;
        }
        boolean ft = operator.apply(false, true);
        boolean tf = operator.apply(true, false);
        AxisAlignedBB aabbF = first.getSingleAABBRepresentation();
        AxisAlignedBB aabbS = second.getSingleAABBRepresentation();
        boolean hasAABBF = aabbF != null;
        boolean bl = hasAABBS = aabbS != null;
        if (hasAABBF | hasAABBS) {
            boolean intersect = hasAABBF & hasAABBS ? CollisionUtil.voxelShapeIntersect(aabbF, aabbS) : (hasAABBF ? CollisionUtil.voxelShapeIntersectNoEmpty(second, aabbF) : CollisionUtil.voxelShapeIntersectNoEmpty(first, aabbS));
            if (!intersect) {
                return tf | ft;
            }
            if (tt) {
                return true;
            }
        } else {
            boolean intersect = CollisionUtil.voxelShapeIntersect(first.a(), second.a());
            if (!intersect) {
                return tf | ft;
            }
        }
        if ((mergedX = MergedVoxelCoordinateList.merge(first.rootCoordinatesX(), first.offsetX(), second.rootCoordinatesX(), second.offsetX(), ft, tf)) == MergedVoxelCoordinateList.EMPTY) {
            return false;
        }
        MergedVoxelCoordinateList mergedY = MergedVoxelCoordinateList.merge(first.rootCoordinatesY(), first.offsetY(), second.rootCoordinatesY(), second.offsetY(), ft, tf);
        if (mergedY == MergedVoxelCoordinateList.EMPTY) {
            return false;
        }
        MergedVoxelCoordinateList mergedZ = MergedVoxelCoordinateList.merge(first.rootCoordinatesZ(), first.offsetZ(), second.rootCoordinatesZ(), second.offsetZ(), ft, tf);
        if (mergedZ == MergedVoxelCoordinateList.EMPTY) {
            return false;
        }
        CachedShapeData shapeDataFirst = first.getCachedVoxelData();
        return !CollisionUtil.isMergeEmpty(shapeDataFirst, shapeDataSecond = second.getCachedVoxelData(), mergedX, mergedY, mergedZ, CollisionUtil.makeBitset(ft, tf, tt));
    }

    public static AxisAlignedBB offsetX(AxisAlignedBB box, double dx) {
        return new AxisAlignedBB(box.a + dx, box.b, box.c, box.d + dx, box.e, box.f, false);
    }

    public static AxisAlignedBB offsetY(AxisAlignedBB box, double dy) {
        return new AxisAlignedBB(box.a, box.b + dy, box.c, box.d, box.e + dy, box.f, false);
    }

    public static AxisAlignedBB offsetZ(AxisAlignedBB box, double dz) {
        return new AxisAlignedBB(box.a, box.b, box.c + dz, box.d, box.e, box.f + dz, false);
    }

    public static AxisAlignedBB expandRight(AxisAlignedBB box, double dx) {
        return new AxisAlignedBB(box.a, box.b, box.c, box.d + dx, box.e, box.f, false);
    }

    public static AxisAlignedBB expandLeft(AxisAlignedBB box, double dx) {
        return new AxisAlignedBB(box.a - dx, box.b, box.c, box.d, box.e, box.f);
    }

    public static AxisAlignedBB expandUpwards(AxisAlignedBB box, double dy) {
        return new AxisAlignedBB(box.a, box.b, box.c, box.d, box.e + dy, box.f, false);
    }

    public static AxisAlignedBB expandDownwards(AxisAlignedBB box, double dy) {
        return new AxisAlignedBB(box.a, box.b - dy, box.c, box.d, box.e, box.f, false);
    }

    public static AxisAlignedBB expandForwards(AxisAlignedBB box, double dz) {
        return new AxisAlignedBB(box.a, box.b, box.c, box.d, box.e, box.f + dz, false);
    }

    public static AxisAlignedBB expandBackwards(AxisAlignedBB box, double dz) {
        return new AxisAlignedBB(box.a, box.b, box.c - dz, box.d, box.e, box.f, false);
    }

    public static AxisAlignedBB cutRight(AxisAlignedBB box, double dx) {
        return new AxisAlignedBB(box.d, box.b, box.c, box.d + dx, box.e, box.f, false);
    }

    public static AxisAlignedBB cutLeft(AxisAlignedBB box, double dx) {
        return new AxisAlignedBB(box.a + dx, box.b, box.c, box.a, box.e, box.f, false);
    }

    public static AxisAlignedBB cutUpwards(AxisAlignedBB box, double dy) {
        return new AxisAlignedBB(box.a, box.e, box.c, box.d, box.e + dy, box.f, false);
    }

    public static AxisAlignedBB cutDownwards(AxisAlignedBB box, double dy) {
        return new AxisAlignedBB(box.a, box.b + dy, box.c, box.d, box.b, box.f, false);
    }

    public static AxisAlignedBB cutForwards(AxisAlignedBB box, double dz) {
        return new AxisAlignedBB(box.a, box.b, box.f, box.d, box.e, box.f + dz, false);
    }

    public static AxisAlignedBB cutBackwards(AxisAlignedBB box, double dz) {
        return new AxisAlignedBB(box.a, box.b, box.c + dz, box.d, box.e, box.c, false);
    }

    public static double performAABBCollisionsX(AxisAlignedBB currentBoundingBox, double value, List<AxisAlignedBB> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Math.abs(value) < 1.0E-7) {
                return 0.0;
            }
            AxisAlignedBB target = potentialCollisions.get(i2);
            value = CollisionUtil.collideX(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performAABBCollisionsY(AxisAlignedBB currentBoundingBox, double value, List<AxisAlignedBB> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Math.abs(value) < 1.0E-7) {
                return 0.0;
            }
            AxisAlignedBB target = potentialCollisions.get(i2);
            value = CollisionUtil.collideY(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performAABBCollisionsZ(AxisAlignedBB currentBoundingBox, double value, List<AxisAlignedBB> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Math.abs(value) < 1.0E-7) {
                return 0.0;
            }
            AxisAlignedBB target = potentialCollisions.get(i2);
            value = CollisionUtil.collideZ(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performVoxelCollisionsX(AxisAlignedBB currentBoundingBox, double value, List<VoxelShape> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Math.abs(value) < 1.0E-7) {
                return 0.0;
            }
            VoxelShape target = potentialCollisions.get(i2);
            value = CollisionUtil.collideX(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performVoxelCollisionsY(AxisAlignedBB currentBoundingBox, double value, List<VoxelShape> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Math.abs(value) < 1.0E-7) {
                return 0.0;
            }
            VoxelShape target = potentialCollisions.get(i2);
            value = CollisionUtil.collideY(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performVoxelCollisionsZ(AxisAlignedBB currentBoundingBox, double value, List<VoxelShape> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Math.abs(value) < 1.0E-7) {
                return 0.0;
            }
            VoxelShape target = potentialCollisions.get(i2);
            value = CollisionUtil.collideZ(target, currentBoundingBox, value);
        }
        return value;
    }

    public static Vec3D performVoxelCollisions(Vec3D moveVector, AxisAlignedBB axisalignedbb, List<VoxelShape> potentialCollisions) {
        boolean xSmaller;
        double x2 = moveVector.c;
        double y2 = moveVector.d;
        double z2 = moveVector.e;
        if (y2 != 0.0 && (y2 = CollisionUtil.performVoxelCollisionsY(axisalignedbb, y2, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetY(axisalignedbb, y2);
        }
        boolean bl = xSmaller = Math.abs(x2) < Math.abs(z2);
        if (xSmaller && z2 != 0.0 && (z2 = CollisionUtil.performVoxelCollisionsZ(axisalignedbb, z2, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetZ(axisalignedbb, z2);
        }
        if (x2 != 0.0) {
            x2 = CollisionUtil.performVoxelCollisionsX(axisalignedbb, x2, potentialCollisions);
            if (!xSmaller && x2 != 0.0) {
                axisalignedbb = CollisionUtil.offsetX(axisalignedbb, x2);
            }
        }
        if (!xSmaller && z2 != 0.0) {
            z2 = CollisionUtil.performVoxelCollisionsZ(axisalignedbb, z2, potentialCollisions);
        }
        return new Vec3D(x2, y2, z2);
    }

    public static Vec3D performAABBCollisions(Vec3D moveVector, AxisAlignedBB axisalignedbb, List<AxisAlignedBB> potentialCollisions) {
        boolean xSmaller;
        double x2 = moveVector.c;
        double y2 = moveVector.d;
        double z2 = moveVector.e;
        if (y2 != 0.0 && (y2 = CollisionUtil.performAABBCollisionsY(axisalignedbb, y2, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetY(axisalignedbb, y2);
        }
        boolean bl = xSmaller = Math.abs(x2) < Math.abs(z2);
        if (xSmaller && z2 != 0.0 && (z2 = CollisionUtil.performAABBCollisionsZ(axisalignedbb, z2, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetZ(axisalignedbb, z2);
        }
        if (x2 != 0.0) {
            x2 = CollisionUtil.performAABBCollisionsX(axisalignedbb, x2, potentialCollisions);
            if (!xSmaller && x2 != 0.0) {
                axisalignedbb = CollisionUtil.offsetX(axisalignedbb, x2);
            }
        }
        if (!xSmaller && z2 != 0.0) {
            z2 = CollisionUtil.performAABBCollisionsZ(axisalignedbb, z2, potentialCollisions);
        }
        return new Vec3D(x2, y2, z2);
    }

    public static Vec3D performCollisions(Vec3D moveVector, AxisAlignedBB axisalignedbb, List<VoxelShape> voxels, List<AxisAlignedBB> aabbs) {
        boolean xSmaller;
        if (voxels.isEmpty()) {
            return CollisionUtil.performAABBCollisions(moveVector, axisalignedbb, aabbs);
        }
        double x2 = moveVector.c;
        double y2 = moveVector.d;
        double z2 = moveVector.e;
        if (y2 != 0.0) {
            y2 = CollisionUtil.performAABBCollisionsY(axisalignedbb, y2, aabbs);
            if ((y2 = CollisionUtil.performVoxelCollisionsY(axisalignedbb, y2, voxels)) != 0.0) {
                axisalignedbb = CollisionUtil.offsetY(axisalignedbb, y2);
            }
        }
        boolean bl = xSmaller = Math.abs(x2) < Math.abs(z2);
        if (xSmaller && z2 != 0.0) {
            z2 = CollisionUtil.performAABBCollisionsZ(axisalignedbb, z2, aabbs);
            if ((z2 = CollisionUtil.performVoxelCollisionsZ(axisalignedbb, z2, voxels)) != 0.0) {
                axisalignedbb = CollisionUtil.offsetZ(axisalignedbb, z2);
            }
        }
        if (x2 != 0.0) {
            x2 = CollisionUtil.performAABBCollisionsX(axisalignedbb, x2, aabbs);
            x2 = CollisionUtil.performVoxelCollisionsX(axisalignedbb, x2, voxels);
            if (!xSmaller && x2 != 0.0) {
                axisalignedbb = CollisionUtil.offsetX(axisalignedbb, x2);
            }
        }
        if (!xSmaller && z2 != 0.0) {
            z2 = CollisionUtil.performAABBCollisionsZ(axisalignedbb, z2, aabbs);
            z2 = CollisionUtil.performVoxelCollisionsZ(axisalignedbb, z2, voxels);
        }
        return new Vec3D(x2, y2, z2);
    }

    public static boolean isAlmostCollidingOnBorder(WorldBorder worldborder, AxisAlignedBB boundingBox) {
        return CollisionUtil.isAlmostCollidingOnBorder(worldborder, boundingBox.a, boundingBox.d, boundingBox.c, boundingBox.f);
    }

    public static boolean isAlmostCollidingOnBorder(WorldBorder worldborder, double boxMinX, double boxMaxX, double boxMinZ, double boxMaxZ) {
        double borderMaxZ;
        double borderMinX = worldborder.e();
        double borderMaxX = worldborder.g();
        double borderMinZ = worldborder.f();
        return !CollisionUtil.voxelShapeIntersect(boxMinX + 1.0E-7, Double.NEGATIVE_INFINITY, boxMinZ + 1.0E-7, boxMaxX - 1.0E-7, Double.POSITIVE_INFINITY, boxMaxZ - 1.0E-7, borderMinX, Double.NEGATIVE_INFINITY, borderMinZ, borderMaxX, Double.POSITIVE_INFINITY, borderMaxZ = worldborder.h()) && CollisionUtil.voxelShapeIntersect(boxMinX - 1.0E-7, Double.NEGATIVE_INFINITY, boxMinZ - 1.0E-7, boxMaxX + 1.0E-7, Double.POSITIVE_INFINITY, boxMaxZ + 1.0E-7, borderMinX, Double.NEGATIVE_INFINITY, borderMinZ, borderMaxX, Double.POSITIVE_INFINITY, borderMaxZ);
    }

    public static boolean isCollidingWithBorderEdge(WorldBorder worldborder, AxisAlignedBB boundingBox) {
        return CollisionUtil.isCollidingWithBorderEdge(worldborder, boundingBox.a, boundingBox.d, boundingBox.c, boundingBox.f);
    }

    public static boolean isCollidingWithBorderEdge(WorldBorder worldborder, double boxMinX, double boxMaxX, double boxMinZ, double boxMaxZ) {
        double borderMinX = worldborder.e() + 1.0E-7;
        double borderMaxX = worldborder.g() - 1.0E-7;
        double borderMinZ = worldborder.f() + 1.0E-7;
        double borderMaxZ = worldborder.h() - 1.0E-7;
        return boxMinX < borderMinX || boxMaxX > borderMaxX || boxMinZ < borderMinZ || boxMaxZ > borderMaxZ;
    }

    private static double min(double x2, double y2) {
        return x2 < y2 ? x2 : y2;
    }

    private static double max(double x2, double y2) {
        return x2 > y2 ? x2 : y2;
    }

    public static boolean getCollisionsForBlocksOrWorldBorder(World world, Entity entity, AxisAlignedBB aabb, List<VoxelShape> intoVoxel, List<AxisAlignedBB> intoAABB, int collisionFlags, BiPredicate<IBlockData, BlockPosition> predicate) {
        boolean checkOnly = (collisionFlags & 8) != 0;
        boolean ret = false;
        if ((collisionFlags & 4) != 0 && CollisionUtil.isCollidingWithBorderEdge(world.B_(), aabb)) {
            if (checkOnly) {
                return true;
            }
            VoxelShape borderShape = world.B_().c();
            intoVoxel.add(borderShape);
            ret = true;
        }
        int minSection = world.minSection;
        int minBlockX = MathHelper.a(aabb.a - 1.0E-7) - 1;
        int maxBlockX = MathHelper.a(aabb.d + 1.0E-7) + 1;
        int minBlockY = Math.max((minSection << 4) - 1, MathHelper.a(aabb.b - 1.0E-7) - 1);
        int maxBlockY = Math.min((world.maxSection << 4) + 16, MathHelper.a(aabb.e + 1.0E-7) + 1);
        int minBlockZ = MathHelper.a(aabb.c - 1.0E-7) - 1;
        int maxBlockZ = MathHelper.a(aabb.f + 1.0E-7) + 1;
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        LazyEntityCollisionContext collisionShape = new LazyEntityCollisionContext(entity);
        if (minBlockY > maxBlockY) {
            return ret;
        }
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        boolean loadChunks = (collisionFlags & 1) != 0;
        ChunkProviderServer chunkSource = (ChunkProviderServer)world.J();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                Chunk chunk;
                IChunkAccess iChunkAccess = chunk = loadChunks ? chunkSource.a(currChunkX, currChunkZ, ChunkStatus.n, true) : chunkSource.getChunkAtIfLoadedImmediately(currChunkX, currChunkZ);
                if (chunk == null) {
                    if ((collisionFlags & 2) == 0) continue;
                    if (checkOnly) {
                        return true;
                    }
                    intoAABB.add(CollisionUtil.getBoxForChunk(currChunkX, currChunkZ));
                    ret = true;
                    continue;
                }
                ChunkSection[] sections = chunk.d();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    ChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]) == null || section.c()) continue;
                    boolean hasSpecial = section.getSpecialCollidingBlocks() != 0;
                    int sectionAdjust = !hasSpecial ? 1 : 0;
                    DataPaletteBlock<IBlockData> blocks = section.h;
                    int minXIterate = currChunkX == minChunkX ? (minBlockX & 0xF) + sectionAdjust : 0;
                    int maxXIterate = currChunkX == maxChunkX ? (maxBlockX & 0xF) - sectionAdjust : 15;
                    int minZIterate = currChunkZ == minChunkZ ? (minBlockZ & 0xF) + sectionAdjust : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? (maxBlockZ & 0xF) - sectionAdjust : 15;
                    int minYIterate = currChunkY == minChunkY ? (minBlockY & 0xF) + sectionAdjust : 0;
                    int maxYIterate = currChunkY == maxChunkY ? (maxBlockY & 0xF) - sectionAdjust : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                VoxelShape blockCollisionOffset;
                                AxisAlignedBB singleAABB;
                                IBlockData blockData;
                                int edgeCount;
                                int localBlockIndex = currX | currZ << 4 | currY << 8;
                                int blockX = currX | currChunkX << 4;
                                int n2 = hasSpecial ? (blockX == minBlockX || blockX == maxBlockX ? 1 : 0) + (blockY == minBlockY || blockY == maxBlockY ? 1 : 0) + (blockZ == minBlockZ || blockZ == maxBlockZ ? 1 : 0) : (edgeCount = 0);
                                if (edgeCount == 3 || (blockData = blocks.a(localBlockIndex)).emptyCollisionShape() || edgeCount != 0 && (edgeCount == 1 && !blockData.f() || edgeCount == 2 && blockData.b() != Blocks.bQ)) continue;
                                VoxelShape blockCollision = blockData.getConstantCollisionShape();
                                if (blockCollision == null) {
                                    mutablePos.d(blockX, blockY, blockZ);
                                    blockCollision = blockData.b((IBlockAccess)world, (BlockPosition)mutablePos, collisionShape);
                                }
                                if ((singleAABB = blockCollision.getSingleAABBRepresentation()) != null) {
                                    if (!CollisionUtil.voxelShapeIntersect(aabb, singleAABB = singleAABB.d(blockX, blockY, blockZ))) continue;
                                    if (predicate != null) {
                                        mutablePos.d(blockX, blockY, blockZ);
                                        if (!predicate.test(blockData, mutablePos)) continue;
                                    }
                                    if (checkOnly) {
                                        return true;
                                    }
                                    ret = true;
                                    intoAABB.add(singleAABB);
                                    continue;
                                }
                                if (blockCollision.c() || !CollisionUtil.voxelShapeIntersectNoEmpty(blockCollisionOffset = blockCollision.a(blockX, (double)blockY, (double)blockZ), aabb)) continue;
                                if (predicate != null) {
                                    mutablePos.d(blockX, blockY, blockZ);
                                    if (!predicate.test(blockData, mutablePos)) continue;
                                }
                                if (checkOnly) {
                                    return true;
                                }
                                ret = true;
                                intoVoxel.add(blockCollisionOffset);
                            }
                        }
                    }
                }
            }
        }
        return ret;
    }

    public static boolean getEntityHardCollisions(ICollisionAccess getter, Entity entity, AxisAlignedBB aabb, List<AxisAlignedBB> into, int collisionFlags, Predicate<Entity> predicate) {
        boolean checkOnly;
        boolean bl = checkOnly = (collisionFlags & 8) != 0;
        if (!(getter instanceof IEntityAccess)) {
            return false;
        }
        IEntityAccess entityGetter = (IEntityAccess)((Object)getter);
        boolean ret = false;
        aabb = aabb.c(-1.0E-7, -1.0E-7, -1.0E-7);
        List<Entity> entities = entity != null && entity.hardCollides() ? entityGetter.a(entity, aabb, predicate) : entityGetter.getHardCollidingEntities(entity, aabb, predicate);
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            Entity otherEntity = entities.get(i2);
            if (otherEntity.M_() || (entity != null || !otherEntity.bx()) && (entity == null || !entity.h(otherEntity))) continue;
            if (checkOnly) {
                return true;
            }
            into.add(otherEntity.cG());
            ret = true;
        }
        return ret;
    }

    public static boolean getCollisions(World world, Entity entity, AxisAlignedBB aabb, List<VoxelShape> intoVoxel, List<AxisAlignedBB> intoAABB, int collisionFlags, BiPredicate<IBlockData, BlockPosition> blockPredicate, Predicate<Entity> entityPredicate) {
        if ((collisionFlags & 8) != 0) {
            return CollisionUtil.getCollisionsForBlocksOrWorldBorder(world, entity, aabb, intoVoxel, intoAABB, collisionFlags, blockPredicate) || CollisionUtil.getEntityHardCollisions(world, entity, aabb, intoAABB, collisionFlags, entityPredicate);
        }
        return CollisionUtil.getCollisionsForBlocksOrWorldBorder(world, entity, aabb, intoVoxel, intoAABB, collisionFlags, blockPredicate) | CollisionUtil.getEntityHardCollisions(world, entity, aabb, intoAABB, collisionFlags, entityPredicate);
    }

    private CollisionUtil() {
        throw new RuntimeException();
    }

    private static final class MergedVoxelCoordinateList {
        private static final int[][] SIMPLE_INDICES_CACHE = new int[64][];
        private static final MergedVoxelCoordinateList EMPTY;
        public final double[] coordinates;
        public final double coordinateOffset;
        public final int[] firstIndices;
        public final int[] secondIndices;
        public final int voxels;

        private static int[] getIndices(int length) {
            int[] ret = new int[length];
            for (int i2 = 1; i2 < length; ++i2) {
                ret[i2] = i2;
            }
            return ret;
        }

        private MergedVoxelCoordinateList(double[] coordinates, double coordinateOffset, int[] firstIndices, int[] secondIndices, int voxels) {
            this.coordinates = coordinates;
            this.coordinateOffset = coordinateOffset;
            this.firstIndices = firstIndices;
            this.secondIndices = secondIndices;
            this.voxels = voxels;
        }

        public DoubleList wrapCoords() {
            if (this.coordinateOffset == 0.0) {
                return DoubleArrayList.wrap((double[])this.coordinates, (int)(this.voxels + 1));
            }
            return new DoubleListOffset((DoubleList)DoubleArrayList.wrap((double[])this.coordinates, (int)(this.voxels + 1)), this.coordinateOffset);
        }

        public static MergedVoxelCoordinateList getForSingle(double[] coordinates, double offset) {
            int voxels = coordinates.length - 1;
            int[] indices = voxels < SIMPLE_INDICES_CACHE.length ? SIMPLE_INDICES_CACHE[voxels] : MergedVoxelCoordinateList.getIndices(voxels);
            return new MergedVoxelCoordinateList(coordinates, offset, indices, indices, voxels);
        }

        public static MergedVoxelCoordinateList merge(double[] firstCoordinates, double firstOffset, double[] secondCoordinates, double secondOffset, boolean ft, boolean tf) {
            if (firstCoordinates == secondCoordinates && firstOffset == secondOffset) {
                return MergedVoxelCoordinateList.getForSingle(firstCoordinates, firstOffset);
            }
            int firstCount = firstCoordinates.length;
            int secondCount = secondCoordinates.length;
            int voxelsFirst = firstCount - 1;
            int voxelsSecond = secondCount - 1;
            int maxCount = firstCount + secondCount;
            double[] coordinates = new double[maxCount];
            int[] firstIndices = new int[maxCount];
            int[] secondIndices = new int[maxCount];
            boolean notTF = !tf;
            boolean notFT = !ft;
            int firstIndex = 0;
            int secondIndex = 0;
            int resultSize = 0;
            double last = Double.NaN;
            while (true) {
                double select;
                boolean secondZero;
                boolean noneLeftSecond;
                boolean noneLeftFirst = firstIndex >= firstCount;
                boolean bl = noneLeftSecond = secondIndex >= secondCount;
                if (noneLeftFirst & noneLeftSecond | noneLeftSecond & notTF | noneLeftFirst & notFT) break;
                boolean firstZero = firstIndex == 0;
                boolean bl2 = secondZero = secondIndex == 0;
                if (noneLeftFirst) {
                    select = secondCoordinates[secondIndex] + secondOffset;
                    ++secondIndex;
                } else if (noneLeftSecond) {
                    select = firstCoordinates[firstIndex] + firstOffset;
                    ++firstIndex;
                } else {
                    boolean breakFirst = notTF & secondZero;
                    boolean breakSecond = notFT & firstZero;
                    double first = firstCoordinates[firstIndex] + firstOffset;
                    double second = secondCoordinates[secondIndex] + secondOffset;
                    boolean useFirst = first < second + 1.0E-7;
                    boolean cont = useFirst & breakFirst | !useFirst & breakSecond;
                    select = useFirst ? first : second;
                    firstIndex += useFirst ? 1 : 0;
                    secondIndex += 1 ^ (useFirst ? 1 : 0);
                    if (cont) continue;
                }
                int prevFirst = firstIndex - 1;
                prevFirst = prevFirst >= voxelsFirst ? -1 : prevFirst;
                int prevSecond = secondIndex - 1;
                int n2 = prevSecond = prevSecond >= voxelsSecond ? -1 : prevSecond;
                if (last >= select - 1.0E-7) {
                    firstIndices[resultSize - 1] = prevFirst;
                    secondIndices[resultSize - 1] = prevSecond;
                    continue;
                }
                firstIndices[resultSize] = prevFirst;
                secondIndices[resultSize] = prevSecond;
                coordinates[resultSize] = select;
                ++resultSize;
                last = select;
            }
            return resultSize <= 1 ? EMPTY : new MergedVoxelCoordinateList(coordinates, 0.0, firstIndices, secondIndices, resultSize - 1);
        }

        static {
            for (int i2 = 0; i2 < SIMPLE_INDICES_CACHE.length; ++i2) {
                MergedVoxelCoordinateList.SIMPLE_INDICES_CACHE[i2] = MergedVoxelCoordinateList.getIndices(i2);
            }
            EMPTY = new MergedVoxelCoordinateList(new double[]{0.0}, 0.0, new int[0], new int[0], 0);
        }
    }

    public static final class LazyEntityCollisionContext
    extends VoxelShapeCollisionEntity {
        private VoxelShapeCollision delegate;
        private boolean delegated;

        public LazyEntityCollisionContext(Entity entity) {
            super(false, 0.0, null, null, entity);
        }

        public boolean isDelegated() {
            boolean delegated = this.delegated;
            this.delegated = false;
            return delegated;
        }

        public VoxelShapeCollision getDelegate() {
            this.delegated = true;
            Entity entity = this.c();
            return this.delegate == null ? (this.delegate = entity == null ? VoxelShapeCollision.a() : VoxelShapeCollision.a(entity)) : this.delegate;
        }

        @Override
        public boolean b() {
            return this.getDelegate().b();
        }

        @Override
        public boolean a(VoxelShape shape, BlockPosition pos, boolean defaultValue) {
            return this.getDelegate().a(shape, pos, defaultValue);
        }

        @Override
        public boolean a(Item item) {
            return this.getDelegate().a(item);
        }

        @Override
        public boolean a(Fluid state, Fluid fluidState) {
            return this.getDelegate().a(state, fluidState);
        }
    }
}

