/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.Position;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.Cleaner;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import top.leavesmc.leaves.LeavesConfig;

public final class MCUtil {
    public static final ThreadPoolExecutor asyncExecutor = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Paper Async Task Handler Thread - %1$d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.n)).build());
    public static final ThreadPoolExecutor cleanerExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Paper Object Cleaner").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.n)).build());
    public static final long INVALID_CHUNK_KEY = MCUtil.getCoordinateKey(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final Executor MAIN_EXECUTOR = run -> {
        if (!MCUtil.isMainThread()) {
            MinecraftServer.getServer().execute(run);
        } else {
            run.run();
        }
    };

    public static Runnable once(Runnable run) {
        AtomicBoolean ran = new AtomicBoolean(false);
        return () -> {
            if (ran.compareAndSet(false, true)) {
                run.run();
            }
        };
    }

    public static <T> Runnable once(List<T> list, Consumer<T> cb) {
        return MCUtil.once(() -> list.forEach(cb));
    }

    private static Runnable makeCleanerCallback(Runnable run) {
        return MCUtil.once(() -> cleanerExecutor.execute(run));
    }

    public static Runnable registerCleaner(Object obj, Runnable run) {
        Runnable cleaner = MCUtil.makeCleanerCallback(run);
        CleanerHolder.CLEANER.register(obj, cleaner);
        return cleaner;
    }

    public static <T> Runnable registerListCleaner(Object obj, List<T> list, Consumer<T> cleaner) {
        return MCUtil.registerCleaner(obj, () -> {
            list.forEach(cleaner);
            list.clear();
        });
    }

    public static <T> Runnable registerCleaner(Object obj, T resource, Consumer<T> cleaner) {
        return MCUtil.registerCleaner(obj, () -> cleaner.accept(resource));
    }

    public static List<ChunkCoordIntPair> getSpiralOutChunks(BlockPosition blockposition, int radius) {
        ArrayList list = Lists.newArrayList();
        list.add(new ChunkCoordIntPair(blockposition.u() >> 4, blockposition.w() >> 4));
        for (int r2 = 1; r2 <= radius; ++r2) {
            int x2 = -r2;
            int z2 = r2;
            while (x2 <= r2 && z2 > -r2) {
                list.add(new ChunkCoordIntPair(blockposition.u() + (x2 << 4) >> 4, blockposition.w() + (z2 << 4) >> 4));
                list.add(new ChunkCoordIntPair(blockposition.u() - (x2 << 4) >> 4, blockposition.w() - (z2 << 4) >> 4));
                if (x2 < r2) {
                    ++x2;
                    continue;
                }
                --z2;
            }
        }
        return list;
    }

    public static int fastFloor(double x2) {
        int truncated = (int)x2;
        return x2 < (double)truncated ? truncated - 1 : truncated;
    }

    public static int fastFloor(float x2) {
        int truncated = (int)x2;
        return (double)x2 < (double)truncated ? truncated - 1 : truncated;
    }

    public static float normalizeYaw(float f2) {
        float f1 = f2 % 360.0f;
        if (f1 >= 180.0f) {
            f1 -= 360.0f;
        }
        if (f1 < -180.0f) {
            f1 += 360.0f;
        }
        return f1;
    }

    public static String stack() {
        return ExceptionUtils.getFullStackTrace((Throwable)new Throwable());
    }

    public static String stack(String str) {
        return ExceptionUtils.getFullStackTrace((Throwable)new Throwable(str));
    }

    public static long getCoordinateKey(BlockPosition blockPos) {
        return (long)(blockPos.w() >> 4) << 32 | (long)(blockPos.u() >> 4) & 0xFFFFFFFFL;
    }

    public static long getCoordinateKey(net.minecraft.world.entity.Entity entity) {
        if (LeavesConfig.optimizeEntityCoordinateKey) {
            return (long)(entity.v.w() >> 4) << 32 | (long)(entity.v.u() >> 4) & 0xFFFFFFFFL;
        }
        return (long)(MCUtil.fastFloor(entity.dw()) >> 4) << 32 | (long)(MCUtil.fastFloor(entity.dq()) >> 4) & 0xFFFFFFFFL;
    }

    public static long getCoordinateKey(ChunkCoordIntPair pair) {
        return (long)pair.f << 32 | (long)pair.e & 0xFFFFFFFFL;
    }

    public static long getCoordinateKey(int x2, int z2) {
        return (long)z2 << 32 | (long)x2 & 0xFFFFFFFFL;
    }

    public static int getCoordinateX(long key) {
        return (int)key;
    }

    public static int getCoordinateZ(long key) {
        return (int)(key >>> 32);
    }

    public static int getChunkCoordinate(double coordinate) {
        return MCUtil.fastFloor(coordinate) >> 4;
    }

    public static int getBlockCoordinate(double coordinate) {
        return MCUtil.fastFloor(coordinate);
    }

    public static long getBlockKey(int x2, int y2, int z2) {
        return (long)x2 & 0x7FFFFFFL | ((long)z2 & 0x7FFFFFFL) << 27 | (long)y2 << 54;
    }

    public static long getBlockKey(BlockPosition pos) {
        return (long)pos.u() & 0x7FFFFFFL | ((long)pos.w() & 0x7FFFFFFL) << 27 | (long)pos.v() << 54;
    }

    public static long getBlockKey(net.minecraft.world.entity.Entity entity) {
        return MCUtil.getBlockKey(MCUtil.getBlockCoordinate(entity.dq()), MCUtil.getBlockCoordinate(entity.ds()), MCUtil.getBlockCoordinate(entity.dw()));
    }

    public static <T> void mergeSortedSets(Consumer<T> consumer, Comparator<? super T> comparator, SortedSet<T> ... sets) {
        ObjectRBTreeSet all = new ObjectRBTreeSet(comparator);
        for (SortedSet<T> set : sets) {
            if (set == null) continue;
            all.addAll(set);
        }
        all.forEach(consumer);
    }

    private MCUtil() {
    }

    public static <T> CompletableFuture<T> ensureMain(CompletableFuture<T> future) {
        return future.thenApplyAsync(r2 -> r2, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, Consumer<T> consumer) {
        future.thenAcceptAsync((Consumer)consumer, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, BiConsumer<T, Throwable> consumer) {
        future.whenCompleteAsync((BiConsumer)consumer, MAIN_EXECUTOR);
    }

    public static boolean isMainThread() {
        return MinecraftServer.getServer().bl();
    }

    public static BukkitTask scheduleTask(int ticks, Runnable runnable) {
        return MCUtil.scheduleTask(ticks, runnable, null);
    }

    public static BukkitTask scheduleTask(int ticks, Runnable runnable, String taskName) {
        return MinecraftServer.getServer().server.getScheduler().scheduleInternalTask(runnable, ticks, taskName);
    }

    public static void processQueue() {
        Runnable runnable;
        Queue<Runnable> processQueue = MCUtil.getProcessQueue();
        while ((runnable = processQueue.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Exception e2) {
                MinecraftServer.n.error("Error executing task", (Throwable)e2);
            }
        }
    }

    public static <T> T processQueueWhileWaiting(CompletableFuture<T> future) {
        try {
            if (MCUtil.isMainThread()) {
                while (!future.isDone()) {
                    try {
                        return future.get(1L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException ignored) {
                        MCUtil.processQueue();
                    }
                }
            }
            return future.get();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void ensureMain(Runnable run) {
        MCUtil.ensureMain(null, run);
    }

    public static void ensureMain(String reason, Runnable run) {
        if (!MCUtil.isMainThread()) {
            if (reason != null) {
                MinecraftServer.n.warn("Asynchronous " + reason + "!", (Throwable)new IllegalStateException());
            }
            MCUtil.getProcessQueue().add(run);
            return;
        }
        run.run();
    }

    private static Queue<Runnable> getProcessQueue() {
        return MinecraftServer.getServer().processQueue;
    }

    public static <T> T ensureMain(Supplier<T> run) {
        return MCUtil.ensureMain(null, run);
    }

    public static <T> T ensureMain(String reason, final Supplier<T> run) {
        if (!MCUtil.isMainThread()) {
            if (reason != null) {
                MinecraftServer.n.warn("Asynchronous " + reason + "! Blocking thread until it returns ", (Throwable)new IllegalStateException());
            }
            Waitable wait = new Waitable<T>(){

                @Override
                protected T evaluate() {
                    return run.get();
                }
            };
            MCUtil.getProcessQueue().add(wait);
            try {
                return wait.get();
            }
            catch (InterruptedException | ExecutionException e2) {
                MinecraftServer.n.warn("Encountered exception", (Throwable)e2);
                return null;
            }
        }
        return run.get();
    }

    public static PlayerProfile toBukkit(GameProfile profile) {
        return CraftPlayerProfile.asBukkitMirror(profile);
    }

    public static double distance(net.minecraft.world.entity.Entity e1, net.minecraft.world.entity.Entity e2) {
        return Math.sqrt(MCUtil.distanceSq(e1, e2));
    }

    public static double distance(BlockPosition e1, BlockPosition e2) {
        return Math.sqrt(MCUtil.distanceSq(e1, e2));
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(MCUtil.distanceSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distanceSq(net.minecraft.world.entity.Entity e1, net.minecraft.world.entity.Entity e2) {
        return MCUtil.distanceSq(e1.dq(), e1.ds(), e1.dw(), e2.dq(), e2.ds(), e2.dw());
    }

    public static double distanceSq(BlockPosition pos1, BlockPosition pos2) {
        return MCUtil.distanceSq(pos1.u(), pos1.v(), pos1.w(), pos2.u(), pos2.v(), pos2.w());
    }

    public static double distanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
    }

    public static Location toLocation(World world, double x2, double y2, double z2) {
        return new Location((org.bukkit.World)world.getWorld(), x2, y2, z2);
    }

    public static Location toLocation(World world, BlockPosition pos) {
        return new Location((org.bukkit.World)world.getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w());
    }

    public static Location toLocation(net.minecraft.world.entity.Entity entity) {
        return new Location((org.bukkit.World)entity.cJ().getWorld(), entity.dq(), entity.ds(), entity.dw());
    }

    public static Block toBukkitBlock(World world, BlockPosition pos) {
        return world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
    }

    public static BlockPosition toBlockPosition(Location loc) {
        return new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public static BlockPosition toBlockPos(Position pos) {
        return new BlockPosition(pos.blockX(), pos.blockY(), pos.blockZ());
    }

    public static BlockPosition toBlockPosition(Vector vec) {
        return new BlockPosition(vec.getBlockX(), vec.getBlockY(), vec.getBlockZ());
    }

    public static FinePosition toPosition(Vec3D vector) {
        return Position.fine((double)vector.c, (double)vector.d, (double)vector.e);
    }

    public static io.papermc.paper.math.BlockPosition toPosition(BaseBlockPosition vector) {
        return Position.block((int)vector.u(), (int)vector.v(), (int)vector.w());
    }

    public static Vec3D toVec3(Position position) {
        return new Vec3D(position.x(), position.y(), position.z());
    }

    public static boolean isEdgeOfChunk(BlockPosition pos) {
        int modX = pos.u() & 0xF;
        int modZ = pos.w() & 0xF;
        return modX == 0 || modX == 15 || modZ == 0 || modZ == 15;
    }

    public static void scheduleAsyncTask(Runnable run) {
        asyncExecutor.execute(run);
    }

    @Nonnull
    public static WorldServer getNMSWorld(@Nonnull org.bukkit.World world) {
        return ((CraftWorld)world).getHandle();
    }

    public static WorldServer getNMSWorld(@Nonnull Entity entity) {
        return MCUtil.getNMSWorld(entity.getWorld());
    }

    public static BlockFace toBukkitBlockFace(EnumDirection enumDirection) {
        switch (enumDirection) {
            case a: {
                return BlockFace.DOWN;
            }
            case b: {
                return BlockFace.UP;
            }
            case c: {
                return BlockFace.NORTH;
            }
            case d: {
                return BlockFace.SOUTH;
            }
            case e: {
                return BlockFace.WEST;
            }
            case f: {
                return BlockFace.EAST;
            }
        }
        return null;
    }

    public static ChunkStatus getChunkStatus(PlayerChunk chunk) {
        return chunk.getChunkHolderStatus();
    }

    /*
     * WARNING - void declaration
     */
    public static void dumpChunks(File file, boolean watchdog) throws IOException {
        void var8_12;
        file.getParentFile().mkdirs();
        file.createNewFile();
        ReferenceArrayList worlds = new ReferenceArrayList((Collection)Bukkit.getWorlds());
        ReferenceArrayList loadedWorlds = new ReferenceArrayList((ReferenceList)worlds);
        JsonObject data = new JsonObject();
        data.addProperty("server-version", Bukkit.getVersion());
        data.addProperty("data-version", (Number)1);
        JsonArray players = new JsonArray();
        data.add("all-players", (JsonElement)players);
        ChunkTaskScheduler.ChunkInfo[] playerList = MinecraftServer.getServer().ac().l;
        for (EntityPlayer entityPlayer : playerList) {
            JsonObject playerData = new JsonObject();
            players.add((JsonElement)playerData);
            World playerWorld = entityPlayer.dL();
            CraftWorld craftWorld = playerWorld.getWorld();
            Entity.RemovalReason removalReason = entityPlayer.dH();
            playerData.addProperty("name", entityPlayer.cx());
            playerData.addProperty("x", (Number)entityPlayer.dq());
            playerData.addProperty("y", (Number)entityPlayer.ds());
            playerData.addProperty("z", (Number)entityPlayer.dw());
            playerData.addProperty("world", playerWorld == null ? "null world" : craftWorld.getName());
            playerData.addProperty("removalReason", removalReason == null ? "null" : removalReason.name());
            if (worlds.contains((Object)craftWorld)) continue;
            worlds.add((Object)craftWorld);
        }
        JsonArray chunkWaitInformation = new JsonArray();
        data.add("chunk-wait-infos", (JsonElement)chunkWaitInformation);
        playerList = ChunkTaskScheduler.getChunkInfos();
        int n2 = playerList.length;
        boolean bl = false;
        while (var8_12 < n2) {
            ChunkTaskScheduler.ChunkInfo chunkInfo = playerList[var8_12];
            chunkWaitInformation.add(chunkInfo.toString());
            ++var8_12;
        }
        JsonArray worldsData = new JsonArray();
        for (org.bukkit.World world : worlds) {
            JsonObject worldData = new JsonObject();
            WorldServer world2 = ((CraftWorld)world).getHandle();
            List<EntityPlayer> players2 = world2.v();
            worldData.addProperty("is-loaded", Boolean.valueOf(loadedWorlds.contains((Object)world)));
            worldData.addProperty("name", world2.getWorld().getName());
            worldData.addProperty("view-distance", (Number)world2.getWorld().getViewDistance());
            worldData.addProperty("tick-view-distance", (Number)world2.getWorld().getSimulationDistance());
            worldData.addProperty("keep-spawn-loaded", Boolean.valueOf(world2.keepSpawnInMemory));
            worldData.addProperty("keep-spawn-loaded-range", (Number)(world2.paperConfig().spawn.keepSpawnLoadedRange * 16));
            JsonArray playersData = new JsonArray();
            for (EntityPlayer player : players2) {
                JsonObject playerData = new JsonObject();
                playerData.addProperty("name", player.cx());
                playerData.addProperty("x", (Number)player.dq());
                playerData.addProperty("y", (Number)player.ds());
                playerData.addProperty("z", (Number)player.dw());
                playersData.add((JsonElement)playerData);
            }
            worldData.add("players", (JsonElement)playersData);
            worldData.add("chunk-data", (JsonElement)(watchdog ? world2.chunkTaskScheduler.chunkHolderManager.getDebugJsonForWatchdog() : world2.chunkTaskScheduler.chunkHolderManager.getDebugJson()));
            worldsData.add((JsonElement)worldData);
        }
        data.add("worlds", (JsonElement)worldsData);
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        jsonWriter.setIndent(" ");
        jsonWriter.setLenient(false);
        Streams.write((JsonElement)data, (JsonWriter)jsonWriter);
        String fileData = stringWriter.toString();
        try (PrintStream out = new PrintStream((OutputStream)new FileOutputStream(file), false, StandardCharsets.UTF_8);){
            out.print(fileData);
        }
    }

    public static int getTicketLevelFor(ChunkStatus status) {
        return 32 + ChunkStatus.a(status);
    }

    @Nullable
    public static IChatBaseComponent getBaseComponentFromNbt(String key, NBTTagCompound compound) {
        if (!compound.e(key)) {
            return null;
        }
        String string = compound.l(key);
        try {
            return IChatBaseComponent.ChatSerializer.a(string);
        }
        catch (JsonParseException e2) {
            Bukkit.getLogger().warning("Unable to parse " + key + " from " + compound + ": " + e2.getMessage());
            return null;
        }
    }

    private static final class CleanerHolder {
        private static final Cleaner CLEANER = Cleaner.create();

        private CleanerHolder() {
        }
    }
}

