/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util.player;

import com.destroystokyo.paper.util.maplist.ReferenceList;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.player.SingleUserAreaMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;

public final class NearbyPlayers {
    private static final NearbyMapType[] MOB_TYPES = NearbyMapType.values();
    public static final int TOTAL_MAP_TYPES = MOB_TYPES.length;
    private static final int GENERAL_AREA_VIEW_DISTANCE = 33;
    private static final int GENERAL_SMALL_VIEW_DISTANCE = 10;
    private static final int GENERAL_REALLY_SMALL_VIEW_DISTANCE = 3;
    private static final int SPAWN_RANGE_VIEW_DISTANCE = 8;
    public static final int GENERAL_AREA_VIEW_DISTANCE_BLOCKS = 528;
    public static final int GENERAL_SMALL_AREA_VIEW_DISTANCE_BLOCKS = 160;
    public static final int GENERAL_REALLY_SMALL_AREA_VIEW_DISTANCE_BLOCKS = 48;
    public static final int SPAWN_RANGE_VIEW_DISTANCE_BLOCKS = 128;
    private final WorldServer world;
    private final Reference2ReferenceOpenHashMap<EntityPlayer, TrackedPlayer[]> players = new Reference2ReferenceOpenHashMap();
    private final Long2ReferenceOpenHashMap<TrackedChunk> byChunk = new Long2ReferenceOpenHashMap();

    public NearbyPlayers(WorldServer world) {
        this.world = world;
    }

    public void addPlayer(EntityPlayer player) {
        TrackedPlayer[] newTrackers = new TrackedPlayer[TOTAL_MAP_TYPES];
        if (this.players.putIfAbsent((Object)player, (Object)newTrackers) != null) {
            throw new IllegalStateException("Already have player " + player);
        }
        ChunkCoordIntPair chunk = player.dn();
        for (int i2 = 0; i2 < TOTAL_MAP_TYPES; ++i2) {
            newTrackers[i2] = new TrackedPlayer(player, MOB_TYPES[i2]);
            newTrackers[i2].add(chunk.e, chunk.f, 0);
        }
        this.tickPlayer(player);
    }

    public void removePlayer(EntityPlayer player) {
        TrackedPlayer[] players = (TrackedPlayer[])this.players.remove((Object)player);
        if (players == null) {
            return;
        }
        for (TrackedPlayer tracker : players) {
            tracker.remove();
        }
    }

    public void tickPlayer(EntityPlayer player) {
        TrackedPlayer[] players = (TrackedPlayer[])this.players.get((Object)player);
        if (players == null) {
            throw new IllegalStateException("Don't have player " + player);
        }
        ChunkCoordIntPair chunk = player.dn();
        players[NearbyMapType.GENERAL.ordinal()].update(chunk.e, chunk.f, 33);
        players[NearbyMapType.GENERAL_SMALL.ordinal()].update(chunk.e, chunk.f, 10);
        players[NearbyMapType.GENERAL_REALLY_SMALL.ordinal()].update(chunk.e, chunk.f, 3);
        players[NearbyMapType.TICK_VIEW_DISTANCE.ordinal()].update(chunk.e, chunk.f, ChunkSystem.getTickViewDistance(player));
        players[NearbyMapType.VIEW_DISTANCE.ordinal()].update(chunk.e, chunk.f, ChunkSystem.getLoadViewDistance(player));
        players[NearbyMapType.SPAWN_RANGE.ordinal()].update(chunk.e, chunk.f, 8);
    }

    public TrackedChunk getChunk(ChunkCoordIntPair pos) {
        return (TrackedChunk)this.byChunk.get(CoordinateUtils.getChunkKey(pos));
    }

    public TrackedChunk getChunk(BlockPosition pos) {
        return (TrackedChunk)this.byChunk.get(CoordinateUtils.getChunkKey(pos));
    }

    public ReferenceList<EntityPlayer> getPlayers(BlockPosition pos, NearbyMapType type) {
        TrackedChunk chunk = (TrackedChunk)this.byChunk.get(CoordinateUtils.getChunkKey(pos));
        return chunk == null ? null : chunk.players[type.ordinal()];
    }

    public ReferenceList<EntityPlayer> getPlayers(ChunkCoordIntPair pos, NearbyMapType type) {
        TrackedChunk chunk = (TrackedChunk)this.byChunk.get(CoordinateUtils.getChunkKey(pos));
        return chunk == null ? null : chunk.players[type.ordinal()];
    }

    public ReferenceList<EntityPlayer> getPlayersByChunk(int chunkX, int chunkZ, NearbyMapType type) {
        TrackedChunk chunk = (TrackedChunk)this.byChunk.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        return chunk == null ? null : chunk.players[type.ordinal()];
    }

    public ReferenceList<EntityPlayer> getPlayersByBlock(int blockX, int blockZ, NearbyMapType type) {
        TrackedChunk chunk = (TrackedChunk)this.byChunk.get(CoordinateUtils.getChunkKey(blockX >> 4, blockZ >> 4));
        return chunk == null ? null : chunk.players[type.ordinal()];
    }

    private final class TrackedPlayer
    extends SingleUserAreaMap<EntityPlayer> {
        final NearbyMapType type;

        public TrackedPlayer(EntityPlayer player, NearbyMapType type) {
            super(player);
            this.type = type;
        }

        @Override
        protected void addCallback(EntityPlayer parameter, int chunkX, int chunkZ) {
            long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
            ((TrackedChunk)NearbyPlayers.this.byChunk.computeIfAbsent(chunkKey, keyInMap -> new TrackedChunk())).addPlayer(parameter, this.type);
        }

        @Override
        protected void removeCallback(EntityPlayer parameter, int chunkX, int chunkZ) {
            long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
            TrackedChunk chunk = (TrackedChunk)NearbyPlayers.this.byChunk.get(chunkKey);
            if (chunk == null) {
                throw new IllegalStateException("Chunk should exist at " + new ChunkCoordIntPair(chunkKey));
            }
            chunk.removePlayer(parameter, this.type);
            if (chunk.isEmpty()) {
                NearbyPlayers.this.byChunk.remove(chunkKey);
            }
        }
    }

    public static enum NearbyMapType {
        GENERAL,
        GENERAL_SMALL,
        GENERAL_REALLY_SMALL,
        TICK_VIEW_DISTANCE,
        VIEW_DISTANCE,
        SPAWN_RANGE;

    }

    public static final class TrackedChunk {
        public final ReferenceList<EntityPlayer>[] players = new ReferenceList[TOTAL_MAP_TYPES];
        private int nonEmptyLists;
        private int updateCount;

        public boolean isEmpty() {
            return this.nonEmptyLists == 0;
        }

        public int getUpdateCount() {
            return this.updateCount;
        }

        public ReferenceList<EntityPlayer> getPlayers(NearbyMapType type) {
            return this.players[type.ordinal()];
        }

        public void addPlayer(EntityPlayer player, NearbyMapType type) {
            ++this.updateCount;
            int idx = type.ordinal();
            ReferenceList<EntityPlayer> list = this.players[idx];
            if (list == null) {
                ++this.nonEmptyLists;
                this.players[idx] = new ReferenceList<EntityPlayer>();
                this.players[idx].add(player);
                return;
            }
            if (!list.add(player)) {
                throw new IllegalStateException("Already contains player " + player);
            }
        }

        public void removePlayer(EntityPlayer player, NearbyMapType type) {
            ++this.updateCount;
            int idx = type.ordinal();
            ReferenceList<EntityPlayer> list = this.players[idx];
            if (list == null) {
                throw new IllegalStateException("Does not contain player " + player);
            }
            if (!list.remove(player)) {
                throw new IllegalStateException("Does not contain player " + player);
            }
            if (list.size() == 0) {
                this.players[idx] = null;
                --this.nonEmptyLists;
            }
        }
    }
}

