/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;
import top.leavesmc.leaves.LeavesConfig;

public record Advancement(Optional<MinecraftKey> a, Optional<AdvancementDisplay> b, AdvancementRewards c, Map<String, Criterion<?>> d, AdvancementRequirements e, boolean f, Optional<IChatBaseComponent> g) {
    private final Optional<MinecraftKey> a;
    private final Optional<AdvancementDisplay> b;
    private final AdvancementRewards c;
    private final Map<String, Criterion<?>> d;
    private final AdvancementRequirements e;
    private final boolean f;
    private final Optional<IChatBaseComponent> g;

    public Advancement(Optional<MinecraftKey> parent, Optional<AdvancementDisplay> display, AdvancementRewards rewards, Map<String, Criterion<?>> criteria, AdvancementRequirements requirements, boolean sendsTelemetryEvent) {
        this(parent, display, rewards, !LeavesConfig.skipCloningAdvancementCriteria ? Map.copyOf(criteria) : criteria, requirements, sendsTelemetryEvent, display.map(Advancement::a));
    }

    public static IChatBaseComponent a(AdvancementDisplay display) {
        IChatBaseComponent component = display.a();
        EnumChatFormat chatFormatting = display.e().b();
        IChatMutableComponent component2 = ChatComponentUtils.a(component.e(), ChatModifier.a.a(chatFormatting)).f("\n").b(display.b());
        IChatMutableComponent component3 = component.e().a(style -> style.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, component2)));
        return ChatComponentUtils.a(component3).a(chatFormatting);
    }

    public static IChatBaseComponent a(AdvancementHolder identifiedAdvancement) {
        return identifiedAdvancement.b().i().orElseGet(() -> IChatBaseComponent.b(identifiedAdvancement.a().toString()));
    }

    public JsonObject a() {
        JsonObject jsonObject = new JsonObject();
        this.a.ifPresent(parent -> jsonObject.addProperty("parent", parent.toString()));
        this.b.ifPresent(display -> jsonObject.add("display", display.k()));
        jsonObject.add("rewards", this.c.b());
        JsonObject jsonObject2 = new JsonObject();
        for (Map.Entry<String, Criterion<?>> entry : this.d.entrySet()) {
            jsonObject2.add(entry.getKey(), entry.getValue().a());
        }
        jsonObject.add("criteria", (JsonElement)jsonObject2);
        jsonObject.add("requirements", (JsonElement)this.e.b());
        jsonObject.addProperty("sends_telemetry_event", Boolean.valueOf(this.f));
        return jsonObject;
    }

    public static Advancement a(JsonObject json, LootDeserializationContext predicateDeserializer) {
        Optional<MinecraftKey> optional = json.has("parent") ? Optional.of(new MinecraftKey(ChatDeserializer.i(json, "parent"))) : Optional.empty();
        Optional<AdvancementDisplay> optional2 = json.has("display") ? Optional.of(AdvancementDisplay.a(ChatDeserializer.u(json, "display"))) : Optional.empty();
        AdvancementRewards advancementRewards = json.has("rewards") ? AdvancementRewards.a(ChatDeserializer.u(json, "rewards")) : AdvancementRewards.a;
        Map<String, Criterion<?>> map = Criterion.b(ChatDeserializer.u(json, "criteria"), predicateDeserializer);
        if (map.isEmpty()) {
            throw new JsonSyntaxException("Advancement criteria cannot be empty");
        }
        JsonArray jsonArray = ChatDeserializer.a(json, "requirements", new JsonArray());
        AdvancementRequirements advancementRequirements = jsonArray.isEmpty() ? AdvancementRequirements.a(map.keySet()) : AdvancementRequirements.a(jsonArray, map.keySet());
        boolean bl = ChatDeserializer.a(json, "sends_telemetry_event", false);
        return new Advancement(optional, optional2, advancementRewards, map, advancementRequirements, bl);
    }

    public void a(PacketDataSerializer buf) {
        buf.a(this.a, PacketDataSerializer::a);
        buf.a(this.b, (bufx, display) -> display.a((PacketDataSerializer)((Object)bufx)));
        this.e.a(buf);
        buf.a(this.f);
    }

    public static Advancement b(PacketDataSerializer buf) {
        return new Advancement(buf.b(PacketDataSerializer::s), buf.b(AdvancementDisplay::b), AdvancementRewards.a, Map.of(), new AdvancementRequirements(buf), buf.readBoolean());
    }

    public boolean b() {
        return this.a.isEmpty();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "a", "b", "c", "d", "e", "f", "g"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "a", "b", "c", "d", "e", "f", "g"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "a", "b", "c", "d", "e", "f", "g"}, this, o2);
    }

    public Optional<MinecraftKey> c() {
        return this.a;
    }

    public Optional<AdvancementDisplay> d() {
        return this.b;
    }

    public AdvancementRewards e() {
        return this.c;
    }

    public Map<String, Criterion<?>> f() {
        return this.d;
    }

    public AdvancementRequirements g() {
        return this.e;
    }

    public boolean h() {
        return this.f;
    }

    public Optional<IChatBaseComponent> i() {
        return this.g;
    }

    public static class SerializedAdvancement {
        private Optional<MinecraftKey> a = Optional.empty();
        private Optional<AdvancementDisplay> b = Optional.empty();
        private AdvancementRewards c = AdvancementRewards.a;
        private final ImmutableMap.Builder<String, Criterion<?>> d = ImmutableMap.builder();
        private Optional<AdvancementRequirements> e = Optional.empty();
        private AdvancementRequirements.a f = AdvancementRequirements.a.a;
        private boolean g;

        public static SerializedAdvancement a() {
            return new SerializedAdvancement().c();
        }

        public static SerializedAdvancement b() {
            return new SerializedAdvancement();
        }

        public SerializedAdvancement a(AdvancementHolder parent) {
            this.a = Optional.of(parent.a());
            return this;
        }

        @Deprecated(forRemoval=true)
        public SerializedAdvancement a(MinecraftKey parentId) {
            this.a = Optional.of(parentId);
            return this;
        }

        public SerializedAdvancement a(ItemStack icon, IChatBaseComponent title, IChatBaseComponent description, @Nullable MinecraftKey background, AdvancementFrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.a(new AdvancementDisplay(icon, title, description, background, frame, showToast, announceToChat, hidden));
        }

        public SerializedAdvancement a(IMaterial icon, IChatBaseComponent title, IChatBaseComponent description, @Nullable MinecraftKey background, AdvancementFrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.a(new AdvancementDisplay(new ItemStack(icon.k()), title, description, background, frame, showToast, announceToChat, hidden));
        }

        public SerializedAdvancement a(AdvancementDisplay display) {
            this.b = Optional.of(display);
            return this;
        }

        public SerializedAdvancement a(AdvancementRewards.a builder) {
            return this.a(builder.a());
        }

        public SerializedAdvancement a(AdvancementRewards rewards) {
            this.c = rewards;
            return this;
        }

        public SerializedAdvancement a(String name, Criterion<?> criterion) {
            this.d.put((Object)name, criterion);
            return this;
        }

        public SerializedAdvancement a(AdvancementRequirements.a merger) {
            this.f = merger;
            return this;
        }

        public SerializedAdvancement a(AdvancementRequirements requirements) {
            this.e = Optional.of(requirements);
            return this;
        }

        public SerializedAdvancement c() {
            this.g = true;
            return this;
        }

        public AdvancementHolder b(MinecraftKey id) {
            ImmutableMap map = this.d.buildOrThrow();
            AdvancementRequirements advancementRequirements = this.e.orElseGet(() -> this.a((Map)map));
            return new AdvancementHolder(id, new Advancement(this.a, this.b, this.c, (Map<String, Criterion<?>>)map, advancementRequirements, this.g));
        }

        public AdvancementHolder a(Consumer<AdvancementHolder> exporter, String id) {
            AdvancementHolder advancementHolder = this.b(new MinecraftKey(id));
            exporter.accept(advancementHolder);
            return advancementHolder;
        }

        private /* synthetic */ AdvancementRequirements a(Map map) {
            return this.f.create(map.keySet());
        }
    }
}

