/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.advancement.PaperAdvancementDisplay;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AdvancementDisplay {
    private final IChatBaseComponent a;
    private final IChatBaseComponent b;
    private final ItemStack c;
    @Nullable
    private final MinecraftKey d;
    private final AdvancementFrameType e;
    private final boolean f;
    private final boolean g;
    private final boolean h;
    private float i;
    private float j;
    public final io.papermc.paper.advancement.AdvancementDisplay paper = new PaperAdvancementDisplay(this);

    public AdvancementDisplay(ItemStack icon, IChatBaseComponent title, IChatBaseComponent description, @Nullable MinecraftKey background, AdvancementFrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        this.a = title;
        this.b = description;
        this.c = icon;
        this.d = background;
        this.e = frame;
        this.f = showToast;
        this.g = announceToChat;
        this.h = hidden;
    }

    public void a(float x2, float y2) {
        this.i = x2;
        this.j = y2;
    }

    public IChatBaseComponent a() {
        return this.a;
    }

    public IChatBaseComponent b() {
        return this.b;
    }

    public ItemStack c() {
        return this.c;
    }

    @Nullable
    public MinecraftKey d() {
        return this.d;
    }

    public AdvancementFrameType e() {
        return this.e;
    }

    public float f() {
        return this.i;
    }

    public float g() {
        return this.j;
    }

    public boolean h() {
        return this.f;
    }

    public boolean i() {
        return this.g;
    }

    public boolean j() {
        return this.h;
    }

    public static AdvancementDisplay a(JsonObject obj) {
        IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(obj.get("title"));
        IChatMutableComponent component2 = IChatBaseComponent.ChatSerializer.a(obj.get("description"));
        if (component != null && component2 != null) {
            ItemStack itemStack = AdvancementDisplay.b(ChatDeserializer.u(obj, "icon"));
            MinecraftKey resourceLocation = obj.has("background") ? new MinecraftKey(ChatDeserializer.i(obj, "background")) : null;
            AdvancementFrameType frameType = obj.has("frame") ? AdvancementFrameType.a(ChatDeserializer.i(obj, "frame")) : AdvancementFrameType.a;
            boolean bl = ChatDeserializer.a(obj, "show_toast", true);
            boolean bl2 = ChatDeserializer.a(obj, "announce_to_chat", true);
            boolean bl3 = ChatDeserializer.a(obj, "hidden", false);
            return new AdvancementDisplay(itemStack, component, component2, resourceLocation, frameType, bl, bl2, bl3);
        }
        throw new JsonSyntaxException("Both title and description must be set");
    }

    private static ItemStack b(JsonObject json) {
        if (!json.has("item")) {
            throw new JsonSyntaxException("Unsupported icon type, currently only items are supported (add 'item' key)");
        }
        Holder<Item> holder = ChatDeserializer.j(json, "item");
        if (json.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        ItemStack itemStack = new ItemStack(holder);
        if (json.has("nbt")) {
            try {
                NBTTagCompound compoundTag = MojangsonParser.a(ChatDeserializer.a(json.get("nbt"), "nbt"));
                itemStack.c(compoundTag);
            }
            catch (CommandSyntaxException var4) {
                throw new JsonSyntaxException("Invalid nbt tag: " + var4.getMessage());
            }
        }
        return itemStack;
    }

    public void a(PacketDataSerializer buf) {
        buf.a(this.a);
        buf.a(this.b);
        buf.a(this.c);
        buf.a(this.e);
        int i2 = 0;
        if (this.d != null) {
            i2 |= 1;
        }
        if (this.f) {
            i2 |= 2;
        }
        if (this.h) {
            i2 |= 4;
        }
        buf.p(i2);
        if (this.d != null) {
            buf.a(this.d);
        }
        buf.a(this.i);
        buf.a(this.j);
    }

    public static AdvancementDisplay b(PacketDataSerializer buf) {
        IChatBaseComponent component = buf.l();
        IChatBaseComponent component2 = buf.l();
        ItemStack itemStack = buf.q();
        AdvancementFrameType frameType = buf.b(AdvancementFrameType.class);
        int i2 = buf.readInt();
        MinecraftKey resourceLocation = (i2 & 1) != 0 ? buf.s() : null;
        boolean bl = (i2 & 2) != 0;
        boolean bl2 = (i2 & 4) != 0;
        AdvancementDisplay displayInfo = new AdvancementDisplay(itemStack, component, component2, resourceLocation, frameType, bl, false, bl2);
        displayInfo.a(buf.readFloat(), buf.readFloat());
        return displayInfo;
    }

    public JsonElement k() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("icon", (JsonElement)this.l());
        jsonObject.add("title", IChatBaseComponent.ChatSerializer.c(this.a));
        jsonObject.add("description", IChatBaseComponent.ChatSerializer.c(this.b));
        jsonObject.addProperty("frame", this.e.a());
        jsonObject.addProperty("show_toast", Boolean.valueOf(this.f));
        jsonObject.addProperty("announce_to_chat", Boolean.valueOf(this.g));
        jsonObject.addProperty("hidden", Boolean.valueOf(this.h));
        if (this.d != null) {
            jsonObject.addProperty("background", this.d.toString());
        }
        return jsonObject;
    }

    private JsonObject l() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("item", BuiltInRegistries.i.b(this.c.d()).toString());
        if (this.c.u()) {
            jsonObject.addProperty("nbt", this.c.v().toString());
        }
        return jsonObject;
    }
}

