/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ExtraCodecs;

public class AdvancementProgress
implements Comparable<AdvancementProgress> {
    private static final DateTimeFormatter b = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    private static final Codec<Instant> c = ExtraCodecs.a(b).xmap(Instant::from, instant -> instant.atZone(ZoneId.systemDefault()));
    private static final Codec<Map<String, CriterionProgress>> d = Codec.unboundedMap((Codec)Codec.STRING, c).xmap(map -> map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new CriterionProgress((Instant)entry.getValue()))), map -> map.entrySet().stream().filter(entry -> ((CriterionProgress)entry.getValue()).a()).collect(Collectors.toMap(Map.Entry::getKey, entry -> Objects.requireNonNull(((CriterionProgress)entry.getValue()).d()))));
    public static final Codec<AdvancementProgress> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a(d, "criteria", Map.of()).forGetter(advancementProgress -> advancementProgress.e), (App)Codec.BOOL.fieldOf("done").orElse((Object)true).forGetter(AdvancementProgress::a)).apply((Applicative)instance, (criteriaProgresses, done) -> new AdvancementProgress(new HashMap<String, CriterionProgress>((Map<String, CriterionProgress>)criteriaProgresses))));
    private final Map<String, CriterionProgress> e;
    private AdvancementRequirements f = AdvancementRequirements.a;

    private AdvancementProgress(Map<String, CriterionProgress> criteriaProgresses) {
        this.e = criteriaProgresses;
    }

    public AdvancementProgress() {
        this.e = Maps.newHashMap();
    }

    public void a(AdvancementRequirements requirements) {
        Set<String> set = requirements.d();
        this.e.entrySet().removeIf(progress -> !set.contains(progress.getKey()));
        for (String string : set) {
            this.e.putIfAbsent(string, new CriterionProgress());
        }
        this.f = requirements;
    }

    public boolean a() {
        return this.f.a(this::d);
    }

    public boolean b() {
        for (CriterionProgress criterionProgress : this.e.values()) {
            if (!criterionProgress.a()) continue;
            return true;
        }
        return false;
    }

    public boolean a(String name) {
        CriterionProgress criterionProgress = this.e.get(name);
        if (criterionProgress != null && !criterionProgress.a()) {
            criterionProgress.b();
            return true;
        }
        return false;
    }

    public boolean b(String name) {
        CriterionProgress criterionProgress = this.e.get(name);
        if (criterionProgress != null && criterionProgress.a()) {
            criterionProgress.c();
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "AdvancementProgress{criteria=" + this.e + ", requirements=" + this.f + "}";
    }

    public void a(PacketDataSerializer buf) {
        buf.a(this.e, PacketDataSerializer::a, (bufx, progresses) -> progresses.a((PacketDataSerializer)((Object)bufx)));
    }

    public static AdvancementProgress b(PacketDataSerializer buf) {
        Map<String, CriterionProgress> map = buf.a(PacketDataSerializer::r, CriterionProgress::b);
        return new AdvancementProgress(map);
    }

    @Nullable
    public CriterionProgress c(String name) {
        return this.e.get(name);
    }

    private boolean d(String name) {
        CriterionProgress criterionProgress = this.c(name);
        return criterionProgress != null && criterionProgress.a();
    }

    public float c() {
        if (this.e.isEmpty()) {
            return 0.0f;
        }
        float f2 = this.f.a();
        float g2 = this.h();
        return g2 / f2;
    }

    @Nullable
    public IChatBaseComponent d() {
        if (this.e.isEmpty()) {
            return null;
        }
        int i2 = this.f.a();
        if (i2 <= 1) {
            return null;
        }
        int j2 = this.h();
        return IChatBaseComponent.a("advancements.progress", j2, i2);
    }

    private int h() {
        return this.f.b(this::d);
    }

    public Iterable<String> e() {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, CriterionProgress> entry : this.e.entrySet()) {
            if (entry.getValue().a()) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    public Iterable<String> f() {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, CriterionProgress> entry : this.e.entrySet()) {
            if (!entry.getValue().a()) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    @Nullable
    public Instant g() {
        return this.e.values().stream().map(CriterionProgress::d).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null);
    }

    @Override
    public int a(AdvancementProgress advancementProgress) {
        Instant instant = this.g();
        Instant instant2 = advancementProgress.g();
        if (instant == null && instant2 != null) {
            return 1;
        }
        if (instant != null && instant2 == null) {
            return -1;
        }
        if (instant == null && instant2 == null) {
            return 0;
        }
        return instant.compareTo(instant2);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.a((AdvancementProgress)object);
    }
}

