/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class ContextAwarePredicate {
    private final List<LootItemCondition> a;
    private final Predicate<LootTableInfo> b;

    ContextAwarePredicate(List<LootItemCondition> conditions) {
        if (conditions.isEmpty()) {
            throw new IllegalArgumentException("ContextAwarePredicate must have at least one condition");
        }
        this.a = conditions;
        this.b = LootItemConditions.a(conditions);
    }

    public static ContextAwarePredicate a(LootItemCondition ... conditions) {
        return new ContextAwarePredicate(List.of(conditions));
    }

    public static Optional<Optional<ContextAwarePredicate>> a(String key, LootDeserializationContext predicateDeserializer, @Nullable JsonElement json, LootContextParameterSet contextType) {
        if (json != null && json.isJsonArray()) {
            List<LootItemCondition> list = predicateDeserializer.a(json.getAsJsonArray(), predicateDeserializer.a() + "/" + key, contextType);
            if (list.isEmpty()) {
                return Optional.of(Optional.empty());
            }
            return Optional.of(Optional.of(new ContextAwarePredicate(list)));
        }
        return Optional.empty();
    }

    public boolean a(LootTableInfo context) {
        return this.b.test(context);
    }

    public JsonElement a() {
        return (JsonElement)SystemUtils.a(LootItemConditions.a.listOf().encodeStart((DynamicOps)JsonOps.INSTANCE, this.a), IllegalStateException::new);
    }

    public static JsonElement a(List<ContextAwarePredicate> list) {
        if (list.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        JsonArray jsonArray = new JsonArray();
        for (ContextAwarePredicate contextAwarePredicate : list) {
            jsonArray.add(contextAwarePredicate.a());
        }
        return jsonArray;
    }
}

