/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionDistance;
import net.minecraft.advancements.critereon.CriterionConditionEntityEquipment;
import net.minecraft.advancements.critereon.CriterionConditionEntityFlags;
import net.minecraft.advancements.critereon.CriterionConditionEntityType;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.advancements.critereon.CriterionConditionMobEffect;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeamBase;

public record CriterionConditionEntity(Optional<CriterionConditionEntityType> b, Optional<CriterionConditionDistance> c, Optional<CriterionConditionLocation> d, Optional<CriterionConditionLocation> e, Optional<CriterionConditionMobEffect> f, Optional<CriterionConditionNBT> g, Optional<CriterionConditionEntityFlags> h, Optional<CriterionConditionEntityEquipment> i, Optional<EntitySubPredicate> j, Optional<CriterionConditionEntity> k, Optional<CriterionConditionEntity> l, Optional<CriterionConditionEntity> m, Optional<String> n) {
    public static final Codec<CriterionConditionEntity> a = ExtraCodecs.a((Codec<T> entityPredicateCodec) -> RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a(CriterionConditionEntityType.a, "type").forGetter(CriterionConditionEntity::b), (App)ExtraCodecs.a(CriterionConditionDistance.a, "distance").forGetter(CriterionConditionEntity::c), (App)ExtraCodecs.a(CriterionConditionLocation.a, "location").forGetter(CriterionConditionEntity::d), (App)ExtraCodecs.a(CriterionConditionLocation.a, "stepping_on").forGetter(CriterionConditionEntity::e), (App)ExtraCodecs.a(CriterionConditionMobEffect.a, "effects").forGetter(CriterionConditionEntity::f), (App)ExtraCodecs.a(CriterionConditionNBT.a, "nbt").forGetter(CriterionConditionEntity::g), (App)ExtraCodecs.a(CriterionConditionEntityFlags.a, "flags").forGetter(CriterionConditionEntity::h), (App)ExtraCodecs.a(CriterionConditionEntityEquipment.a, "equipment").forGetter(CriterionConditionEntity::i), (App)ExtraCodecs.a(EntitySubPredicate.a, "type_specific").forGetter(CriterionConditionEntity::j), (App)ExtraCodecs.a(entityPredicateCodec, "vehicle").forGetter(CriterionConditionEntity::k), (App)ExtraCodecs.a(entityPredicateCodec, "passenger").forGetter(CriterionConditionEntity::l), (App)ExtraCodecs.a(entityPredicateCodec, "targeted_entity").forGetter(CriterionConditionEntity::m), (App)ExtraCodecs.a(Codec.STRING, "team").forGetter(CriterionConditionEntity::n)).apply((Applicative)instance, CriterionConditionEntity::new)));

    public static Optional<ContextAwarePredicate> a(JsonObject json, String key, LootDeserializationContext predicateDeserializer) {
        JsonElement jsonElement = json.get(key);
        return CriterionConditionEntity.a(key, predicateDeserializer, jsonElement);
    }

    public static List<ContextAwarePredicate> b(JsonObject json, String key, LootDeserializationContext predicateDeserializer) {
        JsonElement jsonElement = json.get(key);
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return List.of();
        }
        JsonArray jsonArray = ChatDeserializer.n(jsonElement, key);
        ArrayList list = new ArrayList(jsonArray.size());
        for (int i2 = 0; i2 < jsonArray.size(); ++i2) {
            CriterionConditionEntity.a(key + "[" + i2 + "]", predicateDeserializer, jsonArray.get(i2)).ifPresent(list::add);
        }
        return List.copyOf(list);
    }

    private static Optional<ContextAwarePredicate> a(String key, LootDeserializationContext predicateDeserializer, @Nullable JsonElement json) {
        Optional<Optional<ContextAwarePredicate>> optional = ContextAwarePredicate.a(key, predicateDeserializer, json, LootContextParameterSets.l);
        if (optional.isPresent()) {
            return optional.get();
        }
        Optional<CriterionConditionEntity> optional2 = CriterionConditionEntity.a(json);
        return CriterionConditionEntity.a(optional2);
    }

    public static ContextAwarePredicate a(a builder) {
        return CriterionConditionEntity.a(builder.b());
    }

    public static Optional<ContextAwarePredicate> a(Optional<CriterionConditionEntity> entityPredicate) {
        return entityPredicate.map(CriterionConditionEntity::a);
    }

    public static List<ContextAwarePredicate> a(a ... builders) {
        return Stream.of(builders).map(CriterionConditionEntity::a).toList();
    }

    public static ContextAwarePredicate a(CriterionConditionEntity predicate) {
        LootItemCondition lootItemCondition = LootItemConditionEntityProperty.a(LootTableInfo.EntityTarget.a, predicate).build();
        return new ContextAwarePredicate(List.of(lootItemCondition));
    }

    public boolean a(EntityPlayer player, @Nullable Entity entity) {
        return this.a(player.x(), player.dj(), entity);
    }

    public boolean a(WorldServer world, @Nullable Vec3D pos, @Nullable Entity entity) {
        ScoreboardTeamBase team;
        if (entity == null) {
            return false;
        }
        if (this.b.isPresent() && !this.b.get().b(entity.ag())) {
            return false;
        }
        if (pos == null ? this.c.isPresent() : this.c.isPresent() && !this.c.get().a(pos.c, pos.d, pos.e, entity.dq(), entity.ds(), entity.dw())) {
            return false;
        }
        if (this.d.isPresent() && !this.d.get().a(world, entity.dq(), entity.ds(), entity.dw())) {
            return false;
        }
        if (this.e.isPresent()) {
            Vec3D vec3 = Vec3D.b(entity.aH());
            if (!this.e.get().a(world, vec3.a(), vec3.b(), vec3.c())) {
                return false;
            }
        }
        if (this.f.isPresent() && !this.f.get().a(entity)) {
            return false;
        }
        if (this.g.isPresent() && !this.g.get().a(entity)) {
            return false;
        }
        if (this.h.isPresent() && !this.h.get().a(entity)) {
            return false;
        }
        if (this.i.isPresent() && !this.i.get().a(entity)) {
            return false;
        }
        if (this.j.isPresent() && !this.j.get().a(entity, world, pos)) {
            return false;
        }
        if (this.k.isPresent() && !this.k.get().a(world, pos, entity.cY())) {
            return false;
        }
        if (this.l.isPresent() && entity.cP().stream().noneMatch(entityx -> this.l.get().a(world, pos, (Entity)entityx))) {
            return false;
        }
        if (this.m.isPresent() && !this.m.get().a(world, pos, entity instanceof EntityInsentient ? ((EntityInsentient)entity).q() : null)) {
            return false;
        }
        return !this.n.isPresent() || (team = entity.cf()) != null && this.n.get().equals(team.b());
    }

    public static Optional<CriterionConditionEntity> a(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return Optional.empty();
        }
        return Optional.of((CriterionConditionEntity)SystemUtils.a(a.parse((DynamicOps)JsonOps.INSTANCE, (Object)json), JsonParseException::new));
    }

    public JsonElement a() {
        return (JsonElement)SystemUtils.a(a.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this), IllegalStateException::new);
    }

    public static LootTableInfo b(EntityPlayer player, Entity target) {
        LootParams lootParams = new LootParams.a(player.x()).a(LootContextParameters.a, target).a(LootContextParameters.f, player.dj()).a(LootContextParameterSets.l);
        return new LootTableInfo.Builder(lootParams).a(Optional.empty());
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CriterionConditionEntity.class, "entityType;distanceToPlayer;location;steppingOnLocation;effects;nbt;flags;equipment;subPredicate;vehicle;passenger;targetedEntity;team", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CriterionConditionEntity.class, "entityType;distanceToPlayer;location;steppingOnLocation;effects;nbt;flags;equipment;subPredicate;vehicle;passenger;targetedEntity;team", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CriterionConditionEntity.class, "entityType;distanceToPlayer;location;steppingOnLocation;effects;nbt;flags;equipment;subPredicate;vehicle;passenger;targetedEntity;team", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n"}, this, object);
    }

    public static class a {
        private Optional<CriterionConditionEntityType> a = Optional.empty();
        private Optional<CriterionConditionDistance> b = Optional.empty();
        private Optional<CriterionConditionLocation> c = Optional.empty();
        private Optional<CriterionConditionLocation> d = Optional.empty();
        private Optional<CriterionConditionMobEffect> e = Optional.empty();
        private Optional<CriterionConditionNBT> f = Optional.empty();
        private Optional<CriterionConditionEntityFlags> g = Optional.empty();
        private Optional<CriterionConditionEntityEquipment> h = Optional.empty();
        private Optional<EntitySubPredicate> i = Optional.empty();
        private Optional<CriterionConditionEntity> j = Optional.empty();
        private Optional<CriterionConditionEntity> k = Optional.empty();
        private Optional<CriterionConditionEntity> l = Optional.empty();
        private Optional<String> m = Optional.empty();

        public static a a() {
            return new a();
        }

        public a a(EntityTypes<?> type) {
            this.a = Optional.of(CriterionConditionEntityType.a(type));
            return this;
        }

        public a a(TagKey<EntityTypes<?>> tag) {
            this.a = Optional.of(CriterionConditionEntityType.a(tag));
            return this;
        }

        public a a(CriterionConditionEntityType type) {
            this.a = Optional.of(type);
            return this;
        }

        public a a(CriterionConditionDistance distance) {
            this.b = Optional.of(distance);
            return this;
        }

        public a a(CriterionConditionLocation.a location) {
            this.c = Optional.of(location.b());
            return this;
        }

        public a b(CriterionConditionLocation.a steppingOn) {
            this.d = Optional.of(steppingOn.b());
            return this;
        }

        public a a(CriterionConditionMobEffect.a effects) {
            this.e = effects.b();
            return this;
        }

        public a a(CriterionConditionNBT nbt) {
            this.f = Optional.of(nbt);
            return this;
        }

        public a a(CriterionConditionEntityFlags.a flags) {
            this.g = Optional.of(flags.b());
            return this;
        }

        public a a(CriterionConditionEntityEquipment.a equipment) {
            this.h = Optional.of(equipment.b());
            return this;
        }

        public a a(CriterionConditionEntityEquipment equipment) {
            this.h = Optional.of(equipment);
            return this;
        }

        public a a(EntitySubPredicate typeSpecific) {
            this.i = Optional.of(typeSpecific);
            return this;
        }

        public a a(a vehicle) {
            this.j = Optional.of(vehicle.b());
            return this;
        }

        public a b(a passenger) {
            this.k = Optional.of(passenger.b());
            return this;
        }

        public a c(a targetedEntity) {
            this.l = Optional.of(targetedEntity.b());
            return this;
        }

        public a a(String team) {
            this.m = Optional.of(team);
            return this;
        }

        public CriterionConditionEntity b() {
            return new CriterionConditionEntity(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l, this.m);
        }
    }
}

