/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.advancements.critereon.CriterionConditionFluid;
import net.minecraft.advancements.critereon.CriterionConditionLight;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftDimensionUtil;

public record CriterionConditionLocation(Optional<b> b, Optional<ResourceKey<BiomeBase>> c, Optional<ResourceKey<Structure>> d, Optional<ResourceKey<World>> e, Optional<Boolean> f, Optional<CriterionConditionLight> g, Optional<CriterionConditionBlock> h, Optional<CriterionConditionFluid> i) {
    public static final Codec<CriterionConditionLocation> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a(net.minecraft.advancements.critereon.CriterionConditionLocation$b.a, "position").forGetter(CriterionConditionLocation::b), (App)ExtraCodecs.a(ResourceKey.a(Registries.ap), "biome").forGetter(CriterionConditionLocation::c), (App)ExtraCodecs.a(ResourceKey.a(Registries.az), "structure").forGetter(CriterionConditionLocation::d), (App)ExtraCodecs.a(ResourceKey.a(Registries.aH), "dimension").forGetter(CriterionConditionLocation::e), (App)ExtraCodecs.a(Codec.BOOL, "smokey").forGetter(CriterionConditionLocation::f), (App)ExtraCodecs.a(CriterionConditionLight.a, "light").forGetter(CriterionConditionLocation::g), (App)ExtraCodecs.a(CriterionConditionBlock.a, "block").forGetter(CriterionConditionLocation::h), (App)ExtraCodecs.a(CriterionConditionFluid.a, "fluid").forGetter(CriterionConditionLocation::i)).apply((Applicative)instance, CriterionConditionLocation::new));

    private static Optional<CriterionConditionLocation> a(Optional<b> position, Optional<ResourceKey<BiomeBase>> biome, Optional<ResourceKey<Structure>> structure, Optional<ResourceKey<World>> dimension, Optional<Boolean> smokey, Optional<CriterionConditionLight> light, Optional<CriterionConditionBlock> block, Optional<CriterionConditionFluid> fluid) {
        return position.isEmpty() && biome.isEmpty() && structure.isEmpty() && dimension.isEmpty() && smokey.isEmpty() && light.isEmpty() && block.isEmpty() && fluid.isEmpty() ? Optional.empty() : Optional.of(new CriterionConditionLocation(position, biome, structure, dimension, smokey, light, block, fluid));
    }

    public boolean a(WorldServer world, double x2, double y2, double z2) {
        if (this.b.isPresent() && !this.b.get().a(x2, y2, z2)) {
            return false;
        }
        if (this.e.isPresent() && this.e.get() != (GlobalConfiguration.get().misc.strictAdvancementDimensionCheck ? world.ac() : CraftDimensionUtil.getMainDimensionKey(world))) {
            return false;
        }
        BlockPosition blockPos = BlockPosition.a(x2, y2, z2);
        boolean bl = world.o(blockPos);
        if (!this.c.isPresent() || bl && world.s(blockPos).a(this.c.get())) {
            if (!this.d.isPresent() || bl && world.a().a(blockPos, this.d.get()).b()) {
                if (!this.f.isPresent() || bl && this.f.get() == BlockCampfire.a(world, blockPos)) {
                    if (this.g.isPresent() && !this.g.get().a(world, blockPos)) {
                        return false;
                    }
                    if (this.h.isPresent() && !this.h.get().a(world, blockPos)) {
                        return false;
                    }
                    return !this.i.isPresent() || this.i.get().a(world, blockPos);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public JsonElement a() {
        return (JsonElement)SystemUtils.a(a.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this), IllegalStateException::new);
    }

    public static Optional<CriterionConditionLocation> a(@Nullable JsonElement json) {
        return json != null && !json.isJsonNull() ? Optional.of((CriterionConditionLocation)SystemUtils.a(a.parse((DynamicOps)JsonOps.INSTANCE, (Object)json), JsonParseException::new)) : Optional.empty();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CriterionConditionLocation.class, "position;biome;structure;dimension;smokey;light;block;fluid", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CriterionConditionLocation.class, "position;biome;structure;dimension;smokey;light;block;fluid", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CriterionConditionLocation.class, "position;biome;structure;dimension;smokey;light;block;fluid", "b", "c", "d", "e", "f", "g", "h", "i"}, this, o2);
    }

    static final class b
    extends Record {
        private final CriterionConditionValue.DoubleRange b;
        private final CriterionConditionValue.DoubleRange c;
        private final CriterionConditionValue.DoubleRange d;
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a(CriterionConditionValue.DoubleRange.d, "x", CriterionConditionValue.DoubleRange.c).forGetter(b::a), (App)ExtraCodecs.a(CriterionConditionValue.DoubleRange.d, "y", CriterionConditionValue.DoubleRange.c).forGetter(b::b), (App)ExtraCodecs.a(CriterionConditionValue.DoubleRange.d, "z", CriterionConditionValue.DoubleRange.c).forGetter(b::c)).apply((Applicative)instance, b::new));

        b(CriterionConditionValue.DoubleRange x2, CriterionConditionValue.DoubleRange y2, CriterionConditionValue.DoubleRange z2) {
            this.b = x2;
            this.c = y2;
            this.d = z2;
        }

        static Optional<b> a(CriterionConditionValue.DoubleRange x2, CriterionConditionValue.DoubleRange y2, CriterionConditionValue.DoubleRange z2) {
            return x2.c() && y2.c() && z2.c() ? Optional.empty() : Optional.of(new b(x2, y2, z2));
        }

        public boolean a(double x2, double y2, double z2) {
            return this.b.d(x2) && this.c.d(y2) && this.d.d(z2);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "x;y;z", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "x;y;z", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "x;y;z", "b", "c", "d"}, this, o2);
        }

        public CriterionConditionValue.DoubleRange a() {
            return this.b;
        }

        public CriterionConditionValue.DoubleRange b() {
            return this.c;
        }

        public CriterionConditionValue.DoubleRange c() {
            return this.d;
        }
    }

    public static class a {
        private CriterionConditionValue.DoubleRange a = CriterionConditionValue.DoubleRange.c;
        private CriterionConditionValue.DoubleRange b = CriterionConditionValue.DoubleRange.c;
        private CriterionConditionValue.DoubleRange c = CriterionConditionValue.DoubleRange.c;
        private Optional<ResourceKey<BiomeBase>> d = Optional.empty();
        private Optional<ResourceKey<Structure>> e = Optional.empty();
        private Optional<ResourceKey<World>> f = Optional.empty();
        private Optional<Boolean> g = Optional.empty();
        private Optional<CriterionConditionLight> h = Optional.empty();
        private Optional<CriterionConditionBlock> i = Optional.empty();
        private Optional<CriterionConditionFluid> j = Optional.empty();

        public static a a() {
            return new a();
        }

        public static a a(ResourceKey<BiomeBase> biome) {
            return net.minecraft.advancements.critereon.CriterionConditionLocation$a.a().d(biome);
        }

        public static a b(ResourceKey<World> dimension) {
            return net.minecraft.advancements.critereon.CriterionConditionLocation$a.a().f(dimension);
        }

        public static a c(ResourceKey<Structure> structure) {
            return net.minecraft.advancements.critereon.CriterionConditionLocation$a.a().e(structure);
        }

        public static a a(CriterionConditionValue.DoubleRange y2) {
            return net.minecraft.advancements.critereon.CriterionConditionLocation$a.a().c(y2);
        }

        public a b(CriterionConditionValue.DoubleRange x2) {
            this.a = x2;
            return this;
        }

        public a c(CriterionConditionValue.DoubleRange y2) {
            this.b = y2;
            return this;
        }

        public a d(CriterionConditionValue.DoubleRange z2) {
            this.c = z2;
            return this;
        }

        public a d(ResourceKey<BiomeBase> biome) {
            this.d = Optional.of(biome);
            return this;
        }

        public a e(ResourceKey<Structure> structure) {
            this.e = Optional.of(structure);
            return this;
        }

        public a f(ResourceKey<World> dimension) {
            this.f = Optional.of(dimension);
            return this;
        }

        public a a(CriterionConditionLight.a light) {
            this.h = Optional.of(light.b());
            return this;
        }

        public a a(CriterionConditionBlock.a block) {
            this.i = Optional.of(block.b());
            return this;
        }

        public a a(CriterionConditionFluid.a fluid) {
            this.j = Optional.of(fluid.b());
            return this;
        }

        public a a(boolean smokey) {
            this.g = Optional.of(smokey);
            return this;
        }

        public CriterionConditionLocation b() {
            Optional<b> optional = net.minecraft.advancements.critereon.CriterionConditionLocation$b.a(this.a, this.b, this.c);
            return new CriterionConditionLocation(optional, this.d, this.e, this.f, this.g, this.h, this.i, this.j);
        }
    }
}

