/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ExtraCodecs;

public interface CriterionConditionValue<T extends Number> {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.range.empty"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.range.swapped"));

    public Optional<T> a();

    public Optional<T> b();

    default public boolean c() {
        return this.a().isEmpty() && this.b().isEmpty();
    }

    default public Optional<T> d() {
        Optional<T> optional2;
        Optional<T> optional = this.a();
        return optional.equals(optional2 = this.b()) ? optional : Optional.empty();
    }

    public static <T extends Number, R extends CriterionConditionValue<T>> Codec<R> a(Codec<T> codec, a<T, R> boundsFactory) {
        Codec codec2 = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a(codec, "min").forGetter(CriterionConditionValue::a), (App)ExtraCodecs.a(codec, "max").forGetter(CriterionConditionValue::b)).apply((Applicative)instance, boundsFactory::create));
        return Codec.either((Codec)codec2, codec).xmap(either -> either.map(minMaxBounds -> minMaxBounds, number -> boundsFactory.create(Optional.of(number), Optional.of(number))), minMaxBounds -> {
            Optional optional = minMaxBounds.d();
            return optional.isPresent() ? Either.right((Number)optional.get()) : Either.left(minMaxBounds);
        });
    }

    public static <T extends Number, R extends CriterionConditionValue<T>> R a(StringReader commandReader, b<T, R> commandFactory, Function<String, T> converter, Supplier<DynamicCommandExceptionType> exceptionTypeSupplier, Function<T, T> mapper) throws CommandSyntaxException {
        if (!commandReader.canRead()) {
            throw a.createWithContext((ImmutableStringReader)commandReader);
        }
        int i2 = commandReader.getCursor();
        try {
            Optional<T> optional3;
            Optional<T> optional = CriterionConditionValue.a(commandReader, converter, exceptionTypeSupplier).map(mapper);
            if (commandReader.canRead(2) && commandReader.peek() == '.' && commandReader.peek(1) == '.') {
                commandReader.skip();
                commandReader.skip();
                Optional<T> optional2 = CriterionConditionValue.a(commandReader, converter, exceptionTypeSupplier).map(mapper);
                if (optional.isEmpty() && optional2.isEmpty()) {
                    throw a.createWithContext((ImmutableStringReader)commandReader);
                }
            } else {
                optional3 = optional;
            }
            if (optional.isEmpty() && optional3.isEmpty()) {
                throw a.createWithContext((ImmutableStringReader)commandReader);
            }
            return commandFactory.create(commandReader, optional, optional3);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            commandReader.setCursor(i2);
            throw new CommandSyntaxException(commandSyntaxException.getType(), commandSyntaxException.getRawMessage(), commandSyntaxException.getInput(), i2);
        }
    }

    private static <T extends Number> Optional<T> a(StringReader reader, Function<String, T> converter, Supplier<DynamicCommandExceptionType> exceptionTypeSupplier) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        while (reader.canRead() && CriterionConditionValue.a(reader)) {
            reader.skip();
        }
        String string = reader.getString().substring(i2, reader.getCursor());
        if (string.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of((Number)converter.apply(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw exceptionTypeSupplier.get().createWithContext((ImmutableStringReader)reader, (Object)string);
        }
    }

    private static boolean a(StringReader reader) {
        char c2 = reader.peek();
        if (c2 >= '0' && c2 <= '9' || c2 == '-') {
            return true;
        }
        if (c2 == '.') {
            return !reader.canRead(2) || reader.peek(1) != '.';
        }
        return false;
    }

    @FunctionalInterface
    public static interface a<T extends Number, R extends CriterionConditionValue<T>> {
        public R create(Optional<T> var1, Optional<T> var2);
    }

    @FunctionalInterface
    public static interface b<T extends Number, R extends CriterionConditionValue<T>> {
        public R create(StringReader var1, Optional<T> var2, Optional<T> var3) throws CommandSyntaxException;
    }

    public static final class DoubleRange
    extends Record
    implements CriterionConditionValue<Double> {
        private final Optional<Double> e;
        private final Optional<Double> f;
        private final Optional<Double> g;
        private final Optional<Double> h;
        public static final DoubleRange c = new DoubleRange(Optional.empty(), Optional.empty());
        public static final Codec<DoubleRange> d = CriterionConditionValue.a(Codec.DOUBLE, DoubleRange::new);

        private DoubleRange(Optional<Double> optional, Optional<Double> optional2) {
            this(optional, optional2, DoubleRange.a(optional), DoubleRange.a(optional2));
        }

        public DoubleRange(Optional<Double> optional, Optional<Double> optional2, Optional<Double> optional3, Optional<Double> optional4) {
            this.e = optional;
            this.f = optional2;
            this.g = optional3;
            this.h = optional4;
        }

        private static DoubleRange a(StringReader reader, Optional<Double> optional, Optional<Double> optional2) throws CommandSyntaxException {
            if (optional.isPresent() && optional2.isPresent() && optional.get() > optional2.get()) {
                throw b.createWithContext((ImmutableStringReader)reader);
            }
            return new DoubleRange(optional, optional2);
        }

        private static Optional<Double> a(Optional<Double> optional) {
            return optional.map(double_ -> double_ * double_);
        }

        public static DoubleRange a(double value) {
            return new DoubleRange(Optional.of(value), Optional.of(value));
        }

        public static DoubleRange a(double min, double max) {
            return new DoubleRange(Optional.of(min), Optional.of(max));
        }

        public static DoubleRange b(double value) {
            return new DoubleRange(Optional.of(value), Optional.empty());
        }

        public static DoubleRange c(double value) {
            return new DoubleRange(Optional.empty(), Optional.of(value));
        }

        public boolean d(double value) {
            if (this.e.isPresent() && this.e.get() > value) {
                return false;
            }
            return this.f.isEmpty() || !(this.f.get() < value);
        }

        public boolean e(double value) {
            if (this.g.isPresent() && this.g.get() > value) {
                return false;
            }
            return this.h.isEmpty() || !(this.h.get() < value);
        }

        public static DoubleRange a(@Nullable JsonElement element) {
            if (element == null || element.isJsonNull()) {
                return c;
            }
            return (DoubleRange)SystemUtils.a(d.parse((DynamicOps)JsonOps.INSTANCE, (Object)element), JsonParseException::new);
        }

        public JsonElement e() {
            if (this.c()) {
                return JsonNull.INSTANCE;
            }
            return (JsonElement)SystemUtils.a(d.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this), IllegalStateException::new);
        }

        public static DoubleRange a(StringReader reader) throws CommandSyntaxException {
            return DoubleRange.a(reader, (Double value) -> value);
        }

        public static DoubleRange a(StringReader reader, Function<Double, Double> mapper) throws CommandSyntaxException {
            return CriterionConditionValue.a(reader, DoubleRange::a, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble(), mapper);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DoubleRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DoubleRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DoubleRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this, object);
        }

        @Override
        @Override
        public Optional<Double> a() {
            return this.e;
        }

        @Override
        @Override
        public Optional<Double> b() {
            return this.f;
        }

        public Optional<Double> f() {
            return this.g;
        }

        public Optional<Double> g() {
            return this.h;
        }
    }

    public static final class IntegerRange
    extends Record
    implements CriterionConditionValue<Integer> {
        private final Optional<Integer> e;
        private final Optional<Integer> f;
        private final Optional<Long> g;
        private final Optional<Long> h;
        public static final IntegerRange c = new IntegerRange(Optional.empty(), Optional.empty());
        public static final Codec<IntegerRange> d = CriterionConditionValue.a(Codec.INT, IntegerRange::new);

        private IntegerRange(Optional<Integer> optional, Optional<Integer> optional2) {
            this(optional, optional2, optional.map(integer -> integer.longValue() * integer.longValue()), IntegerRange.a(optional2));
        }

        public IntegerRange(Optional<Integer> optional, Optional<Integer> optional2, Optional<Long> optional3, Optional<Long> optional4) {
            this.e = optional;
            this.f = optional2;
            this.g = optional3;
            this.h = optional4;
        }

        private static IntegerRange a(StringReader reader, Optional<Integer> optional, Optional<Integer> optional2) throws CommandSyntaxException {
            if (optional.isPresent() && optional2.isPresent() && optional.get() > optional2.get()) {
                throw b.createWithContext((ImmutableStringReader)reader);
            }
            return new IntegerRange(optional, optional2);
        }

        private static Optional<Long> a(Optional<Integer> optional) {
            return optional.map(integer -> integer.longValue() * integer.longValue());
        }

        public static IntegerRange a(int value) {
            return new IntegerRange(Optional.of(value), Optional.of(value));
        }

        public static IntegerRange a(int min, int max) {
            return new IntegerRange(Optional.of(min), Optional.of(max));
        }

        public static IntegerRange b(int value) {
            return new IntegerRange(Optional.of(value), Optional.empty());
        }

        public static IntegerRange c(int value) {
            return new IntegerRange(Optional.empty(), Optional.of(value));
        }

        public boolean d(int value) {
            if (this.e.isPresent() && this.e.get() > value) {
                return false;
            }
            return this.f.isEmpty() || this.f.get() >= value;
        }

        public boolean a(long value) {
            if (this.g.isPresent() && this.g.get() > value) {
                return false;
            }
            return this.h.isEmpty() || this.h.get() >= value;
        }

        public static IntegerRange a(@Nullable JsonElement element) {
            if (element == null || element.isJsonNull()) {
                return c;
            }
            return (IntegerRange)SystemUtils.a(d.parse((DynamicOps)JsonOps.INSTANCE, (Object)element), JsonParseException::new);
        }

        public JsonElement e() {
            if (this.c()) {
                return JsonNull.INSTANCE;
            }
            return (JsonElement)SystemUtils.a(d.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this), IllegalStateException::new);
        }

        public static IntegerRange a(StringReader reader) throws CommandSyntaxException {
            return IntegerRange.a(reader, (Integer value) -> value);
        }

        public static IntegerRange a(StringReader reader, Function<Integer, Integer> converter) throws CommandSyntaxException {
            return CriterionConditionValue.a(reader, IntegerRange::a, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt(), converter);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntegerRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntegerRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntegerRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this, object);
        }

        @Override
        @Override
        public Optional<Integer> a() {
            return this.e;
        }

        @Override
        @Override
        public Optional<Integer> b() {
            return this.f;
        }

        public Optional<Long> f() {
            return this.g;
        }

        public Optional<Long> g() {
            return this.h;
        }
    }
}

