/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionData;

public class CustomFunction {
    private final d[] a;
    final MinecraftKey b;

    public CustomFunction(MinecraftKey id, d[] elements) {
        this.b = id;
        this.a = elements;
    }

    public MinecraftKey a() {
        return this.b;
    }

    public d[] b() {
        return this.a;
    }

    public CustomFunction a(@Nullable NBTTagCompound arguments, com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> dispatcher, CommandListenerWrapper source) throws FunctionInstantiationException {
        return this;
    }

    private static boolean a(CharSequence string) {
        int i2 = string.length();
        return i2 > 0 && string.charAt(i2 - 1) == '\\';
    }

    public static CustomFunction a(MinecraftKey id, com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> dispatcher, CommandListenerWrapper source, List<String> lines) {
        ArrayList<d> list = new ArrayList<d>(lines.size());
        ObjectArraySet set = new ObjectArraySet();
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            String string3;
            int j2 = i2 + 1;
            String string = lines.get(i2).trim();
            if (CustomFunction.a((CharSequence)string)) {
                StringBuilder stringBuilder = new StringBuilder(string);
                do {
                    if (++i2 == lines.size()) {
                        throw new IllegalArgumentException("Line continuation at end of file");
                    }
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    String string2 = lines.get(i2).trim();
                    stringBuilder.append(string2);
                } while (CustomFunction.a(stringBuilder));
                string3 = stringBuilder.toString();
            } else {
                string3 = string;
            }
            StringReader stringReader = new StringReader(string3);
            if (!stringReader.canRead() || stringReader.peek() == '#') continue;
            if (stringReader.peek() == '/') {
                stringReader.skip();
                if (stringReader.peek() == '/') {
                    throw new IllegalArgumentException("Unknown or invalid command '" + string3 + "' on line " + j2 + " (if you intended to make a comment, use '#' not '//')");
                }
                String string5 = stringReader.readUnquotedString();
                throw new IllegalArgumentException("Unknown or invalid command '" + string3 + "' on line " + j2 + " (did you mean '" + string5 + "'? Do not use a preceding forwards slash.)");
            }
            if (stringReader.peek() == '$') {
                f macroEntry = CustomFunction.a(string3.substring(1), j2);
                list.add(macroEntry);
                set.addAll(macroEntry.a());
                continue;
            }
            try {
                ParseResults<CommandListenerWrapper> parseResults = dispatcher.parse(stringReader, source);
                if (parseResults.getReader().canRead()) {
                    throw CommandDispatcher.a(parseResults);
                }
                list.add(new b(parseResults));
                continue;
            }
            catch (CommandSyntaxException var12) {
                throw new IllegalArgumentException("Whilst parsing command on line " + j2 + ": " + var12.getMessage());
            }
        }
        return set.isEmpty() ? new CustomFunction(id, (d[])list.toArray(d[]::new)) : new c(id, (d[])list.toArray(d[]::new), List.copyOf(set));
    }

    @VisibleForTesting
    public static f a(String macro, int line) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder builder2 = ImmutableList.builder();
        int i2 = macro.length();
        int j2 = 0;
        int k2 = macro.indexOf(36);
        while (k2 != -1) {
            if (k2 != i2 - 1 && macro.charAt(k2 + 1) == '(') {
                builder.add((Object)macro.substring(j2, k2));
                int l2 = macro.indexOf(41, k2 + 1);
                if (l2 == -1) {
                    throw new IllegalArgumentException("Unterminated macro variable in macro '" + macro + "' on line " + line);
                }
                String string = macro.substring(k2 + 2, l2);
                if (!CustomFunction.a(string)) {
                    throw new IllegalArgumentException("Invalid macro variable name '" + string + "' on line " + line);
                }
                builder2.add((Object)string);
                j2 = l2 + 1;
                k2 = macro.indexOf(36, j2);
                continue;
            }
            k2 = macro.indexOf(36, k2 + 1);
        }
        if (j2 == 0) {
            throw new IllegalArgumentException("Macro without variables on line " + line);
        }
        if (j2 != i2) {
            builder.add((Object)macro.substring(j2));
        }
        return new f((List<String>)builder.build(), (List<String>)builder2.build());
    }

    private static boolean a(String name) {
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c2 = name.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '_') continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    public static interface d {
        public void execute(CustomFunctionData var1, CommandListenerWrapper var2, Deque<CustomFunctionData.QueuedCommand> var3, int var4, int var5, @Nullable CustomFunctionData.TraceCallbacks var6) throws CommandSyntaxException;
    }

    public static class f
    implements d {
        private final List<String> a;
        private final List<String> b;

        public f(List<String> parts, List<String> variables) {
            this.a = parts;
            this.b = variables;
        }

        public List<String> a() {
            return this.b;
        }

        public String a(List<String> arguments) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                stringBuilder.append(this.a.get(i2)).append(arguments.get(i2));
            }
            if (this.a.size() > this.b.size()) {
                stringBuilder.append(this.a.get(this.a.size() - 1));
            }
            return stringBuilder.toString();
        }

        @Override
        public void execute(CustomFunctionData manager, CommandListenerWrapper source, Deque<CustomFunctionData.QueuedCommand> entries, int maxChainLength, int depth, @Nullable CustomFunctionData.TraceCallbacks tracer) throws CommandSyntaxException {
            throw new IllegalStateException("Tried to execute an uninstantiated macro");
        }
    }

    public static class b
    implements d {
        private final ParseResults<CommandListenerWrapper> a;

        public b(ParseResults<CommandListenerWrapper> parsed) {
            this.a = parsed;
        }

        @Override
        public void execute(CustomFunctionData manager, CommandListenerWrapper source, Deque<CustomFunctionData.QueuedCommand> entries, int maxChainLength, int depth, @Nullable CustomFunctionData.TraceCallbacks tracer) throws CommandSyntaxException {
            if (tracer != null) {
                String string = this.a.getReader().getString();
                tracer.a(depth, string);
                int i2 = this.a(manager, source);
                tracer.a(depth, string, i2);
            } else {
                this.a(manager, source);
            }
        }

        private int a(CustomFunctionData manager, CommandListenerWrapper source) throws CommandSyntaxException {
            return manager.b().execute(CommandDispatcher.a(this.a, currentSource -> source));
        }

        public String toString() {
            return this.a.getReader().getString();
        }
    }

    static class c
    extends CustomFunction {
        private static final DecimalFormat a = new DecimalFormat("#");
        private final List<String> b;
        private static final int c = 8;
        private final Object2ObjectLinkedOpenHashMap<List<String>, CustomFunction> d = new Object2ObjectLinkedOpenHashMap(8, 0.25f);

        public c(MinecraftKey id, d[] elements, List<String> variables) {
            super(id, elements);
            this.b = variables;
        }

        @Override
        public CustomFunction a(@Nullable NBTTagCompound arguments, com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> dispatcher, CommandListenerWrapper source) throws FunctionInstantiationException {
            CustomFunction commandFunction2;
            if (arguments == null) {
                throw new FunctionInstantiationException(IChatBaseComponent.a("commands.function.error.missing_arguments", this.a()));
            }
            ArrayList<String> list = new ArrayList<String>(this.b.size());
            for (String string : this.b) {
                if (!arguments.e(string)) {
                    throw new FunctionInstantiationException(IChatBaseComponent.a("commands.function.error.missing_argument", this.a(), string));
                }
                list.add(net.minecraft.commands.CustomFunction$c.a(arguments.c(string)));
            }
            CustomFunction commandFunction = (CustomFunction)this.d.getAndMoveToLast(list);
            if (commandFunction != null) {
                return commandFunction;
            }
            if (this.d.size() >= 8) {
                this.d.removeFirst();
            }
            if ((commandFunction2 = this.a(list, dispatcher, source)) != null) {
                this.d.put(list, (Object)commandFunction2);
            }
            return commandFunction2;
        }

        private static String a(NBTBase nbt) {
            if (nbt instanceof NBTTagFloat) {
                NBTTagFloat floatTag = (NBTTagFloat)nbt;
                return a.format(floatTag.k());
            }
            if (nbt instanceof NBTTagDouble) {
                NBTTagDouble doubleTag = (NBTTagDouble)nbt;
                return a.format(doubleTag.j());
            }
            if (nbt instanceof NBTTagByte) {
                NBTTagByte byteTag = (NBTTagByte)nbt;
                return String.valueOf(byteTag.i());
            }
            if (nbt instanceof NBTTagShort) {
                NBTTagShort shortTag = (NBTTagShort)nbt;
                return String.valueOf(shortTag.h());
            }
            if (nbt instanceof NBTTagLong) {
                NBTTagLong longTag = (NBTTagLong)nbt;
                return String.valueOf(longTag.f());
            }
            return nbt.r_();
        }

        private CustomFunction a(List<String> arguments, com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> dispatcher, CommandListenerWrapper source) throws FunctionInstantiationException {
            d[] entrys = this.b();
            d[] entrys2 = new d[entrys.length];
            for (int i2 = 0; i2 < entrys.length; ++i2) {
                d entry = entrys[i2];
                if (!(entry instanceof f)) {
                    entrys2[i2] = entry;
                    continue;
                }
                f macroEntry = (f)entry;
                List<String> list = macroEntry.a();
                ArrayList<String> list2 = new ArrayList<String>(list.size());
                for (String string : list) {
                    list2.add(arguments.get(this.b.indexOf(string)));
                }
                String string2 = macroEntry.a(list2);
                try {
                    ParseResults<CommandListenerWrapper> parseResults = dispatcher.parse(string2, source);
                    if (parseResults.getReader().canRead()) {
                        throw CommandDispatcher.a(parseResults);
                    }
                    entrys2[i2] = new b(parseResults);
                    continue;
                }
                catch (CommandSyntaxException var13) {
                    throw new FunctionInstantiationException(IChatBaseComponent.a("commands.function.error.parse", this.a(), string2, var13.getMessage()));
                }
            }
            MinecraftKey resourceLocation = this.a();
            return new CustomFunction(new MinecraftKey(resourceLocation.b(), resourceLocation.a() + "/" + arguments.hashCode()), entrys2);
        }

        static {
            a.setMaximumFractionDigits(15);
            a.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
        }
    }

    public static class e
    implements d {
        private final a a;

        public e(CustomFunction function) {
            this.a = new a(function);
        }

        @Override
        public void execute(CustomFunctionData manager, CommandListenerWrapper source, Deque<CustomFunctionData.QueuedCommand> entries, int maxChainLength, int depth, @Nullable CustomFunctionData.TraceCallbacks tracer) {
            SystemUtils.a(this.a.a(manager), f2 -> {
                d[] entrys = f2.b();
                if (tracer != null) {
                    tracer.a(depth, f2.a(), entrys.length);
                }
                int k2 = maxChainLength - entries.size();
                int l2 = Math.min(entrys.length, k2);
                for (int m2 = l2 - 1; m2 >= 0; --m2) {
                    entries.addFirst(new CustomFunctionData.QueuedCommand(source, depth + 1, entrys[m2]));
                }
            }, () -> {
                if (tracer != null) {
                    tracer.a(depth, this.a.a(), -1);
                }
            });
        }

        public String toString() {
            return "function " + this.a.a();
        }
    }

    public static class a {
        public static final a a = new a((MinecraftKey)null);
        @Nullable
        private final MinecraftKey b;
        private boolean c;
        private Optional<CustomFunction> d = Optional.empty();

        public a(@Nullable MinecraftKey id) {
            this.b = id;
        }

        public a(CustomFunction function) {
            this.c = true;
            this.b = null;
            this.d = Optional.of(function);
        }

        public Optional<CustomFunction> a(CustomFunctionData manager) {
            if (!this.c) {
                if (this.b != null) {
                    this.d = manager.a(this.b);
                }
                this.c = true;
            }
            return this.d;
        }

        @Nullable
        public MinecraftKey a() {
            return this.d.map(f2 -> f2.b).orElse(this.b);
        }
    }
}

