/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ArgumentNBTKey
implements ArgumentType<g> {
    private static final Collection<String> d = Arrays.asList("foo", "foo.bar", "foo[0]", "[0]", "[]", "{foo=bar}");
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("arguments.nbtpath.node.invalid"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("arguments.nbtpath.too_deep"));
    public static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(path -> IChatBaseComponent.a("arguments.nbtpath.nothing_found", path));
    static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(nbt -> IChatBaseComponent.a("commands.data.modify.expected_list", nbt));
    static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(index -> IChatBaseComponent.a("commands.data.modify.invalid_index", index));
    private static final char g = '[';
    private static final char h = ']';
    private static final char i = '{';
    private static final char j = '}';
    private static final char k = '\"';
    private static final char l = '\'';

    public static ArgumentNBTKey a() {
        return new ArgumentNBTKey();
    }

    public static g a(CommandContext<CommandListenerWrapper> context, String name) {
        return (g)context.getArgument(name, g.class);
    }

    public g a(StringReader stringReader) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayList();
        int i2 = stringReader.getCursor();
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        boolean bl = true;
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            char c2;
            h node = ArgumentNBTKey.a(stringReader, bl);
            list.add(node);
            object2IntMap.put((Object)node, stringReader.getCursor() - i2);
            bl = false;
            if (!stringReader.canRead() || (c2 = stringReader.peek()) == ' ' || c2 == '[' || c2 == '{') continue;
            stringReader.expect('.');
        }
        return new g(stringReader.getString().substring(i2, stringReader.getCursor()), list.toArray(new h[0]), (Object2IntMap<h>)object2IntMap);
    }

    private static h a(StringReader reader, boolean root) throws CommandSyntaxException {
        return switch (reader.peek()) {
            case '{' -> {
                if (!root) {
                    throw a.createWithContext((ImmutableStringReader)reader);
                }
                NBTTagCompound compoundTag = new MojangsonParser(reader).f();
                yield new f(compoundTag);
            }
            case '[' -> {
                reader.skip();
                char i = reader.peek();
                if (i == '{') {
                    NBTTagCompound compoundTag2 = new MojangsonParser(reader).f();
                    reader.expect(']');
                    yield new d(compoundTag2);
                }
                if (i == ']') {
                    reader.skip();
                    yield net.minecraft.commands.arguments.ArgumentNBTKey$a.a;
                }
                int j = reader.readInt();
                reader.expect(']');
                yield new c(j);
            }
            case '\"', '\'' -> ArgumentNBTKey.a(reader, reader.readString());
            default -> ArgumentNBTKey.a(reader, ArgumentNBTKey.b(reader));
        };
    }

    private static h a(StringReader reader, String name) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '{') {
            NBTTagCompound compoundTag = new MojangsonParser(reader).f();
            return new e(name, compoundTag);
        }
        return new b(name);
    }

    private static String b(StringReader reader) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        while (reader.canRead() && ArgumentNBTKey.a(reader.peek())) {
            reader.skip();
        }
        if (reader.getCursor() == i2) {
            throw a.createWithContext((ImmutableStringReader)reader);
        }
        return reader.getString().substring(i2, reader.getCursor());
    }

    public Collection<String> getExamples() {
        return d;
    }

    private static boolean a(char c2) {
        return c2 != ' ' && c2 != '\"' && c2 != '\'' && c2 != '[' && c2 != ']' && c2 != '.' && c2 != '{' && c2 != '}';
    }

    static Predicate<NBTBase> a(NBTTagCompound filter) {
        return nbt -> GameProfileSerializer.a((NBTBase)filter, nbt, true);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }

    public static class g {
        private final String a;
        private final Object2IntMap<h> b;
        private final h[] c;

        public g(String string, h[] nodes, Object2IntMap<h> nodeEndIndices) {
            this.a = string;
            this.c = nodes;
            this.b = nodeEndIndices;
        }

        public List<NBTBase> a(NBTBase element) throws CommandSyntaxException {
            List<NBTBase> list = Collections.singletonList(element);
            for (h node : this.c) {
                if (!(list = node.a(list)).isEmpty()) continue;
                throw this.a(node);
            }
            return list;
        }

        public int b(NBTBase element) {
            List<NBTBase> list = Collections.singletonList(element);
            for (h node : this.c) {
                if (!(list = node.a(list)).isEmpty()) continue;
                return 0;
            }
            return list.size();
        }

        private List<NBTBase> d(NBTBase start) throws CommandSyntaxException {
            List<NBTBase> list = Collections.singletonList(start);
            for (int i2 = 0; i2 < this.c.length - 1; ++i2) {
                h node = this.c[i2];
                int j2 = i2 + 1;
                if (!(list = node.a(list, this.c[j2]::a)).isEmpty()) continue;
                throw this.a(node);
            }
            return list;
        }

        public List<NBTBase> a(NBTBase element, Supplier<NBTBase> source) throws CommandSyntaxException {
            List<NBTBase> list = this.d(element);
            h node = this.c[this.c.length - 1];
            return node.a(list, source);
        }

        private static int a(List<NBTBase> elements, Function<NBTBase, Integer> operation) {
            return elements.stream().map(operation).reduce(0, (a2, b2) -> a2 + b2);
        }

        public static boolean a(NBTBase element, int depth) {
            block4: {
                block3: {
                    if (depth >= 512) {
                        return true;
                    }
                    if (!(element instanceof NBTTagCompound)) break block3;
                    NBTTagCompound compoundTag = (NBTTagCompound)element;
                    for (String string : compoundTag.e()) {
                        NBTBase tag = compoundTag.c(string);
                        if (tag == null || !net.minecraft.commands.arguments.ArgumentNBTKey$g.a(tag, depth + 1)) continue;
                        return true;
                    }
                    break block4;
                }
                if (!(element instanceof NBTTagList)) break block4;
                NBTTagList listTag = (NBTTagList)element;
                for (NBTBase tag2 : listTag) {
                    if (!net.minecraft.commands.arguments.ArgumentNBTKey$g.a(tag2, depth + 1)) continue;
                    return true;
                }
            }
            return false;
        }

        public int a(NBTBase element, NBTBase source) throws CommandSyntaxException {
            if (net.minecraft.commands.arguments.ArgumentNBTKey$g.a(source, this.a())) {
                throw b.create();
            }
            NBTBase tag = source.d();
            List<NBTBase> list = this.d(element);
            if (list.isEmpty()) {
                return 0;
            }
            h node = this.c[this.c.length - 1];
            MutableBoolean mutableBoolean = new MutableBoolean(false);
            return net.minecraft.commands.arguments.ArgumentNBTKey$g.a(list, (NBTBase tag2) -> node.a((NBTBase)tag2, () -> {
                if (mutableBoolean.isFalse()) {
                    mutableBoolean.setTrue();
                    return tag;
                }
                return tag.d();
            }));
        }

        private int a() {
            return this.c.length;
        }

        public int a(int index, NBTTagCompound compound, List<NBTBase> elements) throws CommandSyntaxException {
            ArrayList<NBTBase> list = new ArrayList<NBTBase>(elements.size());
            for (NBTBase tag : elements) {
                NBTBase tag2 = tag.d();
                list.add(tag2);
                if (!net.minecraft.commands.arguments.ArgumentNBTKey$g.a(tag2, this.a())) continue;
                throw b.create();
            }
            List<NBTBase> collection = this.a((NBTBase)compound, NBTTagList::new);
            int i2 = 0;
            boolean bl = false;
            for (NBTBase tag3 : collection) {
                if (!(tag3 instanceof NBTList)) {
                    throw e.create((Object)tag3);
                }
                NBTList collectionTag = (NBTList)tag3;
                boolean bl2 = false;
                int j2 = index < 0 ? collectionTag.size() + index + 1 : index;
                for (NBTBase tag4 : list) {
                    try {
                        if (!collectionTag.b(j2, bl ? tag4.d() : tag4)) continue;
                        ++j2;
                        bl2 = true;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw f.create((Object)j2);
                    }
                }
                bl = true;
                i2 += bl2 ? 1 : 0;
            }
            return i2;
        }

        public int c(NBTBase element) {
            List<NBTBase> list = Collections.singletonList(element);
            for (int i2 = 0; i2 < this.c.length - 1; ++i2) {
                list = this.c[i2].a(list);
            }
            h node = this.c[this.c.length - 1];
            return net.minecraft.commands.arguments.ArgumentNBTKey$g.a(list, node::a);
        }

        private CommandSyntaxException a(h node) {
            int i2 = this.b.getInt((Object)node);
            return c.create((Object)this.a.substring(0, i2));
        }

        @Override
        public String toString() {
            return this.a;
        }
    }

    static interface h {
        public void a(NBTBase var1, List<NBTBase> var2);

        public void a(NBTBase var1, Supplier<NBTBase> var2, List<NBTBase> var3);

        public NBTBase a();

        public int a(NBTBase var1, Supplier<NBTBase> var2);

        public int a(NBTBase var1);

        default public List<NBTBase> a(List<NBTBase> elements) {
            return this.a(elements, this::a);
        }

        default public List<NBTBase> a(List<NBTBase> elements, Supplier<NBTBase> supplier) {
            return this.a(elements, (NBTBase current, List<NBTBase> results) -> this.a((NBTBase)current, supplier, (List<NBTBase>)results));
        }

        default public List<NBTBase> a(List<NBTBase> elements, BiConsumer<NBTBase, List<NBTBase>> action) {
            ArrayList list = Lists.newArrayList();
            for (NBTBase tag : elements) {
                action.accept(tag, list);
            }
            return list;
        }
    }

    static class f
    implements h {
        private final Predicate<NBTBase> a;

        public f(NBTTagCompound filter) {
            this.a = ArgumentNBTKey.a(filter);
        }

        @Override
        @Override
        public void a(NBTBase current, List<NBTBase> results) {
            if (current instanceof NBTTagCompound && this.a.test(current)) {
                results.add(current);
            }
        }

        @Override
        @Override
        public void a(NBTBase current, Supplier<NBTBase> source, List<NBTBase> results) {
            this.a(current, results);
        }

        @Override
        @Override
        public NBTBase a() {
            return new NBTTagCompound();
        }

        @Override
        @Override
        public int a(NBTBase current, Supplier<NBTBase> source) {
            return 0;
        }

        @Override
        @Override
        public int a(NBTBase current) {
            return 0;
        }
    }

    static class d
    implements h {
        private final NBTTagCompound a;
        private final Predicate<NBTBase> b;

        public d(NBTTagCompound filter) {
            this.a = filter;
            this.b = ArgumentNBTKey.a(filter);
        }

        @Override
        @Override
        public void a(NBTBase current, List<NBTBase> results) {
            if (current instanceof NBTTagList) {
                NBTTagList listTag = (NBTTagList)current;
                listTag.stream().filter(this.b).forEach(results::add);
            }
        }

        @Override
        @Override
        public void a(NBTBase current, Supplier<NBTBase> source, List<NBTBase> results) {
            MutableBoolean mutableBoolean = new MutableBoolean();
            if (current instanceof NBTTagList) {
                NBTTagList listTag = (NBTTagList)current;
                listTag.stream().filter(this.b).forEach(nbt -> {
                    results.add((NBTBase)nbt);
                    mutableBoolean.setTrue();
                });
                if (mutableBoolean.isFalse()) {
                    NBTTagCompound compoundTag = this.a.h();
                    listTag.add(compoundTag);
                    results.add(compoundTag);
                }
            }
        }

        @Override
        @Override
        public NBTBase a() {
            return new NBTTagList();
        }

        @Override
        @Override
        public int a(NBTBase current, Supplier<NBTBase> source) {
            int i2 = 0;
            if (current instanceof NBTTagList) {
                NBTTagList listTag = (NBTTagList)current;
                int j2 = listTag.size();
                if (j2 == 0) {
                    listTag.add(source.get());
                    ++i2;
                } else {
                    for (int k2 = 0; k2 < j2; ++k2) {
                        NBTBase tag2;
                        NBTBase tag = listTag.k(k2);
                        if (!this.b.test(tag) || (tag2 = source.get()).equals(tag) || !listTag.a(k2, tag2)) continue;
                        ++i2;
                    }
                }
            }
            return i2;
        }

        @Override
        @Override
        public int a(NBTBase current) {
            int i2 = 0;
            if (current instanceof NBTTagList) {
                NBTTagList listTag = (NBTTagList)current;
                for (int j2 = listTag.size() - 1; j2 >= 0; --j2) {
                    if (!this.b.test(listTag.k(j2))) continue;
                    listTag.c(j2);
                    ++i2;
                }
            }
            return i2;
        }
    }

    static class a
    implements h {
        public static final a a = new a();

        private a() {
        }

        @Override
        @Override
        public void a(NBTBase current, List<NBTBase> results) {
            if (current instanceof NBTList) {
                results.addAll((NBTList)current);
            }
        }

        @Override
        @Override
        public void a(NBTBase current, Supplier<NBTBase> source, List<NBTBase> results) {
            if (current instanceof NBTList) {
                NBTList collectionTag = (NBTList)current;
                if (collectionTag.isEmpty()) {
                    NBTBase tag = source.get();
                    if (collectionTag.b(0, tag)) {
                        results.add(tag);
                    }
                } else {
                    results.addAll(collectionTag);
                }
            }
        }

        @Override
        @Override
        public NBTBase a() {
            return new NBTTagList();
        }

        @Override
        @Override
        public int a(NBTBase current, Supplier<NBTBase> source) {
            if (current instanceof NBTList) {
                NBTList collectionTag = (NBTList)current;
                int i2 = collectionTag.size();
                if (i2 == 0) {
                    collectionTag.b(0, source.get());
                    return 1;
                }
                NBTBase tag = source.get();
                int j2 = i2 - (int)collectionTag.stream().filter(tag::equals).count();
                if (j2 == 0) {
                    return 0;
                }
                collectionTag.clear();
                if (!collectionTag.b(0, tag)) {
                    return 0;
                }
                for (int k2 = 1; k2 < i2; ++k2) {
                    collectionTag.b(k2, source.get());
                }
                return j2;
            }
            return 0;
        }

        @Override
        @Override
        public int a(NBTBase current) {
            NBTList collectionTag;
            int i2;
            if (current instanceof NBTList && (i2 = (collectionTag = (NBTList)current).size()) > 0) {
                collectionTag.clear();
                return i2;
            }
            return 0;
        }
    }

    static class c
    implements h {
        private final int a;

        public c(int index) {
            this.a = index;
        }

        @Override
        @Override
        public void a(NBTBase current, List<NBTBase> results) {
            if (current instanceof NBTList) {
                int j2;
                NBTList collectionTag = (NBTList)current;
                int i2 = collectionTag.size();
                int n2 = j2 = this.a < 0 ? i2 + this.a : this.a;
                if (0 <= j2 && j2 < i2) {
                    results.add((NBTBase)collectionTag.get(j2));
                }
            }
        }

        @Override
        @Override
        public void a(NBTBase current, Supplier<NBTBase> source, List<NBTBase> results) {
            this.a(current, results);
        }

        @Override
        @Override
        public NBTBase a() {
            return new NBTTagList();
        }

        @Override
        @Override
        public int a(NBTBase current, Supplier<NBTBase> source) {
            if (current instanceof NBTList) {
                int j2;
                NBTList collectionTag = (NBTList)current;
                int i2 = collectionTag.size();
                int n2 = j2 = this.a < 0 ? i2 + this.a : this.a;
                if (0 <= j2 && j2 < i2) {
                    NBTBase tag = (NBTBase)collectionTag.get(j2);
                    NBTBase tag2 = source.get();
                    if (!tag2.equals(tag) && collectionTag.a(j2, tag2)) {
                        return 1;
                    }
                }
            }
            return 0;
        }

        @Override
        @Override
        public int a(NBTBase current) {
            if (current instanceof NBTList) {
                int j2;
                NBTList collectionTag = (NBTList)current;
                int i2 = collectionTag.size();
                int n2 = j2 = this.a < 0 ? i2 + this.a : this.a;
                if (0 <= j2 && j2 < i2) {
                    collectionTag.c(j2);
                    return 1;
                }
            }
            return 0;
        }
    }

    static class e
    implements h {
        private final String a;
        private final NBTTagCompound b;
        private final Predicate<NBTBase> c;

        public e(String name, NBTTagCompound filter) {
            this.a = name;
            this.b = filter;
            this.c = ArgumentNBTKey.a(filter);
        }

        @Override
        @Override
        public void a(NBTBase current, List<NBTBase> results) {
            NBTBase tag;
            if (current instanceof NBTTagCompound && this.c.test(tag = ((NBTTagCompound)current).c(this.a))) {
                results.add(tag);
            }
        }

        @Override
        @Override
        public void a(NBTBase current, Supplier<NBTBase> source, List<NBTBase> results) {
            if (current instanceof NBTTagCompound) {
                NBTTagCompound compoundTag = (NBTTagCompound)current;
                NBTBase tag = compoundTag.c(this.a);
                if (tag == null) {
                    tag = this.b.h();
                    compoundTag.a(this.a, tag);
                    results.add(tag);
                } else if (this.c.test(tag)) {
                    results.add(tag);
                }
            }
        }

        @Override
        @Override
        public NBTBase a() {
            return new NBTTagCompound();
        }

        @Override
        @Override
        public int a(NBTBase current, Supplier<NBTBase> source) {
            NBTBase tag2;
            NBTTagCompound compoundTag;
            NBTBase tag;
            if (current instanceof NBTTagCompound && this.c.test(tag = (compoundTag = (NBTTagCompound)current).c(this.a)) && !(tag2 = source.get()).equals(tag)) {
                compoundTag.a(this.a, tag2);
                return 1;
            }
            return 0;
        }

        @Override
        @Override
        public int a(NBTBase current) {
            NBTTagCompound compoundTag;
            NBTBase tag;
            if (current instanceof NBTTagCompound && this.c.test(tag = (compoundTag = (NBTTagCompound)current).c(this.a))) {
                compoundTag.r(this.a);
                return 1;
            }
            return 0;
        }
    }

    static class b
    implements h {
        private final String a;

        public b(String name) {
            this.a = name;
        }

        @Override
        @Override
        public void a(NBTBase current, List<NBTBase> results) {
            NBTBase tag;
            if (current instanceof NBTTagCompound && (tag = ((NBTTagCompound)current).c(this.a)) != null) {
                results.add(tag);
            }
        }

        @Override
        @Override
        public void a(NBTBase current, Supplier<NBTBase> source, List<NBTBase> results) {
            if (current instanceof NBTTagCompound) {
                NBTBase tag2;
                NBTTagCompound compoundTag = (NBTTagCompound)current;
                if (compoundTag.e(this.a)) {
                    NBTBase tag = compoundTag.c(this.a);
                } else {
                    tag2 = source.get();
                    compoundTag.a(this.a, tag2);
                }
                results.add(tag2);
            }
        }

        @Override
        @Override
        public NBTBase a() {
            return new NBTTagCompound();
        }

        @Override
        @Override
        public int a(NBTBase current, Supplier<NBTBase> source) {
            if (current instanceof NBTTagCompound) {
                NBTBase tag2;
                NBTTagCompound compoundTag = (NBTTagCompound)current;
                NBTBase tag = source.get();
                if (!tag.equals(tag2 = compoundTag.a(this.a, tag))) {
                    return 1;
                }
            }
            return 0;
        }

        @Override
        @Override
        public int a(NBTBase current) {
            NBTTagCompound compoundTag;
            if (current instanceof NBTTagCompound && (compoundTag = (NBTTagCompound)current).e(this.a)) {
                compoundTag.r(this.a);
                return 1;
            }
            return 0;
        }
    }
}

