/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public class ResourceOrTagArgument<T>
implements ArgumentType<c<T>> {
    private static final Collection<String> a = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    private static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((tag, type) -> IChatBaseComponent.a("argument.resource_tag.not_found", tag, type));
    private static final Dynamic3CommandExceptionType c = new Dynamic3CommandExceptionType((tag, type, expectedType) -> IChatBaseComponent.a("argument.resource_tag.invalid_type", tag, type, expectedType));
    private final HolderLookup<T> d;
    final ResourceKey<? extends IRegistry<T>> e;

    public ResourceOrTagArgument(CommandBuildContext registryAccess, ResourceKey<? extends IRegistry<T>> registryRef) {
        this.e = registryRef;
        this.d = registryAccess.a(registryRef);
    }

    public static <T> ResourceOrTagArgument<T> a(CommandBuildContext registryRef, ResourceKey<? extends IRegistry<T>> registryAccess) {
        return new ResourceOrTagArgument<T>(registryRef, registryAccess);
    }

    public static <T> c<T> a(CommandContext<CommandListenerWrapper> context, String name, ResourceKey<IRegistry<T>> registryRef) throws CommandSyntaxException {
        c result = (c)context.getArgument(name, c.class);
        Optional<c<T>> optional = result.a(registryRef);
        return optional.orElseThrow(() -> result.a().map(entry -> {
            ResourceKey resourceKey2 = entry.g();
            return ResourceArgument.b.create((Object)resourceKey2.a(), (Object)resourceKey2.b(), (Object)registryRef.a());
        }, entryList -> {
            TagKey tagKey = entryList.f();
            return c.create((Object)tagKey.b(), tagKey.a(), (Object)registryRef.a());
        }));
    }

    public c<T> a(StringReader stringReader) throws CommandSyntaxException {
        if (stringReader.canRead() && stringReader.peek() == '#') {
            int i2 = stringReader.getCursor();
            try {
                stringReader.skip();
                MinecraftKey resourceLocation = MinecraftKey.a(stringReader);
                TagKey tagKey = TagKey.a(this.e, resourceLocation);
                HolderSet.Named named = this.d.a(tagKey).orElseThrow(() -> b.create((Object)resourceLocation, (Object)this.e.a()));
                return new d(named);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                stringReader.setCursor(i2);
                throw commandSyntaxException;
            }
        }
        MinecraftKey resourceLocation2 = MinecraftKey.a(stringReader);
        ResourceKey resourceKey = ResourceKey.a(this.e, resourceLocation2);
        Holder.c reference = this.d.a(resourceKey).orElseThrow(() -> ResourceArgument.a.create((Object)resourceLocation2, (Object)this.e.a()));
        return new b(reference);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        ICompletionProvider.a(this.d.e().map(TagKey::b), suggestionsBuilder, "#");
        return ICompletionProvider.a(this.d.c().map(ResourceKey::a), suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return a;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }

    public static interface c<T>
    extends Predicate<Holder<T>> {
        public Either<Holder.c<T>, HolderSet.Named<T>> a();

        public <E> Optional<c<E>> a(ResourceKey<? extends IRegistry<E>> var1);

        public String b();
    }

    record d<T>(HolderSet.Named<T> a) implements c<T>
    {
        private final HolderSet.Named<T> a;

        @Override
        @Override
        public Either<Holder.c<T>, HolderSet.Named<T>> a() {
            return Either.right(this.a);
        }

        @Override
        @Override
        public <E> Optional<c<E>> a(ResourceKey<? extends IRegistry<E>> registryRef) {
            return this.a.f().c(registryRef) ? Optional.of(this) : Optional.empty();
        }

        @Override
        public boolean a(Holder<T> holder) {
            return this.a.a(holder);
        }

        @Override
        @Override
        public String b() {
            return "#" + this.a.f().b();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "tag", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "tag", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "tag", "a"}, this, object);
        }

        public HolderSet.Named<T> c() {
            return this.a;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((Holder)object);
        }
    }

    record b<T>(Holder.c<T> a) implements c<T>
    {
        private final Holder.c<T> a;

        @Override
        @Override
        public Either<Holder.c<T>, HolderSet.Named<T>> a() {
            return Either.left(this.a);
        }

        @Override
        @Override
        public <E> Optional<c<E>> a(ResourceKey<? extends IRegistry<E>> registryRef) {
            return this.a.g().b(registryRef) ? Optional.of(this) : Optional.empty();
        }

        @Override
        public boolean a(Holder<T> holder) {
            return holder.equals(this.a);
        }

        @Override
        @Override
        public String b() {
            return this.a.g().a().toString();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "value", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "value", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "value", "a"}, this, object);
        }

        public Holder.c<T> c() {
            return this.a;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((Holder)object);
        }
    }

    public static class net.minecraft.commands.arguments.ResourceOrTagArgument$a<T>
    implements ArgumentTypeInfo<ResourceOrTagArgument<T>, a> {
        @Override
        @Override
        public void a(a properties, PacketDataSerializer buf) {
            buf.b(properties.b);
        }

        @Override
        @Override
        public a a(PacketDataSerializer friendlyByteBuf) {
            return new a(friendlyByteBuf.t());
        }

        @Override
        @Override
        public void a(a properties, JsonObject json) {
            json.addProperty("registry", properties.b.a().toString());
        }

        @Override
        @Override
        public a a(ResourceOrTagArgument<T> argumentType) {
            return new a(argumentType.e);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a b(PacketDataSerializer buf) {
            return this.a(buf);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceOrTagArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> b;

            a(ResourceKey<? extends IRegistry<T>> registryRef) {
                this.b = registryRef;
            }

            @Override
            public ResourceOrTagArgument<T> a(CommandBuildContext commandBuildContext) {
                return new ResourceOrTagArgument(commandBuildContext, this.b);
            }

            @Override
            @Override
            public ArgumentTypeInfo<ResourceOrTagArgument<T>, ?> a() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType b(CommandBuildContext commandRegistryAccess) {
                return this.a(commandRegistryAccess);
            }
        }
    }
}

