/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class ArgumentBlock {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.block.tag.disallowed"));
    public static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(object -> IChatBaseComponent.a("argument.block.id.invalid", object));
    public static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.a("argument.block.property.unknown", object, object1));
    public static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.a("argument.block.property.duplicate", object1, object));
    public static final Dynamic3CommandExceptionType e = new Dynamic3CommandExceptionType((object, object1, object2) -> IChatBaseComponent.a("argument.block.property.invalid", object, object2, object1));
    public static final Dynamic2CommandExceptionType f = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.a("argument.block.property.novalue", object, object1));
    public static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.block.property.unclosed"));
    public static final DynamicCommandExceptionType h = new DynamicCommandExceptionType(object -> IChatBaseComponent.a("arguments.block.tag.unknown", object));
    private static final char i = '[';
    private static final char j = '{';
    private static final char k = ']';
    private static final char l = '=';
    private static final char m = ',';
    private static final char n = '#';
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> o = SuggestionsBuilder::buildFuture;
    private final HolderLookup<Block> p;
    private final StringReader q;
    private final boolean r;
    private final boolean s;
    private final Map<IBlockState<?>, Comparable<?>> t = Maps.newLinkedHashMap();
    private final Map<String, String> u = Maps.newHashMap();
    private MinecraftKey v = new MinecraftKey("");
    @Nullable
    private BlockStateList<Block, IBlockData> w;
    @Nullable
    private IBlockData x;
    @Nullable
    private NBTTagCompound y;
    @Nullable
    private HolderSet<Block> z;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> A = o;

    private ArgumentBlock(HolderLookup<Block> registryWrapper, StringReader reader, boolean allowTag, boolean allowSnbt) {
        this.p = registryWrapper;
        this.q = reader;
        this.r = allowTag;
        this.s = allowSnbt;
    }

    public static a a(HolderLookup<Block> registryWrapper, String string, boolean allowSnbt) throws CommandSyntaxException {
        return ArgumentBlock.a(registryWrapper, new StringReader(string), allowSnbt);
    }

    public static a a(HolderLookup<Block> registryWrapper, StringReader reader, boolean allowSnbt) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        try {
            ArgumentBlock argumentblock = new ArgumentBlock(registryWrapper, reader, false, allowSnbt);
            argumentblock.a();
            return new a(argumentblock.x, argumentblock.t, argumentblock.y);
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            reader.setCursor(i2);
            throw commandsyntaxexception;
        }
    }

    public static Either<a, b> b(HolderLookup<Block> registryWrapper, String string, boolean allowSnbt) throws CommandSyntaxException {
        return ArgumentBlock.b(registryWrapper, new StringReader(string), allowSnbt);
    }

    public static Either<a, b> b(HolderLookup<Block> registryWrapper, StringReader reader, boolean allowSnbt) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        try {
            ArgumentBlock argumentblock = new ArgumentBlock(registryWrapper, reader, true, allowSnbt);
            argumentblock.a();
            return argumentblock.z != null ? Either.right(new b(argumentblock.z, argumentblock.u, argumentblock.y)) : Either.left(new a(argumentblock.x, argumentblock.t, argumentblock.y));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            reader.setCursor(i2);
            throw commandsyntaxexception;
        }
    }

    public static CompletableFuture<Suggestions> a(HolderLookup<Block> registryWrapper, SuggestionsBuilder builder, boolean allowTag, boolean allowSnbt) {
        StringReader stringreader = new StringReader(builder.getInput());
        stringreader.setCursor(builder.getStart());
        ArgumentBlock argumentblock = new ArgumentBlock(registryWrapper, stringreader, allowTag, allowSnbt);
        try {
            argumentblock.a();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return argumentblock.A.apply(builder.createOffset(stringreader.getCursor()));
    }

    private void a() throws CommandSyntaxException {
        this.A = this.r ? this::l : this::k;
        if (this.q.canRead() && this.q.peek() == '#') {
            this.d();
            this.A = this::h;
            if (this.q.canRead() && this.q.peek() == '[') {
                this.f();
                this.A = this::e;
            }
        } else {
            this.c();
            this.A = this::i;
            if (this.q.canRead() && this.q.peek() == '[') {
                this.e();
                this.A = this::e;
            }
        }
        if (this.s && this.q.canRead() && this.q.peek() == '{') {
            this.A = o;
            this.g();
        }
    }

    private CompletableFuture<Suggestions> a(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(']'));
        }
        return this.c(builder);
    }

    private CompletableFuture<Suggestions> b(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(']'));
        }
        return this.d(builder);
    }

    private CompletableFuture<Suggestions> c(SuggestionsBuilder builder) {
        String s2 = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (IBlockState<?> iblockstate : this.x.B()) {
            if (this.t.containsKey(iblockstate) || !iblockstate.f().startsWith(s2)) continue;
            builder.suggest(iblockstate.f() + "=");
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> d(SuggestionsBuilder builder) {
        String s2 = builder.getRemaining().toLowerCase(Locale.ROOT);
        if (this.z != null) {
            for (Holder holder : this.z) {
                for (IBlockState<?> iblockstate : ((Block)holder.a()).l().d()) {
                    if (this.u.containsKey(iblockstate.f()) || !iblockstate.f().startsWith(s2)) continue;
                    builder.suggest(iblockstate.f() + "=");
                }
            }
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> e(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty() && this.b()) {
            builder.suggest(String.valueOf('{'));
        }
        return builder.buildFuture();
    }

    private boolean b() {
        if (this.x != null) {
            return this.x.t();
        }
        if (this.z != null) {
            for (Holder holder : this.z) {
                if (!((Block)holder.a()).n().t()) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Suggestions> f(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf('='));
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> g(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(']'));
        }
        if (builder.getRemaining().isEmpty() && this.t.size() < this.x.B().size()) {
            builder.suggest(String.valueOf(','));
        }
        return builder.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder a(SuggestionsBuilder builder, IBlockState<T> property) {
        for (Comparable t0 : property.a()) {
            if (t0 instanceof Integer) {
                Integer integer = (Integer)t0;
                builder.suggest(integer.intValue());
                continue;
            }
            builder.suggest(property.a(t0));
        }
        return builder;
    }

    private CompletableFuture<Suggestions> a(SuggestionsBuilder builder, String name) {
        boolean flag = false;
        if (this.z != null) {
            block0: for (Holder holder : this.z) {
                Block block = (Block)holder.a();
                IBlockState<?> iblockstate = block.l().a(name);
                if (iblockstate != null) {
                    ArgumentBlock.a(builder, iblockstate);
                }
                if (flag) continue;
                for (IBlockState<?> iblockstate1 : block.l().d()) {
                    if (this.u.containsKey(iblockstate1.f())) continue;
                    flag = true;
                    continue block0;
                }
            }
        }
        if (flag) {
            builder.suggest(String.valueOf(','));
        }
        builder.suggest(String.valueOf(']'));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> h(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty() && this.z != null) {
            Holder holder;
            Block block;
            boolean flag = false;
            boolean flag1 = false;
            Iterator iterator = this.z.iterator();
            while (!(!iterator.hasNext() || (flag |= !(block = (Block)(holder = (Holder)iterator.next()).a()).l().d().isEmpty()) && (flag1 |= block.n().t()))) {
            }
            if (flag) {
                builder.suggest(String.valueOf('['));
            }
            if (flag1) {
                builder.suggest(String.valueOf('{'));
            }
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> i(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            if (!this.w.d().isEmpty()) {
                builder.suggest(String.valueOf('['));
            }
            if (this.x.t()) {
                builder.suggest(String.valueOf('{'));
            }
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> j(SuggestionsBuilder builder) {
        return ICompletionProvider.a(this.p.e().map(TagKey::b), builder, String.valueOf('#'));
    }

    private CompletableFuture<Suggestions> k(SuggestionsBuilder builder) {
        return ICompletionProvider.a(this.p.c().map(ResourceKey::a), builder);
    }

    private CompletableFuture<Suggestions> l(SuggestionsBuilder builder) {
        this.j(builder);
        this.k(builder);
        return builder.buildFuture();
    }

    private void c() throws CommandSyntaxException {
        int i2 = this.q.getCursor();
        this.v = MinecraftKey.a(this.q);
        Block block = this.p.a(ResourceKey.a(Registries.e, this.v)).orElseThrow(() -> {
            this.q.setCursor(i2);
            return b.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString());
        }).a();
        this.w = block.l();
        this.x = block.n();
    }

    private void d() throws CommandSyntaxException {
        if (!this.r) {
            throw a.createWithContext((ImmutableStringReader)this.q);
        }
        int i2 = this.q.getCursor();
        this.q.expect('#');
        this.A = this::j;
        MinecraftKey minecraftkey = MinecraftKey.a(this.q);
        this.z = this.p.a(TagKey.a(Registries.e, minecraftkey)).orElseThrow(() -> {
            this.q.setCursor(i2);
            return h.createWithContext((ImmutableStringReader)this.q, (Object)minecraftkey.toString());
        });
    }

    private void e() throws CommandSyntaxException {
        this.q.skip();
        this.A = this::a;
        this.q.skipWhitespace();
        while (this.q.canRead() && this.q.peek() != ']') {
            this.q.skipWhitespace();
            int i2 = this.q.getCursor();
            String s2 = this.q.readString();
            IBlockState<?> iblockstate = this.w.a(s2);
            if (iblockstate == null) {
                this.q.setCursor(i2);
                throw c.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)s2);
            }
            if (this.t.containsKey(iblockstate)) {
                this.q.setCursor(i2);
                throw d.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)s2);
            }
            this.q.skipWhitespace();
            this.A = this::f;
            if (!this.q.canRead() || this.q.peek() != '=') {
                throw f.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)s2);
            }
            this.q.skip();
            this.q.skipWhitespace();
            this.A = suggestionsbuilder -> ArgumentBlock.a(suggestionsbuilder, iblockstate).buildFuture();
            int j2 = this.q.getCursor();
            this.a(iblockstate, this.q.readString(), j2);
            this.A = this::g;
            this.q.skipWhitespace();
            if (!this.q.canRead()) continue;
            if (this.q.peek() == ',') {
                this.q.skip();
                this.A = this::c;
                continue;
            }
            if (this.q.peek() == ']') break;
            throw g.createWithContext((ImmutableStringReader)this.q);
        }
        if (this.q.canRead()) {
            this.q.skip();
            return;
        }
        throw g.createWithContext((ImmutableStringReader)this.q);
    }

    private void f() throws CommandSyntaxException {
        this.q.skip();
        this.A = this::b;
        int i2 = -1;
        this.q.skipWhitespace();
        while (this.q.canRead() && this.q.peek() != ']') {
            this.q.skipWhitespace();
            int j2 = this.q.getCursor();
            String s2 = this.q.readString();
            if (this.u.containsKey(s2)) {
                this.q.setCursor(j2);
                throw d.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)s2);
            }
            this.q.skipWhitespace();
            if (!this.q.canRead() || this.q.peek() != '=') {
                this.q.setCursor(j2);
                throw f.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)s2);
            }
            this.q.skip();
            this.q.skipWhitespace();
            this.A = suggestionsbuilder -> this.a((SuggestionsBuilder)suggestionsbuilder, s2);
            i2 = this.q.getCursor();
            String s1 = this.q.readString();
            this.u.put(s2, s1);
            this.q.skipWhitespace();
            if (!this.q.canRead()) continue;
            i2 = -1;
            if (this.q.peek() == ',') {
                this.q.skip();
                this.A = this::d;
                continue;
            }
            if (this.q.peek() == ']') break;
            throw g.createWithContext((ImmutableStringReader)this.q);
        }
        if (this.q.canRead()) {
            this.q.skip();
            return;
        }
        if (i2 >= 0) {
            this.q.setCursor(i2);
        }
        throw g.createWithContext((ImmutableStringReader)this.q);
    }

    private void g() throws CommandSyntaxException {
        this.y = new MojangsonParser(this.q).f();
    }

    private <T extends Comparable<T>> void a(IBlockState<T> property, String value, int cursor) throws CommandSyntaxException {
        Optional<T> optional = property.b(value);
        if (!optional.isPresent()) {
            this.q.setCursor(cursor);
            throw e.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)property.f(), (Object)value);
        }
        this.x = (IBlockData)this.x.a(property, (Comparable)optional.get());
        this.t.put(property, (Comparable)optional.get());
    }

    public static String a(IBlockData state) {
        StringBuilder stringbuilder = new StringBuilder(state.c().e().map(resourcekey -> resourcekey.a().toString()).orElse("air"));
        if (!state.B().isEmpty()) {
            stringbuilder.append('[');
            boolean flag = false;
            for (Map.Entry entry : state.C().entrySet()) {
                if (flag) {
                    stringbuilder.append(',');
                }
                ArgumentBlock.a(stringbuilder, (IBlockState)entry.getKey(), (Comparable)entry.getValue());
                flag = true;
            }
            stringbuilder.append(']');
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> void a(StringBuilder builder, IBlockState<T> property, Comparable<?> value) {
        builder.append(property.f());
        builder.append('=');
        builder.append(property.a(value));
    }

    public record a(IBlockData a, Map<IBlockState<?>, Comparable<?>> b, @Nullable NBTTagCompound c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blockState;properties;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blockState;properties;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blockState;properties;nbt", "a", "b", "c"}, this, o2);
        }
    }

    public record b(HolderSet<Block> a, Map<String, String> b, @Nullable NBTTagCompound c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "tag;vagueProperties;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "tag;vagueProperties;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "tag;vagueProperties;nbt", "a", "b", "c"}, this, o2);
        }
    }
}

