/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import org.slf4j.Logger;

public class ArgumentUtils {
    private static final Logger a = LogUtils.getLogger();
    private static final byte b = 1;
    private static final byte c = 2;

    public static int a(boolean hasMin, boolean hasMax) {
        int i2 = 0;
        if (hasMin) {
            i2 |= 1;
        }
        if (hasMax) {
            i2 |= 2;
        }
        return i2;
    }

    public static boolean a(byte flags) {
        return (flags & 1) != 0;
    }

    public static boolean b(byte flags) {
        return (flags & 2) != 0;
    }

    private static <A extends ArgumentType<?>> void a(JsonObject json, ArgumentTypeInfo.a<A> properties) {
        ArgumentUtils.a(json, properties.a(), properties);
    }

    private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.a<A>> void a(JsonObject json, ArgumentTypeInfo<A, T> serializer, ArgumentTypeInfo.a<A> properties) {
        serializer.a(properties, json);
    }

    private static <T extends ArgumentType<?>> void a(JsonObject json, T argumentType) {
        ArgumentTypeInfo.a<T> template = ArgumentTypeInfos.b(argumentType);
        json.addProperty("type", "argument");
        json.addProperty("parser", BuiltInRegistries.x.b(template.a()).toString());
        JsonObject jsonObject = new JsonObject();
        ArgumentUtils.a(jsonObject, template);
        if (jsonObject.size() > 0) {
            json.add("properties", (JsonElement)jsonObject);
        }
    }

    public static <S> JsonObject a(CommandDispatcher<S> dispatcher, CommandNode<S> rootNode) {
        Collection<String> collection;
        JsonObject jsonObject = new JsonObject();
        if (rootNode instanceof RootCommandNode) {
            jsonObject.addProperty("type", "root");
        } else if (rootNode instanceof LiteralCommandNode) {
            jsonObject.addProperty("type", "literal");
        } else if (rootNode instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)rootNode;
            ArgumentUtils.a(jsonObject, argumentCommandNode.getType());
        } else {
            a.error("Could not serialize node {} ({})!", rootNode, rootNode.getClass());
            jsonObject.addProperty("type", "unknown");
        }
        JsonObject jsonObject2 = new JsonObject();
        for (CommandNode<S> commandNode : rootNode.getChildren()) {
            jsonObject2.add(commandNode.getName(), (JsonElement)ArgumentUtils.a(dispatcher, commandNode));
        }
        if (jsonObject2.size() > 0) {
            jsonObject.add("children", (JsonElement)jsonObject2);
        }
        if (rootNode.getCommand() != null) {
            jsonObject.addProperty("executable", Boolean.valueOf(true));
        }
        if (rootNode.getRedirect() != null && !(collection = dispatcher.getPath(rootNode.getRedirect())).isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (String string : collection) {
                jsonArray.add(string);
            }
            jsonObject.add("redirect", (JsonElement)jsonArray);
        }
        return jsonObject;
    }

    public static <T> Set<ArgumentType<?>> a(CommandNode<T> rootNode) {
        Set set = Sets.newIdentityHashSet();
        HashSet set2 = Sets.newHashSet();
        ArgumentUtils.a(rootNode, set2, set);
        return set2;
    }

    private static <T> void a(CommandNode<T> node, Set<ArgumentType<?>> usedArgumentTypes, Set<CommandNode<T>> visitedNodes) {
        if (!visitedNodes.add(node)) {
            return;
        }
        if (node instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)node;
            usedArgumentTypes.add(argumentCommandNode.getType());
        }
        node.getChildren().forEach(child -> ArgumentUtils.a(child, usedArgumentTypes, visitedNodes));
        CommandNode<T> commandNode = node.getRedirect();
        if (commandNode != null) {
            ArgumentUtils.a(commandNode, usedArgumentTypes, visitedNodes);
        }
    }
}

