/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;

public class NonNullList<E>
extends AbstractList<E> {
    private final List<E> a;
    @Nullable
    private final E b;

    public static <E> NonNullList<E> a() {
        return new NonNullList<Object>(Lists.newArrayList(), null);
    }

    public static <E> NonNullList<E> a(int size) {
        return new NonNullList<Object>(Lists.newArrayListWithCapacity((int)size), null);
    }

    public static <E> NonNullList<E> a(int size, E defaultValue) {
        Validate.notNull(defaultValue);
        Object[] objects = new Object[size];
        Arrays.fill(objects, defaultValue);
        return new NonNullList<Object>(Arrays.asList(objects), defaultValue);
    }

    @SafeVarargs
    public static <E> NonNullList<E> a(E defaultValue, E ... values) {
        return new NonNullList<E>(Arrays.asList(values), defaultValue);
    }

    protected NonNullList(List<E> delegate, @Nullable E initialElement) {
        this.a = delegate;
        this.b = initialElement;
    }

    @Override
    @Nonnull
    @Override
    public E get(int i2) {
        return this.a.get(i2);
    }

    @Override
    @Override
    public E set(int i2, E object) {
        Validate.notNull(object);
        return this.a.set(i2, object);
    }

    @Override
    @Override
    public void add(int i2, E object) {
        Validate.notNull(object);
        this.a.add(i2, object);
    }

    @Override
    @Override
    public E remove(int i2) {
        return this.a.remove(i2);
    }

    @Override
    @Override
    public int size() {
        return this.a.size();
    }

    @Override
    @Override
    public void clear() {
        if (this.b == null) {
            super.clear();
        } else {
            for (int i2 = 0; i2 < this.size(); ++i2) {
                this.set(i2, this.b);
            }
        }
    }
}

