/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class RegistryMaterials<T>
implements IRegistryWritable<T> {
    private static final Logger b = LogUtils.getLogger();
    final ResourceKey<? extends IRegistry<T>> c;
    private final ObjectList<Holder.c<T>> d = new ObjectArrayList(256);
    private final Reference2IntOpenHashMap<T> e = new Reference2IntOpenHashMap(2048);
    private final Map<MinecraftKey, Holder.c<T>> f = new HashMap<MinecraftKey, Holder.c<T>>(2048);
    private final Map<ResourceKey<T>, Holder.c<T>> g = new HashMap<ResourceKey<T>, Holder.c<T>>(2048);
    private final Map<T, Holder.c<T>> h = new IdentityHashMap<T, Holder.c<T>>(2048);
    private final Map<T, Lifecycle> i = new IdentityHashMap<T, Lifecycle>(2048);
    private Lifecycle j;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> k = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private boolean l;
    @Nullable
    private Map<T, Holder.c<T>> m;
    @Nullable
    private List<Holder.c<T>> n;
    private int o;
    private final HolderLookup.c<T> p = new HolderLookup.c<T>(){

        @Override
        public ResourceKey<? extends IRegistry<? extends T>> f() {
            return RegistryMaterials.this.c;
        }

        @Override
        public Lifecycle g() {
            return RegistryMaterials.this.d();
        }

        @Override
        public Optional<Holder.c<T>> a(ResourceKey<T> key) {
            return RegistryMaterials.this.b(key);
        }

        @Override
        public Stream<Holder.c<T>> b() {
            return RegistryMaterials.this.h();
        }

        @Override
        public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
            return RegistryMaterials.this.b(tag);
        }

        @Override
        public Stream<HolderSet.Named<T>> d() {
            return RegistryMaterials.this.i().map(Pair::getSecond);
        }
    };

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle) {
        this(key, lifecycle, false);
    }

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, boolean intrusive) {
        this.e.defaultReturnValue(-1);
        DispenserRegistry.a(() -> "registry " + key);
        this.c = key;
        this.j = lifecycle;
        if (intrusive) {
            this.m = new IdentityHashMap<T, Holder.c<T>>();
        }
    }

    @Override
    public ResourceKey<? extends IRegistry<T>> c() {
        return this.c;
    }

    public String toString() {
        return "Registry[" + this.c + " (" + this.j + ")]";
    }

    private List<Holder.c<T>> a() {
        if (this.n == null) {
            this.n = this.d.stream().filter(Objects::nonNull).toList();
        }
        return this.n;
    }

    private void v() {
        if (this.l) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    private void g(ResourceKey<T> key) {
        if (this.l) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + key + ")");
        }
    }

    public Holder.c<T> a(int rawId, ResourceKey<T> key, T value, Lifecycle lifecycle) {
        Holder.c reference;
        this.g(key);
        Validate.notNull(key);
        Validate.notNull(value);
        if (this.f.containsKey(key.a())) {
            SystemUtils.b(new IllegalStateException("Adding duplicate key '" + key + "' to registry"));
        }
        if (this.h.containsKey(value)) {
            SystemUtils.b(new IllegalStateException("Adding duplicate value '" + value + "' to registry"));
        }
        if (this.m != null) {
            reference = this.m.remove(value);
            if (reference == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + key + ":" + value));
            }
            reference.b(key);
        } else {
            reference = this.g.computeIfAbsent(key, keyx -> Holder.c.a(this.o(), keyx));
        }
        this.g.put(key, reference);
        this.f.put(key.a(), reference);
        this.h.put(value, reference);
        this.d.size(Math.max(this.d.size(), rawId + 1));
        this.d.set(rawId, (Object)reference);
        this.e.put(value, rawId);
        if (this.o <= rawId) {
            this.o = rawId + 1;
        }
        this.i.put(value, lifecycle);
        this.j = this.j.add(lifecycle);
        this.n = null;
        return reference;
    }

    @Override
    public Holder.c<T> a(ResourceKey<T> key, T entry, Lifecycle lifecycle) {
        return this.a(this.o, key, entry, lifecycle);
    }

    @Override
    @Nullable
    public MinecraftKey b(T value) {
        Holder.c<T> reference = this.h.get(value);
        return reference != null ? reference.g().a() : null;
    }

    @Override
    public Optional<ResourceKey<T>> c(T entry) {
        return Optional.ofNullable(this.h.get(entry)).map(Holder.c::g);
    }

    @Override
    public int a(@Nullable T value) {
        return this.e.getInt(value);
    }

    @Override
    @Nullable
    public T a(@Nullable ResourceKey<T> key) {
        return RegistryMaterials.a(this.g.get(key));
    }

    @Override
    @Nullable
    public T a(int index) {
        return index >= 0 && index < this.d.size() ? (T)RegistryMaterials.a((Holder.c)this.d.get(index)) : null;
    }

    @Override
    public Optional<Holder.c<T>> c(int rawId) {
        return rawId >= 0 && rawId < this.d.size() ? Optional.ofNullable((Holder.c)this.d.get(rawId)) : Optional.empty();
    }

    @Override
    public Optional<Holder.c<T>> b(ResourceKey<T> key) {
        return Optional.ofNullable(this.g.get(key));
    }

    @Override
    public Holder<T> d(T value) {
        Holder.c<T> reference = this.h.get(value);
        return reference != null ? reference : Holder.a(value);
    }

    Holder.c<T> h(ResourceKey<T> key) {
        return this.g.computeIfAbsent(key, key2 -> {
            if (this.m != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.g((ResourceKey<T>)key2);
            return Holder.c.a(this.o(), key2);
        });
    }

    @Override
    public int b() {
        return this.g.size();
    }

    @Override
    public Lifecycle e(T entry) {
        return this.i.get(entry);
    }

    @Override
    public Lifecycle d() {
        return this.j;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform(this.a().iterator(), Holder::a);
    }

    @Override
    @Nullable
    public T a(@Nullable MinecraftKey id) {
        Holder.c<T> reference = this.f.get(id);
        return RegistryMaterials.a(reference);
    }

    @Nullable
    private static <T> T a(@Nullable Holder.c<T> entry) {
        return entry != null ? (T)entry.a() : null;
    }

    @Override
    public Set<MinecraftKey> e() {
        return Collections.unmodifiableSet(this.f.keySet());
    }

    @Override
    public Set<ResourceKey<T>> f() {
        return Collections.unmodifiableSet(this.g.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> g() {
        return Collections.unmodifiableSet(Maps.transformValues(this.g, Holder::a).entrySet());
    }

    @Override
    public Stream<Holder.c<T>> h() {
        return this.a().stream();
    }

    @Override
    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> i() {
        return this.k.entrySet().stream().map(entry -> Pair.of((Object)((TagKey)entry.getKey()), (Object)((HolderSet.Named)entry.getValue())));
    }

    @Override
    public HolderSet.Named<T> a(TagKey<T> tag) {
        HolderSet.Named<T> named = this.k.get(tag);
        if (named == null) {
            named = this.d(tag);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.k);
            map.put(tag, named);
            this.k = map;
        }
        return named;
    }

    @Override
    private HolderSet.Named<T> d(TagKey<T> tag) {
        return new HolderSet.Named<T>(this.o(), tag);
    }

    @Override
    public Stream<TagKey<T>> j() {
        return this.k.keySet().stream();
    }

    @Override
    public boolean k() {
        return this.g.isEmpty();
    }

    @Override
    public Optional<Holder.c<T>> a(RandomSource random) {
        return SystemUtils.b(this.a(), random);
    }

    @Override
    public boolean c(MinecraftKey id) {
        return this.f.containsKey(id);
    }

    @Override
    public boolean c(ResourceKey<T> key) {
        return this.g.containsKey(key);
    }

    @Override
    public IRegistry<T> l() {
        if (this.l) {
            return this;
        }
        this.l = true;
        this.h.forEach((? super K value, ? super V entry) -> entry.b(value));
        List<MinecraftKey> list = this.g.entrySet().stream().filter(entry -> !((Holder.c)entry.getValue()).b()).map(entry -> ((ResourceKey)entry.getKey()).a()).sorted().toList();
        if (!list.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + this.c() + ": " + list);
        }
        if (this.m != null) {
            if (!this.m.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not registered: " + this.m.values());
            }
            this.m = null;
        }
        return this;
    }

    @Override
    public Holder.c<T> f(T value) {
        if (this.m == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.v();
        return this.m.computeIfAbsent(value, valuex -> Holder.c.a(this.p(), valuex));
    }

    @Override
    public Optional<HolderSet.Named<T>> b(TagKey<T> tag) {
        return Optional.ofNullable(this.k.get(tag));
    }

    @Override
    public void a(Map<TagKey<T>, List<Holder<T>>> tagEntries) {
        IdentityHashMap<Holder.c, List> map = new IdentityHashMap<Holder.c, List>();
        this.g.values().forEach(entry -> map.put((Holder.c)entry, new ArrayList()));
        tagEntries.forEach((? super K tag, ? super V entries) -> {
            for (Holder holder : entries) {
                if (!holder.a(this.p())) {
                    throw new IllegalStateException("Can't create named set " + tag + " containing value " + holder + " from outside registry " + this);
                }
                if (!(holder instanceof Holder.c)) {
                    throw new IllegalStateException("Found direct holder " + holder + " value in tag " + tag);
                }
                Holder.c reference = (Holder.c)holder;
                ((List)map.get(reference)).add(tag);
            }
        });
        Sets.SetView set = Sets.difference(this.k.keySet(), tagEntries.keySet());
        if (!set.isEmpty()) {
            b.warn("Not all defined tags for registry {} are present in data pack: {}", this.c(), (Object)set.stream().map(tag -> tag.b().toString()).sorted().collect(Collectors.joining(", ")));
        }
        IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map2 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.k);
        tagEntries.forEach((? super K tag, ? super V entries) -> map2.computeIfAbsent((TagKey<T>)tag, this::d).b(entries));
        map.forEach(Holder.c::a);
        this.k = map2;
    }

    @Override
    public void m() {
        this.k.values().forEach(entryList -> entryList.b(List.of()));
        this.g.values().forEach(entry -> entry.a(Set.of()));
    }

    @Override
    public HolderGetter<T> n() {
        this.v();
        return new HolderGetter<T>(){

            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                return Optional.of(this.b(key));
            }

            @Override
            public Holder.c<T> b(ResourceKey<T> key) {
                return RegistryMaterials.this.h(key);
            }

            @Override
            public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
                return Optional.of(this.b(tag));
            }

            @Override
            public HolderSet.Named<T> b(TagKey<T> tag) {
                return RegistryMaterials.this.a(tag);
            }
        };
    }

    @Override
    public HolderOwner<T> o() {
        return this.p;
    }

    @Override
    public HolderLookup.c<T> p() {
        return this.p;
    }
}

