/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.RegistryLayer;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.dimension.DimensionManager;

public class RegistrySynchronization {
    private static final Map<ResourceKey<? extends IRegistry<?>>, a<?>> b = (Map)SystemUtils.a(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        RegistrySynchronization.a(builder, Registries.ap, BiomeBase.b);
        RegistrySynchronization.a(builder, Registries.aq, ChatMessageType.a);
        RegistrySynchronization.a(builder, Registries.aE, TrimPattern.a);
        RegistrySynchronization.a(builder, Registries.aD, TrimMaterial.a);
        RegistrySynchronization.a(builder, Registries.au, DimensionManager.h);
        RegistrySynchronization.a(builder, Registries.p, DamageType.a);
        return builder.build();
    });
    public static final Codec<IRegistryCustom> a = RegistrySynchronization.a();

    private static <E> void a(ImmutableMap.Builder<ResourceKey<? extends IRegistry<?>>, a<?>> builder, ResourceKey<? extends IRegistry<E>> key, Codec<E> networkCodec) {
        builder.put(key, new a<E>(key, networkCodec));
    }

    private static Stream<IRegistryCustom.d<?>> a(IRegistryCustom dynamicRegistryManager) {
        return dynamicRegistryManager.b().filter(entry -> b.containsKey(entry.a()));
    }

    private static <E> DataResult<? extends Codec<E>> a(ResourceKey<? extends IRegistry<E>> registryRef) {
        return Optional.ofNullable(b.get(registryRef)).map(info -> info.b()).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown or not serializable registry: " + registryRef));
    }

    private static <E> Codec<IRegistryCustom> a() {
        Codec codec = MinecraftKey.a.xmap(ResourceKey::a, ResourceKey::a);
        Codec codec2 = codec.partialDispatch("type", registry -> DataResult.success(registry.c()), registryRef -> RegistrySynchronization.a(registryRef).map(codec -> RegistryCodecs.a(registryRef, Lifecycle.experimental(), codec)));
        UnboundedMapCodec unboundedMapCodec = Codec.unboundedMap((Codec)codec, (Codec)codec2);
        return RegistrySynchronization.a(unboundedMapCodec);
    }

    private static <K extends ResourceKey<? extends IRegistry<?>>, V extends IRegistry<?>> Codec<IRegistryCustom> a(UnboundedMapCodec<K, V> networkCodec) {
        return networkCodec.xmap(IRegistryCustom.c::new, registryManager -> (Map)RegistrySynchronization.a(registryManager).collect(ImmutableMap.toImmutableMap(entry -> entry.a(), entry -> entry.b())));
    }

    public static Stream<IRegistryCustom.d<?>> a(LayeredRegistryAccess<RegistryLayer> combinedRegistries) {
        return RegistrySynchronization.a(combinedRegistries.c(RegistryLayer.b));
    }

    public static Stream<IRegistryCustom.d<?>> b(LayeredRegistryAccess<RegistryLayer> combinedRegistries) {
        Stream<IRegistryCustom.d<?>> stream = combinedRegistries.a(RegistryLayer.a).b();
        Stream<IRegistryCustom.d<?>> stream2 = RegistrySynchronization.a(combinedRegistries);
        return Stream.concat(stream2, stream);
    }

    record a<E>(ResourceKey<? extends IRegistry<E>> a, Codec<E> b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "key;networkCodec", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "key;networkCodec", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "key;networkCodec", "a", "b"}, this, object);
        }
    }
}

