/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.advancements.critereon.CriterionConditionEnchantments;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.INamable;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockFlowerPot;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.entries.LootEntryAlternatives;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootSelectorDynamic;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyNBT;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionLimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetContents;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionBlockStateProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionLocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionMatchTool;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionRandomChance;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionSurvivesExplosion;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionTableBonus;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionUser;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public abstract class BlockLootSubProvider
implements LootTableSubProvider {
    protected static final LootItemCondition.a a = LootItemConditionMatchTool.a(CriterionConditionItem.a.a().a(new CriterionConditionEnchantments(Enchantments.v, CriterionConditionValue.IntegerRange.b(1))));
    protected static final LootItemCondition.a b = a.invert();
    protected static final LootItemCondition.a c = LootItemConditionMatchTool.a(CriterionConditionItem.a.a().a(Items.rg));
    private static final LootItemCondition.a h = c.or(a);
    private static final LootItemCondition.a i = h.invert();
    protected final Set<Item> d;
    protected final FeatureFlagSet e;
    protected final Map<MinecraftKey, LootTable.a> f;
    protected static final float[] g = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private static final float[] j = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

    protected BlockLootSubProvider(Set<Item> explosionImmuneItems, FeatureFlagSet requiredFeatures) {
        this(explosionImmuneItems, requiredFeatures, new HashMap<MinecraftKey, LootTable.a>());
    }

    protected BlockLootSubProvider(Set<Item> explosionImmuneItems, FeatureFlagSet requiredFeatures, Map<MinecraftKey, LootTable.a> lootTables) {
        this.d = explosionImmuneItems;
        this.e = requiredFeatures;
        this.f = lootTables;
    }

    protected <T extends LootItemFunctionUser<T>> T a(IMaterial drop, LootItemFunctionUser<T> builder) {
        if (!this.d.contains(drop.k())) {
            return builder.b(LootItemFunctionExplosionDecay.c());
        }
        return builder.c();
    }

    protected <T extends LootItemConditionUser<T>> T a(IMaterial drop, LootItemConditionUser<T> builder) {
        if (!this.d.contains(drop.k())) {
            return builder.b(LootItemConditionSurvivesExplosion.c());
        }
        return builder.d();
    }

    public LootTable.a a(IMaterial drop) {
        return LootTable.b().a(this.a(drop, LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(drop))));
    }

    private static LootTable.a a(Block drop, LootItemCondition.a conditionBuilder, LootEntryAbstract.a<?> child) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(((LootSelectorEntry.a)LootItem.a(drop).a(conditionBuilder)).a(child)));
    }

    protected static LootTable.a a(Block drop, LootEntryAbstract.a<?> child) {
        return BlockLootSubProvider.a(drop, a, child);
    }

    protected static LootTable.a b(Block drop, LootEntryAbstract.a<?> child) {
        return BlockLootSubProvider.a(drop, c, child);
    }

    protected static LootTable.a c(Block drop, LootEntryAbstract.a<?> child) {
        return BlockLootSubProvider.a(drop, h, child);
    }

    protected LootTable.a a(Block dropWithSilkTouch, IMaterial drop) {
        return BlockLootSubProvider.a(dropWithSilkTouch, (LootEntryAbstract.a)this.a((IMaterial)dropWithSilkTouch, LootItem.a(drop)));
    }

    protected LootTable.a a(IMaterial drop, NumberProvider count) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)this.a(drop, (LootItemFunctionUser)LootItem.a(drop).a(LootItemFunctionSetCount.a(count)))));
    }

    protected LootTable.a a(Block dropWithSilkTouch, IMaterial drop, NumberProvider count) {
        return BlockLootSubProvider.a(dropWithSilkTouch, (LootEntryAbstract.a)this.a((IMaterial)dropWithSilkTouch, (LootItemFunctionUser)LootItem.a(drop).a(LootItemFunctionSetCount.a(count))));
    }

    private static LootTable.a c(IMaterial drop) {
        return LootTable.b().a(LootSelector.a().a(a).a(ConstantValue.a(1.0f)).a(LootItem.a(drop)));
    }

    private LootTable.a d(IMaterial drop) {
        return LootTable.b().a(this.a((IMaterial)Blocks.fR, LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(Blocks.fR)))).a(this.a(drop, LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(drop))));
    }

    protected LootTable.a a(Block drop) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)this.a((IMaterial)drop, (LootItemFunctionUser)LootItem.a(drop).a((LootItemFunction.a)LootItemFunctionSetCount.a(ConstantValue.a(2.0f)).a(LootItemConditionBlockStateProperty.a(drop).a(CriterionTriggerProperties.a.a().a(BlockStepAbstract.a, BlockPropertySlabType.c)))))));
    }

    protected <T extends Comparable<T> & INamable> LootTable.a a(Block drop, IBlockState<T> property, T value) {
        return LootTable.b().a(this.a((IMaterial)drop, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)LootItem.a(drop).a(LootItemConditionBlockStateProperty.a(drop).a(CriterionTriggerProperties.a.a().a(property, value))))));
    }

    protected LootTable.a b(Block drop) {
        return LootTable.b().a(this.a((IMaterial)drop, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)LootItem.a(drop).a(LootItemFunctionCopyName.a(LootItemFunctionCopyName.Source.d)))));
    }

    protected LootTable.a c(Block drop) {
        return LootTable.b().a(this.a((IMaterial)drop, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)((LootSelectorEntry.a)LootItem.a(drop).a(LootItemFunctionCopyName.a(LootItemFunctionCopyName.Source.d))).a(LootItemFunctionCopyNBT.a(ContextNbtProvider.a).a("Lock", "BlockEntityTag.Lock").a("LootTable", "BlockEntityTag.LootTable").a("LootTableSeed", "BlockEntityTag.LootTableSeed"))).a(LootItemFunctionSetContents.a(TileEntityTypes.x).a(LootSelectorDynamic.a(BlockShulkerBox.b))))));
    }

    protected LootTable.a d(Block drop) {
        return BlockLootSubProvider.a(drop, (LootEntryAbstract.a)this.a((IMaterial)drop, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(Items.nR).a(LootItemFunctionSetCount.a(UniformGenerator.a(2.0f, 5.0f)))).a(LootItemFunctionApplyBonus.a(Enchantments.x))));
    }

    protected LootTable.a e(Block drop) {
        return BlockLootSubProvider.a(drop, (LootEntryAbstract.a)this.a((IMaterial)drop, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(Items.nM).a(LootItemFunctionSetCount.a(UniformGenerator.a(4.0f, 9.0f)))).a(LootItemFunctionApplyBonus.a(Enchantments.x))));
    }

    protected LootTable.a f(Block drop) {
        return BlockLootSubProvider.a(drop, (LootEntryAbstract.a)this.a((IMaterial)drop, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(Items.ll).a(LootItemFunctionSetCount.a(UniformGenerator.a(4.0f, 5.0f)))).a(LootItemFunctionApplyBonus.b(Enchantments.x))));
    }

    protected LootTable.a g(Block drop) {
        return LootTable.b().a(this.a((IMaterial)drop, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)LootItem.a(drop).a(LootItemFunctionCopyName.a(LootItemFunctionCopyName.Source.d))).a(LootItemFunctionCopyNBT.a(ContextNbtProvider.a).a("Patterns", "BlockEntityTag.Patterns")))));
    }

    protected static LootTable.a h(Block drop) {
        return LootTable.b().a(LootSelector.a().a(a).a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)LootItem.a(drop).a(LootItemFunctionCopyNBT.a(ContextNbtProvider.a).a("Bees", "BlockEntityTag.Bees"))).a(LootItemFunctionCopyState.a(drop).a(BlockBeehive.b))));
    }

    protected static LootTable.a i(Block drop) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(((LootEntryAbstract.a)((LootSelectorEntry.a)((LootSelectorEntry.a)LootItem.a(drop).a(a)).a(LootItemFunctionCopyNBT.a(ContextNbtProvider.a).a("Bees", "BlockEntityTag.Bees"))).a(LootItemFunctionCopyState.a(drop).a(BlockBeehive.b))).a(LootItem.a(drop))));
    }

    protected static LootTable.a j(Block drop) {
        return LootTable.b().a(LootSelector.a().a(LootItem.a(Items.vw)).a(LootItemConditionBlockStateProperty.a(drop).a(CriterionTriggerProperties.a.a().a(CaveVines.s_, true))));
    }

    protected LootTable.a a(Block dropWithSilkTouch, Item drop) {
        return BlockLootSubProvider.a(dropWithSilkTouch, (LootEntryAbstract.a)this.a((IMaterial)dropWithSilkTouch, (LootItemFunctionUser)LootItem.a(drop).a(LootItemFunctionApplyBonus.a(Enchantments.x))));
    }

    protected LootTable.a b(Block dropWithSilkTouch, IMaterial drop) {
        return BlockLootSubProvider.a(dropWithSilkTouch, (LootEntryAbstract.a)this.a((IMaterial)dropWithSilkTouch, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(drop).a(LootItemFunctionSetCount.a(UniformGenerator.a(-6.0f, 2.0f)))).a(LootItemFunctionLimitCount.a(IntRange.b(0)))));
    }

    protected LootTable.a k(Block dropWithShears) {
        return BlockLootSubProvider.b(dropWithShears, (LootEntryAbstract.a)this.a((IMaterial)dropWithShears, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(Items.oH).a(LootItemConditionRandomChance.a(0.125f))).a(LootItemFunctionApplyBonus.a(Enchantments.x, 2))));
    }

    public LootTable.a b(Block stem, Item drop) {
        return LootTable.b().a(this.a((IMaterial)stem, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)LootItem.a(drop).a(BlockStem.b.a(), (E integer) -> LootItemFunctionSetCount.a(BinomialDistributionGenerator.a(3, (float)(integer + 1) / 15.0f)).a(LootItemConditionBlockStateProperty.a(stem).a(CriterionTriggerProperties.a.a().a(BlockStem.b, integer.intValue())))))));
    }

    public LootTable.a c(Block stem, Item drop) {
        return LootTable.b().a(this.a((IMaterial)stem, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)LootItem.a(drop).a(LootItemFunctionSetCount.a(BinomialDistributionGenerator.a(3, 0.53333336f))))));
    }

    protected static LootTable.a b(IMaterial drop) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(c).a(LootItem.a(drop)));
    }

    protected LootTable.a a(Block drop, LootItemCondition.a condition) {
        return LootTable.b().a(LootSelector.a().a((LootEntryAbstract.a)this.a((IMaterial)drop, (LootItemFunctionUser)((LootSelectorEntry.a)((LootSelectorEntry.a)LootItem.a(drop).a(condition)).a(EnumDirection.values(), (E direction) -> LootItemFunctionSetCount.a((NumberProvider)ConstantValue.a(1.0f), true).a(LootItemConditionBlockStateProperty.a(drop).a(CriterionTriggerProperties.a.a().a(MultifaceBlock.b(direction), true))))).a(LootItemFunctionSetCount.a((NumberProvider)ConstantValue.a(-1.0f), true)))));
    }

    protected LootTable.a a(Block leaves, Block drop, float ... chance) {
        return BlockLootSubProvider.c(leaves, ((LootSelectorEntry.a)this.a((IMaterial)leaves, LootItem.a(drop))).a(LootItemConditionTableBonus.a(Enchantments.x, chance))).a(LootSelector.a().a(ConstantValue.a(1.0f)).a(i).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)this.a((IMaterial)leaves, (LootItemFunctionUser)LootItem.a(Items.oB).a(LootItemFunctionSetCount.a(UniformGenerator.a(1.0f, 2.0f))))).a(LootItemConditionTableBonus.a(Enchantments.x, j))));
    }

    protected LootTable.a b(Block leaves, Block drop, float ... chance) {
        return this.a(leaves, drop, chance).a(LootSelector.a().a(ConstantValue.a(1.0f)).a(i).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)this.a((IMaterial)leaves, LootItem.a(Items.nF))).a(LootItemConditionTableBonus.a(Enchantments.x, 0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f))));
    }

    protected LootTable.a l(Block leaves) {
        return BlockLootSubProvider.c(leaves, ((LootSelectorEntry.a)this.a((IMaterial)Blocks.aL, (LootItemFunctionUser)LootItem.a(Items.oB).a(LootItemFunctionSetCount.a(UniformGenerator.a(1.0f, 2.0f))))).a(LootItemConditionTableBonus.a(Enchantments.x, j)));
    }

    protected LootTable.a a(Block crop, Item product, Item seeds, LootItemCondition.a condition) {
        return this.a((IMaterial)crop, LootTable.b().a(LootSelector.a().a(((LootSelectorEntry.a)LootItem.a(product).a(condition)).a(LootItem.a(seeds)))).a(LootSelector.a().a(condition).a((LootEntryAbstract.a<?>)LootItem.a(seeds).a(LootItemFunctionApplyBonus.a(Enchantments.x, 0.5714286f, 3)))));
    }

    protected static LootTable.a m(Block seagrass) {
        return LootTable.b().a(LootSelector.a().a(c).a((LootEntryAbstract.a<?>)LootItem.a(seagrass).a(LootItemFunctionSetCount.a(ConstantValue.a(2.0f)))));
    }

    protected LootTable.a a(Block tallGrass, Block grass) {
        LootEntryAlternatives.a builder = ((LootSelectorEntry.a)((LootEntryAbstract.a)LootItem.a(grass).a(LootItemFunctionSetCount.a(ConstantValue.a(2.0f)))).a(c)).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)this.a((IMaterial)tallGrass, LootItem.a(Items.oH))).a(LootItemConditionRandomChance.a(0.125f)));
        return LootTable.b().a(LootSelector.a().a(builder).a(LootItemConditionBlockStateProperty.a(tallGrass).a(CriterionTriggerProperties.a.a().a(BlockTallPlant.a, BlockPropertyDoubleBlockHalf.b))).a(LootItemConditionLocationCheck.a(CriterionConditionLocation.a.a().a(CriterionConditionBlock.a.a().a(tallGrass).a(CriterionTriggerProperties.a.a().a(BlockTallPlant.a, BlockPropertyDoubleBlockHalf.a))), new BlockPosition(0, 1, 0)))).a(LootSelector.a().a(builder).a(LootItemConditionBlockStateProperty.a(tallGrass).a(CriterionTriggerProperties.a.a().a(BlockTallPlant.a, BlockPropertyDoubleBlockHalf.a))).a(LootItemConditionLocationCheck.a(CriterionConditionLocation.a.a().a(CriterionConditionBlock.a.a().a(tallGrass).a(CriterionTriggerProperties.a.a().a(BlockTallPlant.a, BlockPropertyDoubleBlockHalf.b))), new BlockPosition(0, -1, 0))));
    }

    protected LootTable.a n(Block candle) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)this.a((IMaterial)candle, (LootItemFunctionUser)LootItem.a(candle).a(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), (E candles) -> LootItemFunctionSetCount.a(ConstantValue.a(candles.intValue())).a(LootItemConditionBlockStateProperty.a(candle).a(CriterionTriggerProperties.a.a().a(CandleBlock.e, candles.intValue())))))));
    }

    protected LootTable.a o(Block flowerbed) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)this.a((IMaterial)flowerbed, (LootItemFunctionUser)LootItem.a(flowerbed).a(IntStream.rangeClosed(1, 4).boxed().toList(), (E flowerAmount) -> LootItemFunctionSetCount.a(ConstantValue.a(flowerAmount.intValue())).a(LootItemConditionBlockStateProperty.a(flowerbed).a(CriterionTriggerProperties.a.a().a(PinkPetalsBlock.d, flowerAmount.intValue())))))));
    }

    protected static LootTable.a p(Block candleCake) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(candleCake)));
    }

    public static LootTable.a a() {
        return LootTable.b();
    }

    protected abstract void b();

    @Override
    @Override
    public void generate(BiConsumer<MinecraftKey, LootTable.a> exporter) {
        this.b();
        HashSet<MinecraftKey> set = new HashSet<MinecraftKey>();
        for (Block block : BuiltInRegistries.f) {
            MinecraftKey resourceLocation;
            if (!block.a(this.e) || (resourceLocation = block.r()) == LootTables.a || !set.add(resourceLocation)) continue;
            LootTable.a builder = this.f.remove(resourceLocation);
            if (builder == null) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", resourceLocation, BuiltInRegistries.f.b(block)));
            }
            exporter.accept(resourceLocation, builder);
        }
        if (!this.f.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + this.f.keySet());
        }
    }

    protected void b(Block block, Block drop) {
        LootTable.a builder = BlockLootSubProvider.c(block, LootItem.a(block).a(LootItemConditionTableBonus.a(Enchantments.x, 0.33f, 0.55f, 0.77f, 1.0f)));
        this.a(block, builder);
        this.a(drop, builder);
    }

    protected LootTable.a q(Block block) {
        return this.a(block, BlockDoor.e, BlockPropertyDoubleBlockHalf.b);
    }

    protected void r(Block block) {
        this.a(block, (Block flowerPot) -> this.d((IMaterial)((BlockFlowerPot)flowerPot).a()));
    }

    protected void c(Block block, Block drop) {
        this.a(block, BlockLootSubProvider.c(drop));
    }

    protected void c(Block block, IMaterial drop) {
        this.a(block, this.a(drop));
    }

    protected void s(Block block) {
        this.c(block, block);
    }

    protected void t(Block block) {
        this.c(block, (IMaterial)block);
    }

    protected void a(Block block, Function<Block, LootTable.a> lootTableFunction) {
        this.a(block, lootTableFunction.apply(block));
    }

    protected void a(Block block, LootTable.a lootTable) {
        this.f.put(block.r(), lootTable);
    }
}

