/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import net.minecraft.MinecraftVersion;
import net.minecraft.SharedConstants;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.DispenserRegistry;

public class SnbtDatafixer {
    public static void a(String[] args) throws IOException {
        SharedConstants.a(MinecraftVersion.a);
        DispenserRegistry.a();
        for (String string : args) {
            SnbtDatafixer.a(string);
        }
    }

    private static void a(String directory) throws IOException {
        try (Stream<Path> stream = Files.walk(Paths.get(directory, new String[0]), new FileVisitOption[0]);){
            stream.filter(path -> path.toString().endsWith(".snbt")).forEach(path -> {
                try {
                    String string = Files.readString(path);
                    NBTTagCompound compoundTag = GameProfileSerializer.a(string);
                    NBTTagCompound compoundTag2 = StructureUpdater.a(path.toString(), compoundTag);
                    DebugReportNBT.a(CachedOutput.a, path, GameProfileSerializer.c(compoundTag2));
                }
                catch (CommandSyntaxException | IOException exception) {
                    throw new RuntimeException(exception);
                }
            });
        }
    }
}

