/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.locale;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.FormattedString;
import net.minecraft.util.StringDecomposer;
import org.slf4j.Logger;

public abstract class LocaleLanguage {
    private static final Logger b = LogUtils.getLogger();
    private static final Gson c = new Gson();
    private static final Pattern d = Pattern.compile("%(\\d+\\$)?[\\d.]*[df]");
    public static final String a = "en_us";
    private static volatile LocaleLanguage e = LocaleLanguage.c();

    public static void loadI18N(String lang) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BiConsumer<String, String> biConsumer = (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1);
        LocaleLanguage.a(biConsumer, "/assets/minecraft/lang/" + lang + ".json");
        ImmutableMap map = builder.build();
        LocaleLanguage language = new LocaleLanguage((Map)map){
            final /* synthetic */ Map val$map;
            {
                this.val$map = map;
            }

            @Override
            public String a(String key, String fallback) {
                return this.val$map.getOrDefault(key, fallback);
            }

            @Override
            public boolean b(String key) {
                return this.val$map.containsKey(key);
            }

            @Override
            public boolean b() {
                return false;
            }

            @Override
            public FormattedString a(IChatFormatted text) {
                return visitor -> text.a((ChatModifier style, String string) -> StringDecomposer.c(string, style, visitor) ? Optional.empty() : IChatFormatted.a, ChatModifier.a).isPresent();
            }
        };
        LocaleLanguage.a(language);
    }

    private static LocaleLanguage c() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BiConsumer<String, String> biConsumer = (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1);
        LocaleLanguage.a(biConsumer, "/assets/minecraft/lang/en_us.json");
        ImmutableMap map = builder.build();
        return new LocaleLanguage((Map)map){
            final /* synthetic */ Map val$map;
            {
                this.val$map = map;
            }

            @Override
            public String a(String key, String fallback) {
                return this.val$map.getOrDefault(key, fallback);
            }

            @Override
            public boolean b(String key) {
                return this.val$map.containsKey(key);
            }

            @Override
            public boolean b() {
                return false;
            }

            @Override
            public FormattedString a(IChatFormatted text) {
                return visitor -> text.a((ChatModifier style, String string) -> StringDecomposer.c(string, style, visitor) ? Optional.empty() : IChatFormatted.a, ChatModifier.a).isPresent();
            }
        };
    }

    private static void a(BiConsumer<String, String> entryConsumer, String path) {
        try (InputStream inputStream = LocaleLanguage.class.getResourceAsStream(path);){
            LocaleLanguage.a(inputStream, entryConsumer);
        }
        catch (JsonParseException | IOException var7) {
            b.error("Couldn't read strings from {}", (Object)path, (Object)var7);
        }
    }

    public static void a(InputStream inputStream, BiConsumer<String, String> entryConsumer) {
        JsonObject jsonObject = (JsonObject)c.fromJson((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), JsonObject.class);
        for (Map.Entry entry : jsonObject.entrySet()) {
            String string = d.matcher(ChatDeserializer.a((JsonElement)entry.getValue(), (String)entry.getKey())).replaceAll("%$1s");
            entryConsumer.accept((String)entry.getKey(), string);
        }
    }

    public static LocaleLanguage a() {
        return e;
    }

    public static void a(LocaleLanguage language) {
        e = language;
    }

    public String a(String key) {
        return this.a(key, key);
    }

    public abstract String a(String var1, String var2);

    public abstract boolean b(String var1);

    public abstract boolean b();

    public abstract FormattedString a(IChatFormatted var1);

    public List<FormattedString> a(List<IChatFormatted> texts) {
        return (List)texts.stream().map(this::a).collect(ImmutableList.toImmutableList());
    }
}

