/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.FastBufferedInputStream;
import org.spigotmc.LimitStream;

public class NBTCompressedStreamTools {
    public static NBTTagCompound a(File file) throws IOException {
        NBTTagCompound nbttagcompound;
        try (FileInputStream fileinputstream = new FileInputStream(file);){
            nbttagcompound = NBTCompressedStreamTools.a(fileinputstream);
        }
        return nbttagcompound;
    }

    private static DataInputStream b(InputStream stream) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(stream)));
    }

    public static NBTTagCompound a(InputStream stream) throws IOException {
        NBTTagCompound nbttagcompound;
        try (DataInputStream datainputstream = NBTCompressedStreamTools.b(stream);){
            nbttagcompound = NBTCompressedStreamTools.a(datainputstream, NBTReadLimiter.a());
        }
        return nbttagcompound;
    }

    public static void a(File file, StreamTagVisitor scanner, NBTReadLimiter tracker) throws IOException {
        try (FileInputStream fileinputstream = new FileInputStream(file);){
            NBTCompressedStreamTools.a(fileinputstream, scanner, tracker);
        }
    }

    public static void a(InputStream stream, StreamTagVisitor scanner, NBTReadLimiter tracker) throws IOException {
        try (DataInputStream datainputstream = NBTCompressedStreamTools.b(stream);){
            NBTCompressedStreamTools.a((DataInput)datainputstream, scanner, tracker);
        }
    }

    public static void a(NBTTagCompound nbt, File file) throws IOException {
        try (FileOutputStream fileoutputstream = new FileOutputStream(file);){
            NBTCompressedStreamTools.a(nbt, fileoutputstream);
        }
    }

    public static void a(NBTTagCompound nbt, OutputStream stream) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(stream)));){
            NBTCompressedStreamTools.a(nbt, (DataOutput)dataoutputstream);
        }
    }

    public static void b(NBTTagCompound nbt, File file) throws IOException {
        try (FileOutputStream fileoutputstream = new FileOutputStream(file);
             DataOutputStream dataoutputstream = new DataOutputStream(fileoutputstream);){
            NBTCompressedStreamTools.a(nbt, (DataOutput)dataoutputstream);
        }
    }

    @Nullable
    public static NBTTagCompound b(File file) throws IOException {
        NBTTagCompound nbttagcompound;
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream fileinputstream = new FileInputStream(file);
             DataInputStream datainputstream = new DataInputStream(fileinputstream);){
            nbttagcompound = NBTCompressedStreamTools.a(datainputstream, NBTReadLimiter.a());
        }
        return nbttagcompound;
    }

    public static NBTTagCompound a(DataInput input) throws IOException {
        return NBTCompressedStreamTools.a(input, NBTReadLimiter.a());
    }

    public static NBTTagCompound a(DataInput input, NBTReadLimiter tracker) throws IOException {
        NBTBase nbtbase;
        if (input instanceof ByteBufInputStream) {
            input = new DataInputStream(new LimitStream((InputStream)((Object)input), tracker));
        }
        if ((nbtbase = NBTCompressedStreamTools.c(input, tracker)) instanceof NBTTagCompound) {
            return (NBTTagCompound)nbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void a(NBTTagCompound nbt, DataOutput output) throws IOException {
        NBTCompressedStreamTools.b((NBTBase)nbt, output);
    }

    public static void a(DataInput input, StreamTagVisitor scanner, NBTReadLimiter tracker) throws IOException {
        NBTTagType<?> nbttagtype = NBTTagTypes.a(input.readByte());
        if (nbttagtype == NBTTagEnd.a) {
            if (scanner.b(NBTTagEnd.a) == StreamTagVisitor.b.a) {
                scanner.a();
            }
        } else {
            switch (scanner.b(nbttagtype)) {
                default: {
                    break;
                }
                case b: {
                    NBTTagString.a(input);
                    nbttagtype.b(input, tracker);
                    break;
                }
                case a: {
                    NBTTagString.a(input);
                    nbttagtype.a(input, scanner, tracker);
                }
            }
        }
    }

    public static NBTBase b(DataInput input, NBTReadLimiter tracker) throws IOException {
        byte b0 = input.readByte();
        return b0 == 0 ? NBTTagEnd.b : NBTCompressedStreamTools.a(input, tracker, b0);
    }

    public static void a(NBTBase nbt, DataOutput output) throws IOException {
        output.writeByte(nbt.b());
        if (nbt.b() != 0) {
            nbt.a(output);
        }
    }

    public static void b(NBTBase nbt, DataOutput output) throws IOException {
        output.writeByte(nbt.b());
        if (nbt.b() != 0) {
            output.writeUTF("");
            nbt.a(output);
        }
    }

    private static NBTBase c(DataInput input, NBTReadLimiter tracker) throws IOException {
        byte b0 = input.readByte();
        if (b0 == 0) {
            return NBTTagEnd.b;
        }
        NBTTagString.a(input);
        return NBTCompressedStreamTools.a(input, tracker, b0);
    }

    private static NBTBase a(DataInput input, NBTReadLimiter tracker, byte typeId) {
        try {
            return NBTTagTypes.a(typeId).c(input, tracker);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.a(ioexception, "Loading NBT data");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("NBT Tag");
            crashreportsystemdetails.a("Tag type", typeId);
            throw new ReportedException(crashreport);
        }
    }
}

