/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.zip.Deflater;
import net.minecraft.network.VarInt;

public class PacketCompressor
extends MessageToByteEncoder<ByteBuf> {
    private final byte[] a;
    private final Deflater b;
    private final VelocityCompressor compressor;
    private int c;

    public PacketCompressor(int compressionThreshold) {
        this(null, compressionThreshold);
    }

    public PacketCompressor(VelocityCompressor compressor, int compressionThreshold) {
        this.c = compressionThreshold;
        if (compressor == null) {
            this.a = new byte[8192];
            this.b = new Deflater();
        } else {
            this.a = null;
            this.b = null;
        }
        this.compressor = compressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) throws Exception {
        int i2 = byteBuf.readableBytes();
        if (i2 < this.c) {
            VarInt.a(byteBuf2, 0);
            byteBuf2.writeBytes(byteBuf);
        } else {
            if (this.b != null) {
                byte[] bs = new byte[i2];
                byteBuf.readBytes(bs);
                VarInt.a(byteBuf2, bs.length);
                this.b.setInput(bs, 0, i2);
                this.b.finish();
                while (!this.b.finished()) {
                    int j2 = this.b.deflate(this.a);
                    byteBuf2.writeBytes(this.a, 0, j2);
                }
                this.b.reset();
                return;
            }
            VarInt.a(byteBuf2, i2);
            ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)channelHandlerContext.alloc(), (Native)this.compressor, (ByteBuf)byteBuf);
            try {
                this.compressor.deflate(compatibleIn, byteBuf2);
            }
            finally {
                compatibleIn.release();
            }
        }
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
        if (this.compressor != null) {
            int initialBufferSize = msg.readableBytes() + 1;
            return MoreByteBufUtils.preferredBuffer((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (int)initialBufferSize);
        }
        return super.allocateBuffer(ctx, (Object)msg, preferDirect);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.compressor != null) {
            this.compressor.close();
        }
    }

    public int a() {
        return this.c;
    }

    public void a(int compressionThreshold) {
        this.c = compressionThreshold;
    }
}

