/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketDecoder
extends ByteToMessageDecoder
implements ProtocolSwapHandler {
    private static final Logger a = LogUtils.getLogger();
    private final AttributeKey<EnumProtocol.a<?>> b;

    public PacketDecoder(AttributeKey<EnumProtocol.a<?>> protocolKey) {
        this.b = protocolKey;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        PacketDataSerializer friendlyByteBuf;
        int j2;
        int i2 = byteBuf.readableBytes();
        if (i2 == 0) {
            return;
        }
        Attribute attribute = channelHandlerContext.channel().attr(this.b);
        EnumProtocol.a codecData = (EnumProtocol.a)attribute.get();
        Packet<?> packet = codecData.a(j2 = (friendlyByteBuf = new PacketDataSerializer(byteBuf)).m(), friendlyByteBuf);
        if (packet == null) {
            throw new IOException("Bad packet id " + j2);
        }
        JvmProfiler.e.a(codecData.a(), j2, channelHandlerContext.channel().remoteAddress(), i2);
        if (friendlyByteBuf.readableBytes() > 0) {
            throw new IOException("Packet " + codecData.a().a() + "/" + j2 + " (" + packet.getClass().getSimpleName() + ") was larger than I expected, found " + friendlyByteBuf.readableBytes() + " bytes extra whilst reading packet " + j2);
        }
        list.add(packet);
        if (a.isDebugEnabled()) {
            a.debug(NetworkManager.c, " IN: [{}:{}] {}", new Object[]{codecData.a().a(), j2, packet.getClass().getName()});
        }
        ProtocolSwapHandler.a(attribute, packet);
    }
}

