/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.util.ObfHelper;
import java.io.IOException;
import java.util.Locale;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketEncoder
extends MessageToByteEncoder<Packet<?>> {
    private static final Logger a = LogUtils.getLogger();
    private final AttributeKey<EnumProtocol.a<?>> b;
    private static int MAX_PACKET_SIZE = 0x800000;

    public PacketEncoder(AttributeKey<EnumProtocol.a<?>> protocolKey) {
        this.b = protocolKey;
    }

    protected void a(ChannelHandlerContext channelHandlerContext, Packet<?> packet, ByteBuf byteBuf) throws Exception {
        Attribute attribute = channelHandlerContext.channel().attr(this.b);
        EnumProtocol.a codecData = (EnumProtocol.a)attribute.get();
        if (codecData == null) {
            throw new RuntimeException("ConnectionProtocol unknown: " + packet);
        }
        int i2 = codecData.a(packet);
        if (a.isDebugEnabled()) {
            a.debug(NetworkManager.d, "OUT: [{}:{}] {}", new Object[]{codecData.a().a(), i2, packet.getClass().getName()});
        }
        if (i2 == -1) {
            throw new IOException("Can't serialize unregistered packet");
        }
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(byteBuf);
        friendlyByteBuf.c(i2);
        friendlyByteBuf.adventure$locale = (Locale)channelHandlerContext.channel().attr(PaperAdventure.LOCALE_ATTRIBUTE).get();
        try {
            int j2 = friendlyByteBuf.writerIndex();
            packet.a(friendlyByteBuf);
            int k2 = friendlyByteBuf.writerIndex() - j2;
            JvmProfiler.e.b(codecData.a(), i2, channelHandlerContext.channel().remoteAddress(), k2);
        }
        catch (Throwable var13) {
            String packetName = ObfHelper.INSTANCE.deobfClassName(packet.getClass().getName());
            if (packetName.contains(".")) {
                packetName = packetName.substring(packetName.lastIndexOf(".") + 1);
            }
            a.error("Packet encoding of packet {} (ID: {}) threw (skippable? {})", new Object[]{packetName, i2, packet.b(), var13});
            if (packet.b()) {
                throw new SkipEncodeException(var13);
            }
            throw var13;
        }
        finally {
            int packetLength = friendlyByteBuf.readableBytes();
            if (packetLength > MAX_PACKET_SIZE) {
                throw new PacketTooLargeException(packet, this.b, packetLength);
            }
            ProtocolSwapHandler.a(attribute, packet);
        }
    }

    public static class PacketTooLargeException
    extends RuntimeException {
        private final Packet<?> packet;
        public final AttributeKey<EnumProtocol.a<?>> codecKey;

        PacketTooLargeException(Packet<?> packet, AttributeKey<EnumProtocol.a<?>> codecKey, int packetLength) {
            super("PacketTooLarge - " + packet.getClass().getSimpleName() + " is " + packetLength + ". Max is " + MAX_PACKET_SIZE);
            this.packet = packet;
            this.codecKey = codecKey;
        }

        public Packet<?> getPacket() {
            return this.packet;
        }
    }
}

