/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatDecoration;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;

public final class ChatMessageType
extends Record {
    private final ChatDecoration j;
    private final ChatDecoration k;
    public static final Codec<ChatMessageType> a = RecordCodecBuilder.create(instance -> instance.group((App)ChatDecoration.a.fieldOf("chat").forGetter(ChatMessageType::a), (App)ChatDecoration.a.fieldOf("narration").forGetter(ChatMessageType::b)).apply((Applicative)instance, ChatMessageType::new));
    public static final ChatDecoration b = ChatDecoration.a("chat.type.text");
    public static final ResourceKey<ChatMessageType> c = ChatMessageType.a("chat");
    public static final ResourceKey<ChatMessageType> d = ChatMessageType.a("say_command");
    public static final ResourceKey<ChatMessageType> e = ChatMessageType.a("msg_command_incoming");
    public static final ResourceKey<ChatMessageType> f = ChatMessageType.a("msg_command_outgoing");
    public static final ResourceKey<ChatMessageType> g = ChatMessageType.a("team_msg_command_incoming");
    public static final ResourceKey<ChatMessageType> h = ChatMessageType.a("team_msg_command_outgoing");
    public static final ResourceKey<ChatMessageType> i = ChatMessageType.a("emote_command");

    public ChatMessageType(ChatDecoration chatTypeDecoration, ChatDecoration chatTypeDecoration2) {
        this.j = chatTypeDecoration;
        this.k = chatTypeDecoration2;
    }

    private static ResourceKey<ChatMessageType> a(String id) {
        return ResourceKey.a(Registries.aq, new MinecraftKey(id));
    }

    public static void a(BootstapContext<ChatMessageType> messageTypeRegisterable) {
        messageTypeRegisterable.a(c, new ChatMessageType(b, ChatDecoration.a("chat.type.text.narrate")));
        messageTypeRegisterable.a(d, new ChatMessageType(ChatDecoration.a("chat.type.announcement"), ChatDecoration.a("chat.type.text.narrate")));
        messageTypeRegisterable.a(e, new ChatMessageType(ChatDecoration.b("commands.message.display.incoming"), ChatDecoration.a("chat.type.text.narrate")));
        messageTypeRegisterable.a(f, new ChatMessageType(ChatDecoration.c("commands.message.display.outgoing"), ChatDecoration.a("chat.type.text.narrate")));
        messageTypeRegisterable.a(g, new ChatMessageType(ChatDecoration.d("chat.type.team.text"), ChatDecoration.a("chat.type.text.narrate")));
        messageTypeRegisterable.a(h, new ChatMessageType(ChatDecoration.d("chat.type.team.sent"), ChatDecoration.a("chat.type.text.narrate")));
        messageTypeRegisterable.a(i, new ChatMessageType(ChatDecoration.a("chat.type.emote"), ChatDecoration.a("chat.type.emote")));
    }

    public static a a(ResourceKey<ChatMessageType> typeKey, Entity entity) {
        return ChatMessageType.a(typeKey, entity.dL().G_(), entity.N_());
    }

    public static a a(ResourceKey<ChatMessageType> typeKey, CommandListenerWrapper source) {
        return ChatMessageType.a(typeKey, source.v(), source.b());
    }

    public static a a(ResourceKey<ChatMessageType> typeKey, IRegistryCustom registryManager, IChatBaseComponent name) {
        IRegistry<ChatMessageType> registry = registryManager.d(Registries.aq);
        return registry.e(typeKey).a(name);
    }

    public a a(IChatBaseComponent name) {
        return new a(this, name);
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ChatMessageType.class, "chat;narration", "j", "k"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ChatMessageType.class, "chat;narration", "j", "k"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ChatMessageType.class, "chat;narration", "j", "k"}, this, object);
    }

    public ChatDecoration a() {
        return this.j;
    }

    public ChatDecoration b() {
        return this.k;
    }

    public record a(ChatMessageType a, IChatBaseComponent b, @Nullable IChatBaseComponent c) {
        a(ChatMessageType type, IChatBaseComponent name) {
            this(type, name, null);
        }

        public IChatBaseComponent a(IChatBaseComponent content) {
            return this.a.a().a(content, this);
        }

        public IChatBaseComponent b(IChatBaseComponent content) {
            return this.a.b().a(content, this);
        }

        public a c(IChatBaseComponent targetName) {
            return new a(this.a, this.b, targetName);
        }

        public b a(IRegistryCustom registryManager) {
            IRegistry<ChatMessageType> registry = registryManager.d(Registries.aq);
            return new b(registry.a(this.a), this.b, this.c);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "chatType;name;targetName", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "chatType;name;targetName", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "chatType;name;targetName", "a", "b", "c"}, this, object);
        }
    }

    public record b(int a, IChatBaseComponent b, @Nullable IChatBaseComponent c) {
        public b(PacketDataSerializer buf) {
            this(buf.m(), buf.l(), (IChatBaseComponent)buf.c(PacketDataSerializer::l));
        }

        public void a(PacketDataSerializer buf) {
            buf.c(this.a);
            buf.a(this.b);
            buf.a(this.c, PacketDataSerializer::a);
        }

        public Optional<a> a(IRegistryCustom registryManager) {
            IRegistry<ChatMessageType> registry = registryManager.d(Registries.aq);
            ChatMessageType chatType = (ChatMessageType)registry.a(this.a);
            return Optional.ofNullable(chatType).map(type -> new a((ChatMessageType)type, this.b, this.c));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "chatType;name;targetName", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "chatType;name;targetName", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "chatType;name;targetName", "a", "b", "c"}, this, object);
        }
    }
}

