/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHexColor;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;

public class ChatModifier {
    public static final ChatModifier a = new ChatModifier(null, null, null, null, null, null, null, null, null, null);
    public static final Codec<ChatModifier> b = RecordCodecBuilder.create(instance -> instance.group((App)ChatHexColor.a.optionalFieldOf("color").forGetter(style -> Optional.ofNullable(style.d)), (App)Codec.BOOL.optionalFieldOf("bold").forGetter(style -> Optional.ofNullable(style.e)), (App)Codec.BOOL.optionalFieldOf("italic").forGetter(style -> Optional.ofNullable(style.f)), (App)Codec.BOOL.optionalFieldOf("underlined").forGetter(style -> Optional.ofNullable(style.g)), (App)Codec.BOOL.optionalFieldOf("strikethrough").forGetter(style -> Optional.ofNullable(style.h)), (App)Codec.BOOL.optionalFieldOf("obfuscated").forGetter(style -> Optional.ofNullable(style.i)), (App)Codec.STRING.optionalFieldOf("insertion").forGetter(style -> Optional.ofNullable(style.l)), (App)MinecraftKey.a.optionalFieldOf("font").forGetter(style -> Optional.ofNullable(style.m))).apply((Applicative)instance, ChatModifier::a));
    public static final MinecraftKey c = new MinecraftKey("minecraft", "default");
    @Nullable
    final ChatHexColor d;
    @Nullable
    final Boolean e;
    @Nullable
    final Boolean f;
    @Nullable
    final Boolean g;
    @Nullable
    final Boolean h;
    @Nullable
    final Boolean i;
    @Nullable
    final ChatClickable j;
    @Nullable
    final ChatHoverable k;
    @Nullable
    final String l;
    @Nullable
    final MinecraftKey m;

    private static ChatModifier a(Optional<ChatHexColor> color, Optional<Boolean> bold, Optional<Boolean> italic, Optional<Boolean> underlined, Optional<Boolean> strikethrough, Optional<Boolean> obfuscated, Optional<String> insertion, Optional<MinecraftKey> font) {
        return new ChatModifier(color.orElse(null), bold.orElse(null), italic.orElse(null), underlined.orElse(null), strikethrough.orElse(null), obfuscated.orElse(null), null, null, insertion.orElse(null), font.orElse(null));
    }

    ChatModifier(@Nullable ChatHexColor color, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underlined, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated, @Nullable ChatClickable clickEvent, @Nullable ChatHoverable hoverEvent, @Nullable String insertion, @Nullable MinecraftKey font) {
        this.d = color;
        this.e = bold;
        this.f = italic;
        this.g = underlined;
        this.h = strikethrough;
        this.i = obfuscated;
        this.j = clickEvent;
        this.k = hoverEvent;
        this.l = insertion;
        this.m = font;
    }

    @Nullable
    public ChatHexColor a() {
        return this.d;
    }

    public boolean b() {
        return this.e == Boolean.TRUE;
    }

    public boolean c() {
        return this.f == Boolean.TRUE;
    }

    public boolean d() {
        return this.h == Boolean.TRUE;
    }

    public boolean e() {
        return this.g == Boolean.TRUE;
    }

    public boolean f() {
        return this.i == Boolean.TRUE;
    }

    public boolean g() {
        return this == a;
    }

    @Nullable
    public ChatClickable h() {
        return this.j;
    }

    @Nullable
    public ChatHoverable i() {
        return this.k;
    }

    @Nullable
    public String j() {
        return this.l;
    }

    public MinecraftKey k() {
        return this.m != null ? this.m : c;
    }

    public ChatModifier a(@Nullable ChatHexColor color) {
        return new ChatModifier(color, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l, this.m);
    }

    public ChatModifier a(@Nullable EnumChatFormat color) {
        return this.a(color != null ? ChatHexColor.a(color) : null);
    }

    public ChatModifier a(int rgbColor) {
        return this.a(ChatHexColor.a(rgbColor));
    }

    public ChatModifier a(@Nullable Boolean bold) {
        return new ChatModifier(this.d, bold, this.f, this.g, this.h, this.i, this.j, this.k, this.l, this.m);
    }

    public ChatModifier b(@Nullable Boolean italic) {
        return new ChatModifier(this.d, this.e, italic, this.g, this.h, this.i, this.j, this.k, this.l, this.m);
    }

    public ChatModifier c(@Nullable Boolean underline) {
        return new ChatModifier(this.d, this.e, this.f, underline, this.h, this.i, this.j, this.k, this.l, this.m);
    }

    public ChatModifier d(@Nullable Boolean strikethrough) {
        return new ChatModifier(this.d, this.e, this.f, this.g, strikethrough, this.i, this.j, this.k, this.l, this.m);
    }

    public ChatModifier e(@Nullable Boolean obfuscated) {
        return new ChatModifier(this.d, this.e, this.f, this.g, this.h, obfuscated, this.j, this.k, this.l, this.m);
    }

    public ChatModifier a(@Nullable ChatClickable clickEvent) {
        return new ChatModifier(this.d, this.e, this.f, this.g, this.h, this.i, clickEvent, this.k, this.l, this.m);
    }

    public ChatModifier a(@Nullable ChatHoverable hoverEvent) {
        return new ChatModifier(this.d, this.e, this.f, this.g, this.h, this.i, this.j, hoverEvent, this.l, this.m);
    }

    public ChatModifier a(@Nullable String insertion) {
        return new ChatModifier(this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, insertion, this.m);
    }

    public ChatModifier a(@Nullable MinecraftKey font) {
        return new ChatModifier(this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l, font);
    }

    public ChatModifier b(EnumChatFormat formatting) {
        ChatHexColor textColor = this.d;
        Boolean boolean_ = this.e;
        Boolean boolean2 = this.f;
        Boolean boolean3 = this.h;
        Boolean boolean4 = this.g;
        Boolean boolean5 = this.i;
        switch (formatting) {
            case q: {
                boolean5 = true;
                break;
            }
            case r: {
                boolean_ = true;
                break;
            }
            case s: {
                boolean3 = true;
                break;
            }
            case t: {
                boolean4 = true;
                break;
            }
            case u: {
                boolean2 = true;
                break;
            }
            case v: {
                return a;
            }
            default: {
                textColor = ChatHexColor.a(formatting);
            }
        }
        return new ChatModifier(textColor, boolean_, boolean2, boolean4, boolean3, boolean5, this.j, this.k, this.l, this.m);
    }

    public ChatModifier c(EnumChatFormat formatting) {
        ChatHexColor textColor = this.d;
        Boolean boolean_ = this.e;
        Boolean boolean2 = this.f;
        Boolean boolean3 = this.h;
        Boolean boolean4 = this.g;
        Boolean boolean5 = this.i;
        switch (formatting) {
            case q: {
                boolean5 = true;
                break;
            }
            case r: {
                boolean_ = true;
                break;
            }
            case s: {
                boolean3 = true;
                break;
            }
            case t: {
                boolean4 = true;
                break;
            }
            case u: {
                boolean2 = true;
                break;
            }
            case v: {
                return a;
            }
            default: {
                boolean5 = false;
                boolean_ = false;
                boolean3 = false;
                boolean4 = false;
                boolean2 = false;
                textColor = ChatHexColor.a(formatting);
            }
        }
        return new ChatModifier(textColor, boolean_, boolean2, boolean4, boolean3, boolean5, this.j, this.k, this.l, this.m);
    }

    public ChatModifier a(EnumChatFormat ... formattings) {
        ChatHexColor textColor = this.d;
        Boolean boolean_ = this.e;
        Boolean boolean2 = this.f;
        Boolean boolean3 = this.h;
        Boolean boolean4 = this.g;
        Boolean boolean5 = this.i;
        block8: for (EnumChatFormat chatFormatting : formattings) {
            switch (chatFormatting) {
                case q: {
                    boolean5 = true;
                    continue block8;
                }
                case r: {
                    boolean_ = true;
                    continue block8;
                }
                case s: {
                    boolean3 = true;
                    continue block8;
                }
                case t: {
                    boolean4 = true;
                    continue block8;
                }
                case u: {
                    boolean2 = true;
                    continue block8;
                }
                case v: {
                    return a;
                }
                default: {
                    textColor = ChatHexColor.a(chatFormatting);
                }
            }
        }
        return new ChatModifier(textColor, boolean_, boolean2, boolean4, boolean3, boolean5, this.j, this.k, this.l, this.m);
    }

    public ChatModifier a(ChatModifier parent) {
        if (this == a) {
            return parent;
        }
        if (parent == a) {
            return this;
        }
        return new ChatModifier(this.d != null ? this.d : parent.d, this.e != null ? this.e : parent.e, this.f != null ? this.f : parent.f, this.g != null ? this.g : parent.g, this.h != null ? this.h : parent.h, this.i != null ? this.i : parent.i, this.j != null ? this.j : parent.j, this.k != null ? this.k : parent.k, this.l != null ? this.l : parent.l, this.m != null ? this.m : parent.m);
    }

    @Override
    public String toString() {
        final StringBuilder stringBuilder = new StringBuilder("{");
        class A {
            private boolean c;

            A() {
            }

            private void a() {
                if (this.c) {
                    stringBuilder.append(',');
                }
                this.c = true;
            }

            void a(String key, @Nullable Boolean value) {
                if (value != null) {
                    this.a();
                    if (!value.booleanValue()) {
                        stringBuilder.append('!');
                    }
                    stringBuilder.append(key);
                }
            }

            void a(String key, @Nullable Object value) {
                if (value != null) {
                    this.a();
                    stringBuilder.append(key);
                    stringBuilder.append('=');
                    stringBuilder.append(value);
                }
            }
        }
        A lv = new A();
        lv.a("color", this.d);
        lv.a("bold", this.e);
        lv.a("italic", this.f);
        lv.a("underlined", this.g);
        lv.a("strikethrough", this.h);
        lv.a("obfuscated", this.i);
        lv.a("clickEvent", this.j);
        lv.a("hoverEvent", this.k);
        lv.a("insertion", this.l);
        lv.a("font", this.m);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChatModifier) {
            ChatModifier style = (ChatModifier)object;
            return this.b() == style.b() && Objects.equals(this.a(), style.a()) && this.c() == style.c() && this.f() == style.f() && this.d() == style.d() && this.e() == style.e() && Objects.equals(this.h(), style.h()) && Objects.equals(this.i(), style.i()) && Objects.equals(this.j(), style.j()) && Objects.equals(this.k(), style.k());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l);
    }

    public static class ChatModifierSerializer
    implements JsonDeserializer<ChatModifier>,
    JsonSerializer<ChatModifier> {
        @Nullable
        @Override
        public ChatModifier a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (jsonObject == null) {
                    return null;
                }
                Boolean boolean_ = ChatModifierSerializer.a(jsonObject, "bold");
                Boolean boolean2 = ChatModifierSerializer.a(jsonObject, "italic");
                Boolean boolean3 = ChatModifierSerializer.a(jsonObject, "underlined");
                Boolean boolean4 = ChatModifierSerializer.a(jsonObject, "strikethrough");
                Boolean boolean5 = ChatModifierSerializer.a(jsonObject, "obfuscated");
                ChatHexColor textColor = ChatModifierSerializer.e(jsonObject);
                String string = ChatModifierSerializer.d(jsonObject);
                ChatClickable clickEvent = ChatModifierSerializer.c(jsonObject);
                ChatHoverable hoverEvent = ChatModifierSerializer.b(jsonObject);
                MinecraftKey resourceLocation = ChatModifierSerializer.a(jsonObject);
                return new ChatModifier(textColor, boolean_, boolean2, boolean3, boolean4, boolean5, clickEvent, hoverEvent, string, resourceLocation);
            }
            return null;
        }

        @Nullable
        private static MinecraftKey a(JsonObject root) {
            if (root.has("font")) {
                String string = ChatDeserializer.i(root, "font");
                try {
                    return new MinecraftKey(string);
                }
                catch (ResourceKeyInvalidException resourceLocationException) {
                    throw new JsonSyntaxException("Invalid font name: " + string);
                }
            }
            return null;
        }

        @Nullable
        private static ChatHoverable b(JsonObject root) {
            JsonObject jsonObject;
            ChatHoverable hoverEvent;
            if (root.has("hoverEvent") && (hoverEvent = ChatHoverable.a(jsonObject = ChatDeserializer.u(root, "hoverEvent"))) != null && hoverEvent.a().a()) {
                return hoverEvent;
            }
            return null;
        }

        @Nullable
        private static ChatClickable c(JsonObject root) {
            if (root.has("clickEvent")) {
                JsonObject jsonObject = ChatDeserializer.u(root, "clickEvent");
                String string = ChatDeserializer.a(jsonObject, "action", null);
                ChatClickable.EnumClickAction action = string == null ? null : ChatClickable.EnumClickAction.a(string);
                String string2 = ChatDeserializer.a(jsonObject, "value", null);
                if (action != null && string2 != null && action.a()) {
                    return new ChatClickable(action, string2);
                }
            }
            return null;
        }

        @Nullable
        private static String d(JsonObject root) {
            return ChatDeserializer.a(root, "insertion", null);
        }

        @Nullable
        private static ChatHexColor e(JsonObject root) {
            if (root.has("color")) {
                String string = ChatDeserializer.i(root, "color");
                return ChatHexColor.a(string);
            }
            return null;
        }

        @Nullable
        private static Boolean a(JsonObject root, String key) {
            if (root.has(key)) {
                return root.get(key).getAsBoolean();
            }
            return null;
        }

        @Nullable
        @Override
        public JsonElement a(ChatModifier style, Type type, JsonSerializationContext jsonSerializationContext) {
            if (style.g()) {
                return null;
            }
            JsonObject jsonObject = new JsonObject();
            if (style.e != null) {
                jsonObject.addProperty("bold", style.e);
            }
            if (style.f != null) {
                jsonObject.addProperty("italic", style.f);
            }
            if (style.g != null) {
                jsonObject.addProperty("underlined", style.g);
            }
            if (style.h != null) {
                jsonObject.addProperty("strikethrough", style.h);
            }
            if (style.i != null) {
                jsonObject.addProperty("obfuscated", style.i);
            }
            if (style.d != null) {
                jsonObject.addProperty("color", style.d.b());
            }
            if (style.l != null) {
                jsonObject.add("insertion", jsonSerializationContext.serialize((Object)style.l));
            }
            if (style.j != null) {
                JsonObject jsonObject2 = new JsonObject();
                jsonObject2.addProperty("action", style.j.a().b());
                jsonObject2.addProperty("value", style.j.b());
                jsonObject.add("clickEvent", (JsonElement)jsonObject2);
            }
            if (style.k != null) {
                jsonObject.add("hoverEvent", (JsonElement)style.k.b());
            }
            if (style.m != null) {
                jsonObject.addProperty("font", style.m.toString());
            }
            return jsonObject;
        }

        @Nullable
        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.a((ChatModifier)object, type, jsonSerializationContext);
        }

        @Nullable
        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.a(jsonElement, type, jsonDeserializationContext);
        }
    }
}

