/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.time.Instant;
import java.util.Optional;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureUpdater;

public final class SignedMessageBody
extends Record {
    private final String b;
    private final Instant c;
    private final long d;
    private final LastSeenMessages e;
    public static final MapCodec<SignedMessageBody> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("content").forGetter(SignedMessageBody::a), (App)ExtraCodecs.m.fieldOf("time_stamp").forGetter(SignedMessageBody::b), (App)Codec.LONG.fieldOf("salt").forGetter(SignedMessageBody::c), (App)LastSeenMessages.a.optionalFieldOf("last_seen", (Object)LastSeenMessages.b).forGetter(SignedMessageBody::d)).apply((Applicative)instance, SignedMessageBody::new));

    public SignedMessageBody(String string, Instant instant, long l2, LastSeenMessages lastSeenMessages) {
        this.b = string;
        this.c = instant;
        this.d = l2;
        this.e = lastSeenMessages;
    }

    public static SignedMessageBody a(String content) {
        return new SignedMessageBody(content, Instant.now(), 0L, LastSeenMessages.b);
    }

    public void a(SignatureUpdater.a updater) throws SignatureException {
        updater.update(Longs.toByteArray((long)this.d));
        updater.update(Longs.toByteArray((long)this.c.getEpochSecond()));
        byte[] bs = this.b.getBytes(StandardCharsets.UTF_8);
        updater.update(Ints.toByteArray((int)bs.length));
        updater.update(bs);
        this.e.a(updater);
    }

    public a a(MessageSignatureCache storage) {
        return new a(this.b, this.c, this.d, this.e.a(storage));
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SignedMessageBody.class, "content;timeStamp;salt;lastSeen", "b", "c", "d", "e"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SignedMessageBody.class, "content;timeStamp;salt;lastSeen", "b", "c", "d", "e"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SignedMessageBody.class, "content;timeStamp;salt;lastSeen", "b", "c", "d", "e"}, this, object);
    }

    public String a() {
        return this.b;
    }

    public Instant b() {
        return this.c;
    }

    public long c() {
        return this.d;
    }

    public LastSeenMessages d() {
        return this.e;
    }

    public record a(String a, Instant b, long c, LastSeenMessages.a d) {
        public a(PacketDataSerializer buf) {
            this(buf.d(256), buf.v(), buf.readLong(), new LastSeenMessages.a(buf));
        }

        public void a(PacketDataSerializer buf) {
            buf.a(this.a, 256);
            buf.a(this.b);
            buf.b(this.c);
            this.d.a(buf);
        }

        public Optional<SignedMessageBody> a(MessageSignatureCache storage) {
            return this.d.a(storage).map(lastSeenMessages -> new SignedMessageBody(this.a, this.b, this.c, (LastSeenMessages)lastSeenMessages));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "content;timeStamp;salt;lastSeen", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "content;timeStamp;salt;lastSeen", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "content;timeStamp;salt;lastSeen", "a", "b", "c", "d"}, this, object);
        }
    }
}

