/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class NbtContents
implements ComponentContents {
    private static final Logger c = LogUtils.getLogger();
    private final boolean d;
    private final Optional<IChatBaseComponent> e;
    private final String f;
    private final DataSource g;
    @Nullable
    protected final ArgumentNBTKey.g b;

    public NbtContents(String rawPath, boolean interpret, Optional<IChatBaseComponent> separator, DataSource dataSource) {
        this(rawPath, NbtContents.a(rawPath), interpret, separator, dataSource);
    }

    private NbtContents(String rawPath, @Nullable ArgumentNBTKey.g path, boolean interpret, Optional<IChatBaseComponent> separator, DataSource dataSource) {
        this.f = rawPath;
        this.b = path;
        this.d = interpret;
        this.e = separator;
        this.g = dataSource;
    }

    @Nullable
    private static ArgumentNBTKey.g a(String rawPath) {
        try {
            return new ArgumentNBTKey().a(new StringReader(rawPath));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    public String a() {
        return this.f;
    }

    public boolean b() {
        return this.d;
    }

    public Optional<IChatBaseComponent> c() {
        return this.e;
    }

    public DataSource d() {
        return this.g;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NbtContents)) return false;
        NbtContents nbtContents = (NbtContents)object;
        if (!this.g.equals(nbtContents.g)) return false;
        if (!this.e.equals(nbtContents.e)) return false;
        if (this.d != nbtContents.d) return false;
        if (!this.f.equals(nbtContents.f)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int i2 = this.d ? 1 : 0;
        i2 = 31 * i2 + this.e.hashCode();
        i2 = 31 * i2 + this.f.hashCode();
        i2 = 31 * i2 + this.g.hashCode();
        return i2;
    }

    @Override
    public String toString() {
        return "nbt{" + this.g + ", interpreting=" + this.d + ", separator=" + this.e + "}";
    }

    @Override
    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper source, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        if (source == null || this.b == null) {
            return IChatBaseComponent.h();
        }
        Stream<String> stream = this.g.getData(source).flatMap(nbt -> {
            try {
                return this.b.a((NBTBase)nbt).stream();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return Stream.empty();
            }
        }).map(NBTBase::r_);
        if (this.d) {
            IChatBaseComponent component = (IChatBaseComponent)DataFixUtils.orElse(ChatComponentUtils.a(source, this.e, sender, depth), (Object)ChatComponentUtils.c);
            return stream.flatMap(text -> {
                try {
                    IChatMutableComponent mutableComponent = IChatBaseComponent.ChatSerializer.a(text);
                    return Stream.of(ChatComponentUtils.a(source, mutableComponent, sender, depth));
                }
                catch (Exception exception) {
                    c.warn("Failed to parse component: {}", text, (Object)exception);
                    return Stream.of(new IChatMutableComponent[0]);
                }
            }).reduce((accumulator, current) -> accumulator.b(component).b((IChatBaseComponent)current)).orElseGet(IChatBaseComponent::h);
        }
        return ChatComponentUtils.a(source, this.e, sender, depth).map(text -> stream.map(IChatBaseComponent::b).reduce((accumulator, current) -> accumulator.b((IChatBaseComponent)text).b((IChatBaseComponent)current)).orElseGet(IChatBaseComponent::h)).orElseGet(() -> IChatBaseComponent.b(stream.collect(Collectors.joining(", "))));
    }
}

