/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class SelectorContents
implements ComponentContents {
    private static final Logger c = LogUtils.getLogger();
    private final String d;
    @Nullable
    private final EntitySelector e;
    protected final Optional<IChatBaseComponent> b;

    public SelectorContents(String pattern, Optional<IChatBaseComponent> separator) {
        this.d = pattern;
        this.b = separator;
        this.e = SelectorContents.a(pattern);
    }

    @Nullable
    private static EntitySelector a(String pattern) {
        EntitySelector entitySelector = null;
        try {
            ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(new StringReader(pattern));
            entitySelector = entitySelectorParser.t();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            c.warn("Invalid selector component: {}: {}", (Object)pattern, (Object)commandSyntaxException.getMessage());
        }
        return entitySelector;
    }

    public String a() {
        return this.d;
    }

    @Nullable
    public EntitySelector b() {
        return this.e;
    }

    public Optional<IChatBaseComponent> c() {
        return this.b;
    }

    @Override
    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper source, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        if (source == null || this.e == null) {
            return IChatBaseComponent.h();
        }
        Optional<IChatMutableComponent> optional = ChatComponentUtils.a(source, this.b, sender, depth);
        return ChatComponentUtils.a(this.e.b(source), optional, Entity::N_);
    }

    @Override
    @Override
    public <T> Optional<T> a(IChatFormatted.b<T> visitor, ChatModifier style) {
        return visitor.accept(style, this.d);
    }

    @Override
    @Override
    public <T> Optional<T> a(IChatFormatted.a<T> visitor) {
        return visitor.accept(this.d);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SelectorContents)) return false;
        SelectorContents selectorContents = (SelectorContents)object;
        if (!this.d.equals(selectorContents.d)) return false;
        if (!this.b.equals(selectorContents.b)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int i2 = this.d.hashCode();
        i2 = 31 * i2 + this.b.hashCode();
        return i2;
    }

    @Override
    public String toString() {
        return "pattern{" + this.d + "}";
    }
}

