/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.util.thread.IAsyncTaskHandler;
import org.slf4j.Logger;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.util.UpdateSuppressionException;

public class PlayerConnectionUtils {
    private static final Logger a = LogUtils.getLogger();
    public static final ConcurrentLinkedDeque<PacketListener> packetProcessing = new ConcurrentLinkedDeque();
    static final AtomicLong totalMainThreadPacketsProcessed = new AtomicLong();

    public static long getTotalProcessedPackets() {
        return totalMainThreadPacketsProcessed.get();
    }

    public static List<PacketListener> getCurrentPacketProcessors() {
        ArrayList<PacketListener> ret = new ArrayList<PacketListener>(4);
        for (PacketListener listener : packetProcessing) {
            ret.add(listener);
        }
        return ret;
    }

    public static <T extends PacketListener> void a(Packet<T> packet, T listener, WorldServer world) throws CancelledPacketHandleException {
        PlayerConnectionUtils.a(packet, listener, world.n());
    }

    public static <T extends PacketListener> void a(Packet<T> packet, T listener, IAsyncTaskHandler<?> engine) throws CancelledPacketHandleException {
        if (!engine.bl()) {
            engine.execute(() -> {
                block12: {
                    packetProcessing.push(listener);
                    try {
                        if (MinecraftServer.getServer().hasStopped() || listener instanceof ServerCommonPacketListenerImpl && ((ServerCommonPacketListenerImpl)listener).processedDisconnect) {
                            return;
                        }
                        if (listener.a(packet)) {
                            try {
                                packet.a(listener);
                                break block12;
                            }
                            catch (UpdateSuppressionException exception) {
                                LeavesLogger.LOGGER.info(exception.getMessage());
                                break block12;
                            }
                            catch (Exception exception) {
                                ReportedException reportedexception;
                                if (exception instanceof ReportedException && (reportedexception = (ReportedException)exception).getCause() instanceof OutOfMemoryError) {
                                    throw exception;
                                }
                                if (!listener.d()) {
                                    a.error("Failed to handle packet {}, suppressing error", (Object)packet, (Object)exception);
                                    totalMainThreadPacketsProcessed.getAndIncrement();
                                    packetProcessing.pop();
                                    return;
                                }
                                throw exception;
                            }
                        }
                        a.debug("Ignoring packet due to disconnection: {}", (Object)packet);
                    }
                    finally {
                        totalMainThreadPacketsProcessed.getAndIncrement();
                        packetProcessing.pop();
                    }
                }
            });
            throw CancelledPacketHandleException.a;
        }
        if (MinecraftServer.getServer().hasStopped() || listener instanceof ServerCommonPacketListenerImpl && ((ServerCommonPacketListenerImpl)listener).processedDisconnect) {
            throw CancelledPacketHandleException.a;
        }
    }
}

