/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.destroystokyo.paper.antixray.ChunkPacketInfo;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.papermc.paper.annotation.DoNotUse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.levelgen.HeightMap;

public class ClientboundLevelChunkPacketData {
    private static final int a = 0x200000;
    private final NBTTagCompound b;
    private final byte[] c;
    private final List<a> d;
    private final List<Packet<?>> extraPackets = new ArrayList();
    private static final int TE_LIMIT = Integer.getInteger("Paper.excessiveTELimit", 750);

    public List<Packet<?>> getExtraPackets() {
        return this.extraPackets;
    }

    @Deprecated
    @DoNotUse
    public ClientboundLevelChunkPacketData(Chunk chunk) {
        this(chunk, null);
    }

    public ClientboundLevelChunkPacketData(Chunk chunk, ChunkPacketInfo<IBlockData> chunkPacketInfo) {
        this.b = new NBTTagCompound();
        for (Map.Entry<HeightMap.Type, HeightMap> entry : chunk.e()) {
            if (!entry.getKey().b()) continue;
            this.b.a(entry.getKey().a(), new NBTTagLongArray(entry.getValue().a()));
        }
        this.c = new byte[ClientboundLevelChunkPacketData.a(chunk)];
        if (chunkPacketInfo != null) {
            chunkPacketInfo.setBuffer(this.c);
        }
        ClientboundLevelChunkPacketData.extractChunkData(new PacketDataSerializer(this.c()), chunk, chunkPacketInfo);
        this.d = Lists.newArrayList();
        int totalTileEntities = 0;
        for (Map.Entry<BlockPosition, TileEntity> entry2 : chunk.G().entrySet()) {
            Packet<PacketListenerPlayOut> packet;
            if (++totalTileEntities > TE_LIMIT && (packet = entry2.getValue().h()) != null) {
                this.extraPackets.add(packet);
                continue;
            }
            this.d.add(net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData$a.a(entry2.getValue()));
        }
    }

    public ClientboundLevelChunkPacketData(PacketDataSerializer buf, int x2, int z2) {
        this.b = buf.p();
        if (this.b == null) {
            throw new RuntimeException("Can't read heightmap in packet for [" + x2 + ", " + z2 + "]");
        }
        int i2 = buf.m();
        if (i2 > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.c = new byte[i2];
        buf.b(this.c);
        this.d = buf.a(a::new);
    }

    public void a(PacketDataSerializer buf) {
        buf.a(this.b);
        buf.c(this.c.length);
        buf.c(this.c);
        buf.a(this.d, (buf2, entry) -> entry.a((PacketDataSerializer)((Object)buf2)));
    }

    private static int a(Chunk chunk) {
        int i2 = 0;
        for (ChunkSection levelChunkSection : chunk.d()) {
            i2 += levelChunkSection.j();
        }
        return i2;
    }

    private ByteBuf c() {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.c);
        byteBuf.writerIndex(0);
        return byteBuf;
    }

    @Deprecated
    @DoNotUse
    public static void a(PacketDataSerializer buf, Chunk chunk) {
        ClientboundLevelChunkPacketData.extractChunkData(buf, chunk, null);
    }

    public static void extractChunkData(PacketDataSerializer buf, Chunk chunk, ChunkPacketInfo<IBlockData> chunkPacketInfo) {
        int chunkSectionIndex = 0;
        for (ChunkSection levelChunkSection : chunk.d()) {
            levelChunkSection.write(buf, chunkPacketInfo, chunkSectionIndex);
            ++chunkSectionIndex;
        }
    }

    public Consumer<b> a(int x2, int z2) {
        return visitor -> this.a((b)visitor, x2, z2);
    }

    private void a(b consumer, int x2, int z2) {
        int i2 = 16 * x2;
        int j2 = 16 * z2;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (a blockEntityInfo : this.d) {
            int k2 = i2 + SectionPosition.b(blockEntityInfo.a >> 4);
            int l2 = j2 + SectionPosition.b(blockEntityInfo.a);
            mutableBlockPos.d(k2, blockEntityInfo.b, l2);
            consumer.accept(mutableBlockPos, blockEntityInfo.c, blockEntityInfo.d);
        }
    }

    public PacketDataSerializer a() {
        return new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])this.c));
    }

    public NBTTagCompound b() {
        return this.b;
    }

    static class a {
        final int a;
        final int b;
        final TileEntityTypes<?> c;
        @Nullable
        final NBTTagCompound d;

        private a(int localXz, int y2, TileEntityTypes<?> type, @Nullable NBTTagCompound nbt) {
            this.a = localXz;
            this.b = y2;
            this.c = type;
            this.d = nbt;
        }

        private a(PacketDataSerializer buf) {
            this.a = buf.readByte();
            this.b = buf.readShort();
            this.c = buf.a(BuiltInRegistries.l);
            this.d = buf.p();
        }

        void a(PacketDataSerializer buf) {
            buf.k(this.a);
            buf.l(this.b);
            buf.a(BuiltInRegistries.l, this.c);
            buf.a(this.d);
        }

        static a a(TileEntity blockEntity) {
            NBTTagCompound compoundTag = blockEntity.as_();
            BlockPosition blockPos = blockEntity.p();
            int i2 = SectionPosition.b(blockPos.u()) << 4 | SectionPosition.b(blockPos.w());
            blockEntity.sanitizeSentNbt(compoundTag);
            return new a(i2, blockPos.v(), blockEntity.u(), compoundTag.g() ? null : compoundTag);
        }
    }

    @FunctionalInterface
    public static interface b {
        public void accept(BlockPosition var1, TileEntityTypes<?> var2, @Nullable NBTTagCompound var3);
    }
}

