/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.annotation.DoNotUse;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public record ClientboundSystemChatPacket(@Nullable Component adventure$content, @Nullable String content, boolean b) implements Packet<PacketListenerPlayOut>
{
    private final boolean b;

    @DoNotUse
    public ClientboundSystemChatPacket(IChatBaseComponent content, boolean overlay) {
        this(null, IChatBaseComponent.ChatSerializer.a(content), overlay);
    }

    public ClientboundSystemChatPacket(BaseComponent[] content, boolean overlay) {
        this(null, ClientboundSystemChatPacket.improveBungeeComponentSerialization(content), overlay);
    }

    public ClientboundSystemChatPacket {
        Preconditions.checkArgument((adventure$content != null || content != null ? 1 : 0) != 0, (Object)"Component adventure$content and String (json) content cannot both be null");
    }

    public ClientboundSystemChatPacket(Component content, boolean overlay) {
        this(content, null, overlay);
    }

    public ClientboundSystemChatPacket(PacketDataSerializer buf) {
        this(null, PaperAdventure.asJsonString(buf.l(), buf.adventure$locale), buf.readBoolean());
    }

    private static String improveBungeeComponentSerialization(BaseComponent[] content) {
        if (content.length == 1) {
            return ComponentSerializer.toString((BaseComponent)content[0]);
        }
        return ComponentSerializer.toString((BaseComponent[])content);
    }

    @Override
    public void a(PacketDataSerializer buf) {
        if (this.adventure$content != null) {
            buf.writeComponent(this.adventure$content);
        } else if (this.content != null) {
            buf.a(this.content, 262144);
        } else {
            throw new IllegalArgumentException("Must supply either adventure component or string json content");
        }
        buf.a(this.b);
    }

    @Override
    public void a(PacketListenerPlayOut listener) {
        listener.a(this);
    }

    @Override
    public boolean b() {
        return true;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ClientboundSystemChatPacket.class, "adventure$content;content;overlay", "adventure$content", "content", "b"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ClientboundSystemChatPacket.class, "adventure$content;content;overlay", "adventure$content", "content", "b"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ClientboundSystemChatPacket.class, "adventure$content;content;overlay", "adventure$content", "content", "b"}, this, o2);
    }

    public boolean d() {
        return this.b;
    }
}

