/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutExplosion
implements Packet<PacketListenerPlayOut> {
    private final double a;
    private final double b;
    private final double c;
    private final float d;
    private final List<BlockPosition> e;
    private final float f;
    private final float g;
    private final float h;

    public PacketPlayOutExplosion(double x2, double y2, double z2, float radius, List<BlockPosition> affectedBlocks, @Nullable Vec3D playerVelocity) {
        this.a = x2;
        this.b = y2;
        this.c = z2;
        this.d = radius;
        this.e = Lists.newArrayList(affectedBlocks);
        if (playerVelocity != null) {
            this.f = (float)playerVelocity.c;
            this.g = (float)playerVelocity.d;
            this.h = (float)playerVelocity.e;
        } else {
            this.f = 0.0f;
            this.g = 0.0f;
            this.h = 0.0f;
        }
    }

    public PacketPlayOutExplosion(PacketDataSerializer buf) {
        this.a = buf.readDouble();
        this.b = buf.readDouble();
        this.c = buf.readDouble();
        this.d = buf.readFloat();
        int i2 = MathHelper.a(this.a);
        int j2 = MathHelper.a(this.b);
        int k2 = MathHelper.a(this.c);
        this.e = buf.a(buf2 -> {
            int l2 = buf2.readByte() + i2;
            int m2 = buf2.readByte() + j2;
            int n2 = buf2.readByte() + k2;
            return new BlockPosition(l2, m2, n2);
        });
        this.f = buf.readFloat();
        this.g = buf.readFloat();
        this.h = buf.readFloat();
    }

    @Override
    @Override
    public void a(PacketDataSerializer buf) {
        buf.a(this.a);
        buf.a(this.b);
        buf.a(this.c);
        buf.a(this.d);
        int i2 = MathHelper.a(this.a);
        int j2 = MathHelper.a(this.b);
        int k2 = MathHelper.a(this.c);
        buf.a(this.e, (buf2, pos) -> {
            int l2 = pos.u() - i2;
            int m2 = pos.v() - j2;
            int n2 = pos.w() - k2;
            buf2.k(l2);
            buf2.k(m2);
            buf2.k(n2);
        });
        buf.a(this.f);
        buf.a(this.g);
        buf.a(this.h);
    }

    @Override
    @Override
    public void a(PacketListenerPlayOut listener) {
        listener.a(this);
    }

    public float a() {
        return this.f;
    }

    public float d() {
        return this.g;
    }

    public float e() {
        return this.h;
    }

    public double f() {
        return this.a;
    }

    public double g() {
        return this.b;
    }

    public double h() {
        return this.c;
    }

    public float i() {
        return this.d;
    }

    public List<BlockPosition> j() {
        return this.e;
    }
}

