/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.DynamicOpsWrapper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

public class RegistryOps<T>
extends DynamicOpsWrapper<T> {
    private final b b;

    private static b a(final b registryInfoGetter) {
        return new b(){
            private final Map<ResourceKey<? extends IRegistry<?>>, Optional<? extends a<?>>> b = new ConcurrentHashMap();

            @Override
            public <T> Optional<a<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
                return this.b.computeIfAbsent(registryRef, registryInfoGetter::a);
            }
        };
    }

    public static <T> RegistryOps<T> a(DynamicOps<T> delegate, final HolderLookup.b wrapperLookup) {
        return RegistryOps.a(delegate, RegistryOps.a(new b(){

            public <E> Optional<a<E>> a(ResourceKey<? extends IRegistry<? extends E>> registryRef) {
                return wrapperLookup.a(registryRef).map(wrapper -> new a(wrapper, wrapper, wrapper.g()));
            }
        }));
    }

    public static <T> RegistryOps<T> a(DynamicOps<T> delegate, b registryInfoGetter) {
        return new RegistryOps<T>(delegate, registryInfoGetter);
    }

    private RegistryOps(DynamicOps<T> delegate, b registryInfoGetter) {
        super(delegate);
        this.b = registryInfoGetter;
    }

    public <E> Optional<HolderOwner<E>> a(ResourceKey<? extends IRegistry<? extends E>> registryRef) {
        return this.b.a(registryRef).map(a::a);
    }

    public <E> Optional<HolderGetter<E>> b(ResourceKey<? extends IRegistry<? extends E>> registryRef) {
        return this.b.a(registryRef).map(a::b);
    }

    public static <E, O> RecordCodecBuilder<O, HolderGetter<E>> c(ResourceKey<? extends IRegistry<? extends E>> registryRef) {
        return ExtraCodecs.b((DynamicOps<?> ops) -> {
            if (ops instanceof RegistryOps) {
                RegistryOps registryOps = (RegistryOps)ops;
                return registryOps.b.a(registryRef).map(info -> DataResult.success(info.b(), (Lifecycle)info.c())).orElseGet(() -> DataResult.error(() -> "Unknown registry: " + registryRef));
            }
            return DataResult.error(() -> "Not a registry ops");
        }).forGetter(object -> null);
    }

    public static <E, O> RecordCodecBuilder<O, Holder.c<E>> d(ResourceKey<E> key) {
        ResourceKey resourceKey = ResourceKey.a(key.b());
        return ExtraCodecs.b((DynamicOps<?> ops) -> {
            if (ops instanceof RegistryOps) {
                RegistryOps registryOps = (RegistryOps)ops;
                return registryOps.b.a(resourceKey).flatMap(info -> info.b().a(key)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Can't find value: " + key));
            }
            return DataResult.error(() -> "Not a registry ops");
        }).forGetter(object -> null);
    }

    public static interface b {
        public <T> Optional<a<T>> a(ResourceKey<? extends IRegistry<? extends T>> var1);
    }

    public record a<T>(HolderOwner<T> a, HolderGetter<T> b, Lifecycle c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "owner;getter;elementsLifecycle", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "owner;getter;elementsLifecycle", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "owner;getter;elementsLifecycle", "a", "b", "c"}, this, o2);
        }
    }
}

