/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.level.storage.loot.LootDataManager;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class AdvancementDataWorld
extends ResourceDataJson {
    private static final Logger a = LogUtils.getLogger();
    public static final Gson b = new GsonBuilder().create();
    public Map<MinecraftKey, AdvancementHolder> c = Map.of();
    private AdvancementTree d = new AdvancementTree();
    private final LootDataManager e;

    public AdvancementDataWorld(LootDataManager conditionManager) {
        super(b, "advancements");
        this.e = conditionManager;
    }

    @Override
    protected void a(Map<MinecraftKey, JsonElement> prepared, IResourceManager manager, GameProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        prepared.forEach((minecraftkey, jsonelement) -> {
            if (SpigotConfig.disabledAdvancements != null && (SpigotConfig.disabledAdvancements.contains("*") || SpigotConfig.disabledAdvancements.contains(minecraftkey.toString()) || SpigotConfig.disabledAdvancements.contains(minecraftkey.b()))) {
                return;
            }
            try {
                JsonObject jsonobject = ChatDeserializer.m(jsonelement, "advancement");
                Advancement advancement = Advancement.a(jsonobject, new LootDeserializationContext((MinecraftKey)minecraftkey, this.e));
                builder.put(minecraftkey, (Object)new AdvancementHolder((MinecraftKey)minecraftkey, advancement));
            }
            catch (Exception exception) {
                a.error("Parsing error loading custom advancement {}: {}", minecraftkey, (Object)exception.getMessage());
            }
        });
        this.c = builder.buildOrThrow();
        AdvancementTree advancementtree = new AdvancementTree();
        advancementtree.a(this.c.values());
        a.info("Loaded {} advancements", (Object)advancementtree.c().size());
        for (AdvancementNode advancementnode : advancementtree.b()) {
            if (!advancementnode.b().b().d().isPresent()) continue;
            TreeNodePosition.a(advancementnode);
        }
        this.d = advancementtree;
    }

    @Nullable
    public AdvancementHolder a(MinecraftKey id) {
        return this.c.get(id);
    }

    public AdvancementTree a() {
        return this.d;
    }

    public Collection<AdvancementHolder> b() {
        return this.c.values();
    }
}

