/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.chase;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.commands.ChaseCommand;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class ChaseServer {
    private static final Logger a = LogUtils.getLogger();
    private final String b;
    private final int c;
    private final PlayerList d;
    private final int e;
    private volatile boolean f;
    @Nullable
    private ServerSocket g;
    private final CopyOnWriteArrayList<Socket> h = new CopyOnWriteArrayList();

    public ChaseServer(String ip, int port, PlayerList playerManager, int interval) {
        this.b = ip;
        this.c = port;
        this.d = playerManager;
        this.e = interval;
    }

    public void a() throws IOException {
        if (this.g != null && !this.g.isClosed()) {
            a.warn("Remote control server was asked to start, but it is already running. Will ignore.");
            return;
        }
        this.f = true;
        this.g = new ServerSocket(this.c, 50, InetAddress.getByName(this.b));
        Thread thread = new Thread(this::d, "chase-server-acceptor");
        thread.setDaemon(true);
        thread.start();
        Thread thread2 = new Thread(this::c, "chase-server-sender");
        thread2.setDaemon(true);
        thread2.start();
    }

    private void c() {
        a playerPosition = null;
        while (this.f) {
            if (!this.h.isEmpty()) {
                a playerPosition2 = this.e();
                if (playerPosition2 != null && !playerPosition2.equals(playerPosition)) {
                    playerPosition = playerPosition2;
                    byte[] bs = playerPosition2.g().getBytes(StandardCharsets.US_ASCII);
                    for (Socket socket : this.h) {
                        if (socket.isClosed()) continue;
                        SystemUtils.g().submit(() -> {
                            try {
                                OutputStream outputStream = socket.getOutputStream();
                                outputStream.write(bs);
                                outputStream.flush();
                            }
                            catch (IOException iOException) {
                                a.info("Remote control client socket got an IO exception and will be closed", (Throwable)iOException);
                                IOUtils.closeQuietly((Socket)socket);
                            }
                        });
                    }
                }
                List list = this.h.stream().filter(Socket::isClosed).collect(Collectors.toList());
                this.h.removeAll(list);
            }
            if (!this.f) continue;
            try {
                Thread.sleep(this.e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void b() {
        this.f = false;
        IOUtils.closeQuietly((ServerSocket)this.g);
        this.g = null;
    }

    private void d() {
        try {
            while (this.f) {
                if (this.g == null) continue;
                a.info("Remote control server is listening for connections on port {}", (Object)this.c);
                Socket socket = this.g.accept();
                a.info("Remote control server received client connection on port {}", (Object)socket.getPort());
                this.h.add(socket);
            }
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            if (this.f) {
                a.info("Remote control server closed by interrupt");
            }
        }
        catch (IOException iOException) {
            if (this.f) {
                a.error("Remote control server closed because of an IO exception", (Throwable)iOException);
            }
        }
        finally {
            IOUtils.closeQuietly((ServerSocket)this.g);
        }
        a.info("Remote control server is now stopped");
        this.f = false;
    }

    @Nullable
    private a e() {
        List<EntityPlayer> list = this.d.t();
        if (list.isEmpty()) {
            return null;
        }
        EntityPlayer serverPlayer = list.get(0);
        String string = (String)ChaseCommand.a.inverse().get(serverPlayer.dL().ac());
        if (string == null) {
            return null;
        }
        return new a(string, serverPlayer.dq(), serverPlayer.ds(), serverPlayer.dw(), serverPlayer.dB(), serverPlayer.dD());
    }

    record a(String a, double b, double c, double d, float e, float f) {
        String g() {
            return String.format(Locale.ROOT, "t %s %.2f %.2f %.2f %.2f %.2f\n", this.a, this.b, this.c, this.d, Float.valueOf(this.e), Float.valueOf(this.f));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "dimensionName;x;y;z;yRot;xRot", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "dimensionName;x;y;z;yRot;xRot", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "dimensionName;x;y;z;yRot;xRot", "a", "b", "c", "d", "e", "f"}, this, object);
        }
    }
}

