/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.commands.CommandException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;

public class CommandAdvancement {
    private static final SuggestionProvider<CommandListenerWrapper> a = (context, builder) -> {
        Collection<AdvancementHolder> collection = ((CommandListenerWrapper)context.getSource()).l().az().b();
        return ICompletionProvider.a(collection.stream().map(AdvancementHolder::a), builder);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("advancement").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("grant").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.d()).then(net.minecraft.commands.CommandDispatcher.a("only").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("advancement", ArgumentMinecraftKeyRegistered.a()).suggests(a).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.a, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.a)))).then(net.minecraft.commands.CommandDispatcher.a("criterion", StringArgumentType.greedyString()).suggests((context, builder) -> ICompletionProvider.b(ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "advancement").b().f().keySet(), builder)).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.a, ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "advancement"), StringArgumentType.getString((CommandContext)context, (String)"criterion"))))))).then(net.minecraft.commands.CommandDispatcher.a("from").then(net.minecraft.commands.CommandDispatcher.a("advancement", ArgumentMinecraftKeyRegistered.a()).suggests(a).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.a, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.c)))))).then(net.minecraft.commands.CommandDispatcher.a("until").then(net.minecraft.commands.CommandDispatcher.a("advancement", ArgumentMinecraftKeyRegistered.a()).suggests(a).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.a, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.d)))))).then(net.minecraft.commands.CommandDispatcher.a("through").then(net.minecraft.commands.CommandDispatcher.a("advancement", ArgumentMinecraftKeyRegistered.a()).suggests(a).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.a, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.b)))))).then(net.minecraft.commands.CommandDispatcher.a("everything").executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.a, ((CommandListenerWrapper)context.getSource()).l().az().b())))))).then(net.minecraft.commands.CommandDispatcher.a("revoke").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.d()).then(net.minecraft.commands.CommandDispatcher.a("only").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("advancement", ArgumentMinecraftKeyRegistered.a()).suggests(a).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.b, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.a)))).then(net.minecraft.commands.CommandDispatcher.a("criterion", StringArgumentType.greedyString()).suggests((context, builder) -> ICompletionProvider.b(ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "advancement").b().f().keySet(), builder)).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.b, ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "advancement"), StringArgumentType.getString((CommandContext)context, (String)"criterion"))))))).then(net.minecraft.commands.CommandDispatcher.a("from").then(net.minecraft.commands.CommandDispatcher.a("advancement", ArgumentMinecraftKeyRegistered.a()).suggests(a).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.b, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.c)))))).then(net.minecraft.commands.CommandDispatcher.a("until").then(net.minecraft.commands.CommandDispatcher.a("advancement", ArgumentMinecraftKeyRegistered.a()).suggests(a).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.b, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.d)))))).then(net.minecraft.commands.CommandDispatcher.a("through").then(net.minecraft.commands.CommandDispatcher.a("advancement", ArgumentMinecraftKeyRegistered.a()).suggests(a).executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.b, CommandAdvancement.a((CommandContext<CommandListenerWrapper>)context, ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "advancement"), Filter.b)))))).then(net.minecraft.commands.CommandDispatcher.a("everything").executes(context -> CommandAdvancement.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.f((CommandContext<CommandListenerWrapper>)context, "targets"), Action.b, ((CommandListenerWrapper)context.getSource()).l().az().b())))))));
    }

    private static int a(CommandListenerWrapper source, Collection<EntityPlayer> targets, Action operation, Collection<AdvancementHolder> selection) {
        int i2 = 0;
        for (EntityPlayer serverPlayer : targets) {
            i2 += operation.a(serverPlayer, selection);
        }
        if (i2 == 0) {
            if (selection.size() == 1) {
                if (targets.size() == 1) {
                    throw new CommandException(IChatBaseComponent.a(operation.a() + ".one.to.one.failure", Advancement.a(selection.iterator().next()), targets.iterator().next().N_()));
                }
                throw new CommandException(IChatBaseComponent.a(operation.a() + ".one.to.many.failure", Advancement.a(selection.iterator().next()), targets.size()));
            }
            if (targets.size() == 1) {
                throw new CommandException(IChatBaseComponent.a(operation.a() + ".many.to.one.failure", selection.size(), targets.iterator().next().N_()));
            }
            throw new CommandException(IChatBaseComponent.a(operation.a() + ".many.to.many.failure", selection.size(), targets.size()));
        }
        if (selection.size() == 1) {
            if (targets.size() == 1) {
                source.a(() -> IChatBaseComponent.a(operation.a() + ".one.to.one.success", Advancement.a((AdvancementHolder)selection.iterator().next()), ((EntityPlayer)targets.iterator().next()).N_()), true);
            } else {
                source.a(() -> IChatBaseComponent.a(operation.a() + ".one.to.many.success", Advancement.a((AdvancementHolder)selection.iterator().next()), targets.size()), true);
            }
        } else if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a(operation.a() + ".many.to.one.success", selection.size(), ((EntityPlayer)targets.iterator().next()).N_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a(operation.a() + ".many.to.many.success", selection.size(), targets.size()), true);
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source, Collection<EntityPlayer> targets, Action operation, AdvancementHolder advancement, String criterion) {
        int i2 = 0;
        Advancement advancement2 = advancement.b();
        if (!advancement2.f().containsKey(criterion)) {
            throw new CommandException(IChatBaseComponent.a("commands.advancement.criterionNotFound", Advancement.a(advancement), criterion));
        }
        for (EntityPlayer serverPlayer : targets) {
            if (!operation.a(serverPlayer, advancement, criterion)) continue;
            ++i2;
        }
        if (i2 == 0) {
            if (targets.size() == 1) {
                throw new CommandException(IChatBaseComponent.a(operation.a() + ".criterion.to.one.failure", new Object[]{criterion, Advancement.a(advancement), targets.iterator().next().N_()}));
            }
            throw new CommandException(IChatBaseComponent.a(operation.a() + ".criterion.to.many.failure", new Object[]{criterion, Advancement.a(advancement), targets.size()}));
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a(operation.a() + ".criterion.to.one.success", new Object[]{criterion, Advancement.a(advancement), ((EntityPlayer)targets.iterator().next()).N_()}), true);
        } else {
            source.a(() -> IChatBaseComponent.a(operation.a() + ".criterion.to.many.success", new Object[]{criterion, Advancement.a(advancement), targets.size()}), true);
        }
        return i2;
    }

    private static List<AdvancementHolder> a(CommandContext<CommandListenerWrapper> context, AdvancementHolder advancement, Filter selection) {
        AdvancementTree advancementTree = ((CommandListenerWrapper)context.getSource()).l().az().a();
        AdvancementNode advancementNode = advancementTree.a(advancement);
        if (advancementNode == null) {
            return List.of(advancement);
        }
        ArrayList<AdvancementHolder> list = new ArrayList<AdvancementHolder>();
        if (selection.f) {
            for (AdvancementNode advancementNode2 = advancementNode.c(); advancementNode2 != null; advancementNode2 = advancementNode2.c()) {
                list.add(advancementNode2.b());
            }
        }
        list.add(advancement);
        if (selection.g) {
            CommandAdvancement.a(advancementNode, list);
        }
        return list;
    }

    private static void a(AdvancementNode parent, List<AdvancementHolder> childList) {
        for (AdvancementNode advancementNode : parent.e()) {
            childList.add(advancementNode.b());
            CommandAdvancement.a(advancementNode, childList);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class Action
    extends Enum<Action> {
        public static final /* enum */ Action a = new Action("grant"){

            @Override
            @Override
            protected boolean a(EntityPlayer player, AdvancementHolder advancement) {
                AdvancementProgress advancementProgress = player.O().b(advancement);
                if (advancementProgress.a()) {
                    return false;
                }
                for (String string : advancementProgress.e()) {
                    player.O().a(advancement, string);
                }
                return true;
            }

            @Override
            @Override
            protected boolean a(EntityPlayer player, AdvancementHolder advancement, String criterion) {
                return player.O().a(advancement, criterion);
            }
        };
        public static final /* enum */ Action b = new Action("revoke"){

            @Override
            @Override
            protected boolean a(EntityPlayer player, AdvancementHolder advancement) {
                AdvancementProgress advancementProgress = player.O().b(advancement);
                if (!advancementProgress.b()) {
                    return false;
                }
                for (String string : advancementProgress.f()) {
                    player.O().b(advancement, string);
                }
                return true;
            }

            @Override
            @Override
            protected boolean a(EntityPlayer player, AdvancementHolder advancement, String criterion) {
                return player.O().b(advancement, criterion);
            }
        };
        private final String c;
        private static final /* synthetic */ Action[] d;

        public static Action[] values() {
            return (Action[])d.clone();
        }

        public static Action valueOf(String string) {
            return Enum.valueOf(Action.class, string);
        }

        Action(String name) {
            this.c = "commands.advancement." + name;
        }

        public int a(EntityPlayer player, Iterable<AdvancementHolder> advancements) {
            int i2 = 0;
            for (AdvancementHolder advancementHolder : advancements) {
                if (!this.a(player, advancementHolder)) continue;
                ++i2;
            }
            return i2;
        }

        protected abstract boolean a(EntityPlayer var1, AdvancementHolder var2);

        protected abstract boolean a(EntityPlayer var1, AdvancementHolder var2, String var3);

        protected String a() {
            return this.c;
        }

        private static /* synthetic */ Action[] b() {
            return new Action[]{a, b};
        }

        static {
            d = Action.b();
        }
    }

    static final class Filter
    extends Enum<Filter> {
        public static final /* enum */ Filter a = new Filter(false, false);
        public static final /* enum */ Filter b = new Filter(true, true);
        public static final /* enum */ Filter c = new Filter(false, true);
        public static final /* enum */ Filter d = new Filter(true, false);
        public static final /* enum */ Filter e = new Filter(true, true);
        final boolean f;
        final boolean g;
        private static final /* synthetic */ Filter[] h;

        public static Filter[] values() {
            return (Filter[])h.clone();
        }

        public static Filter valueOf(String string) {
            return Enum.valueOf(Filter.class, string);
        }

        private Filter(boolean before, boolean after) {
            this.f = before;
            this.g = after;
        }

        private static /* synthetic */ Filter[] a() {
            return new Filter[]{a, b, c, d, e};
        }

        static {
            h = Filter.a();
        }
    }
}

