/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;

public class CommandClone {
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.clone.overlap"));
    private static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((maxCount, count) -> IChatBaseComponent.a("commands.clone.toobig", maxCount, count));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.clone.failed"));
    public static final Predicate<ShapeDetectorBlock> a = pos -> !pos.a().i();

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("clone").requires(source -> source.c(2))).then(CommandClone.a(commandRegistryAccess, (CommandContext<CommandListenerWrapper> context) -> ((CommandListenerWrapper)context.getSource()).e()))).then(net.minecraft.commands.CommandDispatcher.a("from").then(net.minecraft.commands.CommandDispatcher.a("sourceDimension", ArgumentDimension.a()).then(CommandClone.a(commandRegistryAccess, (CommandContext<CommandListenerWrapper> context) -> ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context, "sourceDimension")))))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandBuildContext commandRegistryAccess, b<CommandContext<CommandListenerWrapper>, WorldServer> worldGetter) {
        return net.minecraft.commands.CommandDispatcher.a("begin", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("end", ArgumentPosition.a()).then(CommandClone.a(commandRegistryAccess, worldGetter, (CommandContext<CommandListenerWrapper> context) -> ((CommandListenerWrapper)context.getSource()).e()))).then(net.minecraft.commands.CommandDispatcher.a("to").then(net.minecraft.commands.CommandDispatcher.a("targetDimension", ArgumentDimension.a()).then(CommandClone.a(commandRegistryAccess, worldGetter, (CommandContext<CommandListenerWrapper> context) -> ArgumentDimension.a((CommandContext<CommandListenerWrapper>)context, "targetDimension"))))));
    }

    private static c a(CommandContext<CommandListenerWrapper> context, WorldServer world, String name) throws CommandSyntaxException {
        BlockPosition blockPos = ArgumentPosition.a(context, world, name);
        return new c(world, blockPos);
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(CommandBuildContext commandRegistryAccess, b<CommandContext<CommandListenerWrapper>, WorldServer> sourceWorldGetter, b<CommandContext<CommandListenerWrapper>, WorldServer> targetWorldGetter) {
        b<CommandContext<CommandListenerWrapper>, c> commandFunction = context -> CommandClone.a((CommandContext<CommandListenerWrapper>)context, (WorldServer)sourceWorldGetter.apply((CommandContext<CommandListenerWrapper>)context), "begin");
        b<CommandContext<CommandListenerWrapper>, c> commandFunction2 = context -> CommandClone.a((CommandContext<CommandListenerWrapper>)context, (WorldServer)sourceWorldGetter.apply((CommandContext<CommandListenerWrapper>)context), "end");
        b<CommandContext<CommandListenerWrapper>, c> commandFunction3 = context -> CommandClone.a((CommandContext<CommandListenerWrapper>)context, (WorldServer)targetWorldGetter.apply((CommandContext<CommandListenerWrapper>)context), "destination");
        return ((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("destination", ArgumentPosition.a()).executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)commandFunction.apply(context), (c)commandFunction2.apply(context), (c)commandFunction3.apply(context), blockInWorld -> true, Mode.c))).then(CommandClone.a(commandFunction, commandFunction2, commandFunction3, (CommandContext<CommandListenerWrapper> context) -> blockInWorld -> true, net.minecraft.commands.CommandDispatcher.a("replace").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)commandFunction.apply(context), (c)commandFunction2.apply(context), (c)commandFunction3.apply(context), blockInWorld -> true, Mode.c))))).then(CommandClone.a(commandFunction, commandFunction2, commandFunction3, (CommandContext<CommandListenerWrapper> context) -> a, net.minecraft.commands.CommandDispatcher.a("masked").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)commandFunction.apply(context), (c)commandFunction2.apply(context), (c)commandFunction3.apply(context), a, Mode.c))))).then(net.minecraft.commands.CommandDispatcher.a("filtered").then(CommandClone.a(commandFunction, commandFunction2, commandFunction3, (CommandContext<CommandListenerWrapper> context) -> ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "filter"), net.minecraft.commands.CommandDispatcher.a("filter", ArgumentBlockPredicate.a(commandRegistryAccess)).executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)commandFunction.apply(context), (c)commandFunction2.apply(context), (c)commandFunction3.apply(context), ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "filter"), Mode.c)))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(b<CommandContext<CommandListenerWrapper>, c> beginPosGetter, b<CommandContext<CommandListenerWrapper>, c> endPosGetter, b<CommandContext<CommandListenerWrapper>, c> destinationPosGetter, b<CommandContext<CommandListenerWrapper>, Predicate<ShapeDetectorBlock>> filterGetter, ArgumentBuilder<CommandListenerWrapper, ?> builder) {
        return ((ArgumentBuilder)((ArgumentBuilder)builder.then(net.minecraft.commands.CommandDispatcher.a("force").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)beginPosGetter.apply(context), (c)endPosGetter.apply(context), (c)destinationPosGetter.apply(context), (Predicate)filterGetter.apply(context), Mode.a)))).then(net.minecraft.commands.CommandDispatcher.a("move").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)beginPosGetter.apply(context), (c)endPosGetter.apply(context), (c)destinationPosGetter.apply(context), (Predicate)filterGetter.apply(context), Mode.b)))).then(net.minecraft.commands.CommandDispatcher.a("normal").executes(context -> CommandClone.a((CommandListenerWrapper)context.getSource(), (c)beginPosGetter.apply(context), (c)endPosGetter.apply(context), (c)destinationPosGetter.apply(context), (Predicate)filterGetter.apply(context), Mode.c)));
    }

    private static int a(CommandListenerWrapper source, c begin, c end, c destination, Predicate<ShapeDetectorBlock> filter, Mode mode) throws CommandSyntaxException {
        int j2;
        BlockPosition blockPos = begin.b();
        BlockPosition blockPos2 = end.b();
        StructureBoundingBox boundingBox = StructureBoundingBox.a(blockPos, blockPos2);
        BlockPosition blockPos3 = destination.b();
        BlockPosition blockPos4 = blockPos3.a(boundingBox.b());
        StructureBoundingBox boundingBox2 = StructureBoundingBox.a(blockPos3, blockPos4);
        WorldServer serverLevel = begin.a();
        WorldServer serverLevel2 = destination.a();
        if (!mode.a() && serverLevel == serverLevel2 && boundingBox2.a(boundingBox)) {
            throw b.create();
        }
        int i2 = boundingBox.c() * boundingBox.d() * boundingBox.e();
        if (i2 > (j2 = source.e().X().c(GameRules.x))) {
            throw c.create((Object)j2, (Object)i2);
        }
        if (!serverLevel.a(blockPos, blockPos2) || !serverLevel2.a(blockPos3, blockPos4)) {
            throw ArgumentPosition.a.create();
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        ArrayList list3 = Lists.newArrayList();
        LinkedList deque = Lists.newLinkedList();
        BlockPosition blockPos5 = new BlockPosition(boundingBox2.g() - boundingBox.g(), boundingBox2.h() - boundingBox.h(), boundingBox2.i() - boundingBox.i());
        for (int k2 = boundingBox.i(); k2 <= boundingBox.l(); ++k2) {
            for (int l2 = boundingBox.h(); l2 <= boundingBox.k(); ++l2) {
                for (int m2 = boundingBox.g(); m2 <= boundingBox.j(); ++m2) {
                    BlockPosition blockPos6 = new BlockPosition(m2, l2, k2);
                    BlockPosition blockPos7 = blockPos6.a(blockPos5);
                    ShapeDetectorBlock blockInWorld = new ShapeDetectorBlock(serverLevel, blockPos6, false);
                    IBlockData blockState = blockInWorld.a();
                    if (!filter.test(blockInWorld)) continue;
                    TileEntity blockEntity = serverLevel.c_(blockPos6);
                    if (blockEntity != null) {
                        NBTTagCompound compoundTag = blockEntity.o();
                        list2.add(new CommandCloneStoredTileEntity(blockPos7, blockState, compoundTag));
                        deque.addLast(blockPos6);
                        continue;
                    }
                    if (blockState.i(serverLevel, blockPos6) || blockState.r(serverLevel, blockPos6)) {
                        list.add(new CommandCloneStoredTileEntity(blockPos7, blockState, null));
                        deque.addLast(blockPos6);
                        continue;
                    }
                    list3.add(new CommandCloneStoredTileEntity(blockPos7, blockState, null));
                    deque.addFirst(blockPos6);
                }
            }
        }
        if (mode == Mode.b) {
            for (BlockPosition blockPos8 : deque) {
                TileEntity blockEntity2 = serverLevel.c_(blockPos8);
                Clearable.a_(blockEntity2);
                serverLevel.a(blockPos8, Blocks.hW.n(), 2);
            }
            for (BlockPosition blockPos9 : deque) {
                serverLevel.a(blockPos9, Blocks.a.n(), 3);
            }
        }
        ArrayList list4 = Lists.newArrayList();
        list4.addAll(list);
        list4.addAll(list2);
        list4.addAll(list3);
        List list5 = Lists.reverse((List)list4);
        for (Iterator cloneBlockInfo : list5) {
            TileEntity blockEntity3 = serverLevel2.c_(((CommandCloneStoredTileEntity)((Object)cloneBlockInfo)).a);
            Clearable.a_(blockEntity3);
            serverLevel2.a(((CommandCloneStoredTileEntity)((Object)cloneBlockInfo)).a, Blocks.hW.n(), 2);
        }
        int n2 = 0;
        for (CommandCloneStoredTileEntity cloneBlockInfo2 : list4) {
            if (!serverLevel2.a(cloneBlockInfo2.a, cloneBlockInfo2.b, 2)) continue;
            ++n2;
        }
        for (CommandCloneStoredTileEntity cloneBlockInfo3 : list2) {
            TileEntity blockEntity4 = serverLevel2.c_(cloneBlockInfo3.a);
            if (cloneBlockInfo3.c != null && blockEntity4 != null) {
                blockEntity4.a(cloneBlockInfo3.c);
                blockEntity4.e();
            }
            serverLevel2.a(cloneBlockInfo3.a, cloneBlockInfo3.b, 2);
        }
        for (CommandCloneStoredTileEntity cloneBlockInfo4 : list5) {
            serverLevel2.b(cloneBlockInfo4.a, cloneBlockInfo4.b.b());
        }
        serverLevel2.l().a(serverLevel.l(), boundingBox, blockPos5);
        if (n2 == 0) {
            throw d.create();
        }
        int o2 = n2;
        source.a(() -> IChatBaseComponent.a("commands.clone.success", o2), true);
        return n2;
    }

    @FunctionalInterface
    static interface b<T, R> {
        public R apply(T var1) throws CommandSyntaxException;
    }

    record c(WorldServer a, BlockPosition b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "dimension;position", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "dimension;position", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "dimension;position", "a", "b"}, this, object);
        }
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode a = new Mode(true);
        public static final /* enum */ Mode b = new Mode(true);
        public static final /* enum */ Mode c = new Mode(false);
        private final boolean d;
        private static final /* synthetic */ Mode[] e;

        public static Mode[] values() {
            return (Mode[])e.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }

        private Mode(boolean allowsOverlap) {
            this.d = allowsOverlap;
        }

        public boolean a() {
            return this.d;
        }

        private static /* synthetic */ Mode[] b() {
            return new Mode[]{a, b, c};
        }

        static {
            e = Mode.b();
        }
    }

    static class CommandCloneStoredTileEntity {
        public final BlockPosition a;
        public final IBlockData b;
        @Nullable
        public final NBTTagCompound c;

        public CommandCloneStoredTileEntity(BlockPosition pos, IBlockData state, @Nullable NBTTagCompound blockEntityNbt) {
            this.a = pos;
            this.b = state;
            this.c = blockEntityNbt;
        }
    }
}

