/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.Entity;

public class CommandTag {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.tag.add.failed"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.tag.remove.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("tag").requires(source -> source.c(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(net.minecraft.commands.CommandDispatcher.a("add").then(net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.word()).executes(context -> CommandTag.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(net.minecraft.commands.CommandDispatcher.a("remove").then(net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.word()).suggests((context, builder) -> ICompletionProvider.b(CommandTag.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets")), builder)).executes(context -> CommandTag.b((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(net.minecraft.commands.CommandDispatcher.a("list").executes(context -> CommandTag.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets")))))));
    }

    private static Collection<String> a(Collection<? extends Entity> entities) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : entities) {
            set.addAll(entity.ai());
        }
        return set;
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, String tag) throws CommandSyntaxException {
        int i2 = 0;
        for (Entity entity : targets) {
            if (!entity.a(tag)) continue;
            ++i2;
        }
        if (i2 == 0) {
            throw a.create();
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.tag.add.success.single", new Object[]{tag, ((Entity)targets.iterator().next()).N_()}), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.tag.add.success.multiple", new Object[]{tag, targets.size()}), true);
        }
        return i2;
    }

    private static int b(CommandListenerWrapper source, Collection<? extends Entity> targets, String tag) throws CommandSyntaxException {
        int i2 = 0;
        for (Entity entity : targets) {
            if (!entity.b(tag)) continue;
            ++i2;
        }
        if (i2 == 0) {
            throw b.create();
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.tag.remove.success.single", new Object[]{tag, ((Entity)targets.iterator().next()).N_()}), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.tag.remove.success.multiple", new Object[]{tag, targets.size()}), true);
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : targets) {
            set.addAll(entity.ai());
        }
        if (targets.size() == 1) {
            Entity entity2 = targets.iterator().next();
            if (set.isEmpty()) {
                source.a(() -> IChatBaseComponent.a("commands.tag.list.single.empty", entity2.N_()), false);
            } else {
                source.a(() -> IChatBaseComponent.a("commands.tag.list.single.success", entity2.N_(), set.size(), ChatComponentUtils.a(set)), false);
            }
        } else if (set.isEmpty()) {
            source.a(() -> IChatBaseComponent.a("commands.tag.list.multiple.empty", targets.size()), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.tag.list.multiple.success", targets.size(), set.size(), ChatComponentUtils.a(set)), false);
        }
        return set.size();
    }
}

