/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import org.apache.commons.lang3.mutable.MutableInt;

public class FillBiomeCommand {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.pos.unloaded"));
    private static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((maximum, specified) -> IChatBaseComponent.a("commands.fillbiome.toobig", maximum, specified));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("fillbiome").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("from", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("to", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("biome", ResourceArgument.a(commandRegistryAccess, Registries.ap)).executes(context -> FillBiomeCommand.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "biome", Registries.ap), (Holder<BiomeBase> holder) -> true))).then(net.minecraft.commands.CommandDispatcher.a("replace").then(net.minecraft.commands.CommandDispatcher.a("filter", ResourceOrTagArgument.a(commandRegistryAccess, Registries.ap)).executes(context -> FillBiomeCommand.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "biome", Registries.ap), ResourceOrTagArgument.a((CommandContext<CommandListenerWrapper>)context, "filter", Registries.ap)::test)))))))));
    }

    private static int a(int coordinate) {
        return QuartPos.c(QuartPos.a(coordinate));
    }

    private static BlockPosition a(BlockPosition pos) {
        return new BlockPosition(FillBiomeCommand.a(pos.u()), FillBiomeCommand.a(pos.v()), FillBiomeCommand.a(pos.w()));
    }

    private static BiomeResolver a(MutableInt counter, IChunkAccess chunk, StructureBoundingBox box, Holder<BiomeBase> biome, Predicate<Holder<BiomeBase>> filter) {
        return (x2, y2, z2, noise) -> {
            int i2 = QuartPos.c(x2);
            int j2 = QuartPos.c(y2);
            int k2 = QuartPos.c(z2);
            Holder<BiomeBase> holder2 = chunk.getNoiseBiome(x2, y2, z2);
            if (box.c(i2, j2, k2) && filter.test(holder2)) {
                counter.increment();
                return biome;
            }
            return holder2;
        };
    }

    private static int a(CommandListenerWrapper source, BlockPosition from, BlockPosition to, Holder.c<BiomeBase> biome, Predicate<Holder<BiomeBase>> filter) throws CommandSyntaxException {
        int j2;
        BlockPosition blockPos2;
        BlockPosition blockPos = FillBiomeCommand.a(from);
        StructureBoundingBox boundingBox = StructureBoundingBox.a(blockPos, blockPos2 = FillBiomeCommand.a(to));
        int i2 = boundingBox.c() * boundingBox.d() * boundingBox.e();
        if (i2 > (j2 = source.e().X().c(GameRules.x))) {
            throw b.create((Object)j2, (Object)i2);
        }
        WorldServer serverLevel = source.e();
        ArrayList<IChunkAccess> list = new ArrayList<IChunkAccess>();
        for (int k2 = SectionPosition.a(boundingBox.i()); k2 <= SectionPosition.a(boundingBox.l()); ++k2) {
            for (int l2 = SectionPosition.a(boundingBox.g()); l2 <= SectionPosition.a(boundingBox.j()); ++l2) {
                IChunkAccess chunkAccess = serverLevel.a(l2, k2, ChunkStatus.n, false);
                if (chunkAccess == null) {
                    throw a.create();
                }
                list.add(chunkAccess);
            }
        }
        MutableInt mutableInt = new MutableInt(0);
        for (IChunkAccess chunkAccess2 : list) {
            chunkAccess2.a(FillBiomeCommand.a(mutableInt, chunkAccess2, boundingBox, biome, filter), serverLevel.k().i().b());
            chunkAccess2.a(true);
        }
        serverLevel.k().a.a(list);
        source.a(() -> IChatBaseComponent.a("commands.fillbiome.success.count", mutableInt.getValue(), boundingBox.g(), boundingBox.h(), boundingBox.i(), boundingBox.j(), boundingBox.k(), boundingBox.l()), true);
        return mutableInt.getValue();
    }
}

