/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public class ItemCommands {
    static final Dynamic3CommandExceptionType a = new Dynamic3CommandExceptionType((x2, y2, z2) -> IChatBaseComponent.a("commands.item.target.not_a_container", x2, y2, z2));
    private static final Dynamic3CommandExceptionType c = new Dynamic3CommandExceptionType((x2, y2, z2) -> IChatBaseComponent.a("commands.item.source.not_a_container", x2, y2, z2));
    static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(slot -> IChatBaseComponent.a("commands.item.target.no_such_slot", slot));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(slot -> IChatBaseComponent.a("commands.item.source.no_such_slot", slot));
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(slot -> IChatBaseComponent.a("commands.item.target.no_changes", slot));
    private static final Dynamic2CommandExceptionType f = new Dynamic2CommandExceptionType((itemName, slot) -> IChatBaseComponent.a("commands.item.target.no_changed.known_item", itemName, slot));
    private static final SuggestionProvider<CommandListenerWrapper> g = (context, builder) -> {
        LootDataManager lootDataManager = ((CommandListenerWrapper)context.getSource()).l().aH();
        return ICompletionProvider.a(lootDataManager.a(LootDataType.b), builder);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("item").requires(source -> source.c(2))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("replace").then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()).then(net.minecraft.commands.CommandDispatcher.a("with").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("item", ArgumentItemStack.a(commandRegistryAccess)).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), ArgumentItemStack.a(context, "item").a(1, false)))).then(net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), ArgumentItemStack.a(context, "item").a(IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), true))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("from").then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourceSlot", ArgumentInventorySlot.a()).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "sourceSlot"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("modifier", ArgumentMinecraftKeyRegistered.a()).suggests(g).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "sourceSlot"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), ArgumentMinecraftKeyRegistered.d((CommandContext<CommandListenerWrapper>)context, "modifier")))))))).then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentEntity.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourceSlot", ArgumentInventorySlot.a()).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "sourceSlot"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("modifier", ArgumentMinecraftKeyRegistered.a()).suggests(g).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "sourceSlot"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), ArgumentMinecraftKeyRegistered.d((CommandContext<CommandListenerWrapper>)context, "modifier")))))))))))).then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()).then(net.minecraft.commands.CommandDispatcher.a("with").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("item", ArgumentItemStack.a(commandRegistryAccess)).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), ArgumentItemStack.a(context, "item").a(1, false)))).then(net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)1, (int)64)).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), ArgumentItemStack.a(context, "item").a(IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), true))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("from").then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourceSlot", ArgumentInventorySlot.a()).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "sourceSlot"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("modifier", ArgumentMinecraftKeyRegistered.a()).suggests(g).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "sourceSlot"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), ArgumentMinecraftKeyRegistered.d((CommandContext<CommandListenerWrapper>)context, "modifier")))))))).then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentEntity.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourceSlot", ArgumentInventorySlot.a()).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "sourceSlot"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("modifier", ArgumentMinecraftKeyRegistered.a()).suggests(g).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "sourceSlot"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), ArgumentMinecraftKeyRegistered.d((CommandContext<CommandListenerWrapper>)context, "modifier"))))))))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("modify").then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()).then(net.minecraft.commands.CommandDispatcher.a("modifier", ArgumentMinecraftKeyRegistered.a()).suggests(g).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), ArgumentMinecraftKeyRegistered.d((CommandContext<CommandListenerWrapper>)context, "modifier")))))))).then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()).then(net.minecraft.commands.CommandDispatcher.a("modifier", ArgumentMinecraftKeyRegistered.a()).suggests(g).executes(context -> ItemCommands.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), ArgumentMinecraftKeyRegistered.d((CommandContext<CommandListenerWrapper>)context, "modifier"))))))))));
    }

    private static int a(CommandListenerWrapper source, BlockPosition pos, int slot, LootItemFunction modifier) throws CommandSyntaxException {
        IInventory container = ItemCommands.a(source, pos, a);
        if (slot < 0 || slot >= container.b()) {
            throw b.create((Object)slot);
        }
        ItemStack itemStack = ItemCommands.a(source, modifier, container.a(slot));
        container.a(slot, itemStack);
        source.a(() -> IChatBaseComponent.a("commands.item.block.set.success", pos.u(), pos.v(), pos.w(), itemStack.J()), true);
        return 1;
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, int slot, LootItemFunction modifier) throws CommandSyntaxException {
        HashMap map = Maps.newHashMapWithExpectedSize((int)targets.size());
        for (Entity entity : targets) {
            ItemStack itemStack;
            SlotAccess slotAccess = entity.a_(slot);
            if (slotAccess == SlotAccess.b || !slotAccess.a(itemStack = ItemCommands.a(source, modifier, slotAccess.a().p()))) continue;
            map.put(entity, itemStack);
            if (!(entity instanceof EntityPlayer)) continue;
            ((EntityPlayer)entity).bS.d();
        }
        if (map.isEmpty()) {
            throw e.create((Object)slot);
        }
        if (map.size() == 1) {
            Map.Entry entry = map.entrySet().iterator().next();
            source.a(() -> IChatBaseComponent.a("commands.item.entity.set.success.single", ((Entity)entry.getKey()).N_(), ((ItemStack)entry.getValue()).J()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.item.entity.set.success.multiple", map.size()), true);
        }
        return map.size();
    }

    private static int a(CommandListenerWrapper source, BlockPosition pos, int slot, ItemStack stack) throws CommandSyntaxException {
        IInventory container = ItemCommands.a(source, pos, a);
        if (slot < 0 || slot >= container.b()) {
            throw b.create((Object)slot);
        }
        container.a(slot, stack);
        source.a(() -> IChatBaseComponent.a("commands.item.block.set.success", pos.u(), pos.v(), pos.w(), stack.J()), true);
        return 1;
    }

    private static IInventory a(CommandListenerWrapper source, BlockPosition pos, Dynamic3CommandExceptionType exception) throws CommandSyntaxException {
        TileEntity blockEntity = source.e().c_(pos);
        if (!(blockEntity instanceof IInventory)) {
            throw exception.create((Object)pos.u(), (Object)pos.v(), (Object)pos.w());
        }
        return (IInventory)((Object)blockEntity);
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, int slot, ItemStack stack) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayListWithCapacity((int)targets.size());
        for (Entity entity : targets) {
            SlotAccess slotAccess = entity.a_(slot);
            if (slotAccess == SlotAccess.b || !slotAccess.a(stack.p())) continue;
            list.add(entity);
            if (!(entity instanceof EntityPlayer)) continue;
            ((EntityPlayer)entity).bS.d();
        }
        if (list.isEmpty()) {
            throw f.create((Object)stack.J(), (Object)slot);
        }
        if (list.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.item.entity.set.success.single", ((Entity)list.iterator().next()).N_(), stack.J()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.item.entity.set.success.multiple", list.size(), stack.J()), true);
        }
        return list.size();
    }

    private static int a(CommandListenerWrapper source, BlockPosition sourcePos, int sourceSlot, Collection<? extends Entity> targets, int slot) throws CommandSyntaxException {
        return ItemCommands.a(source, targets, slot, ItemCommands.a(source, sourcePos, sourceSlot));
    }

    private static int a(CommandListenerWrapper source, BlockPosition sourcePos, int sourceSlot, Collection<? extends Entity> targets, int slot, LootItemFunction modifier) throws CommandSyntaxException {
        return ItemCommands.a(source, targets, slot, ItemCommands.a(source, modifier, ItemCommands.a(source, sourcePos, sourceSlot)));
    }

    private static int a(CommandListenerWrapper source, BlockPosition sourcePos, int sourceSlot, BlockPosition pos, int slot) throws CommandSyntaxException {
        return ItemCommands.a(source, pos, slot, ItemCommands.a(source, sourcePos, sourceSlot));
    }

    private static int a(CommandListenerWrapper source, BlockPosition sourcePos, int sourceSlot, BlockPosition pos, int slot, LootItemFunction modifier) throws CommandSyntaxException {
        return ItemCommands.a(source, pos, slot, ItemCommands.a(source, modifier, ItemCommands.a(source, sourcePos, sourceSlot)));
    }

    private static int a(CommandListenerWrapper source, Entity sourceEntity, int sourceSlot, BlockPosition pos, int slot) throws CommandSyntaxException {
        return ItemCommands.a(source, pos, slot, ItemCommands.a(sourceEntity, sourceSlot));
    }

    private static int a(CommandListenerWrapper source, Entity sourceEntity, int sourceSlot, BlockPosition pos, int slot, LootItemFunction modifier) throws CommandSyntaxException {
        return ItemCommands.a(source, pos, slot, ItemCommands.a(source, modifier, ItemCommands.a(sourceEntity, sourceSlot)));
    }

    private static int a(CommandListenerWrapper source, Entity sourceEntity, int sourceSlot, Collection<? extends Entity> targets, int slot) throws CommandSyntaxException {
        return ItemCommands.a(source, targets, slot, ItemCommands.a(sourceEntity, sourceSlot));
    }

    private static int a(CommandListenerWrapper source, Entity sourceEntity, int sourceSlot, Collection<? extends Entity> targets, int slot, LootItemFunction modifier) throws CommandSyntaxException {
        return ItemCommands.a(source, targets, slot, ItemCommands.a(source, modifier, ItemCommands.a(sourceEntity, sourceSlot)));
    }

    private static ItemStack a(CommandListenerWrapper source, LootItemFunction modifier, ItemStack stack) {
        WorldServer serverLevel = source.e();
        LootParams lootParams = new LootParams.a(serverLevel).a(LootContextParameters.f, source.d()).b(LootContextParameters.a, source.f()).a(LootContextParameterSets.d);
        LootTableInfo lootContext = new LootTableInfo.Builder(lootParams).a(Optional.empty());
        lootContext.b(LootTableInfo.a(modifier));
        return (ItemStack)modifier.apply(stack, lootContext);
    }

    private static ItemStack a(Entity entity, int slotId) throws CommandSyntaxException {
        SlotAccess slotAccess = entity.a_(slotId);
        if (slotAccess == SlotAccess.b) {
            throw d.create((Object)slotId);
        }
        return slotAccess.a().p();
    }

    private static ItemStack a(CommandListenerWrapper source, BlockPosition pos, int slotId) throws CommandSyntaxException {
        IInventory container = ItemCommands.a(source, pos, c);
        if (slotId < 0 || slotId >= container.b()) {
            throw d.create((Object)slotId);
        }
        return container.a(slotId).p();
    }
}

