/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.FileUtils;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.FileZipper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import org.slf4j.Logger;

public class PerfCommand {
    private static final Logger a = LogUtils.getLogger();
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.perf.notRunning"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.perf.alreadyRunning"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("perf").requires(source -> source.c(4))).then(net.minecraft.commands.CommandDispatcher.a("start").executes(context -> PerfCommand.a((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("stop").executes(context -> PerfCommand.b((CommandListenerWrapper)context.getSource())))));
    }

    private static int a(CommandListenerWrapper source) throws CommandSyntaxException {
        MinecraftServer minecraftServer = source.l();
        if (minecraftServer.aN()) {
            throw c.create();
        }
        Consumer<MethodProfilerResults> consumer = result -> PerfCommand.a(source, result);
        Consumer<Path> consumer2 = dumpDirectory -> PerfCommand.a(source, dumpDirectory, minecraftServer);
        minecraftServer.a(consumer, consumer2);
        source.a(() -> IChatBaseComponent.c("commands.perf.started"), false);
        return 0;
    }

    private static int b(CommandListenerWrapper source) throws CommandSyntaxException {
        MinecraftServer minecraftServer = source.l();
        if (!minecraftServer.aN()) {
            throw b.create();
        }
        minecraftServer.aP();
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static void a(CommandListenerWrapper source, Path tempProfilingDirectory, MinecraftServer server) {
        void string3;
        String string = String.format(Locale.ROOT, "%s-%s-%s", SystemUtils.e(), server.aT().g(), SharedConstants.b().b());
        try {
            String string2 = FileUtils.a(MetricsPersister.a, string, ".zip");
        }
        catch (IOException iOException) {
            source.b(IChatBaseComponent.c("commands.perf.reportFailed"));
            a.error("Failed to create report name", (Throwable)iOException);
            return;
        }
        try (FileZipper fileZipper = new FileZipper(MetricsPersister.a.resolve((String)string3));){
            fileZipper.a(Paths.get("system.txt", new String[0]), server.b(new SystemReport()).a());
            fileZipper.a(tempProfilingDirectory);
        }
        try {
            org.apache.commons.io.FileUtils.forceDelete((File)tempProfilingDirectory.toFile());
        }
        catch (IOException iOException2) {
            a.warn("Failed to delete temporary profiling file {}", (Object)tempProfilingDirectory, (Object)iOException2);
        }
        source.a(() -> PerfCommand.a((String)string3), false);
    }

    private static void a(CommandListenerWrapper source, MethodProfilerResults result) {
        if (result == MethodProfilerResultsEmpty.a) {
            return;
        }
        int i2 = result.f();
        double d2 = (double)result.g() / (double)TimeRange.a;
        source.a(() -> IChatBaseComponent.a("commands.perf.stopped", new Object[]{String.format(Locale.ROOT, "%.2f", d2), i2, String.format(Locale.ROOT, "%.2f", (double)i2 / d2)}), false);
    }

    private static /* synthetic */ IChatBaseComponent a(String string) {
        return IChatBaseComponent.a("commands.perf.reportSaved", new Object[]{string});
    }
}

