/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomSequences;

public class RandomCommand {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.random.error.range_too_large"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.random.error.range_too_small"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("random").then(RandomCommand.a("value", false))).then(RandomCommand.a("roll", true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("reset").requires(source -> source.c(2))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("*").executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource()))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("seed", IntegerArgumentType.integer()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("includeWorldSeed", BoolArgumentType.bool()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeWorldSeed"), true))).then(net.minecraft.commands.CommandDispatcher.a("includeSequenceId", BoolArgumentType.bool()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeSequenceId")))))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sequence", ArgumentMinecraftKeyRegistered.a()).suggests(RandomCommand::a).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "sequence")))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("seed", IntegerArgumentType.integer()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "sequence"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("includeWorldSeed", BoolArgumentType.bool()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "sequence"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeWorldSeed"), true))).then(net.minecraft.commands.CommandDispatcher.a("includeSequenceId", BoolArgumentType.bool()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "sequence"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeSequenceId"))))))))));
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> a(String argumentName, boolean roll) {
        return (LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a(argumentName).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("range", ArgumentCriterionValue.a()).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), ArgumentCriterionValue.b.a((CommandContext<CommandListenerWrapper>)context, "range"), null, roll))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sequence", ArgumentMinecraftKeyRegistered.a()).suggests(RandomCommand::a).requires(source -> source.c(2))).executes(context -> RandomCommand.a((CommandListenerWrapper)context.getSource(), ArgumentCriterionValue.b.a((CommandContext<CommandListenerWrapper>)context, "range"), ArgumentMinecraftKeyRegistered.e((CommandContext<CommandListenerWrapper>)context, "sequence"), roll))));
    }

    private static CompletableFuture<Suggestions> a(CommandContext<CommandListenerWrapper> context, SuggestionsBuilder suggestionsBuilder) {
        ArrayList list = Lists.newArrayList();
        ((CommandListenerWrapper)context.getSource()).e().H().a((id, sequence) -> list.add(id.toString()));
        return ICompletionProvider.b(list, suggestionsBuilder);
    }

    private static int a(CommandListenerWrapper source, CriterionConditionValue.IntegerRange range, @Nullable MinecraftKey sequenceId, boolean roll) throws CommandSyntaxException {
        RandomSource randomSource2;
        if (sequenceId != null) {
            RandomSource randomSource = source.e().a(sequenceId);
        } else {
            randomSource2 = source.e().D_();
        }
        int i2 = range.a().orElse(Integer.MIN_VALUE);
        int j2 = range.b().orElse(Integer.MAX_VALUE);
        long l2 = (long)j2 - (long)i2;
        if (l2 == 0L) {
            throw b.create();
        }
        if (l2 >= Integer.MAX_VALUE) {
            throw a.create();
        }
        int k2 = MathHelper.b(randomSource2, i2, j2);
        if (roll) {
            source.l().ac().a(IChatBaseComponent.a("commands.random.roll", source.b(), k2, i2, j2), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.random.sample.success", k2), false);
        }
        return k2;
    }

    private static int a(CommandListenerWrapper source, MinecraftKey sequenceId) throws CommandSyntaxException {
        source.e().H().b(sequenceId);
        source.a(() -> IChatBaseComponent.a("commands.random.reset.success", sequenceId), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, MinecraftKey sequenceId, int salt, boolean includeWorldSeed, boolean includeSequenceId) throws CommandSyntaxException {
        source.e().H().a(sequenceId, salt, includeWorldSeed, includeSequenceId);
        source.a(() -> IChatBaseComponent.a("commands.random.reset.success", sequenceId), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source) {
        int i2 = source.e().H().a();
        source.a(() -> IChatBaseComponent.a("commands.random.reset.all.success", i2), false);
        return i2;
    }

    private static int a(CommandListenerWrapper source, int salt, boolean includeWorldSeed, boolean includeSequenceId) {
        RandomSequences randomSequences = source.e().H();
        randomSequences.a(salt, includeWorldSeed, includeSequenceId);
        int i2 = randomSequences.a();
        source.a(() -> IChatBaseComponent.a("commands.random.reset.all.success", i2), false);
        return i2;
    }
}

