/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.destroystokyo.paper.Metrics;
import com.destroystokyo.paper.VersionHistoryManager;
import com.destroystokyo.paper.console.PaperConsole;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.unix.DomainSocketAddress;
import io.papermc.paper.brigadier.PaperBrigadierProviderImpl;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.command.PaperCommands;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.ObfHelper;
import io.papermc.paper.util.ServerEnvironment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.logging.Handler;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.gui.ServerGUI;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListenerFactory;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.rcon.RemoteControlCommandListener;
import net.minecraft.server.rcon.thread.RemoteControlListener;
import net.minecraft.server.rcon.thread.RemoteStatusListener;
import net.minecraft.util.MathHelper;
import net.minecraft.util.monitoring.jmx.MinecraftServerBeans;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.storage.Convertable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.io.IoBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_20_R2.util.ForwardLogHandler;
import org.bukkit.craftbukkit.v1_20_R2.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;
import top.leavesmc.leaves.LeavesConfig;

public class DedicatedServer
extends MinecraftServer
implements IMinecraftServer {
    static final Logger n = LogUtils.getLogger();
    private static final int o = 5000;
    private static final int p = 2;
    private final Queue<ServerCommand> serverCommandQueue = new ConcurrentLinkedQueue<ServerCommand>();
    @Nullable
    private RemoteStatusListener r;
    @Nullable
    private RemoteControlListener t;
    public DedicatedServerSettings u;
    @Nullable
    private ServerGUI v;
    @Nullable
    private final TextFilter w;
    static final AtomicInteger ASYNC_DEBUG_CHUNKS_COUNT = new AtomicInteger();

    public DedicatedServer(OptionSet options, WorldLoader.a worldLoader, Thread thread, Convertable.ConversionSession convertable_conversionsession, ResourcePackRepository resourcepackrepository, WorldStem worldstem, DedicatedServerSettings dedicatedserversettings, DataFixer datafixer, Services services, WorldLoadListenerFactory worldloadlistenerfactory) {
        super(options, worldLoader, thread, convertable_conversionsession, resourcepackrepository, worldstem, Proxy.NO_PROXY, datafixer, services, worldloadlistenerfactory);
        this.u = dedicatedserversettings;
        this.w = TextFilter.a(dedicatedserversettings.a().R);
    }

    @Override
    public boolean e() throws IOException {
        String proxyLink;
        Object bindAddress;
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                if (!Main.useConsole) {
                    return;
                }
                new PaperConsole(DedicatedServer.this).start();
            }
        };
        java.util.logging.Logger global = java.util.logging.Logger.getLogger("");
        global.setUseParentHandlers(false);
        for (Handler handler : global.getHandlers()) {
            global.removeHandler(handler);
        }
        global.addHandler(new ForwardLogHandler());
        org.apache.logging.log4j.Logger logger = LogManager.getRootLogger();
        System.setOut(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.WARN).buildPrintStream());
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(n));
        n.info("Starting minecraft server version {}", (Object)SharedConstants.b().c());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            n.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        if (ServerEnvironment.userIsRootOrAdmin()) {
            n.warn("****************************");
            n.warn("YOU ARE RUNNING THIS SERVER AS AN ADMINISTRATIVE OR ROOT USER. THIS IS NOT ADVISED.");
            n.warn("YOU ARE OPENING YOURSELF UP TO POTENTIAL RISKS WHEN DOING THIS.");
            n.warn("FOR MORE INFORMATION, SEE https://madelinemiller.dev/blog/root-minecraft-server/");
            n.warn("****************************");
        }
        n.info("Loading properties");
        DedicatedServerProperties dedicatedserverproperties = this.u.a();
        if (this.O()) {
            this.a_("127.0.0.1");
        } else {
            this.d(dedicatedserverproperties.a);
            this.e(dedicatedserverproperties.b);
            this.a_(dedicatedserverproperties.c);
        }
        this.a(new DedicatedPlayerList(this, this.aV(), this.i));
        SpigotConfig.init((File)this.options.valueOf("spigot-settings"));
        SpigotConfig.registerCommands();
        ((Object)((Object)ObfHelper.INSTANCE)).getClass();
        this.paperConfigurations.initializeGlobalConfiguration(this.aU());
        this.paperConfigurations.initializeWorldDefaultsConfiguration(this.aU());
        if (this.bi()) {
            this.ap().save(false);
        }
        this.bg().loadAndSaveFiles();
        WatchdogThread.doStart(SpigotConfig.timeoutTime, SpigotConfig.restartOnCrash);
        thread.start();
        PaperCommands.registerCommands(this);
        ((Object)((Object)VersionHistoryManager.INSTANCE)).getClass();
        ((Object)((Object)PaperBrigadierProviderImpl.INSTANCE)).getClass();
        LeavesConfig.init((File)this.options.valueOf("leaves-settings"));
        LeavesConfig.registerCommands();
        System.setProperty("spark.serverconfigs.extra", "leaves.yml");
        LocaleLanguage.loadI18N(LeavesConfig.serverLang);
        Metrics.PaperMetrics.startMetrics();
        this.f(dedicatedserverproperties.f);
        this.g(dedicatedserverproperties.g);
        this.d(dedicatedserverproperties.h);
        super.c(dedicatedserverproperties.U.get());
        this.h(dedicatedserverproperties.j);
        n.info("Default game type: {}", (Object)dedicatedserverproperties.l);
        if (this.u().startsWith("unix:")) {
            if (!Epoll.isAvailable()) {
                n.error("**** INVALID CONFIGURATION!");
                n.error("You are trying to use a Unix domain socket but you're not on a supported OS.");
                return false;
            }
            if (!GlobalConfiguration.get().proxies.velocity.enabled && !SpigotConfig.bungee) {
                n.error("**** INVALID CONFIGURATION!");
                n.error("Unix domain sockets require IPs to be forwarded from a proxy.");
                return false;
            }
            bindAddress = new DomainSocketAddress(this.u().substring("unix:".length()));
        } else {
            InetAddress inetaddress = null;
            if (!this.u().isEmpty()) {
                inetaddress = InetAddress.getByName(this.u());
            }
            if (this.M() < 0) {
                this.a(dedicatedserverproperties.n);
            }
            bindAddress = new InetSocketAddress(inetaddress, this.M());
        }
        this.P();
        n.info("Starting Minecraft server on {}:{}", (Object)(this.u().isEmpty() ? "*" : this.u()), (Object)this.M());
        try {
            this.ad().bind((SocketAddress)bindAddress);
        }
        catch (IOException ioexception) {
            n.warn("**** FAILED TO BIND TO PORT!");
            n.warn("The exception was: {}", (Object)ioexception.toString());
            n.warn("Perhaps a server is already running on that port?");
            return false;
        }
        this.server.loadPlugins();
        this.server.enablePlugins(PluginLoadOrder.STARTUP);
        boolean usingProxy = SpigotConfig.bungee || GlobalConfiguration.get().proxies.velocity.enabled;
        String proxyFlavor = GlobalConfiguration.get().proxies.velocity.enabled ? "Velocity" : "BungeeCord";
        String string = proxyLink = GlobalConfiguration.get().proxies.velocity.enabled ? "https://docs.papermc.io/velocity/security" : "http://www.spigotmc.org/wiki/firewall-guide/";
        if (!GlobalConfiguration.get().proxies.isProxyOnlineMode()) {
            n.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            n.warn("The server will make no attempt to authenticate usernames. Beware.");
            if (usingProxy) {
                n.warn("Whilst this makes it possible to use " + proxyFlavor + ", unless access to your server is properly restricted, it also opens up the ability for hackers to connect with any username they choose.");
                n.warn("Please see " + proxyLink + " for further information.");
            } else {
                n.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            }
            n.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (!NameReferencingFileConverter.e(this)) {
            return false;
        }
        long i2 = SystemUtils.c();
        TileEntitySkull.a(this.l, this);
        UserCache.a(this.U());
        n.info("Preparing level \"{}\"", (Object)this.q());
        this.loadLevel(this.h.b());
        long j2 = SystemUtils.c() - i2;
        String s2 = String.format(Locale.ROOT, "%.3fs", (double)j2 / 1.0E9);
        if (dedicatedserverproperties.o != null) {
            this.aI().a(GameRules.y).set(dedicatedserverproperties.o, null);
        }
        if (dedicatedserverproperties.p) {
            n.info("Starting GS4 status listener");
            this.r = RemoteStatusListener.a(this);
        }
        if (dedicatedserverproperties.r) {
            n.info("Starting remote control listener");
            this.t = RemoteControlListener.a(this);
        }
        if (dedicatedserverproperties.N) {
            MinecraftServerBeans.a(this);
            n.info("JMX monitoring enabled");
        }
        return true;
    }

    @Override
    public boolean W() {
        return this.a().d && super.W();
    }

    @Override
    public boolean Q() {
        return this.u.a().w && super.Q();
    }

    @Override
    public boolean X() {
        return this.u.a().e && super.X();
    }

    @Override
    public DedicatedServerProperties a() {
        return this.u.a();
    }

    @Override
    public void r() {
    }

    @Override
    public boolean h() {
        return this.a().u;
    }

    @Override
    public SystemReport a(SystemReport details) {
        details.a("Is Modded", () -> this.K().b());
        details.a("Type", () -> "Dedicated Server (map_server.txt)");
        return details;
    }

    @Override
    public void a(Path file) throws IOException {
        DedicatedServerProperties dedicatedserverproperties = this.a();
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(file, new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "sync-chunk-writes=%s%n", dedicatedserverproperties.M));
            bufferedwriter.write(String.format(Locale.ROOT, "gamemode=%s%n", dedicatedserverproperties.l));
            bufferedwriter.write(String.format(Locale.ROOT, "spawn-monsters=%s%n", dedicatedserverproperties.w));
            bufferedwriter.write(String.format(Locale.ROOT, "entity-broadcast-range-percentage=%d%n", dedicatedserverproperties.Q));
            bufferedwriter.write(String.format(Locale.ROOT, "max-world-size=%d%n", dedicatedserverproperties.L));
            bufferedwriter.write(String.format(Locale.ROOT, "spawn-npcs=%s%n", dedicatedserverproperties.e));
            bufferedwriter.write(String.format(Locale.ROOT, "view-distance=%d%n", dedicatedserverproperties.F));
            bufferedwriter.write(String.format(Locale.ROOT, "simulation-distance=%d%n", dedicatedserverproperties.G));
            bufferedwriter.write(String.format(Locale.ROOT, "spawn-animals=%s%n", dedicatedserverproperties.d));
            bufferedwriter.write(String.format(Locale.ROOT, "generate-structures=%s%n", dedicatedserverproperties.Y.c()));
            bufferedwriter.write(String.format(Locale.ROOT, "use-native=%s%n", dedicatedserverproperties.x));
            bufferedwriter.write(String.format(Locale.ROOT, "rate-limit=%d%n", dedicatedserverproperties.E));
        }
    }

    @Override
    public void g() {
        if (this.w != null) {
            this.w.close();
        }
        if (this.v != null) {
            this.v.b();
        }
        if (this.t != null) {
            this.t.stopNonBlocking();
        }
        if (this.r != null) {
            // empty if block
        }
        this.hasFullyShutdown = true;
        System.exit(this.abnormalExit ? 70 : 0);
    }

    @Override
    public void b(BooleanSupplier shouldKeepTicking) {
        super.b(shouldKeepTicking);
        this.bf();
    }

    @Override
    public boolean B() {
        return this.a().v;
    }

    public void a(String command, CommandListenerWrapper commandSource) {
        if (command.equalsIgnoreCase("paper debug chunks --async")) {
            n.info("Scheduling async debug chunks");
            Runnable run = () -> {
                n.info("Async debug chunks executing");
                ChunkTaskScheduler.dumpAllChunkLoadInfo(false);
                ConsoleCommandSender sender = MinecraftServer.getServer().console;
                File file = new File(new File(new File("."), "debug"), "chunks-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + ".txt");
                sender.sendMessage((Component)Component.text((String)("Writing chunk information dump to " + file), (TextColor)NamedTextColor.GREEN));
                try {
                    MCUtil.dumpChunks(file, true);
                    sender.sendMessage((Component)Component.text((String)"Successfully written chunk information!", (TextColor)NamedTextColor.GREEN));
                }
                catch (Throwable thr) {
                    MinecraftServer.n.warn("Failed to dump chunk information to file " + file.toString(), thr);
                    sender.sendMessage((Component)Component.text((String)"Failed to dump chunk information, see console", (TextColor)NamedTextColor.RED));
                }
            };
            Thread t2 = new Thread(run);
            t2.setName("Async debug thread #" + ASYNC_DEBUG_CHUNKS_COUNT.getAndIncrement());
            t2.setDaemon(true);
            t2.start();
            return;
        }
        this.serverCommandQueue.add(new ServerCommand(command, commandSource));
    }

    public void bf() {
        ServerCommand servercommand;
        while ((servercommand = this.serverCommandQueue.poll()) != null) {
            ServerCommandEvent event = new ServerCommandEvent((CommandSender)this.console, servercommand.a);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            servercommand = new ServerCommand(event.getCommand(), servercommand.b);
            this.server.dispatchServerCommand((CommandSender)this.console, servercommand);
        }
    }

    @Override
    public boolean l() {
        return true;
    }

    @Override
    public int m() {
        return this.a().E;
    }

    @Override
    public boolean n() {
        return this.a().x;
    }

    public DedicatedPlayerList bg() {
        return (DedicatedPlayerList)super.ac();
    }

    @Override
    public boolean p() {
        return true;
    }

    @Override
    public String b() {
        return this.u();
    }

    @Override
    public int d() {
        return this.M();
    }

    @Override
    public String f() {
        return this.aa();
    }

    public void bh() {
        if (this.v == null) {
            this.v = ServerGUI.a(this);
        }
    }

    @Override
    public boolean af() {
        return this.v != null;
    }

    @Override
    public boolean o() {
        return this.a().y;
    }

    @Override
    public int ah() {
        return this.a().z;
    }

    @Override
    public boolean a(WorldServer world, BlockPosition pos, EntityHuman player) {
        int j2;
        if (world.ac() != World.h) {
            return false;
        }
        if (this.bg().k().c()) {
            return false;
        }
        if (this.bg().f(player.fQ())) {
            return false;
        }
        if (this.ah() <= 0) {
            return false;
        }
        BlockPosition blockposition1 = world.R();
        int i2 = MathHelper.a(pos.u() - blockposition1.u());
        int k2 = Math.max(i2, j2 = MathHelper.a(pos.w() - blockposition1.w()));
        return k2 <= this.ah();
    }

    @Override
    public boolean ai() {
        return this.a().O;
    }

    @Override
    public boolean aj() {
        return this.a().P;
    }

    @Override
    public int i() {
        return this.a().A;
    }

    @Override
    public int j() {
        return this.a().B;
    }

    @Override
    public void c(int playerIdleTimeout) {
        super.c(playerIdleTimeout);
        this.u.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.U.a(this.aU(), playerIdleTimeout));
    }

    @Override
    public boolean k() {
        return this.a().J;
    }

    @Override
    public boolean T_() {
        return this.a().K;
    }

    @Override
    public int as() {
        return this.a().L;
    }

    @Override
    public int av() {
        return this.a().I;
    }

    @Override
    public boolean aw() {
        DedicatedServerProperties dedicatedserverproperties = this.a();
        return dedicatedserverproperties.W && GlobalConfiguration.get().proxies.isProxyOnlineMode() && this.l.a() != null && !LeavesConfig.noChatSign;
    }

    @Override
    public boolean be() {
        return this.a().X;
    }

    protected boolean bi() {
        int i2;
        boolean flag = false;
        for (i2 = 0; !flag && i2 <= 2; ++i2) {
            if (i2 > 0) {
                n.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.bs();
            }
            flag = NameReferencingFileConverter.a((MinecraftServer)this);
        }
        boolean flag1 = false;
        for (i2 = 0; !flag1 && i2 <= 2; ++i2) {
            if (i2 > 0) {
                n.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.bs();
            }
            flag1 = NameReferencingFileConverter.b(this);
        }
        boolean flag2 = false;
        for (i2 = 0; !flag2 && i2 <= 2; ++i2) {
            if (i2 > 0) {
                n.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.bs();
            }
            flag2 = NameReferencingFileConverter.c(this);
        }
        boolean flag3 = false;
        for (i2 = 0; !flag3 && i2 <= 2; ++i2) {
            if (i2 > 0) {
                n.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.bs();
            }
            flag3 = NameReferencingFileConverter.d(this);
        }
        boolean flag4 = false;
        for (i2 = 0; !flag4 && i2 <= 2; ++i2) {
            if (i2 > 0) {
                n.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.bs();
            }
            flag4 = NameReferencingFileConverter.a(this);
        }
        return flag || flag1 || flag2 || flag3 || flag4;
    }

    private void bs() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long bj() {
        return this.a().C;
    }

    @Override
    public int bc() {
        return this.a().D;
    }

    @Override
    public String s() {
        StringBuilder result = new StringBuilder();
        Plugin[] plugins = this.server.getPluginManager().getPlugins();
        result.append(this.server.getName());
        result.append(" on Bukkit ");
        result.append(this.server.getBukkitVersion());
        if (plugins.length > 0 && this.server.getQueryPlugins()) {
            result.append(": ");
            for (int i2 = 0; i2 < plugins.length; ++i2) {
                if (i2 > 0) {
                    result.append("; ");
                }
                result.append(plugins[i2].getDescription().getName());
                result.append(" ");
                result.append(plugins[i2].getDescription().getVersion().replaceAll(";", ","));
            }
        }
        return result.toString();
    }

    @Override
    public String a(String command) {
        throw new UnsupportedOperationException("Not supported - remote source required.");
    }

    public String runCommand(RemoteControlCommandListener rconConsoleSource, String s2) {
        Waitable[] waitableArray = new Waitable[1];
        rconConsoleSource.e();
        AtomicReference<String> command = new AtomicReference<String>(s2);
        this.h(() -> {
            CommandListenerWrapper wrapper = rconConsoleSource.g();
            RemoteServerCommandEvent event = new RemoteServerCommandEvent(rconConsoleSource.getBukkitSender(wrapper), s2);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            command.set(event.getCommand());
            ServerCommand serverCommand = new ServerCommand(event.getCommand(), wrapper);
            this.server.dispatchServerCommand(event.getSender(), serverCommand);
        });
        if (waitableArray[0] != null) {
            Waitable waitable = waitableArray[0];
            try {
                return (String)waitable.get();
            }
            catch (ExecutionException e2) {
                throw new RuntimeException("Exception processing rcon command " + command.get(), e2.getCause());
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted processing rcon command " + command.get(), e3);
            }
        }
        return rconConsoleSource.f();
    }

    @Override
    public void i(boolean useWhitelist) {
        this.u.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.V.a(this.aU(), useWhitelist));
    }

    @Override
    public void t() {
        super.t();
        TileEntitySkull.c();
    }

    @Override
    public boolean a(GameProfile profile) {
        return false;
    }

    @Override
    public int b(int initialDistance) {
        return this.a().Q * initialDistance / 100;
    }

    @Override
    public String q() {
        return this.h.b();
    }

    @Override
    public boolean aR() {
        return this.u.a().M;
    }

    @Override
    public ITextFilter a(EntityPlayer player) {
        return this.w != null ? this.w.a(player.fQ()) : ITextFilter.a;
    }

    @Override
    @Nullable
    public EnumGamemode aW() {
        return this.u.a().i ? this.m.m() : null;
    }

    @Override
    public Optional<MinecraftServer.ServerResourcePackInfo> S() {
        return this.u.a().S;
    }

    @Override
    public boolean isDebugging() {
        return this.a().debug;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.console;
    }
}

