/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.MoreObjects;
import com.mojang.logging.LogUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.core.IRegistryCustom;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class PropertyManager<T extends PropertyManager<T>> {
    private static final Logger a = LogUtils.getLogger();
    public final Properties Z;
    private static final boolean skipComments = Boolean.getBoolean("Paper.skipServerPropertiesComments");
    private OptionSet options = null;

    public PropertyManager(Properties properties, OptionSet options) {
        this.Z = properties;
        this.options = options;
    }

    private String getOverride(String name, String value) {
        if (this.options != null && this.options.has(name) && !name.equals("online-mode")) {
            return String.valueOf(this.options.valueOf(name));
        }
        return value;
    }

    public static Properties b(Path path) {
        try {
            if (!path.toFile().exists()) {
                return new Properties();
            }
            try {
                Properties properties1;
                try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);){
                    CharsetDecoder charsetdecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                    Properties properties = new Properties();
                    properties.load(new InputStreamReader(inputstream, charsetdecoder));
                    properties1 = properties;
                }
                return properties1;
            }
            catch (CharacterCodingException charactercodingexception) {
                Properties properties1;
                a.info("Failed to load properties as UTF-8 from file {}, trying ISO_8859_1", (Object)path);
                try (BufferedReader bufferedreader = Files.newBufferedReader(path, StandardCharsets.ISO_8859_1);){
                    Properties properties = new Properties();
                    properties.load(bufferedreader);
                    properties1 = properties;
                }
                return properties1;
            }
        }
        catch (IOException ioexception) {
            a.error("Failed to load properties from file: {}", (Object)path, (Object)ioexception);
            return new Properties();
        }
    }

    public void c(Path path) {
        try {
            if (path.toFile().exists() && !path.toFile().canWrite()) {
                a.warn("Can not write to file {}, skipping.", (Object)path);
                return;
            }
            OutputStream outputstream = Files.newOutputStream(path, new OpenOption[0]);
            BufferedOutputStream bufferedOutputStream = !skipComments ? new BufferedOutputStream(outputstream) : new BufferedOutputStream(outputstream){
                private boolean isRightAfterNewline;
                private boolean isComment;
                {
                    this.isRightAfterNewline = true;
                    this.isComment = false;
                }

                @Override
                public void write(@NotNull byte[] b2) throws IOException {
                    this.write(b2, 0, b2.length);
                }

                @Override
                public void write(@NotNull byte[] bbuf, int off, int len) throws IOException {
                    int latest_offset = off;
                    for (int index = off; index < off + len; ++index) {
                        boolean isNewline;
                        byte c2 = bbuf[index];
                        boolean bl = isNewline = c2 == 10 || c2 == 13;
                        if (isNewline && this.isComment) {
                            this.isComment = false;
                            latest_offset = index + 1;
                        }
                        if (c2 == 35 && this.isRightAfterNewline) {
                            this.isComment = true;
                            if (index != latest_offset) {
                                super.write(bbuf, latest_offset, index - latest_offset);
                            }
                        }
                        this.isRightAfterNewline = isNewline;
                    }
                    if (latest_offset < off + len && !this.isComment) {
                        super.write(bbuf, latest_offset, off + len - latest_offset);
                    }
                }
            };
            try (BufferedWriter bufferedwriter = new BufferedWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, StandardCharsets.UTF_8.newEncoder()));){
                this.Z.store(bufferedwriter, "Minecraft server properties");
            }
        }
        catch (IOException ioexception) {
            a.error("Failed to store properties to file: {}", (Object)path);
        }
    }

    private static <V extends Number> Function<String, V> a(Function<String, V> parser) {
        return s2 -> {
            try {
                return (Number)parser.apply((String)s2);
            }
            catch (NumberFormatException numberformatexception) {
                return null;
            }
        };
    }

    protected static <V> Function<String, V> a(IntFunction<V> intParser, Function<String, V> fallbackParser) {
        return s2 -> {
            try {
                return intParser.apply(Integer.parseInt(s2));
            }
            catch (NumberFormatException numberformatexception) {
                return fallbackParser.apply((String)s2);
            }
        };
    }

    @Nullable
    public String c(String key) {
        return this.getOverride(key, this.Z.getProperty(key));
    }

    @Nullable
    protected <V> V a(String key, Function<String, V> stringifier) {
        String s1 = this.c(key);
        if (s1 == null) {
            return null;
        }
        this.Z.remove(key);
        return stringifier.apply(s1);
    }

    protected <V> V a(String key, Function<String, V> parser, Function<V, String> stringifier, V fallback) {
        try {
            return this.get0(key, parser, stringifier, fallback);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not load invalidly configured property '" + key + "'", ex);
        }
    }

    private <V> V get0(String s2, Function<String, V> function, Function<V, String> function1, V v0) {
        String s1 = this.c(s2);
        Object v1 = MoreObjects.firstNonNull(s1 != null ? function.apply(s1) : null, v0);
        this.Z.put(s2, function1.apply(v1));
        return (V)v1;
    }

    protected <V> EditableProperty<V> b(String key, Function<String, V> parser, Function<V, String> stringifier, V fallback) {
        String s1 = this.c(key);
        Object v1 = MoreObjects.firstNonNull(s1 != null ? parser.apply(s1) : null, fallback);
        this.Z.put(key, stringifier.apply(v1));
        return new EditableProperty<Object>(key, v1, stringifier);
    }

    protected <V> V a(String key, Function<String, V> parser, UnaryOperator<V> parsedTransformer, Function<V, String> stringifier, V fallback) {
        return (V)this.a(key, s1 -> {
            Object v1 = parser.apply((String)s1);
            return v1 != null ? parsedTransformer.apply(v1) : null;
        }, stringifier, fallback);
    }

    protected <V> V a(String key, Function<String, V> parser, V fallback) {
        return (V)this.a(key, parser, Objects::toString, fallback);
    }

    protected <V> EditableProperty<V> b(String key, Function<String, V> parser, V fallback) {
        return this.b(key, parser, Objects::toString, fallback);
    }

    protected String a(String key, String fallback) {
        return this.a(key, Function.identity(), Function.identity(), fallback);
    }

    @Nullable
    protected String a(String key) {
        return (String)this.a(key, Function.identity());
    }

    protected int a(String key, int fallback) {
        return this.a(key, PropertyManager.a(Integer::parseInt), Integer.valueOf(fallback));
    }

    protected EditableProperty<Integer> b(String key, int fallback) {
        return this.b(key, PropertyManager.a(Integer::parseInt), fallback);
    }

    protected int a(String key, UnaryOperator<Integer> transformer, int fallback) {
        return this.a(key, PropertyManager.a(Integer::parseInt), transformer, Objects::toString, fallback);
    }

    protected long a(String key, long fallback) {
        return this.a(key, PropertyManager.a(Long::parseLong), fallback);
    }

    protected boolean a(String key, boolean fallback) {
        return this.a(key, Boolean::valueOf, fallback);
    }

    protected EditableProperty<Boolean> b(String key, boolean fallback) {
        return this.b(key, Boolean::valueOf, fallback);
    }

    @Nullable
    protected Boolean b(String key) {
        return this.a(key, Boolean::valueOf);
    }

    protected Properties a() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.Z);
        return properties;
    }

    protected abstract T reload(IRegistryCustom var1, Properties var2, OptionSet var3);

    public class EditableProperty<V>
    implements Supplier<V> {
        private final String b;
        private final V c;
        private final Function<V, String> d;

        EditableProperty(String s2, V object, Function function) {
            this.b = s2;
            this.c = object;
            this.d = function;
        }

        @Override
        public V get() {
            return this.c;
        }

        public T a(IRegistryCustom registryManager, V value) {
            Properties properties = PropertyManager.this.a();
            properties.put(this.b, this.d.apply(value));
            return PropertyManager.this.reload(registryManager, properties, PropertyManager.this.options);
        }
    }
}

