/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerLocaleChangeEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.chunk.system.RegionizedPlayerChunkLoader;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import io.papermc.paper.util.MCUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.translation.Translator;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMapBase;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.util.ReturnPortalManager;
import top.leavesmc.leaves.util.TickStatus;

public class EntityPlayer
extends EntityHuman {
    private static final Logger b = LogUtils.getLogger();
    public long lastSave = MinecraftServer.currentTick;
    private static final int cm = 32;
    private static final int cn = 10;
    public PlayerConnection c;
    public final MinecraftServer d;
    public final PlayerInteractManager e;
    private final AdvancementDataPlayer co;
    private final ServerStatisticManager cp;
    private float cq = Float.MIN_VALUE;
    private int cr = Integer.MIN_VALUE;
    private int cs = Integer.MIN_VALUE;
    private int ct = Integer.MIN_VALUE;
    private int cu = Integer.MIN_VALUE;
    private int cv = Integer.MIN_VALUE;
    private float cw = -1.0E8f;
    private int cx = -99999999;
    private boolean cy = true;
    public int cz = -99999999;
    public int cA = 60;
    private EnumChatVisibility cB;
    private boolean cC = true;
    private long cD;
    @Nullable
    private net.minecraft.world.entity.Entity cE;
    public boolean cF;
    public boolean cG;
    private final RecipeBookServer cH;
    @Nullable
    private Vec3D cI;
    private int cJ;
    private boolean cK;
    private int cL = 2;
    public String cM = null;
    public Locale adventure$locale = Locale.US;
    @Nullable
    private Vec3D cN;
    @Nullable
    private Vec3D cO;
    @Nullable
    private Vec3D cP;
    private SectionPosition cQ;
    private ChunkTrackingView cR;
    private ResourceKey<net.minecraft.world.level.World> cS;
    @Nullable
    private BlockPosition cT;
    private boolean cU;
    private float cV;
    private final ITextFilter cW;
    private boolean cX;
    private boolean cY;
    public WardenSpawnTracker cZ;
    public final ContainerSynchronizer da;
    private final ICrafting db;
    @Nullable
    private RemoteChatSession dc;
    private int dd;
    public boolean f;
    private int containerUpdateDelay;
    public long loginTime;
    public int patrolSpawnDelay;
    public boolean queueHealthUpdatePacket = false;
    public PacketPlayOutUpdateHealth queuedHealthUpdatePacket;
    public static final int MOBCATEGORY_TOTAL_ENUMS = EnumCreatureType.values().length;
    public final int[] mobCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final int[] mobBackoffCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public String displayName;
    public Component adventure$displayName;
    public IChatBaseComponent listName;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public boolean supressTrackerForLogin = false;
    public boolean isRealPlayer;
    public final PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> cachedSingleHashSet;
    public PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnedEvent;
    @Nullable
    public String clientBrandName = null;
    public PlayerQuitEvent.QuitReason quitReason = null;
    private int instaBreakCountPerTick = 0;
    private int placeBlockCountPerTick = 0;
    private final AtomicReference<RegionizedPlayerChunkLoader.ViewDistances> viewDistances = new AtomicReference<RegionizedPlayerChunkLoader.ViewDistances>(new RegionizedPlayerChunkLoader.ViewDistances(-1, -1, -1));
    public RegionizedPlayerChunkLoader.PlayerChunkLoaderData chunkLoader;
    public double lastEntitySpawnRadiusSquared = -1.0;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    public RegionizedPlayerChunkLoader.ViewDistances getViewDistances() {
        return this.viewDistances.get();
    }

    private void updateViewDistance(Function<RegionizedPlayerChunkLoader.ViewDistances, RegionizedPlayerChunkLoader.ViewDistances> update) {
        RegionizedPlayerChunkLoader.ViewDistances curr = this.viewDistances.get();
        while (!this.viewDistances.compareAndSet(curr, update.apply(curr))) {
        }
    }

    public void setTickViewDistance(int distance) {
        if (distance < 2 || distance > 32) {
            throw new IllegalArgumentException("Tick view distance must be a number between 2 and 32, got: " + distance);
        }
        this.updateViewDistance(input -> input.setTickViewDistance(distance));
    }

    public void setLoadViewDistance(int distance) {
        if (distance != -1 && (distance < 2 || distance > 33)) {
            throw new IllegalArgumentException("Load view distance must be a number between 2 and 33 or -1, got: " + distance);
        }
        this.updateViewDistance(input -> input.setLoadViewDistance(distance));
    }

    public void setSendViewDistance(int distance) {
        if (distance != -1 && (distance < 2 || distance > 33)) {
            throw new IllegalArgumentException("Send view distance must be a number between 2 and 33 or -1, got: " + distance);
        }
        this.updateViewDistance(input -> input.setSendViewDistance(distance));
    }

    public EntityPlayer(MinecraftServer server, WorldServer world, GameProfile profile, ClientInformation clientOptions) {
        super(world, world.R(), world.S(), profile);
        this.cB = EnumChatVisibility.a;
        this.cD = SystemUtils.b();
        this.cH = new RecipeBookServer();
        this.cQ = SectionPosition.a(0, 0, 0);
        this.cR = ChunkTrackingView.a;
        this.cS = net.minecraft.world.level.World.h;
        this.cZ = new WardenSpawnTracker(0, 0, 0);
        this.da = new ContainerSynchronizer(){

            @Override
            public void a(Container handler, NonNullList<ItemStack> stacks, ItemStack cursorStack, int[] properties) {
                EntityPlayer.this.c.b(new PacketPlayOutWindowItems(handler.j, handler.k(), stacks, cursorStack));
                for (int i2 = 0; i2 < properties.length; ++i2) {
                    this.b(handler, i2, properties[i2]);
                }
            }

            @Override
            public void sendOffHandSlotChange() {
                EntityPlayer.this.c.b(new PacketPlayOutSetSlot(EntityPlayer.this.bR.j, EntityPlayer.this.bR.k(), 45, EntityPlayer.this.bR.b(45).e().p()));
            }

            @Override
            public void a(Container handler, int slot, ItemStack stack) {
                EntityPlayer.this.c.b(new PacketPlayOutSetSlot(handler.j, handler.k(), slot, stack));
            }

            @Override
            public void a(Container handler, ItemStack stack) {
                EntityPlayer.this.c.b(new PacketPlayOutSetSlot(-1, handler.k(), -1, stack));
            }

            @Override
            public void a(Container handler, int property, int value) {
                this.b(handler, property, value);
            }

            private void b(Container handler, int property, int value) {
                EntityPlayer.this.c.b(new PacketPlayOutWindowData(handler.j, property, value));
            }
        };
        this.db = new ICrafting(){

            @Override
            public void a(Container handler, int slotId, ItemStack stack) {
                Slot slot = handler.b(slotId);
                if (!(slot instanceof SlotResult) && slot.d == EntityPlayer.this.fR()) {
                    CriterionTriggers.e.a(EntityPlayer.this, EntityPlayer.this.fR(), stack);
                }
            }

            @Override
            public void slotChanged(Container handler, int slotId, ItemStack oldStack, ItemStack stack) {
                Slot slot = handler.b(slotId);
                if (!(slot instanceof SlotResult) && slot.d == EntityPlayer.this.fR()) {
                    if (PlayerInventorySlotChangeEvent.getHandlerList().getRegisteredListeners().length == 0) {
                        CriterionTriggers.e.a(EntityPlayer.this, EntityPlayer.this.fR(), stack);
                        return;
                    }
                    PlayerInventorySlotChangeEvent event = new PlayerInventorySlotChangeEvent((Player)EntityPlayer.this.getBukkitEntity(), slotId, CraftItemStack.asBukkitCopy(oldStack), CraftItemStack.asBukkitCopy(stack));
                    event.callEvent();
                    if (event.shouldTriggerAdvancements()) {
                        CriterionTriggers.e.a(EntityPlayer.this, EntityPlayer.this.fR(), stack);
                    }
                }
            }

            @Override
            public void a(Container handler, int property, int value) {
            }
        };
        this.cW = server.a(this);
        this.e = server.b(this);
        this.d = server;
        this.cp = server.ac().getPlayerStats(this);
        this.co = server.ac().f(this);
        this.t(1.0f);
        this.updateOptionsNoEvents(clientOptions);
        this.cachedSingleHashSet = new PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer>(this);
        this.displayName = this.cx();
        this.adventure$displayName = Component.text((String)this.cx());
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.eL();
    }

    public final BlockPosition getSpawnPoint(WorldServer worldserver) {
        BlockPosition blockposition = worldserver.R();
        if (worldserver.C_().g() && worldserver.K.m() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.d.a(worldserver));
            int j2 = MathHelper.a(worldserver.B_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.u(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(worldserver, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                return blockposition1;
            }
        }
        return blockposition;
    }

    public void e(WorldServer world) {
        BlockPosition blockposition = world.R();
        if (world.C_().g() && world.K.m() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.d.a(world));
            int j2 = MathHelper.a(world.B_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.u(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(world, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                this.a(blockposition1, world.S(), 0.0f);
                if (!world.noCollision(this, this.cG(), true)) {
                    continue;
                }
                break;
            }
        } else {
            this.a(blockposition, world.S(), 0.0f);
            while (!world.noCollision(this, this.cG(), true) && this.ds() < (double)(world.aj() - 1)) {
                this.e(this.dq(), this.ds() + 1.0, this.dw());
            }
        }
    }

    private int u(int horizontalSpawnArea) {
        return horizontalSpawnArea <= 16 ? horizontalSpawnArea - 1 : 17;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        String spawnWorld;
        CraftWorld oldWorld;
        super.a(nbt);
        if (nbt.b("warden_spawn_tracker", 10)) {
            DataResult dataresult = WardenSpawnTracker.a.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("warden_spawn_tracker")));
            Logger logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(wardenspawntracker -> {
                this.cZ = wardenspawntracker;
            });
        }
        if (nbt.b("enteredNetherPosition", 10)) {
            NBTTagCompound nbttagcompound1 = nbt.p("enteredNetherPosition");
            this.cO = new Vec3D(nbttagcompound1.k("x"), nbttagcompound1.k("y"), nbttagcompound1.k("z"));
        }
        this.cG = nbt.q("seenCredits");
        if (nbt.b("recipeBook", 10)) {
            this.cH.a(nbt.p("recipeBook"), this.d.aE());
        }
        this.getBukkitEntity().readExtraData(nbt);
        if (this.fC()) {
            this.fD();
        }
        if ((oldWorld = (CraftWorld)Bukkit.getWorld((String)(spawnWorld = nbt.l("SpawnWorld")))) != null) {
            this.cS = oldWorld.getHandle().ac();
        }
        if (nbt.b("SpawnX", 99) && nbt.b("SpawnY", 99) && nbt.b("SpawnZ", 99)) {
            this.cT = new BlockPosition(nbt.h("SpawnX"), nbt.h("SpawnY"), nbt.h("SpawnZ"));
            this.cU = nbt.q("SpawnForced");
            this.cV = nbt.j("SpawnAngle");
            if (nbt.e("SpawnDimension")) {
                DataResult dataresult1 = net.minecraft.world.level.World.g.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("SpawnDimension"));
                Logger logger1 = b;
                Objects.requireNonNull(logger1);
                this.cS = dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).orElse(net.minecraft.world.level.World.h);
            }
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = WardenSpawnTracker.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cZ);
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("warden_spawn_tracker", (NBTBase)nbtbase));
        this.k(nbt);
        nbt.a("seenCredits", this.cG);
        if (this.cO != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.a("x", this.cO.c);
            nbttagcompound1.a("y", this.cO.d);
            nbttagcompound1.a("z", this.cO.e);
            nbt.a("enteredNetherPosition", nbttagcompound1);
        }
        net.minecraft.world.entity.Entity entity = this.cV();
        net.minecraft.world.entity.Entity entity1 = this.cY();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (net.minecraft.world.entity.Entity vehicle = entity1; vehicle != null; vehicle = vehicle.cY()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.cU() && !entity.dG()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            NBTTagCompound nbttagcompound3 = new NBTTagCompound();
            entity.e(nbttagcompound3);
            nbttagcompound2.a("Attach", entity1.cv());
            nbttagcompound2.a("Entity", nbttagcompound3);
            nbt.a("RootVehicle", nbttagcompound2);
        }
        nbt.a("recipeBook", this.cH.b());
        nbt.a("Dimension", this.dL().ac().a().toString());
        if (this.cT != null) {
            nbt.a("SpawnX", this.cT.u());
            nbt.a("SpawnY", this.cT.v());
            nbt.a("SpawnZ", this.cT.w());
            nbt.a("SpawnForced", this.cU);
            nbt.a("SpawnAngle", this.cV);
            dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cS.a());
            logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("SpawnDimension", (NBTBase)nbtbase));
        }
        this.getBukkitEntity().setExtraData(nbt);
    }

    public void spawnIn(net.minecraft.world.level.World world) {
        this.a(world);
        if (world == null) {
            this.dI();
            Vec3D position = null;
            if (this.cS != null && (world = this.d.a(this.cS)) != null && this.P() != null) {
                position = EntityHuman.a((WorldServer)world, this.P(), this.Q(), false, false).orElse(null);
            }
            if (world == null || position == null) {
                world = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
                position = Vec3D.b(world.R());
            }
            this.a(world);
            this.p(position.a(), position.b(), position.c());
        }
        this.e.a((WorldServer)world);
    }

    public void a(int points) {
        float f2 = this.ga();
        float f1 = (f2 - 1.0f) / f2;
        this.ch = MathHelper.a((float)points / f2, 0.0f, f1);
        this.cz = -1;
    }

    public void b(int level) {
        this.cf = level;
        this.cz = -1;
    }

    @Override
    public void c(int levels) {
        super.c(levels);
        this.cz = -1;
    }

    @Override
    public void a(ItemStack enchantedItem, int experienceLevels) {
        super.a(enchantedItem, experienceLevels);
        this.cz = -1;
    }

    public void a(Container screenHandler) {
        screenHandler.a(this.db);
        screenHandler.a(this.da);
    }

    public void h() {
        this.a(this.bR);
    }

    @Override
    public void e_() {
        super.e_();
        this.c.b(new ClientboundPlayerCombatEnterPacket());
    }

    @Override
    public void f_() {
        super.f_();
        this.c.b(new ClientboundPlayerCombatEndPacket(this.eJ()));
    }

    @Override
    protected void a(IBlockData state) {
        CriterionTriggers.d.a(this, state);
    }

    @Override
    protected ItemCooldown k() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void l() {
        net.minecraft.world.entity.Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.resetOperationCountPerTick();
        this.e.a();
        this.cZ.a();
        --this.cA;
        if (this.al > 0) {
            --this.al;
        }
        if (!(this instanceof ServerBot)) {
            if (--this.containerUpdateDelay <= 0) {
                this.bS.d();
                this.containerUpdateDelay = this.dL().paperConfig().tickRates.containerUpdate;
            }
            if (!(this.dL().B || this.bS == this.bR || !this.eX() && this.bS.a(this))) {
                this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
                this.bS = this.bR;
            }
        }
        if ((entity = this.I()) != this) {
            if (entity.bv()) {
                this.a(entity.dq(), entity.ds(), entity.dw(), entity.dB(), entity.dD());
                this.x().k().a(this);
                if (this.fI()) {
                    this.c((net.minecraft.world.entity.Entity)this);
                }
            } else {
                this.c((net.minecraft.world.entity.Entity)this);
            }
        }
        if (!(this instanceof ServerBot)) {
            CriterionTriggers.w.a(this);
        }
        if (this.cI != null) {
            CriterionTriggers.u.a(this, this.cI, this.ah - this.cJ);
        }
        this.o();
        this.p();
        this.co.b(this);
    }

    public void m() {
        try {
            if (this.valid && !this.M_() || !this.dd()) {
                super.l();
            }
            for (int i2 = 0; i2 < this.fR().b(); ++i2) {
                Packet<?> packet;
                ItemStack itemstack = this.fR().a(i2);
                if (!itemstack.d().ah_() || (packet = ((ItemWorldMapBase)itemstack.d()).a(itemstack, this.dL(), this)) == null) continue;
                this.c.b(packet);
            }
            if (this.eu() != this.cw || this.cx != this.bT.a() || this.bT.e() == 0.0f != this.cy) {
                this.c.b(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.bT.a(), this.bT.e()));
                this.cw = this.eu();
                this.cx = this.bT.a();
                boolean bl = this.cy = this.bT.e() == 0.0f;
            }
            if (this.eu() + this.fj() != this.cq) {
                this.cq = this.eu() + this.fj();
                this.a(IScoreboardCriteria.f, MathHelper.f(this.cq));
            }
            if (this.bT.a() != this.cr) {
                this.cr = this.bT.a();
                this.a(IScoreboardCriteria.g, MathHelper.f((float)this.cr));
            }
            if (this.ch() != this.cs) {
                this.cs = this.ch();
                this.a(IScoreboardCriteria.h, MathHelper.f((float)this.cs));
            }
            if (this.eI() != this.ct) {
                this.ct = this.eI();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.ct));
            }
            if (this.cg != this.cv) {
                this.cv = this.cg;
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.cv));
            }
            if (this.maxHealthCache != (double)this.eL()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cf != this.cu) {
                this.cu = this.cf;
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.cu));
            }
            if (this.cg != this.cz) {
                this.cz = this.cg;
                this.c.b(new PacketPlayOutExperience(this.ch, this.cg, this.cf));
            }
            if (this.ah % 20 == 0) {
                CriterionTriggers.p.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cf;
            }
            if (this.oldLevel != this.cf) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cf);
                this.oldLevel = this.cf;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void n() {
        if (this.eu() > 0.0f && this.cN != null) {
            CriterionTriggers.U.a(this, this.cN);
        }
        this.cN = null;
        super.n();
    }

    public void o() {
        if (this.ab > 0.0f && this.cN == null) {
            this.cN = this.dj();
        }
    }

    public void p() {
        if (this.cY() != null && this.cY().bl()) {
            if (this.cP == null) {
                this.cP = this.dj();
            } else {
                CriterionTriggers.V.a(this, this.cP);
            }
        }
        if (!(this.cP == null || this.cY() != null && this.cY().bl())) {
            this.cP = null;
        }
    }

    private void a(IScoreboardCriteria criterion, int score) {
        this.dL().getCraftServer().getScoreboardManager().getScoreboardScores(criterion, this.cx(), scoreboardscore -> scoreboardscore.b(score));
    }

    private static void processKeep(PlayerDeathEvent event, NonNullList<ItemStack> inv) {
        List itemsToKeep = event.getItemsToKeep();
        if (inv == null) {
            if (!itemsToKeep.isEmpty()) {
                for (org.bukkit.inventory.ItemStack itemStack : itemsToKeep) {
                    event.getEntity().getInventory().addItem(new org.bukkit.inventory.ItemStack[]{itemStack});
                }
            }
            return;
        }
        for (int i2 = 0; i2 < inv.size(); ++i2) {
            ItemStack item = inv.get(i2);
            if (EnchantmentManager.e(item) || itemsToKeep.isEmpty() || item.b()) {
                inv.set(i2, ItemStack.b);
                continue;
            }
            org.bukkit.inventory.ItemStack bukkitStack = item.getBukkitStack();
            boolean keep = false;
            Iterator iterator = itemsToKeep.iterator();
            while (iterator.hasNext()) {
                org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)iterator.next();
                if (!bukkitStack.equals((Object)itemStack)) continue;
                iterator.remove();
                keep = true;
                break;
            }
            if (keep) continue;
            inv.set(i2, ItemStack.b);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        TextComponent deathMessage;
        boolean keepInventory;
        this.a(GameEvent.p);
        boolean flag = this.dL().X().b(GameRules.m);
        if (this.dG()) {
            return;
        }
        ArrayList<Entity.DefaultDrop> loot = new ArrayList<Entity.DefaultDrop>(this.fR().b());
        boolean bl = keepInventory = this.dL().X().b(GameRules.d) || this.M_();
        if (!keepInventory || this instanceof ServerBot) {
            for (ItemStack item : this.fR().getContents()) {
                if (item.b() || EnchantmentManager.e(item)) continue;
                loot.add(new Entity.DefaultDrop(item, stack -> this.a((ItemStack)stack, true, false)));
            }
        }
        if (this.ec() && this.dL().X().b(GameRules.f)) {
            this.a(damageSource, this.aZ > 0);
            loot.addAll(this.drops);
            this.drops.clear();
        }
        IChatBaseComponent defaultMessage = this.eJ().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, loot, PaperAdventure.asAdventure(defaultMessage), defaultMessage.getString(), keepInventory);
        if (event.isCancelled()) {
            if (this.eu() <= 0.0f) {
                this.c((float)event.getReviveHealth());
            }
            return;
        }
        if (this.bS != this.bR) {
            this.closeContainer(InventoryCloseEvent.Reason.DEATH);
        }
        Object object = deathMessage = event.deathMessage() != null ? event.deathMessage() : Component.empty();
        if (deathMessage != null && deathMessage != Component.empty() && flag) {
            IChatBaseComponent ichatbasecomponent = PaperAdventure.asVanilla((Component)deathMessage);
            this.c.a(new ClientboundPlayerCombatKillPacket(this.ah(), ichatbasecomponent), PacketSendListener.a(() -> {
                boolean flag1 = true;
                String s2 = ichatbasecomponent.a(256);
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(s2).a(EnumChatFormat.o));
                IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("death.attack.even_more_magic", this.N_()).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, ichatmutablecomponent)));
                return new ClientboundPlayerCombatKillPacket(this.ah(), ichatmutablecomponent1);
            }));
            ScoreboardTeamBase scoreboardTeamBase = this.cf();
            if (scoreboardTeamBase != null && scoreboardTeamBase.k() != ScoreboardTeamBase.EnumNameTagVisibility.a) {
                if (scoreboardTeamBase.k() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                    this.d.ac().a((EntityHuman)this, ichatbasecomponent);
                } else if (scoreboardTeamBase.k() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                    this.d.ac().b(this, ichatbasecomponent);
                }
            } else {
                this.d.ac().a(ichatbasecomponent, false);
            }
        } else {
            this.c.b(new ClientboundPlayerCombatKillPacket(this.ah(), CommonComponents.a));
        }
        this.gf();
        if (this.dL().X().b(GameRules.J)) {
            this.gr();
        }
        if (event.shouldDropExperience()) {
            this.ey();
        }
        if (!event.getKeepInventory()) {
            for (NonNullList nonNullList : this.fR().o) {
                EntityPlayer.processKeep(event, nonNullList);
            }
            EntityPlayer.processKeep(event, null);
        }
        this.c((net.minecraft.world.entity.Entity)this);
        this.dL().getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.c, this.cx(), ScoreboardScore::a);
        EntityLiving entityliving = this.eK();
        if (entityliving != null) {
            this.b(StatisticList.h.b(entityliving.ag()));
            entityliving.a((net.minecraft.world.entity.Entity)this, this.bh, damageSource);
            this.f(entityliving);
        }
        this.dL().a((net.minecraft.world.entity.Entity)this, (byte)3);
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.ay();
        this.k(0);
        this.a_(false);
        this.eJ().c();
        ((EntityHuman)this).a(Optional.of(GlobalPos.a(this.dL().ac(), this.dl())));
    }

    private void gr() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.dl()).c(32.0, 10.0, 32.0);
        this.dL().a(EntityInsentient.class, axisalignedbb, IEntitySelector.f).stream().filter(entityinsentient -> entityinsentient instanceof IEntityAngerable).forEach(entityinsentient -> ((IEntityAngerable)((Object)entityinsentient)).a_(this));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled != this) {
            super.a(entityKilled, score, damageSource);
            this.s(score);
            String s2 = this.cx();
            String s1 = entityKilled.cx();
            this.dL().getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.e, s2, ScoreboardScore::a);
            if (entityKilled instanceof EntityHuman) {
                this.a(StatisticList.Q);
                this.dL().getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.d, s2, ScoreboardScore::a);
            } else {
                this.a(StatisticList.O);
            }
            this.a(s2, s1, IScoreboardCriteria.l);
            this.a(s1, s2, IScoreboardCriteria.m);
            CriterionTriggers.b.a(this, entityKilled, damageSource);
        }
    }

    private void a(String playerName, String team, IScoreboardCriteria[] criterions) {
        int i2;
        ScoreboardTeam scoreboardteam = this.gg().g(team);
        if (scoreboardteam != null && (i2 = scoreboardteam.n().b()) >= 0 && i2 < criterions.length) {
            this.dL().getCraftServer().getScoreboardManager().getScoreboardScores(criterions[i2], playerName, ScoreboardScore::a);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        EntityHuman entityhuman1;
        EntityArrow entityarrow;
        net.minecraft.world.entity.Entity entity1;
        EntityHuman entityhuman;
        boolean flag;
        if (this.b(source)) {
            return false;
        }
        boolean bl = flag = this.d.l() && this.gs() && source.a(DamageTypeTags.m);
        if (!flag && this.cA > 0 && !source.a(DamageTypeTags.d)) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = source.d();
        if (entity instanceof EntityHuman && !this.a(entityhuman = (EntityHuman)entity)) {
            return false;
        }
        if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).v()) instanceof EntityHuman && !this.a(entityhuman1 = (EntityHuman)entity1)) {
            return false;
        }
        this.queueHealthUpdatePacket = true;
        boolean damaged = super.a(source, amount);
        this.queueHealthUpdatePacket = false;
        if (this.queuedHealthUpdatePacket != null) {
            this.c.b(this.queuedHealthUpdatePacket);
            this.queuedHealthUpdatePacket = null;
        }
        return damaged;
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.gs() ? false : super.a(player);
    }

    private boolean gs() {
        return this.dL().pvpMode;
    }

    @Override
    @Nullable
    protected ShapeDetectorShape a(WorldServer destination) {
        ShapeDetectorShape shapedetectorshape = super.a(destination);
        WorldServer worldServer = destination = shapedetectorshape == null ? destination : shapedetectorshape.world;
        if (shapedetectorshape != null && this.dL().getTypeKey() == WorldDimension.b && destination != null && destination.getTypeKey() == WorldDimension.d) {
            Vec3D vec3d = shapedetectorshape.a.b(0.0, -1.0, 0.0);
            return new ShapeDetectorShape(vec3d, Vec3D.b, 90.0f, 0.0f, destination, shapedetectorshape.portalEventInfo);
        }
        return shapedetectorshape;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity b(WorldServer destination) {
        return this.changeDimension(destination, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @Nullable
    public net.minecraft.world.entity.Entity changeDimension(WorldServer worldserver, PlayerTeleportEvent.TeleportCause cause) {
        if (this.fC()) {
            return this;
        }
        WorldServer worldserver1 = this.x();
        ResourceKey<WorldDimension> resourcekey = worldserver1.getTypeKey();
        if (resourcekey == WorldDimension.d && worldserver != null && worldserver.getTypeKey() == WorldDimension.b) {
            this.cF = true;
            this.ae();
            this.x().a(this, Entity.RemovalReason.e);
            if (!this.f) {
                if (this.dL().paperConfig().misc.disableEndCredits) {
                    this.cG = true;
                }
                this.f = true;
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, this.cG ? 0.0f : 1.0f));
                this.cG = true;
            }
            return this;
        }
        ShapeDetectorShape shapedetectorshape = this.a(worldserver);
        if (shapedetectorshape != null) {
            worldserver1.ad().a("moving");
            worldserver = shapedetectorshape.world;
            if (worldserver != null) {
                if (resourcekey == WorldDimension.b && worldserver.getTypeKey() == WorldDimension.c) {
                    this.cO = this.dj();
                } else if (worldserver.getTypeKey() == WorldDimension.d && shapedetectorshape.portalEventInfo != null && shapedetectorshape.portalEventInfo.getCanCreatePortal()) {
                    this.a(worldserver, BlockPosition.a(shapedetectorshape.a));
                }
            }
        } else {
            return null;
        }
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = worldserver == null ? null : CraftLocation.toBukkit(shapedetectorshape.a, (World)worldserver.getWorld(), shapedetectorshape.c, shapedetectorshape.d);
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, cause);
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        if (tpEvent.isCancelled() || tpEvent.getTo() == null) {
            return null;
        }
        exit = tpEvent.getTo();
        worldserver = ((CraftWorld)exit.getWorld()).getHandle();
        worldserver1.ad().c();
        worldserver1.ad().a("placing");
        this.cF = true;
        this.c.b(new PacketPlayOutRespawn(this.d(worldserver), 3));
        this.c.b(new PacketPlayOutServerDifficulty(worldserver.ai(), this.dL().z_().t()));
        PlayerList playerlist = this.d.ac();
        playerlist.d(this);
        worldserver1.a(this, Entity.RemovalReason.e);
        this.dI();
        this.c(worldserver);
        this.c.teleport(exit);
        this.c.m();
        if (LeavesConfig.fixPaper9372) {
            this.aD = Optional.empty();
        }
        worldserver.b(this);
        worldserver1.ad().c();
        this.f(worldserver1);
        this.c.b(new PacketPlayOutAbilities(this.fS()));
        playerlist.a(this, worldserver);
        playerlist.e(this);
        for (MobEffect mobeffect : this.er()) {
            this.c.b(new PacketPlayOutEntityEffect(this.ah(), mobeffect));
        }
        this.c.b(new PacketPlayOutWorldEvent(1032, BlockPosition.b, 0, false));
        this.cz = -1;
        this.cw = -1.0f;
        this.cx = -1;
        if (LeavesConfig.fakeplayerSupport) {
            ServerBot.getBots().forEach(bot1 -> bot1.sendFakeDataIfNeed(this, true));
        }
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.dL().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        if (LeavesConfig.netherPortalFix) {
            BlockPosition lastPos;
            ResourceKey<net.minecraft.world.level.World> fromDim = worldserver1.ac();
            ResourceKey<net.minecraft.world.level.World> toDim = this.dL().ac();
            ResourceKey<net.minecraft.world.level.World> OVERWORLD = net.minecraft.world.level.World.h;
            ResourceKey<net.minecraft.world.level.World> THE_NETHER = net.minecraft.world.level.World.i;
            if ((fromDim == OVERWORLD && toDim == THE_NETHER || fromDim == THE_NETHER && toDim == OVERWORLD) && (lastPos = ((EntityLiving)this).cc) != null) {
                BlockUtil.Rectangle fromPortal = ReturnPortalManager.findPortalAt(this, fromDim, lastPos);
                BlockPosition toPos = this.dl();
                if (fromPortal != null) {
                    ReturnPortalManager.storeReturnPortal(this, toDim, toPos, fromPortal);
                }
            }
        }
        if (this.ft()) {
            this.fs();
        }
        return this;
    }

    @Override
    protected CraftPortalEvent callPortalEvent(net.minecraft.world.entity.Entity entity, WorldServer exitWorldServer, Vec3D exitPosition, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = CraftLocation.toBukkit(exitPosition, (World)exitWorldServer.getWorld(), this.dB(), this.dD());
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    private void a(WorldServer world, BlockPosition centerPos) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = centerPos.j();
        BlockStateListPopulator blockList = new BlockStateListPopulator(world);
        for (int i2 = -2; i2 <= 2; ++i2) {
            for (int j2 = -2; j2 <= 2; ++j2) {
                for (int k2 = -1; k2 < 3; ++k2) {
                    IBlockData iblockdata = k2 == -1 ? Blocks.co.n() : Blocks.a.n();
                    blockList.a((BlockPosition)blockposition_mutableblockposition.g(centerPos).e(j2, k2, i2), iblockdata, 3);
                }
            }
        }
        PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), (World)world.getWorld(), (Entity)this.getBukkitEntity(), PortalCreateEvent.CreateReason.END_PLATFORM);
        world.getCraftServer().getPluginManager().callEvent((Event)portalEvent);
        if (!portalEvent.isCancelled()) {
            blockList.updateList();
        }
    }

    @Override
    protected Optional<BlockUtil.Rectangle> getExitPortal(WorldServer worldserver, BlockPosition blockposition, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        Optional<BlockUtil.Rectangle> optional = super.getExitPortal(worldserver, blockposition, flag, worldborder, searchRadius, canCreatePortal, createRadius);
        if (LeavesConfig.netherPortalFix) {
            WorldServer toLevel;
            MinecraftServer server;
            ReturnPortalManager.ReturnPortal returnPortal;
            boolean isTeleportBetweenNetherAndOverworld;
            BlockPosition fromPos = this.dl();
            ResourceKey<net.minecraft.world.level.World> fromDim = this.dL().ac();
            ResourceKey<net.minecraft.world.level.World> toDim = this.dL().ac();
            ResourceKey<net.minecraft.world.level.World> OVERWORLD = net.minecraft.world.level.World.h;
            ResourceKey<net.minecraft.world.level.World> THE_NETHER = net.minecraft.world.level.World.i;
            boolean bl = isTeleportBetweenNetherAndOverworld = fromDim == OVERWORLD && toDim == THE_NETHER || fromDim == THE_NETHER && toDim == OVERWORLD;
            if (this.av && isTeleportBetweenNetherAndOverworld && (returnPortal = ReturnPortalManager.findReturnPortal(this, fromDim, fromPos)) != null && (server = this.cK()) != null && (toLevel = server.a(toDim)) != null) {
                return Optional.of(returnPortal.rectangle());
            }
        }
        if (optional.isPresent() || !canCreatePortal) {
            return optional;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis = this.dL().a_(this.ax).d(BlockPortal.a).orElse(EnumDirection.EnumAxis.a);
        Optional<BlockUtil.Rectangle> optional1 = worldserver.o().createPortal(blockposition, enumdirection_enumaxis, this, createRadius);
        if (optional1.isEmpty()) {
            // empty if block
        }
        return optional1;
    }

    public void f(WorldServer origin) {
        ResourceKey<net.minecraft.world.level.World> resourcekey = origin.ac();
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = this.dL().ac();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(origin);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.dL());
        if (GlobalConfiguration.get().misc.strictAdvancementDimensionCheck) {
            maindimensionkey = resourcekey;
            maindimensionkey1 = resourcekey1;
        }
        CriterionTriggers.v.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriterionTriggers.v.a(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.i && maindimensionkey1 == net.minecraft.world.level.World.h && this.cO != null) {
            CriterionTriggers.C.a(this, this.cO);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.i) {
            this.cO = null;
        }
    }

    @Override
    public boolean a(EntityPlayer spectator) {
        return spectator.M_() ? this.I() == this : (this.M_() ? false : super.a(spectator));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity item, int count) {
        super.a(item, count);
        this.bS.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition blockposition, EnumDirection enumdirection) {
        if (!this.fC() && this.bv()) {
            if (!this.dL().C_().j() || !this.dL().C_().l()) {
                return Either.left(EntityHuman.EnumBedResult.a);
            }
            if (!this.a(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.c);
            }
            if (this.b(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.d);
            }
            this.setRespawnPosition(this.dL().ac(), blockposition, this.dB(), false, true, PlayerSetSpawnEvent.Cause.BED);
            if (this.dL().N()) {
                return Either.left(EntityHuman.EnumBedResult.b);
            }
            if (!this.f()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3D vec3d = Vec3D.c(blockposition);
                List<EntityMonster> list = this.dL().a(EntityMonster.class, new AxisAlignedBB(vec3d.a() - 8.0, vec3d.b() - 5.0, vec3d.c() - 8.0, vec3d.a() + 8.0, vec3d.b() + 5.0, vec3d.c() + 8.0), (? super T entitymonster) -> entitymonster.f(this));
                if (!list.isEmpty()) {
                    return Either.left(EntityHuman.EnumBedResult.f);
                }
            }
            return Either.right(Unit.a);
        }
        return Either.left(EntityHuman.EnumBedResult.e);
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        EnumDirection enumdirection = this.dL().a_(blockposition).c(BlockFacingHorizontal.aC);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right(Unit.a);
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either<EntityHuman.EnumBedResult, Unit> either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.a(StatisticList.ap);
            CriterionTriggers.q.a(this);
        });
        if (!this.x().d()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        ((WorldServer)this.dL()).e();
        return either;
    }

    @Override
    public void b(BlockPosition pos) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(pos);
    }

    private boolean a(BlockPosition pos, EnumDirection direction) {
        return this.i(pos) || this.i(pos.a(direction.g()));
    }

    private boolean i(BlockPosition pos) {
        Vec3D vec3d = Vec3D.c(pos);
        return Math.abs(this.dq() - vec3d.a()) <= 3.0 && Math.abs(this.ds() - vec3d.b()) <= 2.0 && Math.abs(this.dw() - vec3d.c()) <= 3.0;
    }

    private boolean b(BlockPosition pos, EnumDirection direction) {
        BlockPosition blockposition1 = pos.c();
        return !this.h(blockposition1) || !this.h(blockposition1.a(direction.g()));
    }

    @Override
    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        if (!this.fC()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.fA().orElse(null);
        Block bed = bedPosition != null ? this.dL().getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.dL().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.dL().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.fC()) {
            this.x().k().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(skipSleepTimer, updateSleepingPlayers);
        if (this.c != null) {
            this.c.teleport(this.dq(), this.ds(), this.dw(), this.dB(), this.dD(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public void a(double destX, double destY, double destZ) {
        this.bB();
        this.e(destX, destY, destZ);
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return super.b(damageSource) || this.M() || !this.dL().paperConfig().collisions.allowPlayerCrammingDamage && damageSource == this.dM().g();
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
    }

    @Override
    protected void c(BlockPosition pos) {
        if (!this.M_()) {
            super.c(pos);
        }
    }

    public void a(double xDifference, double yDifference, double zDifference, boolean onGround) {
        if (!this.dd()) {
            this.b(onGround, new Vec3D(xDifference, yDifference, zDifference));
            BlockPosition blockposition = this.aF();
            super.a(yDifference, onGround, this.dL().a_(blockposition), blockposition);
        }
    }

    @Override
    public void a(TileEntitySign sign, boolean front) {
        this.c.b(new PacketPlayOutBlockChange(this.dL(), sign.p()));
        this.c.b(new PacketPlayOutOpenSignEditor(sign.p(), front));
    }

    public int nextContainerCounter() {
        this.dd = this.dd % 100 + 1;
        return this.dd;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory factory) {
        if (factory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container container = factory.createMenu(this.dd, this.fR(), this);
        IChatBaseComponent title = null;
        if (container != null) {
            container.setTitle(factory.N_());
            boolean cancelled = false;
            Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(this, container, cancelled);
            container = (Container)result.getSecond();
            title = PaperAdventure.asVanilla((Component)result.getFirst());
            if (container == null && !cancelled) {
                if (factory instanceof IInventory) {
                    ((IInventory)((Object)factory)).c(this);
                } else if (factory instanceof BlockChest.DoubleInventory) {
                    ((BlockChest.DoubleInventory)factory).inventorylargechest.c(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.M_()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.bS = container;
        if (!this.eX()) {
            this.c.b(new PacketPlayOutOpenWindow(container.j, container.a(), Objects.requireNonNullElseGet(title, container::getTitle)));
        }
        this.a(container);
        return OptionalInt.of(this.dd);
    }

    @Override
    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
        this.c.b(new PacketPlayOutOpenWindowMerchant(syncId, offers, levelProgress, experience, leveled, refreshable));
    }

    @Override
    public void a(EntityHorseAbstract horse, IInventory inventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.dd, this.fR(), inventory, horse);
        container.setTitle(horse.N_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            inventory.c(this);
            return;
        }
        if (this.bS != this.bR) {
            this.closeContainer(InventoryCloseEvent.Reason.OPEN_NEW);
        }
        this.c.b(new PacketPlayOutOpenWindowHorse(this.dd, inventory.b(), horse.ah()));
        this.bS = container;
        this.a(this.bS);
    }

    @Override
    public void a(ItemStack book, EnumHand hand) {
        if (book.a(Items.th)) {
            if (ItemWrittenBook.a(book, this.dc(), this)) {
                this.bS.d();
            }
            this.c.b(new PacketPlayOutOpenBook(hand));
        }
    }

    @Override
    public void a(TileEntityCommand commandBlock) {
        this.c.b(PacketPlayOutTileEntityData.a(commandBlock, TileEntity::o));
    }

    @Override
    public void q() {
        this.closeContainer(InventoryCloseEvent.Reason.UNKNOWN);
    }

    @Override
    public void closeContainer(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.c.b(new PacketPlayOutCloseWindow(this.bS.j));
        this.r();
    }

    @Override
    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.c.b(new PacketPlayOutCloseWindow(this.bS.j));
        this.bS = this.bR;
    }

    @Override
    public void r() {
        this.bS.b(this);
        this.bR.a(this.bS);
        this.bS = this.bR;
    }

    public void a(float sidewaysSpeed, float forwardSpeed, boolean jumping, boolean sneaking) {
        if (this.bN()) {
            if (sidewaysSpeed >= -1.0f && sidewaysSpeed <= 1.0f) {
                this.bk = sidewaysSpeed;
            }
            if (forwardSpeed >= -1.0f && forwardSpeed <= 1.0f) {
                this.bm = forwardSpeed;
            }
            this.bj = jumping;
            if (sneaking != this.bR()) {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getBukkitEntity(), sneaking);
                this.d.server.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            this.f(sneaking);
        }
    }

    @Override
    public void a(Statistic<?> stat, int amount) {
        this.cp.b(this, stat, amount);
        this.dL().getCraftServer().getScoreboardManager().getScoreboardScores(stat, this.cx(), scoreboardscore -> scoreboardscore.a(amount));
    }

    @Override
    public void a(Statistic<?> stat) {
        this.cp.a(this, stat, 0);
        this.dL().getCraftServer().getScoreboardManager().getScoreboardScores(stat, this.cx(), ScoreboardScore::c);
    }

    @Override
    public int a(Collection<RecipeHolder<?>> recipes) {
        return this.cH.a(recipes, this);
    }

    @Override
    public void a(RecipeHolder<?> recipe, List<ItemStack> ingredients) {
        CriterionTriggers.Z.a(this, recipe.a(), ingredients);
    }

    @Override
    public void a(MinecraftKey[] ids) {
        ArrayList list = Lists.newArrayList();
        MinecraftKey[] aminecraftkey1 = ids;
        int i2 = ids.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            MinecraftKey minecraftkey = aminecraftkey1[j2];
            Optional<RecipeHolder<?>> optional = this.d.aE().a(minecraftkey);
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
        }
        this.a(list);
    }

    @Override
    public int b(Collection<RecipeHolder<?>> recipes) {
        return this.cH.b(recipes, this);
    }

    @Override
    public void d(int experience) {
        super.d(experience);
        this.cz = -1;
    }

    public void s() {
        this.cK = true;
        this.bA();
        if (this.bN() && this.cY() instanceof EntityPlayer) {
            this.aa();
        }
        if (this.fC()) {
            this.a(true, false);
        }
    }

    public boolean t() {
        return this.cK;
    }

    public void u() {
        this.cw = -1.0E8f;
        this.cz = -1;
    }

    @Override
    public void a(IChatBaseComponent message, boolean overlay) {
        this.b(message, overlay);
    }

    @Override
    protected void ad_() {
        if (!this.bv.b() && this.fm()) {
            this.c.b(new PacketPlayOutEntityStatus(this, 9));
            super.ad_();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        super.a(anchorPoint, target);
        this.c.b(new PacketPlayOutLookAt(anchorPoint, target.c, target.d, target.e));
    }

    public void a(ArgumentAnchor.Anchor anchorPoint, net.minecraft.world.entity.Entity targetEntity, ArgumentAnchor.Anchor targetAnchor) {
        Vec3D vec3d = targetAnchor.a(targetEntity);
        super.a(anchorPoint, vec3d);
        this.c.b(new PacketPlayOutLookAt(anchorPoint, targetEntity, targetAnchor));
    }

    public void a(EntityPlayer oldPlayer, boolean alive) {
        this.cZ = oldPlayer.cZ;
        this.dc = oldPlayer.dc;
        this.e.a(oldPlayer.e.b(), oldPlayer.e.c());
        this.w();
        if (alive) {
            this.fR().a(oldPlayer.fR());
            this.c(oldPlayer.eu());
            this.bT = oldPlayer.bT;
            this.cf = oldPlayer.cf;
            this.cg = oldPlayer.cg;
            this.ch = oldPlayer.ch;
            this.r(oldPlayer.fM());
            this.ax = oldPlayer.ax;
        } else if (this.dL().X().b(GameRules.d) || oldPlayer.M_()) {
            this.fR().a(oldPlayer.fR());
            this.cf = oldPlayer.cf;
            this.cg = oldPlayer.cg;
            this.ch = oldPlayer.ch;
            this.r(oldPlayer.fM());
        }
        this.ci = oldPlayer.ci;
        this.bQ = oldPlayer.bQ;
        this.al().b(EntityHuman.bM, oldPlayer.al().b(EntityHuman.bM));
        this.cz = -1;
        this.cw = -1.0f;
        this.cx = -1;
        this.cG = oldPlayer.cG;
        this.cO = oldPlayer.cO;
        this.cR = oldPlayer.cR;
        this.i(oldPlayer.gi());
        this.j(oldPlayer.gj());
        ((EntityHuman)this).a(oldPlayer.gq());
    }

    @Override
    protected void a(MobEffect effect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, source);
        this.c.b(new PacketPlayOutEntityEffect(this.ah(), effect));
        if (effect.c() == MobEffects.y) {
            this.cJ = this.ah;
            this.cI = this.dj();
        }
        CriterionTriggers.A.a(this, source);
    }

    @Override
    protected void a(MobEffect effect, boolean reapplyEffect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, reapplyEffect, source);
        this.c.b(new PacketPlayOutEntityEffect(this.ah(), effect));
        CriterionTriggers.A.a(this, source);
    }

    @Override
    protected void a(MobEffect effect) {
        super.a(effect);
        this.c.b(new PacketPlayOutRemoveEntityEffect(this.ah(), effect.c()));
        if (effect.c() == MobEffects.y) {
            this.cI = null;
        }
        CriterionTriggers.A.a(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void b(double destX, double destY, double destZ) {
        this.c.a(destX, destY, destZ, this.dB(), this.dD(), RelativeMovement.g);
    }

    @Override
    public void c(double offsetX, double offsetY, double offsetZ) {
        this.c.a(this.dq() + offsetX, this.ds() + offsetY, this.dw() + offsetZ, this.dB(), this.dD(), RelativeMovement.f);
    }

    @Override
    public boolean a(WorldServer world, double destX, double destY, double destZ, Set<RelativeMovement> flags, float yaw, float pitch) {
        return this.teleportTo(world, destX, destY, destZ, flags, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @Override
    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(d0, d1, d2));
        worldserver.k().a(TicketType.g, chunkcoordintpair, 1, this.ah());
        this.aa();
        if (this.fC()) {
            this.a(true, true);
        }
        if (worldserver == this.dL()) {
            this.c.teleport(d0, d1, d2, f2, f1, set, cause);
        } else {
            this.teleportTo(worldserver, d0, d1, d2, f2, f1, cause);
        }
        this.n(f2);
        return true;
    }

    @Override
    public void d(double x2, double y2, double z2) {
        super.d(x2, y2, z2);
        this.c.m();
        if (LeavesConfig.fixPaper9372) {
            this.aD = Optional.empty();
        }
    }

    @Override
    public void a(net.minecraft.world.entity.Entity target) {
        this.x().k().a(this, new PacketPlayOutAnimation(target, 4));
    }

    @Override
    public void b(net.minecraft.world.entity.Entity target) {
        this.x().k().a(this, new PacketPlayOutAnimation(target, 5));
    }

    @Override
    public void w() {
        if (this.c != null) {
            this.c.b(new PacketPlayOutAbilities(this.fS()));
            this.H();
        }
    }

    public WorldServer x() {
        return (WorldServer)this.dL();
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event == null ? false : event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent setGameMode(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component message) {
        PlayerGameModeChangeEvent event = this.e.changeGameModeForPlayer(gameMode, cause, message);
        if (event == null || event.isCancelled()) {
            return null;
        }
        this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, gameMode.a()));
        if (gameMode == EnumGamemode.d) {
            this.gf();
            this.aa();
        } else {
            this.c((net.minecraft.world.entity.Entity)this);
        }
        this.w();
        this.fk();
        return event;
    }

    @Override
    public boolean M_() {
        return this.e.b() == EnumGamemode.d;
    }

    @Override
    public boolean f() {
        return this.e.b() == EnumGamemode.b;
    }

    @Override
    public void a(IChatBaseComponent message) {
        this.b(message, false);
    }

    public void b(IChatBaseComponent message, boolean overlay) {
        if (this.v(overlay)) {
            this.c.a(new ClientboundSystemChatPacket(PaperAdventure.asAdventure(message), overlay), PacketSendListener.a(() -> {
                if (this.v(false)) {
                    boolean flag1 = true;
                    String s2 = message.a(256);
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.b(s2).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(PaperAdventure.asAdventure(IChatBaseComponent.a("multiplayer.message_not_delivered", ichatmutablecomponent).a(EnumChatFormat.m)), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage message, boolean filterMaskEnabled, ChatMessageType.a params) {
        this.sendChatMessage(message, filterMaskEnabled, params, null);
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filterMaskEnabled, ChatMessageType.a params, @Nullable IChatBaseComponent unsigned) {
        if (this.gu()) {
            message.sendToPlayer(this, filterMaskEnabled, params, unsigned);
        }
    }

    public String y() {
        SocketAddress socketaddress = this.c.n();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    private Map<ClientOption<?>, ?> getClientOptionMap(String locale, int viewDistance, ClientOption.ChatVisibility chatVisibility, boolean chatColors, PaperSkinParts skinParts, MainHand mainHand, boolean allowsServerListing, boolean textFilteringEnabled) {
        HashMap<ClientOption, Object> map = new HashMap<ClientOption, Object>();
        map.put(ClientOption.LOCALE, locale);
        map.put(ClientOption.VIEW_DISTANCE, viewDistance);
        map.put(ClientOption.CHAT_VISIBILITY, chatVisibility);
        map.put(ClientOption.CHAT_COLORS_ENABLED, chatColors);
        map.put(ClientOption.SKIN_PARTS, skinParts);
        map.put(ClientOption.MAIN_HAND, mainHand);
        map.put(ClientOption.ALLOW_SERVER_LISTINGS, allowsServerListing);
        map.put(ClientOption.TEXT_FILTERING_ENABLED, textFilteringEnabled);
        return map;
    }

    public void a(ClientInformation clientOptions) {
        PlayerChangedMainHandEvent event;
        new PlayerClientOptionsChangeEvent((Player)this.getBukkitEntity(), this.getClientOptionMap(clientOptions.b(), clientOptions.c(), ClientOption.ChatVisibility.valueOf((String)clientOptions.d().name()), clientOptions.e(), new PaperSkinParts(clientOptions.f()), clientOptions.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT, clientOptions.i(), clientOptions.h())).callEvent();
        if (this.fl() != clientOptions.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.fl() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.d.server.getPluginManager().callEvent((Event)event);
        }
        if (this.cM == null || !this.cM.equals(clientOptions.b())) {
            event = new org.bukkit.event.player.PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), clientOptions.b());
            this.d.server.getPluginManager().callEvent((Event)event);
            this.d.server.getPluginManager().callEvent((Event)new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), this.cM, clientOptions.b()));
        }
        this.updateOptionsNoEvents(clientOptions);
    }

    public void updateOptionsNoEvents(ClientInformation clientOptions) {
        this.cM = clientOptions.b();
        this.adventure$locale = Translator.parseLocale((String)this.cM);
        this.cL = clientOptions.c();
        this.cB = clientOptions.d();
        this.cC = clientOptions.e();
        this.cX = clientOptions.h();
        this.cY = clientOptions.i();
        this.al().b(EntityHuman.bM, (byte)clientOptions.f());
        this.al().b(EntityHuman.bN, (byte)clientOptions.g().a());
    }

    public ClientInformation z() {
        byte b0 = this.al().b(EntityHuman.bM);
        EnumMainHand enummainhand = EnumMainHand.d.apply(this.al().b(EntityHuman.bN).byteValue());
        return new ClientInformation(this.cM, this.cL, this.cB, this.cC, b0, enummainhand, this.cX, this.cY);
    }

    public boolean A() {
        return this.cC;
    }

    public EnumChatVisibility B() {
        return this.cB;
    }

    private boolean v(boolean overlay) {
        return this.cB == EnumChatVisibility.c ? overlay : true;
    }

    private boolean gu() {
        return this.cB == EnumChatVisibility.a;
    }

    public int C() {
        return this.cL;
    }

    public void a(ServerPing metadata) {
        this.c.b(new ClientboundServerDataPacket(metadata.a(), metadata.d().map(ServerPing.a::a), metadata.e()));
    }

    @Override
    protected int D() {
        return this.d.c(this.fQ());
    }

    public void E() {
        this.cD = SystemUtils.b();
    }

    public ServerStatisticManager F() {
        return this.cp;
    }

    public RecipeBookServer G() {
        return this.cH;
    }

    @Override
    protected void H() {
        if (this.M_()) {
            this.ep();
            this.j(true);
        } else {
            super.H();
        }
    }

    public net.minecraft.world.entity.Entity I() {
        return this.cE == null ? this : this.cE;
    }

    public void c(@Nullable net.minecraft.world.entity.Entity entity) {
        net.minecraft.world.entity.Entity entity1 = this.I();
        net.minecraft.world.entity.Entity entity2 = this.cE = entity == null ? this : entity;
        if (entity1 != this.cE) {
            net.minecraft.world.level.World world;
            if (this.cE == this) {
                PlayerStopSpectatingEntityEvent playerStopSpectatingEntityEvent = new PlayerStopSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity());
                if (!playerStopSpectatingEntityEvent.callEvent()) {
                    this.cE = entity1;
                    return;
                }
            } else {
                PlayerStartSpectatingEntityEvent playerStartSpectatingEntityEvent = new PlayerStartSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity(), (Entity)entity.getBukkitEntity());
                if (!playerStartSpectatingEntityEvent.callEvent()) {
                    this.cE = entity1;
                    return;
                }
            }
            if ((world = this.cE.dL()) instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                this.teleportTo(worldserver, this.cE.dq(), this.cE.ds(), this.cE.dw(), Set.of(), this.dB(), this.dD(), PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entity != null) {
                this.x().k().a(this);
            }
            this.c.b(new PacketPlayOutCamera(this.cE));
            this.c.m();
            if (LeavesConfig.fixPaper9372) {
                this.aD = Optional.empty();
            }
        }
    }

    @Override
    protected void J() {
        if (!this.cF) {
            super.J();
        }
    }

    @Override
    public void d(net.minecraft.world.entity.Entity target) {
        if (this.e.b() == EnumGamemode.d) {
            this.c(target);
        } else {
            super.d(target);
        }
    }

    public long K() {
        return this.cD;
    }

    @Nullable
    public IChatBaseComponent L() {
        return this.listName;
    }

    @Override
    public void a(EnumHand hand) {
        super.a(hand);
        this.gl();
    }

    public boolean M() {
        return this.cF;
    }

    public void N() {
        this.cF = false;
    }

    public AdvancementDataPlayer O() {
        return this.co;
    }

    public void a(WorldServer targetWorld, double x2, double y2, double z2, float yaw, float pitch) {
        this.teleportTo(targetWorld, x2, y2, z2, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleportTo(WorldServer worldserver, double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.c((net.minecraft.world.entity.Entity)this);
        this.aa();
        this.getBukkitEntity().teleport(new Location((World)worldserver.getWorld(), d0, d1, d2, f2, f1), cause);
    }

    @Nullable
    public BlockPosition P() {
        return this.cT;
    }

    public float Q() {
        return this.cV;
    }

    public ResourceKey<net.minecraft.world.level.World> R() {
        return this.cS;
    }

    public boolean S() {
        return this.cU;
    }

    @Deprecated
    public void a(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage) {
        this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, PlayerSetSpawnEvent.Cause.UNKNOWN);
    }

    @Deprecated
    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage, PlayerSpawnChangeEvent.Cause cause) {
        return this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, cause == PlayerSpawnChangeEvent.Cause.RESET ? PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN : PlayerSetSpawnEvent.Cause.valueOf((String)cause.name()));
    }

    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage, PlayerSetSpawnEvent.Cause cause) {
        Location spawnLoc = null;
        boolean willNotify = false;
        if (pos != null) {
            boolean flag2 = pos.equals(this.cT) && dimension.equals(this.cS);
            spawnLoc = MCUtil.toLocation(this.cK().a(dimension), pos);
            spawnLoc.setYaw(angle);
            willNotify = sendMessage && !flag2;
        }
        PlayerSpawnChangeEvent dumbEvent = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), spawnLoc, forced, cause == PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN ? PlayerSpawnChangeEvent.Cause.RESET : PlayerSpawnChangeEvent.Cause.valueOf((String)cause.name()));
        dumbEvent.callEvent();
        PlayerSetSpawnEvent event = new PlayerSetSpawnEvent((Player)this.getBukkitEntity(), cause, dumbEvent.getNewSpawn(), dumbEvent.isForced(), willNotify, (Component)(willNotify ? Component.translatable((String)"block.minecraft.set_spawn") : null));
        event.setCancelled(dumbEvent.isCancelled());
        if (!event.callEvent()) {
            return false;
        }
        if (event.getLocation() != null) {
            dimension = event.getLocation().getWorld() != null ? ((CraftWorld)event.getLocation().getWorld()).getHandle().ac() : dimension;
            pos = MCUtil.toBlockPosition(event.getLocation());
            angle = event.getLocation().getYaw();
            forced = event.isForced();
            if (event.willNotifyPlayer() && event.getNotification() != null) {
                this.a(PaperAdventure.asVanilla(event.getNotification()));
            }
            this.cT = pos;
            this.cS = dimension;
            this.cV = angle;
            this.cU = forced;
        } else {
            this.cT = null;
            this.cS = net.minecraft.world.level.World.h;
            this.cV = 0.0f;
            this.cU = false;
        }
        return true;
    }

    public SectionPosition T() {
        return this.cQ;
    }

    public void a(SectionPosition section) {
        this.cQ = section;
    }

    public ChunkTrackingView U() {
        return this.cR;
    }

    public void a(ChunkTrackingView chunkFilter) {
        this.cR = chunkFilter;
    }

    @Override
    public void a(SoundEffect event, SoundCategory category, float volume, float pitch) {
        this.c.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.c.d(event), category, this.dq(), this.ds(), this.dw(), volume, pitch, this.ag.g()));
    }

    @Override
    public EntityItem a(ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        EntityItem entityitem = super.a(stack, throwRandomly, retainOwnership);
        if (entityitem == null) {
            return null;
        }
        this.dL().b(entityitem);
        ItemStack itemstack1 = entityitem.q();
        if (retainOwnership) {
            if (!itemstack1.b()) {
                this.a(StatisticList.f.b(itemstack1.d()), itemstack1.L());
            }
            this.a(StatisticList.F);
        }
        return entityitem;
    }

    public ITextFilter V() {
        return this.cW;
    }

    public void c(WorldServer world) {
        this.a((net.minecraft.world.level.World)world);
        this.e.a(world);
    }

    @Nullable
    private static EnumGamemode a(@Nullable NBTTagCompound nbt, String key) {
        return nbt != null && nbt.b(key, 99) ? EnumGamemode.a(nbt.h(key)) : null;
    }

    private EnumGamemode b(@Nullable EnumGamemode backupGameMode) {
        EnumGamemode enumgamemode1 = this.d.aW();
        return enumgamemode1 != null ? enumgamemode1 : (backupGameMode != null ? backupGameMode : this.d.t_());
    }

    public void c(@Nullable NBTTagCompound nbt) {
        if (this.d.aW() != null && this.d.aW() != EntityPlayer.a(nbt, "playerGameType")) {
            if (new PlayerGameModeChangeEvent((Player)this.getBukkitEntity(), GameMode.getByValue((int)this.d.t_().a()), PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null).callEvent()) {
                this.e.a(this.d.aW(), EnumGamemode.e);
            } else {
                this.e.a(EntityPlayer.a(nbt, "playerGameType"), EntityPlayer.a(nbt, "previousPlayerGameType"));
            }
            return;
        }
        this.e.a(this.b(EntityPlayer.a(nbt, "playerGameType")), EntityPlayer.a(nbt, "previousPlayerGameType"));
    }

    private void k(NBTTagCompound nbt) {
        nbt.a("playerGameType", this.e.b().a());
        EnumGamemode enumgamemode = this.e.c();
        if (enumgamemode != null) {
            nbt.a("previousPlayerGameType", enumgamemode.a());
        }
    }

    @Override
    public boolean W() {
        return this.cX;
    }

    public boolean b(EntityPlayer player) {
        return player == this ? false : this.cX || player.cX;
    }

    @Override
    public boolean a(net.minecraft.world.level.World world, BlockPosition pos) {
        return super.a(world, pos) && world.a(this, pos);
    }

    @Override
    protected void a(ItemStack stack) {
        CriterionTriggers.T.a(this, stack);
        super.a(stack);
    }

    public boolean a(boolean entireStack) {
        PlayerInventory playerinventory = this.fR();
        ItemStack itemstack = playerinventory.a(entireStack);
        this.bS.b(playerinventory, playerinventory.l).ifPresent(i2 -> this.bS.a(i2, playerinventory.f()));
        return this.a(itemstack, false, true) != null;
    }

    public boolean X() {
        return this.cY;
    }

    @Override
    public Optional<WardenSpawnTracker> Y() {
        return Optional.of(this.cZ);
    }

    @Override
    public void a(EntityItem item) {
        super.a(item);
        net.minecraft.world.entity.Entity entity = item.v();
        if (entity != null) {
            CriterionTriggers.P.a(this, item.q(), entity);
        }
    }

    public void a(RemoteChatSession session) {
        this.dc = session;
    }

    @Nullable
    public RemoteChatSession Z() {
        return this.dc != null && this.dc.b() ? null : this.dc;
    }

    @Override
    public void a(double deltaX, double deltaZ) {
        this.cl = (float)(MathHelper.d(deltaZ, deltaX) * 57.2957763671875 - (double)this.dB());
        this.c.b(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(net.minecraft.world.entity.Entity entity, boolean force) {
        if (!super.a(entity, force)) {
            return false;
        }
        entity.i(this);
        this.c.a(this.dq(), this.ds(), this.dw(), this.dB(), this.dD());
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.er()) {
                this.c.b(new PacketPlayOutEntityEffect(entity.ah(), mobeffect));
            }
        }
        return true;
    }

    @Override
    public void aa() {
        net.minecraft.world.entity.Entity entity = this.cY();
        super.aa();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.er()) {
                this.c.b(new PacketPlayOutRemoveEntityEffect(entity.ah(), mobeffect.c()));
            }
        }
    }

    public CommonPlayerSpawnInfo d(WorldServer world) {
        return new CommonPlayerSpawnInfo(world.aa(), world.ac(), BiomeManager.a(world.A()), this.e.b(), this.e.c(), world.af(), world.z(), this.gq(), this.at());
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.dL().W() + this.timeOffset;
        }
        return this.dL().W() - this.dL().W() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        } else {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newThunder));
            } else {
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.dL().z_().k() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cx() + " at " + this.dq() + "," + this.ds() + "," + this.dw() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.c.m();
        if (LeavesConfig.fixPaper9372) {
            this.aD = Optional.empty();
        }
    }

    @Override
    public boolean eX() {
        return super.eX() || this.c != null && this.c.isDisconnected();
    }

    @Override
    public Scoreboard gg() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        boolean keepInventory = this.dL().X().b(GameRules.d);
        if (this.keepLevel) {
            exp = this.ch;
            this.newTotalExp = this.cg;
            this.newLevel = this.cf;
        }
        this.c(this.eL());
        this.fs();
        this.j(this.cg());
        this.h(0);
        this.ab = 0.0f;
        this.bT = new FoodMetaData(this);
        this.cf = this.newLevel;
        this.cg = this.newTotalExp;
        this.ch = 0.0f;
        this.aM = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        ((EntityLiving)this).bU = true;
        this.bS = this.bR;
        this.aY = null;
        ((EntityLiving)this).bV = null;
        ((EntityLiving)this).bP = new CombatTracker(this);
        this.cz = -1;
        if (this.keepLevel) {
            this.ch = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.o(0.0, 0.0, 0.0);
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    private void resetOperationCountPerTick() {
        this.instaBreakCountPerTick = 0;
        this.placeBlockCountPerTick = 0;
    }

    public int getInstaBreakCountPerTick() {
        return this.instaBreakCountPerTick;
    }

    public int getPlaceBlockCountPerTick() {
        return this.placeBlockCountPerTick;
    }

    public void addInstaBreakCountPerTick() {
        ++this.instaBreakCountPerTick;
    }

    public void addPlaceBlockCountPerTick() {
        ++this.placeBlockCountPerTick;
    }

    public boolean allowOperation() {
        return MinecraftServer.tickStatus == TickStatus.FREEZE || (this.instaBreakCountPerTick == 0 || this.placeBlockCountPerTick == 0) && this.instaBreakCountPerTick <= 1 && this.placeBlockCountPerTick <= 2;
    }
}

